/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <localsys.h>
#include <save.h>
#include <io_defs.h>
#include <cu_defs.h>
#include <size_defs.h>
#include <header.h>
#include <errno.h>
#include <strings.h>

int verbose;
FILE *prtfile;

void map_error(from,to)
char *from,*to;
{
	fprintf(prtfile,"Invalid mapping: %s=%s\n",to,from);
	fprintf(stderr,"Invalid mapping: %s=%s\n",to,from);
}

int main(argc,argv)
int argc;
char **argv;
{
	FILE *input,*output;
	int i,j,k,trcknt,mapknt;
	char **from,**to,*value;
	char *lbracket,*rbracket;
	int offset;
	int numsmpflg;
	char prtfilename[32];
	char hostname[9],comment[81];
	char native[8];
	short numsmp,smpint,numtrc;
	short  numaux, cdpfold, origsmpint, orignumsmp;
	int line_hdr_indx,trace_hdr_indx;
	int indx,bytes,help,databytes,segydatabytes;
	int native_line_header, native_trace_header, native_trace_data;
	short samples;
	char ntap[256],otap[256],map_file[256];
	char *def_map_file;
	char *header,*buffer;
	int count;
	int luout;
	short sval;
	int lval;
	float rval;
	char *chval;
	int format,index,length;
	int TrcNumSmp_format, TrcNumSmp_index, TrcNumSmp_length;
	int TrcIdCode_format, TrcIdCode_index, TrcIdCode_length;
	int ElevScaler_format, ElevScaler_index, ElevScaler_length;
	int XYUnits_format, XYUnits_index, XYUnits_length;
	int RecNum_format, RecNum_index, RecNum_length;
	int TrcNum_format, TrcNum_index, TrcNum_length;
	int SrcX_format, SrcX_index, SrcX_length;
	int SrcY_format, SrcY_index, SrcY_length;
	int FieldRecNum_format, FieldRecNum_index, FieldRecNum_length;
	int FieldTrcNum_format, FieldTrcNum_index, FieldTrcNum_length;
	int LineTrcNum_format, LineTrcNum_index, LineTrcNum_length;
	int TrcSmpInt_format, TrcSmpInt_index, TrcSmpInt_length;
	int CdpNum_format, CdpNum_index, CdpNum_length;
	int CdpTrcNum_format, CdpTrcNum_index, CdpTrcNum_length;
	typedef struct {
		char *tag;
		int hdrtype;
		int format;
		int index;
		int length;
		} save_struct;

	save_struct *hdr_map,*segy_line_hdr_map,*segy_trace_hdr_map;
	save_struct **line_hdr_map,**trace_hdr_map;

	short fmtcode,unitsflg;
	int *hdrtype;
	int jobnum;
	int linenum, reelnum;
	int linetrcnum;
	int segy_prrcnm, segy_prtrnm;
	short trid, trcnumsmp, segysmpint;
	int cdpnum, cdptrcnum;
	int hlhknt;
	char **hlh;
	int read_map_file();

	help = C_ARGIS("-?",&argc,argv);
	help += C_ARGIS("-h",&argc,argv);
	if (help > 0) {
	  fprintf(stderr,"\nUsage: segy2usp -N[] -O[] -m mapping -M map_file");
	  fprintf(stderr,"\n\t-native [line | trace | data| all] -h -'?'");
	  fprintf(stderr," -V level\n\n");
	  fprintf(stderr,"       -N[input]   -- input SEGY data set (default=stdin)\n");
	  fprintf(stderr,"       -O[output]  -- output USP data set (default=stdout)\n");
	  fprintf(stderr,"       -map usp_header_mnemonic = segy_header_mnemonic|constant]\n");
	  fprintf(stderr,"                   -- map header info\n");
	  fprintf(stderr,"       -M          -- mapping file containing entries of form\n");
	  fprintf(stderr,"                      usp_header_mnemonic = [segy_header_mnemonic|constant]\n");
	  fprintf(stderr,"       -native [line | trace | data | all]\n");
	  fprintf(stderr,"                   -- native format flags\n");
	  fprintf(stderr,"       -V          -- verbose mode\n\n");
	  fprintf(stderr,"       -h -?       -- display this help screen\n\n");
	  exit(1);
	  }

	sprintf(prtfilename,"SEGY2USP.%d",getpid());

	if (C_IN_IKP() != 0) {
	  if (gethostname(hostname,9) == 0) {
	    hostname[8] = '\0';
	    strcat(prtfilename,".");
	    strcat(prtfilename,hostname);
	    }
	  }

	prtfile = fopen(prtfilename,"w");
	if (prtfile == NULL) prtfile = stderr;
	setbuf(prtfile,NULL);

	fprintf(prtfile,"SEGY2USP:\n");

	C_ARGI4("-V",&verbose,1,0,&argc,argv);

	from = (char **) malloc(150*sizeof(char *));
	to = (char **) malloc(150*sizeof(char *));
	indx=-1;
	def_map_file = getenv("SEGY2USP_DEFAULT_MAP");
	if (def_map_file != NULL) {
	  if (verbose != 0)
	    fprintf(prtfile," Using default mappings from %s\n",def_map_file);
	  indx = read_map_file(def_map_file,indx,to,from);
	  }
	else {
	  fprintf(stderr,"WARNING: SEGY2USP_DEFAULT_MAP was not set - no default mapping will be used\n");
	  fprintf(prtfile,"WARNING: SEGY2USP_DEFAULT_MAP was not set - no default mapping will be used\n");
	  }

	C_ARGSTR("-M",map_file,"","",&argc,argv);
	indx = read_map_file(map_file,indx,to,from);
	indx++;

	do {	/* each call to ARGSTR gives us a new pointer */
	  value = C_ARGSTR("-map",NULL,"EOF=EOF","EOF=EOF",&argc,argv);
	  to[indx] = value;
	  from[indx] = (char *)strchr(to[indx],'=')+1;
	  to[indx][from[indx]-to[indx]-1] = '\0';
	  indx++;
/*
   if we find an override, put it in the map at the location of the 
   previous specification
*/
	  for (i=0; i<indx-1; i++) {
	    if (strcmp(to[i],to[indx-1]) == 0) {
		indx--;
		fprintf(stderr,"SEGY2USP: Duplicate specifications for mnemonic %s;\n          %s=%s overrides previous entry of %s=%s\n",to[indx],to[indx],from[indx],to[i],from[i]);
		fprintf(prtfile," SEGY2USP: Duplicate specifications for mnemonic %s;\n          %s=%s overrides previous entry of %s=%s\n",to[indx],to[indx],from[indx],to[i],from[i]);
		from[i] = from[indx];
		to[i] = to[indx];
		break;
		}
	     }

	  } while (strcmp(from[indx-1],"EOF") != 0);

	indx--;
	mapknt = indx;	/* we don't want to count the EOF entry */

	if (verbose == 1) {
	  fprintf(prtfile," Mapping Array:\n");
	  for(i=0;i<=mapknt;i++) {
	    fprintf(prtfile,"      %s=%s\n",to[i],from[i]);
	    }
	  fprintf(prtfile,"\n");
	  }

	C_ARGSTR("-N",ntap," "," ",&argc,argv);
	if (strcmp(ntap," ") == 0) {
	  if (verbose == 1) fprintf(prtfile," input file = stdin\n");
	  input = stdin;
	  }
	else {
	  if (verbose == 1) fprintf(prtfile," input file = %s\n",ntap);
	  input = fopen(ntap,"r");
	  if (input == NULL) {
	    fprintf(stderr,"%s: error opening input data file (%s)\n",
		argv[0],ntap);
	    exit(1);
	    }
	  }

	C_ARGSTR("-O",otap," "," ",&argc,argv);
	if (verbose == 1) fprintf(prtfile," output file = ");
	if (strcmp(otap," ") == 0) {
	  if (verbose == 1) fprintf(prtfile,"stdout\n");
	  output = (FILE *)stdout;
	  luout = 1;
	  }
	else {
	  if (verbose == 1) fprintf(prtfile,"%s\n",otap);
	  C_LBOPEN(&luout,otap,"w");
	  }

	native_line_header = 0;
	native_trace_header = 0;
        native_trace_data = 0;
	for(i=0; i<3; i++) {
	  C_ARGSTR("-native",native,"all"," ",&argc,argv);
	  if (strcmp(native,"line") == 0) {
	    native_line_header = 1;
	    }
	  if (strcmp(native,"trace") == 0) {
	    native_trace_header = 1;
	    }
	  if (strcmp(native,"data") == 0) {
	    native_trace_data = 1;
	    }
	  if (strcmp(native,"all") == 0) {
	    native_line_header = 1;
	    native_trace_header = 1;
	    native_trace_data = 1;
	    }
	  }
/*
need to check return codes ; we should also realloc after looking up indices
*/
	hdr_map       = (save_struct *) malloc(mapknt * sizeof(save_struct));
	segy_line_hdr_map  = (save_struct *) malloc(mapknt * sizeof(save_struct));
	segy_trace_hdr_map = (save_struct *) malloc(mapknt * sizeof(save_struct));
	line_hdr_map  = (save_struct **) malloc(mapknt * sizeof(save_struct *));
	trace_hdr_map = (save_struct **) malloc(mapknt * sizeof(save_struct *));

	if ((buffer = (char *)malloc(SEGYEBCDICHEADERBYTES)) == NULL) {
	  fprintf(stderr,
	    "%s ERROR: failure mallocing %d bytes of memory for SEGY EBCDIC header\n",
		argv[0],SEGYEBCDICHEADERBYTES);
	  if (verbose != 0) fprintf(prtfile,
	    "%s ERROR: failure mallocing %d bytes of memory for SEGY EBCDIC header\n",
		argv[0],SEGYEBCDICHEADERBYTES);
	  exit(1);
	  }

	bytes = fread(buffer,1,SEGYEBCDICHEADERBYTES,input);
	if (bytes == 0) {
	  fprintf(stderr,"%s: ERROR reading SEGY line header\n", argv[0]);
	  exit(1);
	  }
	
	count=3200;
	F_EBCASC(buffer,buffer,&count);
	comment[80] = '\0';
	if (verbose != 0) {
	  fprintf(prtfile,"\n EBCDIC header:\n");
	  for (i=0;i<40; i++) {
	    memcpy(comment,buffer+(i*80),80);
	    fprintf(prtfile,"%-80s\n",comment);
	    }
	  }

/* put the EBCDIC header into HLH
*/

	if ((buffer = (char *)realloc(buffer,SEGYLINEHEADERBYTES)) == NULL) {
	  fprintf(stderr,"%s: ERROR mallocing %d bytes of memory\n",
		argv[0],SEGYLINEHEADERBYTES);
	  exit(1);
	  }

	bytes = fread(buffer,1,SEGYLINEHEADERBYTES,input);

/* If necessary, we need to do byte rotations */

#if ( BYTE_ORDER == LITTLE_ENDIAN )
	if (native_line_header != 1) {
	  HTOCL(buffer,3);
	  C_SAVELU("NumTrc",&format,&index,&length,SEGYLINEHEADER);
	  HTOCS(buffer+(index*sizeof(short)),25);
	  }
#endif

	get_hw_val(buffer, "JobNum", SEGYLINEHEADER, &jobnum);
	get_hw_val(buffer, "LineNum", SEGYLINEHEADER, &linenum);
	get_hw_val(buffer, "ReelNum", SEGYLINEHEADER, &reelnum);
	get_hw_val(buffer, "NumTrc", SEGYLINEHEADER, &numtrc);
	get_hw_val(buffer, "NumAux", SEGYLINEHEADER, &numaux);
	get_hw_val(buffer, "CdpFold", SEGYLINEHEADER, &cdpfold);
	get_hw_val(buffer, "SmpInt", SEGYLINEHEADER, &smpint);
	get_hw_val(buffer, "OrigSmpInt", SEGYLINEHEADER, &origsmpint);
	get_hw_val(buffer, "NumSmp", SEGYLINEHEADER, &numsmp);
	get_hw_val(buffer, "OrigNumSmp", SEGYLINEHEADER, &orignumsmp);
	get_hw_val(buffer, "FmtCode", SEGYLINEHEADER, &fmtcode);
	get_hw_val(buffer, "UnitsFlag", SEGYLINEHEADER, &unitsflg);

	if (verbose >= 2) {
	  fprintf(prtfile,"\n");
	  fprintf(prtfile,"job identification number        = %d\n",jobnum);
	  fprintf(prtfile,"line number                      = %d\n",linenum);
	  fprintf(prtfile,"reel number                      = %d\n",reelnum);
	  fprintf(prtfile,"data traces per record           = %d\n",numtrc);
	  fprintf(prtfile,"auxiliary traces per record      = %d\n",numaux);
	  fprintf(prtfile,"sample interval in micro seconds = %d\n",smpint);
	  fprintf(prtfile,"samples/trace for this reel      = %d\n",numsmp);
	  fprintf(prtfile,"data sample format code          = %d\n",fmtcode);
	  fprintf(prtfile,"CDP fold                         = %d\n",cdpfold);
	  fprintf(prtfile,"samples/trace for orig. field recording =");
	  fprintf(prtfile,"\t%d\n",orignumsmp);
	  fprintf(prtfile,"units flag = %d\n",unitsflg);
	  fprintf(prtfile,"\n\n");
	  }

	line_hdr_indx = 0;
	trace_hdr_indx = 0;
/*
   This block of code looks up the indexes for all entries in both
   the from (SEGY) and to (USP) entries in the summary map. If a
   USP mapping is found, but the SEGY mnemonic check fails, we will
   assume it is a constant and proceed.
*/

	for (indx=0;indx<mapknt;indx++) {
	  errno = 0;
	  hdr_map[indx].tag = to[indx];
	  if (verbose >= 2) fprintf(prtfile,"look up to entry %s\n",to[indx]);
	  if (strncmp(from[indx],"Spare",5) == 0) {
	    if ((lbracket=(char *)strchr(from[indx],'[')) != NULL) {
	      *lbracket='\0';
	      lbracket+=1;
	      if ((rbracket = (char *)strrchr(lbracket,']')) == NULL) {
		fprintf(stderr,"Invalid indexing - %s\n",from[indx]);
		exit(100);
		}
	      else {
	        *rbracket='\0';
		offset = atoi(lbracket);
		}
	      }
	    }
	  else
	    offset = -1;

	  hdr_map[indx].hdrtype = C_SAVCHK(hdr_map[indx].tag,
		&hdr_map[indx].format, &hdr_map[indx].index,
		&hdr_map[indx].length,LINEHEADER);
	  if (hdr_map[indx].hdrtype == LINEHEADER) {
	    segy_line_hdr_map[line_hdr_indx].tag = from[indx];
	    segy_line_hdr_map[line_hdr_indx].hdrtype =
		  C_SAVCHK(segy_line_hdr_map[line_hdr_indx].tag,
			&segy_line_hdr_map[line_hdr_indx].format,
			&segy_line_hdr_map[line_hdr_indx].index,
			&segy_line_hdr_map[line_hdr_indx].length, SEGYLINEHEADER);
	    if (segy_line_hdr_map[line_hdr_indx].hdrtype != SEGYLINEHEADER) {
/*
   the "from" entry was not a USP SEGYLINEHEADER entry, assume a constant
   we go ahead and set the type so that we'll know how to translate the ascii
*/
	      if (verbose >= 2) fprintf(prtfile,
		  "from entry %s not found; assume constant\n",from[indx]);
	      switch(hdr_map[indx].format) {
		case (SAVE_DUMMY_DEF):
		case (SAVE_SHORT_DEF):
#ifdef DEBUG
fprintf(stderr,"convert ->%s<- to an int\n",from[indx]);
#endif
		    sval = atoi(from[indx]);
		    if ((sval == 0) && (errno != 0)) {
			fprintf(stderr,"1 Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			fprintf(prtfile,"Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			exit(100);
			}
#ifdef DEBUG
if (errno != 0) {fprintf(stderr,"errno = %d\n",errno); perror("Invalid"); }
#endif
		    break;
		case (SAVE_INT_DEF):
		    lval = atol(from[indx]);
		    if ((lval == 0) && (errno != 0)) {
			fprintf(stderr,"2 Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			fprintf(prtfile,"Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			exit(100);
			}
		    break;
		case (SAVE_FLOAT_DEF):
		    rval = atof(from[indx]);
		    if ((rval == 0.) && (errno != 0)) {
			fprintf(stderr,"3 Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			fprintf(prtfile,"Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			exit(100);
			}
		    break;
		}
	      segy_line_hdr_map[line_hdr_indx].format  = hdr_map[indx].format;
	      segy_line_hdr_map[line_hdr_indx].index   = indx;
	      segy_line_hdr_map[line_hdr_indx].length  = -1;
	      }

	    if (verbose >= 2) {
		fprintf(prtfile,"line header %d mapping: from %s",
			line_hdr_indx,from[indx]);
		if (offset >= 0) fprintf(prtfile,"[%d]",offset);
		fprintf(prtfile," to %s\n",to[indx]);
		fprintf(prtfile,"\n");
		}
/*
	this is for SpareBin specifications
*/
	    if (offset >= 0) {
		segy_line_hdr_map[line_hdr_indx].index += offset;
		segy_line_hdr_map[line_hdr_indx].length = 1;
		}

	    line_hdr_map[line_hdr_indx++] = &hdr_map[indx]; 

	    }
	  else {
	    hdr_map[indx].tag = to[indx];
	    if (strncmp(from[indx],"Spare",5) == 0) {
	      if ((lbracket=(char *)strchr(from[indx],'[')) != NULL) {
	        *lbracket='\0';
	        lbracket+=1;
	        if ((rbracket = (char *)strrchr(lbracket,']')) == NULL) {
		  fprintf(stderr,"Invalid indexing - %s\n",from[indx]);
		  fprintf(prtfile,"Invalid indexing - %s\n",from[indx]);
		  exit(100);
		  }
	        else {
	          *rbracket='\0';
		  offset = atoi(lbracket);
		  }
	        }
	      }
	    else
	      offset = -1;

	    hdr_map[indx].hdrtype = C_SAVCHK(hdr_map[indx].tag,
		&hdr_map[indx].format, &hdr_map[indx].index,
		&hdr_map[indx].length,TRACEHEADER);
	    if (hdr_map[indx].hdrtype == TRACEHEADER) {
	      segy_trace_hdr_map[trace_hdr_indx].tag = from[indx];
	      segy_trace_hdr_map[trace_hdr_indx].hdrtype = 
		C_SAVCHK(segy_trace_hdr_map[trace_hdr_indx].tag,
		  &segy_trace_hdr_map[trace_hdr_indx].format,
		  &segy_trace_hdr_map[trace_hdr_indx].index,
		  &segy_trace_hdr_map[trace_hdr_indx].length, SEGYTRACEHEADER);
	      if (segy_trace_hdr_map[trace_hdr_indx].hdrtype != SEGYTRACEHEADER) {
/*
   the "from" entry was not a SEGYTRACEHEADER entry, assume a constant
   we go ahead and set the type so that we'll know how to translate the ascii
*/
		if (verbose >= 2) fprintf(prtfile,
		  "from entry %s not found; assume constant\n",from[indx]);
	        switch(hdr_map[indx].format) {
		  case (SAVE_DUMMY_DEF):
		  case (SAVE_SHORT_DEF):
#ifdef DEBUG
fprintf(stderr,"convert ->%s<- to an int\n",from[indx]);
#endif
		    errno=0;
		    sval = atoi(from[indx]);
		    if ((sval == 0) && (errno != 0)) {
			fprintf(stderr,"4 Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			fprintf(prtfile,"Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			exit(100);
			}
#ifdef DEBUG
if (errno != 0) {fprintf(stderr,"errno = %d\n",errno); perror("Invalid"); }
#endif
		    break;
		  case (SAVE_INT_DEF):
		    lval = atol(from[indx]);
		    if ((lval == 0) && (errno != 0)) {
			fprintf(stderr,"5 Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			fprintf(prtfile,"Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			exit(100);
			}
		    break;
		  case (SAVE_FLOAT_DEF):
		    rval = atof(from[indx]);
		    if ((rval == 0.) && (errno != 0)) {
			fprintf(stderr,"6 Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			fprintf(prtfile,"Invalid constant specification %s=%s\n",
				to[indx], from[indx]);
			exit(100);
			}
		    break;
		  }
		segy_trace_hdr_map[trace_hdr_indx].format  = hdr_map[indx].format;
		segy_trace_hdr_map[trace_hdr_indx].index   = indx;
		segy_trace_hdr_map[trace_hdr_indx].length  = -1;
		}

	      if (verbose >= 2) {
		fprintf(prtfile,"trace header %d mapping: from %s",
			trace_hdr_indx,from[indx]);
		if (offset >= 0) fprintf(prtfile,"[%d]",offset);
		fprintf(prtfile," to %s",to[indx]);
		fprintf(prtfile,"\n");
		}
/*
	this is for SpareBin specifications
*/
	      if (offset >= 0) {
		segy_trace_hdr_map[trace_hdr_indx].index += offset;
		segy_trace_hdr_map[trace_hdr_indx].length = 1;
		}

	      trace_hdr_map[trace_hdr_indx++] = &hdr_map[indx];
	      }
	    else {
		map_error(from[indx],to[indx]);
	      }
	    }
	  }

	if (verbose != 0) {
	  fprintf(prtfile,"number of line header entries = %d\n",line_hdr_indx);
	  for (indx=0;indx<line_hdr_indx;indx++) {
	    if (segy_line_hdr_map[indx].length >= 1) 
	     fprintf(prtfile,"%3d from SEGY: tag=%12s format=%d index=%3d length=%2d\t",
	      indx, segy_line_hdr_map[indx].tag, segy_line_hdr_map[indx].format,
	      segy_line_hdr_map[indx].index, segy_line_hdr_map[indx].length);
	    else
	     fprintf(prtfile,"%3d  constant: value=%12s\t",
	      indx, segy_line_hdr_map[indx].tag);
	    fprintf(prtfile,"\n       to USP: tag=%12s format=%d index=%3d length=%2d\n",
	      line_hdr_map[indx]->tag, line_hdr_map[indx]->format,
	      line_hdr_map[indx]->index, line_hdr_map[indx]->length);
	    }
	  fprintf(prtfile,"\nnumber of trace header entries = %d\n",
		trace_hdr_indx);
	  for (indx=0;indx<trace_hdr_indx;indx++) {
	    if (segy_trace_hdr_map[indx].length >= 1) 
	     fprintf(prtfile,"%3d from SEGY: tag=%12s format=%d index=%3d length=%2d\t",
	      indx, segy_trace_hdr_map[indx].tag, segy_trace_hdr_map[indx].format,
	      segy_trace_hdr_map[indx].index, segy_trace_hdr_map[indx].length);
	    else
	     fprintf(prtfile,"%3d  constant: value=%12s\t",
	      indx, segy_trace_hdr_map[indx].tag);
	    fprintf(prtfile,"\n       to USP: tag=%12s format=%d index=%3d length=%2d\n",
	      trace_hdr_map[indx]->tag, trace_hdr_map[indx]->format,
	      trace_hdr_map[indx]->index, trace_hdr_map[indx]->length);
	    }
	  }

	numsmpflg = 0;
	for (indx=0;indx<line_hdr_indx;indx++) {
	  if (strcmp(line_hdr_map[indx]->tag,"NumSmp") == 0) {
	    numsmpflg = 1;
	    switch(segy_line_hdr_map[indx].format) {
		case (SAVE_DUMMY_DEF):
		case (SAVE_SHORT_DEF):
		    get_indexed_hw_val(buffer,segy_line_hdr_map[indx].format,
			segy_line_hdr_map[indx].index,
			segy_line_hdr_map[indx].length,
			SEGYLINEHEADER,&sval);
		    numsmp = sval;
		    break;
		case (SAVE_INT_DEF):
		    get_indexed_hw_val(buffer,segy_line_hdr_map[indx].format,
			segy_line_hdr_map[indx].index,
			segy_line_hdr_map[indx].length,
			SEGYLINEHEADER,&lval);
		    numsmp = lval;
		    break;
	  	}
	    break;
	    }
	  }

	if (numsmpflg == 0) {
	  fprintf(stderr,
	    "SEGY2USP ERROR: No location to obtain NumSmp was specified\n");
	  fprintf(stderr,
	    "                This is a required entry\n");
	  fprintf(prtfile,
	      "SEGY2USP ERROR: No location to obtain NumSmp was specified\n");
	  fprintf(prtfile,
	      "                This is a required entry\n");
	  exit(0);
	  }

	if (numsmp <= 0) {
	  fprintf(stderr,
	    "SEGY2USP ERROR: NumSmp obtained from SEGY data (%d) is <= 0\n",numsmp);
	  fprintf(prtfile,
	    "SEGY2USP ERROR: NumSmp obtained from SEGY data (%d) is <= 0\n",numsmp);
	  exit(0);
	  }

	if ((header = (char *)malloc(HSTOFF)) == NULL) {
	  fprintf(stderr,"%s: failure mallocing %d bytes of memory for USP output\n",
		argv[0],HSTOFF);
	  fprintf(prtfile,"%s: failure mallocing %d bytes of memory for USP output\n",
		argv[0],HSTOFF);
	  exit(1);
	  }
	else
	  memset(header,0,HSTOFF);
/*
	Now we actually do the moving of data into the SEGY header
*/
	for (indx=0;indx<line_hdr_indx;indx++) {
	    switch( segy_line_hdr_map[indx].format ) {
		case (SAVE_DUMMY_DEF):
		  if (segy_line_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,segy_line_hdr_map[indx].format,
			segy_line_hdr_map[indx].index,segy_line_hdr_map[indx].length,
			SEGYLINEHEADER,&sval);
		  else 
		    sval = atoi(segy_trace_hdr_map[indx].tag);

		  put_indexed_hw_val(header,line_hdr_map[indx]->format,
			line_hdr_map[indx]->index,
			line_hdr_map[indx]->length,
			LINEHEADER,sval);
		  break;
		case (SAVE_CHAR_DEF):
		  if (segy_line_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,segy_line_hdr_map[indx].format,
			segy_line_hdr_map[indx].index,segy_line_hdr_map[indx].length,
			SEGYLINEHEADER,chval);
		  else
		    chval = from[segy_line_hdr_map[indx].index];
		  put_indexed_hw_val(header,line_hdr_map[indx]->format,
			line_hdr_map[indx]->index,
			line_hdr_map[indx]->length,
			LINEHEADER,chval);
		    break;
		case (SAVE_SHORT_DEF):
		  if (segy_line_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,segy_line_hdr_map[indx].format,
			segy_line_hdr_map[indx].index,
			segy_line_hdr_map[indx].length,
			SEGYLINEHEADER,&sval);
		  else
		    sval = atoi(segy_line_hdr_map[indx].tag);

		  put_indexed_hw_val(header,line_hdr_map[indx]->format,
			line_hdr_map[indx]->index,
			line_hdr_map[indx]->length,
			LINEHEADER,sval);
		  break;
		case (SAVE_INT_DEF):
		  if (segy_line_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,segy_line_hdr_map[indx].format,
			segy_line_hdr_map[indx].index,
			segy_line_hdr_map[indx].length,
			SEGYLINEHEADER,&lval);
		  else
		    lval = atol(segy_line_hdr_map[indx].tag);

		  put_indexed_hw_val(header,line_hdr_map[indx]->format,
			line_hdr_map[indx]->index,
			line_hdr_map[indx]->length,
			LINEHEADER,lval);
		  break;
		case (SAVE_FLOAT_DEF):
                case (SAVE_FKFLT_DEF):
		  if (segy_line_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,segy_line_hdr_map[indx].format,
			segy_line_hdr_map[indx].index,
			segy_line_hdr_map[indx].length,
			SEGYLINEHEADER,&rval);
		  else
		    rval = atof(segy_line_hdr_map[indx].tag);

                  put_indexed_hw_val(header,line_hdr_map[indx]->format,
                            line_hdr_map[indx]->index,
                            line_hdr_map[indx]->length,
                            LINEHEADER,rval);
		  break;
		  }
		}

	put_hw_val(header,"PrcDat",LINEHEADER,cgdate());
	put_hw_val(header,"HlhEnt",LINEHEADER,0);
	put_hw_val(header,"HlhByt",LINEHEADER,4);
	C_WRTAPE(luout,header,HSTOFF);
	if (bytes == 0) {
	  fprintf(stderr,"%s: error writing header (%d bytes attempted)\n",
		argv[0],HSTOFF);
	  exit(1);
	  }
	  
	linetrcnum = 0;

	switch(fmtcode) {
	  case(1):
		segydatabytes = numsmp * sizeof(float);
		databytes = numsmp * SZSMPD;
		break;
	  case(2):
		segydatabytes = numsmp * sizeof(int);
		databytes = numsmp * SZSMPD;
		break;
	  case(3):
		segydatabytes = numsmp * sizeof(short);
		databytes = numsmp * SZSMPD;
		break;
	  default:
		fprintf(stderr,"SEGY2USP ERROR: no method for converting SEGY data with format code %d\n",fmtcode);
		exit(1);
		}

	if ((buffer = (char *)realloc(buffer,SEGYTRACEHEADERBYTES+segydatabytes)) == NULL) {
	  fprintf(stderr,"%s: failure mallocing %d bytes of memory for SEGY traces\n",
		argv[0],SEGYTRACEHEADERBYTES+segydatabytes);
	  fprintf(prtfile,"%s: failure mallocing %d bytes of memory for SEGY traces\n",
		argv[0],SEGYTRACEHEADERBYTES+segydatabytes);
	  exit(1);
	  }

	if ((header = (char *)realloc(header,SZTRHD+databytes)) == NULL) {
	  fprintf(stderr,"%s: failure mallocing %d bytes of memory for USP traces\n",
		argv[0],SZTRHD+databytes);
	  fprintf(prtfile,"%s: failure mallocing %d bytes of memory for USP traces\n",
		argv[0],SZTRHD+databytes);
	  exit(1);
	  }

	memset(header,0,SZTRHD);

	if (verbose >= 2) {
	    fprintf(prtfile,"\n\n");
	    fprintf(prtfile," trace       field      field ");
	    fprintf(prtfile,"      trace         number      sample\n");

	    fprintf(prtfile,"sequence     record     trace ");
	    fprintf(prtfile,"  identification      of       interval\n");

	    fprintf(prtfile," number      number     number");
	    fprintf(prtfile,"      code         samples    (microsecs)\n");

	    fprintf(prtfile,"--------     ------     ------");
	    fprintf(prtfile,"  --------------   -------    -----------\n");

	    fprintf(prtfile,"\n\n");

/* look up indexes to speed things up in trace loop */

	  C_SAVELU("TrcIdCode",&TrcIdCode_format,&TrcIdCode_index,
		&TrcIdCode_length,SEGYTRACEHEADER);

	  C_SAVELU("FieldRecNum", &FieldRecNum_format, &FieldRecNum_index,
			&FieldRecNum_length, SEGYTRACEHEADER);
	  C_SAVELU("FieldTrcNum", &FieldTrcNum_format, &FieldTrcNum_index,
			&FieldTrcNum_length, SEGYTRACEHEADER);
	  C_SAVELU("LineTrcNum", &LineTrcNum_format, &LineTrcNum_index,
			&LineTrcNum_length, SEGYTRACEHEADER);
	  C_SAVELU("TrcSmpInt", &TrcSmpInt_format, &TrcSmpInt_index,
			&TrcSmpInt_length, SEGYTRACEHEADER);
	  C_SAVELU("CdpNum", &CdpNum_format, &CdpNum_index,
			&CdpNum_length, SEGYTRACEHEADER);
	  C_SAVELU("CdpTrcNum", &CdpTrcNum_format, &CdpTrcNum_index,
			&CdpTrcNum_length, SEGYTRACEHEADER);
	  C_SAVELU("TrcNumSmp", &TrcNumSmp_format, &TrcNumSmp_index,
			&TrcNumSmp_length, SEGYTRACEHEADER);
	  }

	trcknt = 0;

	while (1) {
	  bytes = fread(buffer,1,SEGYTRACEHEADERBYTES+segydatabytes,input);
	  if (bytes == 0) { 			/* normal exit */
	    fprintf(prtfile,"normal completion - ");
	    fprintf(prtfile,"%d traces processed\n",trcknt);
	    fclose(input);
	    C_LBCLOS(luout);
	  
	    exit(0);
	    }

	  trcknt++;

#if ( BYTE_ORDER == LITTLE_ENDIAN )
	  if (native_trace_header != 1) {
	    HTOCL(buffer,7);
	    C_SAVELU("TrcIdCode",&format,&index,&length,SEGYTRACEHEADER);
	    HTOCS(buffer+(index*sizeof(short)),4);
	    C_SAVELU("DstSgn",&format,&index,&length,SEGYTRACEHEADER);
	    HTOCL(buffer+(index*sizeof(long)),8);
	    C_SAVELU("ElevScaler",&format,&index,&length,SEGYTRACEHEADER);
	    HTOCS(buffer+(index*sizeof(short)),2);
	    C_SAVELU("SrcX",&format,&index,&length,SEGYTRACEHEADER);
	    HTOCL(buffer+(index*sizeof(long)),4);
	    C_SAVELU("XYUnits",&format,&index,&length,SEGYTRACEHEADER);
	    HTOCS(buffer+(index*sizeof(short)),46);
	    }
#endif
/*
   Take care of the specified trace header mappings
*/
	for (indx=0;indx<trace_hdr_indx;indx++) {
	    switch( segy_trace_hdr_map[indx].format ) {
		case (SAVE_DUMMY_DEF):
		  if (segy_trace_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,segy_trace_hdr_map[indx].format,
			segy_trace_hdr_map[indx].index,segy_trace_hdr_map[indx].length,
			SEGYLINEHEADER,&sval);
		  else
		    sval = atoi(segy_trace_hdr_map[indx].tag);

		  put_indexed_hw_val(header,trace_hdr_map[indx]->format,
			trace_hdr_map[indx]->index,
			trace_hdr_map[indx]->length,
			LINEHEADER,sval);
		  break;
		case (SAVE_CHAR_DEF):
		  if (segy_trace_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,segy_trace_hdr_map[indx].format,
			segy_trace_hdr_map[indx].index,segy_trace_hdr_map[indx].length,
			SEGYLINEHEADER,chval);
		  else
		    chval=from[segy_trace_hdr_map[indx].index];
		  put_indexed_hw_val(header,trace_hdr_map[indx]->format,
			trace_hdr_map[indx]->index,
			trace_hdr_map[indx]->length,
			LINEHEADER,chval);
		    break;
		case (SAVE_SHORT_DEF):
		  if (segy_trace_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,segy_trace_hdr_map[indx].format,
			segy_trace_hdr_map[indx].index,
			segy_trace_hdr_map[indx].length,
			SEGYLINEHEADER,&sval);
		  else
		    sval = atoi(segy_trace_hdr_map[indx].tag);

		  put_indexed_hw_val(header,trace_hdr_map[indx]->format,
			trace_hdr_map[indx]->index,
			trace_hdr_map[indx]->length,
			LINEHEADER,sval);
		  break;
		case (SAVE_INT_DEF):
		  if (segy_trace_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,segy_trace_hdr_map[indx].format,
			segy_trace_hdr_map[indx].index,
			segy_trace_hdr_map[indx].length,
			SEGYLINEHEADER,&lval);
		  else
		    lval = atol(segy_trace_hdr_map[indx].tag);

		  put_indexed_hw_val(header,trace_hdr_map[indx]->format,
			trace_hdr_map[indx]->index,
			trace_hdr_map[indx]->length,
			LINEHEADER,lval);
		  break;
		case (SAVE_FLOAT_DEF):
                case (SAVE_FKFLT_DEF):
		  if (segy_trace_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,segy_trace_hdr_map[indx].format,
			segy_trace_hdr_map[indx].index,
			segy_trace_hdr_map[indx].length,
			SEGYLINEHEADER,&rval);
		  else
		    rval = atof(segy_trace_hdr_map[indx].tag);

                    put_indexed_hw_val(header,trace_hdr_map[indx]->format,
                            trace_hdr_map[indx]->index,
                            trace_hdr_map[indx]->length,
                            TRACEHEADER,rval);
		  break;
		  }
		}

	  if (verbose >= 2) {
	    get_indexed_hw_val(buffer, LineTrcNum_format, LineTrcNum_index,
		LineTrcNum_length, SEGYTRACEHEADER, &linetrcnum);
	    get_indexed_hw_val(buffer, TrcIdCode_format,TrcIdCode_index,
		TrcIdCode_length,SEGYTRACEHEADER,&trid);
	    get_indexed_hw_val(buffer, FieldRecNum_format, FieldRecNum_index,
		FieldRecNum_length, SEGYTRACEHEADER, &segy_prrcnm);
	    get_indexed_hw_val(buffer, FieldTrcNum_format, FieldTrcNum_index,
		FieldTrcNum_length, SEGYTRACEHEADER, &segy_prtrnm);
	    get_indexed_hw_val(buffer, TrcNumSmp_format, TrcNumSmp_index,
		TrcNumSmp_length, SEGYTRACEHEADER, &trcnumsmp);
	    get_indexed_hw_val(buffer, TrcSmpInt_format, TrcSmpInt_index,
		TrcSmpInt_length, SEGYTRACEHEADER, &segysmpint);
	    get_indexed_hw_val(buffer, CdpNum_format, CdpNum_index,
		CdpNum_length, SEGYTRACEHEADER, &cdpnum);
	    get_indexed_hw_val(buffer, CdpTrcNum_format, CdpTrcNum_index,
		CdpTrcNum_length, SEGYTRACEHEADER, &cdptrcnum);

	    fprintf(prtfile," %5d       %5d      %5d ",linetrcnum,segy_prrcnm,segy_prtrnm);
/*
	    fprintf(prtfile,"        %1d           %5d      %5d     %5d     %5d\n",
	    trid, trcnumsmp, segysmpint, cdpnum, cdptrcnum);
*/
	    fprintf(prtfile,"        %1d           %5d      %5d\n",
	    trid, trcnumsmp, segysmpint);
	    }

	    switch(fmtcode) {
		case(1):
/*
	    	  for (j=0; j<numsmp; j++) 
			ibmieee(buffer+SEGYTRACEHEADERBYTES+(j*sizeof(float)),
			header+SZTRHD+(j*sizeof(float)));
*/
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		        if (native_trace_data != 1)
	  		  HTOCL(buffer+SZTRHD,numsmp);
			ibm_to_float(buffer+SEGYTRACEHEADERBYTES,
				header+SZTRHD,numsmp,0);
#else
			ibm_to_float(buffer+SEGYTRACEHEADERBYTES,
				header+SZTRHD,numsmp,1);
#endif
		  break;
		case(3):
	    	  for (j=0; j<numsmp; j++) {
			*(float *)(header + SZTRHD + (j*SZSMPD)) = (float)
			  (*(short *)(buffer+SEGYTRACEHEADERBYTES+
				(j*sizeof(short))));
			}
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		  if (native_trace_data != 1) HTOCL(header+SZTRHD,numsmp);
#endif
		  break;
		case(2):
	    	  for (j=0; j<numsmp; j++) 
			*(float *)(header + SZTRHD + (j*SZSMPD)) = (float)
			  (*(int *)(buffer+SEGYTRACEHEADERBYTES+
				(j*sizeof(int))));
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		  if (native_trace_data != 1) HTOCL(header+SZTRHD,numsmp);
#endif
		  break;
		}
		  

	
	  C_WRTAPE(luout,header,SZTRHD+databytes);
	  }
}
int read_map_file(map_file,indx,to,from)
char *map_file;
char **from,**to;
int indx;
{
	int i,nelem;
	FILE *map_unit;
	char value[48];
	if (strlen(map_file) > 0) {
	  map_unit = fopen(map_file,"r");
	  if (map_unit == NULL) {
	    fprintf(stderr,"SEGY2USP ERROR: Unable to open map file %s; aborting\n",
		map_file);
	    if (verbose != 0)
	     fprintf(prtfile,"SEGY2USP ERROR: Unable to open map file %s; aborting\n",
		map_file);
	    exit(1);
	    }
	  else {
	    do {
		nelem = fscanf(map_unit,"%s\n",value);
		if (nelem > 0) {
		  indx++;
	          to[indx] = (char *)strdup(value);
	          from[indx] = (char *)strchr(to[indx],'=')+1;
	          to[indx][from[indx]-to[indx]-1] = '\0';
/*
   if we find an override, put it in the map at the location of the 
   previous specification
*/
		  for (i=0; i<indx; i++) {
		    if (strcmp(to[i],to[indx]) == 0) {
		      fprintf(stderr,"SEGY2USP: Duplicate specifications for mnemonic %s;\n          %s=%s overrides previous entry of %s=%s\n",to[indx],to[indx],from[indx],to[i],from[i]);
		      fprintf(prtfile," SEGY2USP: Duplicate specifications for mnemonic %s;\n          %s=%s overrides previous entry of %s=%s\n",to[indx],to[indx],from[indx],to[i],from[i]);
		      from[i] = from[indx];
		      to[i] = to[indx];
		      indx--;
		      break;
		      }
		    }
		  }
		} while (nelem >= 0);
	  }
	}
	else {
	  strcpy(map_file,"N/A");
	}

	if (verbose != 0)
	  fprintf(prtfile," number of items in %s = %d\n",map_file,indx);
	return(indx);
}
