C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetStatic ( tri, WindowMin, WindowMax, nsampcross,
     :     nsi, Lag, MaxCrossAmp, CrossThreshold, ShotStatic, picks )

c This routine searches for a maximum amplitude given a
c time series [tri()] and search limits [WindowMax,WindowMin, where
c these limits are supplied in milliseconds]
c by resampling the windowed interval in istep microsecond
c intervals [using cubic spline interpolation].  The index
c of the maximum positive amplitude is used to calculate the
c represented static shift of the two time series used to form
c the cross correlation which is output in milliseconds [ShotStatic]

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer nsampcross,WindowMax,WindowMin,nsi,Lag
      integer index,istep,StaticIndex

      real tri(nsampcross)
      real ShotStatic,work(12500),SecondDerivativeCoefs(12500)
      real Times(SZLNHD),yp1,ypn,amplitude,MaxCrossAmp,x
      real CrossThreshold

      character picks*(*)

c declare local variables

      integer islpsw, ierr

      real sigma, temp(2*SZLNHD)

      data yp1/1.e31/,ypn/1.e31/

c initialize arrays

      call vclr(work,1,12500)
      call vclr(SecondDerivativeCoefs,1,12500)

c build Times array relative to tri data sampled at nsi ms but make
c the time values microseconds [ie. ms * 1000.]. THIS WILL MOVE TO THE 
c MAIN ROUTINE AND BE PASSED AS AN ARGUMENT SO IT DOESNT HAVE TO BE
c BUILT EVERY TIME.  For now I will leave it here for clarity.
c
c Note: times contain negative numbers for negative lags

      do i=1,nsampcross

         Times(i) =  (float(i-(Lag+1))*float(nsi))*1000.

      enddo


c create array of second derivative coeffs for use in spline interpolation
c set yp1 and ypn to result in natural spline. 

c      call spline(Times,tri,nsampcross,yp1,ypn,SecondDerivativeCoefs)

      islpsw = 3
      call curv1 ( nsampcross, Times, tri, yp1, ypn, islpsw, 
     :     SecondDerivativeCoefs, temp, sigma, ierr)


c interpolate array from WindowMin (microseconds) to WindowMax
c using an nsi/1000 sample interval.  To do this I need an array of input times
c in microseconds corresponding to the sample times of the cross-correlation
c amplitudes.  Then I need an output array to contain the data sampled at the
c new nsi with a check to make sure I dont create more that 12500 samples.  If
c I do then reset the interpolation sample interval and print a warning to the
c printfile.

      istep = nsi

 10   if(((WindowMax - WindowMin +1)*1000/istep + 1).gt.12500)then

         istep = istep + 1

         write(LERR,*)' '
         write(LERR,*)'ARCSCUM: number of samples requried while '
         write(LERR,*)'         searching for cross correlation '
         write(LERR,*)'         maximum is greater than 12500.  Am '
         write(LERR,*)'         increasing the delta t of the '
         write(LERR,*)'         resampled cross correlation which  '
         write(LERR,*)'         will result in a coarser static '
         write(LERR,*)'         estimate. '
         write(LERR,*)' '
         write(LERR,*)'       Old step size =  ',istep - 1
         write(LERR,*)'       New step size =  ',istep 
         write(LERR,*)' '
         write(LERR,*)'WARNING'

         goto 10

      endif

c create work() array containing cross correlation resampled to
c finer sample interval as provided by above step size calculation

      index = 1

      do i = WindowMin*1000,WindowMax*1000,istep

         x = float(i)

c         call splint(Times,tri,SecondDerivativeCoefs,nsampcross,x,
c     :        amplitude)

         amplitude = curv2( x, nsampcross, Times, tri, 
     :        SecondDerivativeCoefs, sigma )

         work(index) = amplitude
         index = index +1

      enddo

      index = index - 1

c find maximum positive value of cross-correlation 

      call maxv(work,1,MaxCrossAmp,StaticIndex,index)

c calculate ShotStatic in MilliSeconds [ie: 1.036 ms]
c If the CrossCorrelation amplitude at the max in the
c window is not equal to or greater than the threshold
c then assign a zero static to this location.

      if ( picks .eq. ' ' ) then

c at this point I have not read in a crosspicks file so go ahead
c and do the thresholding

         if ( MaxCrossAmp .ge. CrossThreshold )then
      
            ShotStatic=(float(WindowMin*1000)+
     :           (float((StaticIndex-1)*istep)))/1000. 

         else

            ShotStatic = 0.

         endif

      else

c at this point the user has full control over the crosscorrelation
c being supplied and does not want any thresholding done.  So dont
c do it.

         ShotStatic=(float(WindowMin*1000)+
     :        (float((StaticIndex-1)*istep)))/1000. 


      endif

      return
      end
