C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c                       arcscum
c
c Adjacent Record Cumulative Statics: cumulative static curve generation
c
c declare standard USP variables
c
c Changes
c
c Aug 3 2001: fixed bug in spline curv1 call where isplsw was not initialized to
c             3.  This allows the routine to make its own estimate of 1st and last
c             element first derivative values.  This is required to get the thing
c             to interpolate smoothly.  I also added implicit none and correct some
c             undefined variables.
c Garossino

      implicit none
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     argis

      real        tri( 2* SZLNHD )

      character   ntap*255, otap*255, name*7

      logical     verbos

      integer     CrossIndex(2*SZLNHD)

      real        CrossPicks(2*SZLNHD)
      real        CrossPickLocation(2*SZLNHD)

c declare program specific static memory variables

      integer   RecNum, SmoothOrder
      integer   ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer   ifmt_RecInd, l_RecInd, ln_RecInd
      integer   MaxCrossLag, Rec2RecMaxStatic, Lags
      integer   npicks, lugraph, luplotxy
      integer   nsegsCross, lucrosspick
      integer   WindowMin, WindowMax, XgraphIndex(2*SZLNHD)

      real      ShotStatic, MaxCrossAmp, CrossThreshold
      real      work1(2*SZLNHD), work2(2*SZLNHD)
      real      CumShotStatic(2*SZLNHD), CumSmoothedDiff(2*SZLNHD) 
      real      CrossCorrAmp(2*SZLNHD), SmoothedCumShotStatic(2*SZLNHD)

      character   crosspicktap*255, plotxytap*255, SortFlag*1

c variables picked up by implicit none

      integer lbytes, jerr, leplotxytap, lenth, lucross, nbytes
      integer lecrosspicktap, leotap, lentap, JJ, ii

      real UnitSc

c initialize variables

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'ARCSCUM'/

      call vclr ( work1, 1, 2*SZLNHD )
      call vclr ( work2, 1, 2*SZLNHD )
      call vclr ( CumShotStatic, 1, 2*SZLNHD )
      call vclr ( CumSmoothedDiff, 1, 2*SZLNHD )
      call vclr ( CrossCorrAmp, 1, 2*SZLNHD )
      call vclr ( SmoothedCumShotStatic, 1, 2*SZLNHD )
      call vclr ( XgraphIndex, 1, 2*SZLNHD )
      call vclr ( CrossIndex, 1, 2*SZLNHD )
      call vclr ( CrossPicks, 1, 2*SZLNHD )
      call vclr ( CrossPickLocation, 1, 2*SZLNHD )

c get command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c Open Printout File

#include <f77/open.h>

c get Command Line Parameters

      call gcmdln ( ntap, otap, crosspicktap, plotxytap, 
     :     Rec2RecMaxStatic, SmoothOrder, CrossThreshold, verbos )

c ntap : input crosscorrelation dataset name
c otap : output xgraph dataset name
c crosspicktap : crosscorrelation pickfile dataset name 
c plotxytap: manual fit to cum stat curve from plotxy
c Rec2RecMaxStatic : user defined maximum static to allow between records (ms)
c                   [default 8 ms]
c SmoothOrder: smoothing parameter for fft smoothing of cum static curve
c CrossThreshold: normalized amplitude threshold below which static will be assigned as zero
c verbos : verbosity flag
 
c open input datasets

      if ( plotxytap .ne. ' ' ) then

         call alloclun(luplotxy)
         leplotxytap = lenth(plotxytap)
         open(unit=luplotxy,file=plotxytap(1:leplotxytap),
     :        status='old',err=997)

      else         

         call getln ( lucross, ntap, 'r', 0)

         if ( crosspicktap .ne. ' ' ) then
            call alloclun(lucrosspick)
            lecrosspicktap = lenth(crosspicktap)
            open(unit=lucrosspick,file=crosspicktap(1:lecrosspicktap),
     :           status='old',err=996)
         endif

      endif

c open output xgraph file
         
      call alloclun(lugraph)
      leotap = lenth(otap)
      open ( unit=lugraph, file=otap(1:leotap), status='unknown', 
     :     err=992 )

c if this is not a QC run from a plotxy file then read the crosscorrelation data

      IF ( plotxytap .eq. ' ' ) then

c read input crosscorrelation line header 

         call rtape  ( lucross, itr, lbytes)
         if(lbytes .eq. 0) then
            lentap = lenth(ntap)
            write(LER,*)' '
            write(LER,*)'ARCSCUM: No data found in ',ntap(1:lentap)
            write(LER,*)'FATAL'
            stop
         endif
 
c save certain parameters

         call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     :        TRACEHEADER)
         call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,
     :        TRACEHEADER)

         call saver(itr, 'NumSmp', nsamp, LINHED)
         call saver(itr, 'SmpInt', nsi  , LINHED)
         call saver(itr, 'Format', iform, LINHED)
         call saver(itr, 'NumTrc', ntrc , LINHED)
         call saver(itr, 'NumRec', nrec , LINHED)
         call saver(itr, 'EqpCod', SortFlag , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
c print the historical line header to the printout file

         call hlhprt (itr, lbytes, name, 7, LERR)
 
c modify line header to reflect actual number of traces output

         Lags = ( nsamp - 1 ) / 2

         if ( Rec2RecMaxStatic .eq. 0 ) Rec2RecMaxStatic = Lags

      ENDIF
 
c output of all pertinent information before processing begins

      call verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     crosspicktap, Rec2RecMaxStatic, SmoothOrder, plotxytap, 
     :     verbos )
 
c read cross correlation window pick file if supplied

      if ( crosspicktap .ne. ' ' ) then

         call CrossPickCount ( lucrosspick, npicks, nsegsCross )

         call ReadCrossPicks ( lucrosspick, CrossPicks, 
     :        CrossPickLocation, CrossIndex, nsegsCross )

      endif


      IF ( plotxytap .eq. ' ' ) then

c Generate Statics Graph

         DO JJ = 1, nrec

            call rtape ( lucross, itr, lbytes )
            if ( lbytes .eq. 0 ) then
               write(LERR,*)'End of file on input:'   
               write(LERR,*)'  rec= ',jj
               go to 999
            endif

            call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )

c Normalize cross correlation to the maximum positive amplitude

            call maxv ( tri, 1, MaxCrossAmp, MaxCrossLag, nsamp )


c if this is a QC run using the plotxy file as input then skip all the
c static determination because that will be done already.


            do ii = 1, nsamp
               tri(ii) = tri(ii) / MaxCrossAmp
            enddo

c assign static search window limits

            if ( crosspicktap .ne. ' ' ) then

c get limits from user digitization of cross correlation limits

c               call saver2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
c     :              RecNum, TRACEHEADER )

c this is to make sequential search in pickfile legal.

               RecNum = JJ

               call ReadLimits ( CrossPicks, CrossPickLocation, 
     :              CrossIndex, nsegsCross, Lags, nsi, RecNum, verbos, 
     :              WindowMin, WindowMax )

            else

c use limits from command line

               WindowMin = 0 - Rec2RecMaxStatic
               WindowMax = Rec2RecMaxStatic
            
            endif

c determine shot static based on windowed cross correlation
            
            if ( iabs( WindowMax - WindowMin ) .gt. 1 ) then

c calculate time of positive maximum of cross-correlation within window
c This should be done using microsecond sample interval to
c minimize error in the cumulative static curve. 

               call GetStatic ( tri, WindowMin, WindowMax, nsamp, 
     :              nsi, Lags, MaxCrossAmp, CrossThreshold, ShotStatic, 
     :              crosspicktap )
               
            else

c set static to zero and make cross amp -0.1 to indicate that static
c at this location was not accepted due to cross correlation pick file
c exclusion

               ShotStatic = 0.
               MaxCrossAmp = -0.1
            
            endif
            

c load maximum cross correlation amplitude found within search limits
c in GetStatic.  This array will be plotted with other Xgraph stuff to
c provide a visual aid to determine the effects of the cross correlation
c threshold parameter

            CrossCorrAmp(JJ) = MaxCrossAmp

c load current value to CumShotStatic array unless plotxy input is present

            if ( JJ .gt. 1 ) then
               CumShotStatic(JJ) = CumShotStatic( JJ - 1 ) + ShotStatic
            else
               CumShotStatic(JJ) = ShotStatic 
            endif

c Assign x axis index for xgraph plot and application reference.
c This is the SrcLoc or RecInd  of the Object trace depending on
c the sortflag

            if ( SortFlag .eq. 'S' ) then
               
               call saver2 ( itr, ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc, 
     :              XgraphIndex(JJ), TRACEHEADER )
            
            elseif ( SortFlag .eq. 'G' ) then 
            
               call saver2 ( itr, ifmt_RecInd, l_RecInd, ln_RecInd, 
     :              XgraphIndex(JJ), TRACEHEADER )
            
            endif


         ENDDO

      ENDIF

      IF ( plotxytap .eq. ' ' ) then

c calculate smoothed version of cumulative static curve

         call vmov ( CumShotStatic, 1, SmoothedCumShotStatic, 1, 
     :        nrec )
         call SmoothFit ( SmoothedCumShotStatic, nrec, SmoothOrder )

c calculate source static for this iteration

         call vsub ( CumShotStatic, 1, SmoothedCumShotStatic, 1, 
     :        CumSmoothedDiff, 1, nrec )

      ELSE

         call ManualLoad ( luplotxy, XgraphIndex, CumShotStatic,
     :        SmoothedCumShotStatic, CumSmoothedDiff, work1, work2, 
     :        nrec )

         call vfill ( -0.1, CrossCorrAmp, 1, nrec )

      ENDIF

c output curves to xgraph file

      call XgraphOut ( lugraph, CumShotStatic, SmoothedCumShotStatic,
     :     CumSmoothedDiff, XgraphIndex, CrossCorrAmp, nrec )

c GO TO NORMAL TERMINATION

      goto 999

c ERROR MESSAGES

 992  continue

      write(LERR,*)' ARCSCUM: Cannot open output xgraph file'
      write(LERR,*)'       Check write permissions in current '
      write(LERR,*)'       directory and try again.'
      write(LERR,*)'  '
      write(LERR,*)' FATAL'
      write(LER,*)' ARCSCUM: Cannot open output xgraph file'
      write(LER,*)'       Check write permissions in current '
      write(LER,*)'       directory and try again.'
      write(LER,*)'  '
      write(LER,*)' FATAL'
      stop

 996  continue

      write(LER,*)'  '
      write(LER,*)' ARCSCUM: Cannot open cross correlation window pick'
      write(LER,*)'       file: ',crosspicktap(1:lecrosspicktap)
      write(LER,*)'       Check existance and rerun'
      write(LER,*)' '
      write(LER,*)' FATAL'
      write(LERR,*)'  '
      write(LERR,*)' ARCSCUM: Cannot open cross correlation window pick'
      write(LERR,*)'       file: ',crosspicktap(1:lecrosspicktap)
      write(LERR,*)'       Check existance and rerun'
      write(LERR,*)' '
      write(LERR,*)' FATAL'
      stop

 997  continue

      write(LER,*)'  '
      write(LER,*)' ARCSCUM: Cannot open Plotxy data file:  '
      write(LERR,*)'     ', plotxytap(1:leplotxytap)
      write(LERR,*)'      Check existance and rerun'
      write(LERR,*)' '
      write(LER,*)' FATAL'
      write(LERR,*)'  '
      write(LERR,*)' ARCSCUM:  Cannot open Plotxy data file:  '
      write(LERR,*)'      ',plotxytap(1:leplotxytap)
      write(LERR,*)'        Check existance and rerun'
      write(LERR,*)' FATAL'
      stop

c Normal Termination

 999  continue
 
      if ( plotxytap .eq. ' ' ) then
         call lbclos(lucross)
         if ( crosspicktap .ne. ' ' ) close(lucrosspick)
      else
         close(luplotxy)
      endif

      close(lugraph)

c Termination Messages

      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'processed',nrec,' record(s)',' with ',ntrc, 
     :     ' traces'
      write(LERR,*)'       Normal Termination'

      write(LER,*)'ARCSCUM: Normal Termination'

      stop
      end
