C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C This AVBU program is the batch (USP) version of the ILIS interactive 
C program called AVB.  This version has been optimized to move the
C filter "design" step outside of the application loop thereby eliminating
C the need for re-generating the operator(s) for every trace processed.
C
C Original algorithm : R.O. Lindsay and M.C. Kelly, 8 May 1990
C Batch versioin     : Herb Wright, 13 August 1992
C Optimized version  : R.O. Lindsay and D.A. Ford, 18 April 1994
C
C AVB and AVBU generate three trace output records containing trace,
C omega zero and one traces.  The trace is a filtered trace at fone,
C ftwo, f3uppr, f4uppr bandwidth.  Omega zero and omega one traces,
C identified as w0 and w1, are the intercept and slope of a line
C of amplitudes at each isotime as a function of upper frequency.
C Upper frequency is defined as: (f3+f4) / 2.
C
C    get machine dependent parameters
C
#include     <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
C
C
      integer
     : itr ( SZLNHD )
C
      integer
     : lhed( SZLNHD )
C
      integer
     : argis, iatt, ierr, ierror, iform, imode, inorm,
     : ire, irs, lbyout, lbytes, luin, luout, nbytes, ne, nfilt,
     : nrec, nrout, ns, nsamp, nsi, ntout, ntrc, obytes, recnum,
     : static, trcnum, type, weight, rflag
C
C Revision by Lindsay, 19 April 1994.
C Dimension new integers.
C
      integer mxsz,jtr,nrecc,ifrout,i,k,jr,jj,ic,kk,lll,j
C
C End revision.
C
      parameter 
     : (mxsz = 4096, nfilt = 10)
C
      real
     : w0(mxsz), w0copy(mxsz), w1(mxsz),avb(mxsz,10), tri (mxsz),
     : temp(mxsz), sqlobe(mxsz,10), fone, ftwo, f3lowr,
     : f4lowr, f3uppr, f4uppr, angle, q, dt, scale(nfilt),
     : runs(mxsz)
C
C Revision by Lindsay, 19 April 1994.
C Dimension new reals.
C
      real foa(mxsz,nfilt), fop(mxsz),f(4),fn,df3,df4,tempa(mxsz),
     :     tempp(mxsz),dummy
C
C End revision.
C
      character
     : ntap * 512, otap * 512, name*4,  dttm * 24
C
      logical
     : verbos, query
C
c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
C 
C Revision by Lindsay, 20 April 1994
C Weight changed from 1, (yes) to 0, (no).
C
      data lbytes/0/,nbytes/0/,name/'AVBU'/,
     :angle/0.0/,weight/0/,type/0/,q/3.0/
C
C
C Read program parameters from command line card image file looking
C for the "help" request.
C
      query = (( argis ('-?').gt. 0).or.(argis('-H').gt.0).or.
     *         (argis ('-h').gt.0))
      if ( query )then
            call help()
            stop
      endif
C
C Open printout files. This consists of a program name and parent process 
C id number: AVBU.nnnnn  This should be unique even for multiple occurences 
C of the same process in a pipeline.
C
#include <f77/open.h>
C
C Tell user starting date and time
C
      call fgdate(dttm)
      write(lerr,*)' '
      write(lerr,*)' execution started at:'
      write(lerr,*)dttm
      write(lerr,*)' '
#ifdef SUNSYTEM
      call dtime(tarray)
#endif
C     write(lerr,*)'dtime = ',tarray(1), tarray(2)
C
C Read the command line for parameters.
C
      call gcmdln(ntap,otap,ns,ne,irs,ire,fone,ftwo,f3lowr,
     :            f4lowr,f3uppr,f4uppr,inorm,iatt,imode,verbos,
     :            rflag)
C
C Test for missing I/O units.
C
c     if(ntap.eq.' ') then
c         write(lerr,*)' **** error ****'
c         write(lerr,*)' **** ntap not on command line'
c         stop
c     endif
C
c     if(otap.eq.' ') then
c         write(lerr,*)' **** error ****'
c         write(lerr,*)' **** ntap not on command line'
c         stop
c     endif
C
C Get logical unit numbers for input and output of seismic data.
C 0 = default stdin, 1 = default stdout
C
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

C
C Read line header of input file and save needed parameters.
C
      call rtape(luin, itr, lbytes)
C
C Test for missing header.
C
      if(lbytes.eq.0) then
          write(LOT,*)'PRGM: no header read from unit ',luin
          write(LOT,*)'FATAL'
          stop
      endif
C
C Get line header values from itr into variables.
C
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

C
C Print the hlh.
C
      call hlhprt (itr, lbytes, name, 4, lerr)
C
C Test for too many smaples per trace.
C
      ierr = 0
      if(nsamp.gt.4096) then
        write(lerr,*)' input # samples/trace too many for avbu'
        write(lerr,*)' limit is 4096 - # samples found in line header ='
        write(lerr,*)nsamp
        ierr = 1
      endif
C
C Test for correct data format.
C
      if(iform.ne.3.and.iform.ne.1) then
          ierr = 1
          write(lerr,*)' Only format 1 or 3 data allowed'
      endif
      if(ierr.ne.0) stop
C
C Ensure that command line values are compatible with data set
C (i.e. start/end traces; start/end records).
C
      call parchk(ns,ne,irs,ire,ntrc,nrec,inorm,iatt,imode,
     :            fone,ftwo,f3lowr,f4lowr,f3uppr,f4uppr,lerr)
C
C Modify line header to reflect actual number of traces to output.
C
      jtr = ne - ns + 1
      nrecc = ire - irs + 1
      nrout = nrecc * jtr
      call savew(itr, 'NumRec', nrout, LINHED)
      if(rflag.eq.0) then
      	ntout = 3
      else
          ntout = 4
      endif
      call savew(itr, 'NumTrc', ntout , LINHED)
      if(iform.eq.1) then
          ifrout = 3
          call savew(itr, 'Format', ifrout, LINHED)
      endif
C
C Find number of output bytes.
C
      obytes = SZTRHD + nsamp * SZSMPD
C
C Save info to output header.
C
      call savhlh(itr,lbytes,lbyout)
      call wrtape (luout,itr,lbyout)
C
C ?
C
      call verbal(ntap,otap,nsamp,nsi,ntrc,nrec,iform,
     :      ns,ne,irs,ire,inorm,iatt,imode,nrout,ntout,
     :      fone,ftwo,f3lowr,f4lowr,f3uppr,f4uppr,lerr)
C
C Compute sample interval in seconds. Take care of microseconds
C if necessary.
C
          dt = float(nsi) * unitsc
C
C Revision by Lindsay, 19 April 1994.
C Generate filter operators and scalars.
C
C Load the phase array with zeros as AVB is zero phase.
C
      do 50 i=1,nsamp
          fop(i) = 0.0
   50 continue
C
C design the filter points based upon user bandwidth selections.
C
      fn = 1.0 / (2.0 * dt)
      df3 = (f3uppr - f3lowr) / 9.0
      df4 = (f4uppr - f4lowr) / 9.0
      f(1) = fone
      f(2) = ftwo
C
C Generate the amplitude spectra
C
      do 60 k=1,10
          f(3) = f3lowr + float(k-1) * df3
          f(4) = f4lowr + float(k-1) * df4
          if(f(3).gt.fn) f(3) = fn
          if(f(4).gt.fn) f(4) = fn
          call ofd1d(tempa,tempp,nsamp,dt,f,angle,weight,
     :               type,q)
C
C Copy the spectra into the 2d array foa(*,*).
C
          do 70 i=1,nsamp
              foa(i,k) = tempa(i)
   70     continue
C
C Find normalization scalars if inorm = 1.
C
          if(inorm.eq.1) then
              call getfac(f,angle,weight,type,q,dt,
     :                    scale(k),dummy,ierror)
          endif
   60 continue
C
C End revision.
C
C
C Find the output record counter, jr.
C
      jr = irs - 1
C
C Begin processing traces.
C
C Skip unwanted records.
C
      call recskp(1,irs-1,luin,ntrc,itr)
C
C Process desired records
C
      do 1000 jj = irs, ire
C
C Skip to start trace, ns.
C
          call trcskp(jj,1,ns-1,luin,ntrc,itr)
          ic = 0
          do 1001  kk = ns, ne
              nbytes = 0
              call rtape( luin, itr, nbytes)
C
C If end of data encountered (nbytes=0) then exit loop.
C
              if(nbytes .eq. 0) then
                  write(lerr,*)'End of file on input:'
                  write(lerr,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
              endif
              call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
C
C Copy header values into variables.
C
C             dist   = itr(117)
c             static = itr(125)
c             recnum = itr(106)
c             trcnum = itr(107)
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                         static, TRACEHEADER)
                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
C
C Test for dead trace flag.
C
              if(static .eq. 30000) then
                  call vclr (tri,1,nsamp)
                  jr = jr + 1
                  do 950 lll = 1,ntout
c                     itr(106) = jr
c                     itr(107) = lll
                  call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        jr  , TRACEHEADER)
                  call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        lll , TRACEHEADER)
                      call wrtape (luout, itr, obytes)
950               continue
                  if(verbos) then
                      write(lerr,*)' processed input ri ',recnum,
     :                             ' trace ',trcnum
                  endif
                  goto 1001
              endif
              if(iform.eq.1) then
                  k = 128
                  do 975 j = 1, nsamp
                      k = k + 1
                      temp(j) = itr(k) 
975               continue
                  call vmov(temp,1,tri,1,nsamp)
              endif
C
C Revision by Lindsay, 19 April 1994.
C Generate the AVB values.
C
C Old method commented out
C
C             call gnavb2u(tri,nsamp,fone,ftwo,f3lowr,f4lowr,f3uppr,
C    :                     f4uppr,angle,weight,type,q,nfilt,dt,
C    :                     w0,w0copy,w1,avb,sqlobe,inorm,iatt,
C    :                     imode,ierror)
C
C New method uses operators that are designed OUTSIDE of gnavb3u.
C
C              call gnavb3u(tri,nsamp,fone,ftwo,f3lowr,f4lowr,f3uppr,
C    :                     f4uppr,angle,weight,type,q,nfilt,dt,
C    :                     w0,w0copy,w1,avb,sqlobe,inorm,iatt,
C    :                     imode,ierror,foa,fop,scale)
C
C New method uses operators that are designed OUTSIDE of gnavb4u. and runs
C trace is now output
C
C
               call gnavb4u(tri,nsamp,fone,ftwo,f3lowr,f4lowr,f3uppr,
     :                     f4uppr,angle,weight,type,q,nfilt,dt,
     :                     w0,w0copy,w1,avb,sqlobe,inorm,iatt,
     :                     imode,ierror,foa,fop,scale,runs)

C If gnavb3u found an error (or caused one) handle it.
C
              if(ierror .ne. 0) then
                  write(lerr,*)' '
                  write(lerr,*)' error = ',ierror
                  write(lerr,*)' returned from genavb.'
                  write(lerr,*)' '
                  stop
              endif
C
C Write the processed AVB traces out.
C
              jr = jr + 1
c             itr(106) = jr
c             itr(107) = 1
      call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            jr  , TRACEHEADER)
      call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            1   , TRACEHEADER)
              call vmov(avb(1,nfilt), 1, itr(ITHWP1), 1, nsamp)
              call wrtape (luout, itr, obytes)
c             itr(107) = 2
      call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            2   , TRACEHEADER)
              call vmov ( w0, 1, itr(ITHWP1), 1, nsamp )
              call wrtape (luout,itr,obytes)
c             itr(107) = 3
      call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            3   , TRACEHEADER)
              call vmov( w1, 1, itr(ITHWP1), 1, nsamp )
              call wrtape (luout, itr, obytes)
              if(rflag.eq.1) then
c             	itr(107) = 4
      call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            4   , TRACEHEADER)
              	call vmov( runs, 1, itr(ITHWP1), 1, nsamp )
              	call wrtape (luout, itr, obytes)
              endif
              if(verbos) then
                  write(lerr,*)' processed input ri ',recnum,
     :                         ' trace ',trcnum
              endif
1001      continue
C
C Skip to end of record.
C
          call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
 1000 continue
C
C Close data files
C
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
C
C Tell the user that the job is done and how it ended.
C
      write(lerr,*)' end of job '
      write(lerr,*)' '
      write(lerr,2000)nrec,jtr,nrout
2000  format(' no. of input records processed       = ',i5/
     :       ' input traces/record                  = ',i5/
     :       ' no. output records (3 traces/record) = ',i5)
C
C Tell user ending date and time
C
      call fgdate(dttm)
      write(lerr,*)' '
      write(lerr,*)' execution terminated at:'
      write(lerr,*)' ',dttm
      write(lerr,*)' '
C
C ?
C
#ifdef SUNSYTEM
      call dtime(tarray)
      elapt = tarray(1)+tarray(2)
      write(lerr,*)' avbu   time(secs) = ',tarray(1)
      write(lerr,*)' system time(secs) = ',tarray(2)
      write(lerr,*)' total  time(secs) = ',elapt
#endif
      stop 
      end
