 
#include <stdio.h>

#define DISK_IT  disk_it_
#define DISK_WR  disk_wr_
#define DISK_RD  disk_rd_
#define DISK_RWIN  disk_rwn_
#define DISK_WWIN  disk_wwn_
#define DISK_DL  disk_dl_

int DISK_IT( int *nsamp,int *nbufsize,float *buf, int *nchars, char *dirct )
{
        int disk_it(int nsamp,int nbufsize,float *buf, int nchars, char *dirct);
        int xnsamp;
        int xnchars;
        int xnbufsize;
        int i;

        xnsamp = *nsamp;
        xnchars = *nchars;
        xnbufsize = *nbufsize;
        i = disk_it(xnsamp, xnbufsize, buf,xnchars, dirct );
 
        return i;
}

int DISK_WR( int *nsamp,int *index,float *buf )
{
        int  disk_wrte(int nsamp,int index,float *buf);
        int xnsamp;
        int xindex;
        int i;

        xnsamp = *nsamp;
        xindex = *index;

        i = disk_wrte(xnsamp, xindex, buf );
 
        return i;
}

int DISK_WWIN( int *nsamp,int *index, int *isamp, int *nsmp, float *buf )
{
        int  disk_wwin(int nsamp,int index,int isamp, int nsmp, float *buf);
        int xnsamp;
        int xindex;
	int xisamp;
	int xnsmp;
        int i;

        xnsamp = *nsamp;
        xindex = *index;
	xisamp = *isamp;
	xnsmp  = *nsmp;

        i = disk_wwin(xnsamp, xindex, xisamp, xnsmp, buf );
 
        return i;
}

int DISK_RD( int *nsamp,int *index,float *buf )
{
        int  disk_reed(int nsamp,int index,float *buf);
        int xnsamp;
        int xindex;
        int i;

        xnsamp = *nsamp;
        xindex = *index;

        i = disk_reed(xnsamp, xindex, buf );
 
        return i;
}

int DISK_RWIN( int *nsamp,int *index,int *isamp, int *nsmp, float *buf )
{
        int  disk_rwin(int nsamp,int index,int isamp, int nsmp, float *buf);
        int xnsamp;
        int xindex;
	int xisamp;
	int xnsmp;
        int i;

        xnsamp = *nsamp;
        xindex = *index;
	xisamp = *isamp;
	xnsmp  = *nsmp;

        i = disk_rwin(xnsamp, xindex, xisamp, xnsmp, buf );
 
        return i;
}

int DISK_DL( )
{
        int i;

        i = disk_dlte();
 
        return i;
}


static FILE *fout;
static char FileName[81];
static int FileOpen = 0; 

#include <time.h>
 
/* initialize the disk buffer  */
        int disk_it(int nsamp,int nbufsize,float *buf,int nchars, char *dirct)
{

        time_t *tp1;
        time_t tp1a;
        int n;
        char cn[81];
        time_t t;
        void itox( int n, char s[]);
	long nsampl;

	nsampl = nsamp;
        tp1 = &tp1a;
        t = time( tp1);
        n = t;
        itox(n, cn);

        if ( nchars > 0) {
          strncpy(FileName,dirct,nchars);
        }
        else {
          strcpy(FileName,"/tmp");
        }
        strcat(FileName,"/fxydeconjunk");
        strcat(FileName,cn);

        printf("Output work file is %s\n",FileName);
 
        if((fout = fopen(FileName,"w+b"))==NULL) {
                printf("Cannot open output file!\n");
                exit(1);
                }
        FileOpen = -1;
   

/* do not bother to format the disk --- not needed for unit ---
=================================================================
        nbytes = nsampl * sizeof(float);
        ST_ONE = 1;
        for(i=0;i<nbufsize;i++) {
                actual = fwrite(buf, nbytes, ST_ONE, fout);
                   if ( actual != ST_ONE) {
                     printf("Error in fwrite during format\n");
                     printf("Requested index=%d\n",i);
                     printf("Requested Number of records=%d\n",ST_ONE);
                     printf("Actual Number of records wrote=%d\n",actual);
    
                       if((remove(FileName))!= 0) {
                         printf("Cannot remove output file!\n");
                         exit(1);
                         }
   
                     exit(1);
                   }
        }
=================================================================
*/

/*   WARNING   ---- DANGER   --- READ THIS ---
     warning   ---- danger   --- read this ---
     ok -  this is something I do not like--    
     to remove a file in the case of a job ending abnormally,
     I am taking the systems group's suggestion that I "unlink"
     the disk buffer so it will disappear at the end of the job.
     This seems dangerous, but it keeps the disks clean.      */
    
	/*    printf("Unlinking output file\n");  */
                       if((unlink(FileName))!= 0) {
                         printf("Cannot unlink output file!\n");
                         exit(1);
                         }
        /*      printf("Unlinking of output file successful\n"); */
   

        return 0;
}

/* write to the disk buffer  */
        int  disk_wrte(int nsamp,int index,float *buf)
{
        size_t nbytes;
        size_t ST_ONE;
        size_t actual;
        long ipos;
        int i;
        int ierr;
        int iorig=SEEK_SET ;
        float *bufi;
	long nsampl;

	nsampl = nsamp;
        ipos = (index-1) * nsampl * sizeof(float);
               ierr = fseek(fout, ipos, iorig);
                if ( ierr != 0) {
                  printf("Error in fseek a\n");
		  printf(" ipos,index,nsampl=%d %d %d\n",ipos,index,nsampl);
                  exit(1);
                }

        nbytes = nsampl * sizeof(float);
        ST_ONE = 1;

        bufi = buf;
        actual = fwrite(buf, nbytes, ST_ONE, fout);
           if ( actual != ST_ONE) {
             printf("Error in fwrite\n");
             printf("Requested index=%d\n",index);
             printf("Requested Number of records=%d\n",ST_ONE);
             printf("Actual Number of records wrote=%d\n",actual);
             exit(1);
           }

        return 0;
}



/* write to the disk buffer for a window  */
        int  disk_wwin(int nsamp,int index, int isamp, int nsmp ,float *buf)
{
        size_t nbytes;
        size_t ST_ONE;
        size_t actual;
        long ipos;
        int i;
        int ierr;
        int iorig=SEEK_SET ;
        float *bufi;
	long nsampl;

	nsampl = nsamp;
        ipos = (index-1) * nsampl * sizeof(float);
	ipos = ipos + ( (isamp-1) * sizeof(float));
               ierr = fseek(fout, ipos, iorig);
                if ( ierr != 0) {
                  printf("Error in fseek b\n");
		  printf(" ipos,index,nsamp=%d %d %d\n",ipos,index,nsamp);
                  exit(1);
                }

        nbytes = nsmp * sizeof(float);
        ST_ONE = 1;

        bufi = buf;
        actual = fwrite(buf, nbytes, ST_ONE, fout);
           if ( actual != ST_ONE) {
             printf("Error in fwrite in disk_wwin\n");
             printf("Requested index=%d\n",index);
             printf("Requested Number of records=%d\n",ST_ONE);
             printf("Actual Number of records wrote=%d\n",actual);
             exit(1);
           }

        return 0;
}


/* read from the disk buffer  */
        int  disk_reed(int nsamp,int index,float *buf)
{
        size_t nbytes;
        size_t ST_ONE;
        size_t actual;
        long ipos;
        int i;
        int ierr;
        int iorig=SEEK_SET ;
        float *bufi;
	long nsampl;

	nsampl = nsamp;
        ipos = (index-1) * nsampl * sizeof(float);
               ierr = fseek(fout, ipos, iorig);
                if ( ierr != 0) {
                  printf("Error in fseek c\n");
		  printf(" ipos,index,nsamp=%d %d %d\n",ipos,index,nsamp);
                  exit(1);
                }

        nbytes = nsampl * sizeof(float);
        ST_ONE = 1;

        actual = fread(buf, nbytes, ST_ONE, fout);
           if ( actual != ST_ONE) {
             printf("Error in fread\n");
             printf("Requested index=%d\n",index);
             printf("Requested Number of records=%d\n",ST_ONE);
             printf("Actual Number of records read=%d\n",actual);
             exit(1);
           }

        return 0;
}
 


/* read from the disk buffer for a window  */
        int  disk_rwin(int nsamp,int index, int isamp, int nsmp, float *buf)
{
        size_t nbytes;
        size_t ST_ONE;
        size_t actual;
        long ipos;
        int i;
        int ierr;
        int iorig=SEEK_SET ;
        float *bufi;
	long nsampl;

	nsampl = nsamp;
        ipos = (index-1) * nsampl * sizeof(float);
	ipos = ipos + ( (isamp-1) * sizeof(float));
               ierr = fseek(fout, ipos, iorig);
                if ( ierr != 0) {
                  printf("Error in fseek d\n");
		  printf(" ipos,index,nsamp=%d %d %d\n",ipos,index,nsamp);
                  exit(1);
                }

        nbytes = nsmp * sizeof(float);
        ST_ONE = 1;

        actual = fread(buf, nbytes, ST_ONE, fout);
           if ( actual != ST_ONE) {
             printf("Error in fread in disk_rwin\n");
             printf("Requested index=%d\n",index);
             printf("Requested ipos=%d\n",ipos);
             printf("Requested Number of records=%d\n",ST_ONE);
             printf("Actual Number of records read=%d\n",actual);
             exit(1);
           }

        return 0;
}



/* remove he disk buffer  */
        int  disk_dlte(void)
{

        if (FileOpen == 0) {
         return 0;
        }

        if((fclose(fout))==EOF) {
                printf("Cannot close output file!\n");
                exit(1);
                }
 
/*
------------------------------------------------------------------
   I has previously unlinked this input file, so I can no longer
   remove it.  It should disappear automatically.
        if((remove(FileName))!= 0) {
                printf("Cannot remove output file!\n");
                exit(1);
                }
------------------------------------------------------------------
*/
   

        return 0;
}
/* itox ; convert n to characters in s */
void itox( int n, char s[])
{
  int i,sign;
  void reverse( char s[]);
 
  if ((sign = n) < 0)  /* record sign */
    n = -n ;
  i=0;
  do {   /* generate digits in reverse order */
    s[i++] = n % 10 + '0';  /* get next digit */
  } while ((n /= 10) > 0); /* delete it */
  if (sign < 0)
    s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}
 
/* reverse: reverse string s in place */
void reverse( char s[])
{
  int c,i,j;
 
  for (i=0,j=strlen(s)-1; i<j; i++,j--)
    c=s[i],s[i]=s[j],s[j]=c;
}
