c -----------------  Main Routine -----------------------

C     Roll-along, fxydecon 
c
c     Program Description:
c         This routine collects a set of gathers to disk, 
c         processes them with a 3-D fxdecon,
c         then outputs the gathers, all in a roll-along fashion.
c
c  author - Ray Abma  9 Aug. 2001
c
c


c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c------       implicit none 

c dimension standard USP variables 

      integer     itr1 ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     ntrc2, ntrco
      integer     luin1 , luout, lbytes, nbytes, lbyout
      integer     ist, iend, ns, ne, irs, ire, argis
      integer     l2, l3

      real        UnitSc, dt

      character   ntap1*255, otap*255, name*4
      character   wdisk*255

      logical     verbos

c Program Specific _ dynamic memory variables

      integer RecordSize, HeaderSize
      integer errcd1, errcd2, errcd3, errcd4, errcd5, abort
      integer Headers
      integer SHeaders
      integer FKSize

      real    Record, zero
      real    FK_WorkSpace

      pointer (memadr_Record, Record(2))
      pointer (memadr_FK, FK_WorkSpace(2))
      pointer (memadr_Headers, Headers(2))
      pointer (memadr_SHeaders, SHeaders(2))
      pointer (memadr_zero, zero(2))

      integer ngathers
      integer nstored,istored,ilast,ioutredy
      integer ioutcnt
      real sumprt
      integer nomore

      integer pad2
      integer w1,w2,w3
      real  wo1,wo2,wo3

c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor

      integer hdr_index, tr_index, JJ, KK

      integer JJfile

      integer jerr

c Initialize variables

      data abort/0/
      data name/"FXYD"/


      JJfile = 0
      nstored = 0
      istored = 0
      nomore = 0
      ioutcnt = 0

c        ilast = 0  - ok
c        ilast = 1  - last input file
c        ilast = 2  - no input
c        ilast = 3  - last gather to output
      ilast = 0

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>


c get command line input parameters

      call cmdln ( ntap1, otap, wdisk, ns, ne, irs, ire, ist, iend, 
     :     w1,w2,w3, wo1,wo2,wo3,  l2, l3, 
     :     name, verbos )


c open input and output files

      call getln(luin1 , ntap1,'r', 0)
      if (luin1 .lt. 0) then
         write(LERR,*)'Cannot open N dataset', ntap1
         write(LERR,*)'Check spelling / existence and rerun'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'DRIVR: Cannot open N dataset', ntap1
         write(LER,*)'       Check spelling / existence and rerun'
         write(LER,*)'FATAL'
         stop
      endif

      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin1,itr1,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'FXYD: no line header on input file',ntap1
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr1, 'NumSmp', nsamp, LINHED)
      call saver(itr1, 'SmpInt', nsi  , LINHED)
      call saver(itr1, 'NumTrc', ntrc , LINHED)
      call saver(itr1, 'NumRec', nrec , LINHED)
      call saver(itr1, 'Format', iform, LINHED)
      call saver(itr1, 'UnitSc', UnitSc, LINHED)

c print HLH to printout file 

      call hlhprt (itr1, lbytes, name, 4, LERR)

c POLICEMAN: check header for units scaling.  Using UnitSc, remember
c that UnitSc default is milliseconds [i.e. 0.001] and UnitSc
c is a floating point variable.  A UnitSc entry of 1.0 would
c mean units are in seconds.  A UnitSc entry of 0 indicates that
c the unit was not defined.  In this case milliseconds are 
c assumed and loaded to the header for further processing.

      if ( UnitSc .eq. 0.0 ) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         UnitSc = 0.001
         call savew ( itr1, 'UnitSc', UnitSc, LINHED)
      endif



c compute delta T in seconds

      dt = real (nsi) * UnitSc

      if (dt .ge. 1.0) then
         write(LERR,*)'********************************************'
         write(LERR,*)' dt found to be ',dt
         dt = dt / 1000.0
         write(LERR,*)' dt reset to ',dt
         write(LERR,*)'********************************************'
      endif

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec
      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

c this parameterization assumes input in units of the dataset

      ist = nint ( float(ist) / float(nsi) ) + 1
      iend = nint ( float(iend) / float(nsi) ) + 1
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0) then
        iend = nsamp
      else
        iend = nint ( float(iend) / float(nsi) ) + 1
        if ( iend .le. ist  .or. iend .gt. nsamp ) iend = nsamp
      endif

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

      ngathers = nreco

      if (w1 .eq. -999) then
         w1 = 1500
      endif

      w1 = w1 * 0.001 / dt
      if (w1 .gt. nsamp) w1 = nsamp
      if (w1 .le. 1) w1 = nsamp

      if (w2 .eq. -999) then
         w2 = ntrc
         if (w2 .gt. ntrc) w2 = ntrc
         if (w2 .le. 1) w2 = ntrc
      endif

      if (w3 .eq. -999) then
         w3 = ngathers
      endif


c modify line header to reflect actual record configuration output
c NOTE: in this case the trace and sample limits are used to 
c       limit processing only.   All data within the selected record
c       range are actually passed.

      call savew(itr1, 'NumRec', nreco, LINHED)
      call savew(itr1, 'NumTrc', ntrco, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr1, lbytes, lbyout )
      call wrtape ( luout, itr1, lbyout )

c set up pointers to header mnemonic StaCor

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )

c verbose output of all pertinent information before processing begins

      call verbal( ntap1, otap, 
     :     nsamp, nsi, ntrc, nrec, iform, ns, ne,
     :     ngathers,   w1,w2,w3,  wo1,wo2,wo3,
     :     wdisk, l2, l3, 
     :     ist, iend, irs, ire, verbos)

c dynamic memory allocation:  
      nsamp2 =  pad2(w1*2)
      ntrc2  =  w2
      ngath2 =  w3
      if (w3 .eq. 1) ngath2 = 1

      RecordSize = ntrco * nsamp 
      HeaderSize = ntrco * ITRWRD
      FKSize     = nsamp2 * ntrc2 * ngath2

      call galloc (memadr_Record, RecordSize * SZSMPD, errcd1, abort)
      call galloc (memadr_Headers, HeaderSize * SZSMPD, errcd2, abort)
      call gcalloc(memadr_FK, FKSize,SZSMPD*2,errcd3, abort)
      call galloc (memadr_SHeaders,HeaderSize*SZSMPD*ngathers,
     :             errcd4, abort)
      call galloc (memadr_zero, nsamp*SZSMPD, errcd5, abort)
    
      if ( errcd1 .ne. 0 .or.
     :     errcd2.ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) RecordSize* SZSMPD, '  bytes'
         write(LERR,*) 2*HeaderSize* SZSMPD, '  bytes'
         write(LERR,*) FKSize* SZSMPD, '  bytes'
         write(LERR,*) nsamp* SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) RecordSize* SZSMPD, '  bytes'
         write(LER,*) 2*HeaderSize* SZSMPD, '  bytes'
         write(LER,*) FKSize* SZSMPD, '  bytes'
         write(LER,*) nsamp* SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) RecordSize* SZSMPD, '  bytes'
         write(LERR,*) 2*HeaderSize* SZSMPD, '  bytes'
         write(LERR,*) FKSize* SZSMPD, '  bytes'
         write(LERR,*) nsamp* SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory

         
      call vclr ( Record, 1, RecordSize )

      call vclr ( FK_WorkSpace, 1, FKSize*2 )

      call vclr ( Headers, 1, HeaderSize )

      call vclr ( SHeaders, 1, HeaderSize*ngathers )

      call vclr ( zero, 1, nsamp )


c BEGIN PROCESSING 

c skip unwanted input records


      call recskp ( 1, irs-1, luin1, ntrc, itr1 )


      hdr_index = 1 - ITRWRD

C +++++++++++++++++++++++++++++++++++++++++++++++++++++++
      DO JJ = irs, ire

         JJfile = JJfile + 1


         if (JJ .eq. ire) ilast = 1

c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin1, ntrc, itr1 )

c load record to disk

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

         DO KK = ns, ne


            nbytes = 0

            call rtape( luin1, itr1, nbytes)



c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               ilast =  2
               go to 150
            endif

c set array load points for this trace 

           tr_index = tr_index + nsamp
           hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

           call saver2 ( itr1, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :          TRACEHEADER )

           if ( StaCor .ne. 30000 ) then

c load trace to array Record[]

              call vmov ( itr1(ITHWP1), 1, Record(tr_index), 1, nsamp )


           else
              call vclr ( Record(tr_index), 1, nsamp )
           endif

c load trace header to array Headers[]

            call vmov ( itr1, 1, Headers(hdr_index), 1, ITRWRD )


         ENDDO

c skip to end of record if required

         call trcskp ( JJ, ne+1, ntrc, luin1, ntrc, itr1 )


         istored =  istored + 1

         call todsk(Record, wdisk, zero,
     :        Headers, SHeaders,
     :        nsamp, ntrc, ngathers, 
     :        nstored,istored,ITRWRD,
     :        JJfile)

      ENDDO
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++


c Put your subroutine here [remember to declare any arguments you need
c over and above those already declared]

 150  continue
      if (w3 .gt. istored) w3=istored
      ngath2 =  w3
      if (w3 .eq. 1) ngath2 = 1

      call subs ( Headers, SHeaders,
     :     nsamp, ntrc, ist, iend, 
     :     w1,w2,w3, wo1,wo2,wo3, 
     :     nsamp2,ntrc2,ngath2,FK_WorkSpace,
     :     ngathers, nstored,istored,ilast,
     :     dt,ITRWRD,
     :     LERR,JJ,sumprt, l2, l3, 
     :     ioutredy , nomore )



C +++++++++++++++++++++++++++++++++++++++++++++++++++++++

      JJfile = 0
      istored = 0

      DO JJ = irs, ire

         JJfile = JJfile + 1

c    --- output a gather ------

c reset array load points for this trace 
         
         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

         istored =  istored + 1

         call fromdsk(Record,
     :        Headers, SHeaders,
     :        nsamp, ntrc, ngathers,
     :        nstored,istored,ITRWRD,
     :        JJfile)

c write output data

         DO KK = 1, ntrc
            tr_index = tr_index + nsamp
            hdr_index = hdr_index + ITRWRD
            
            call vmov ( Record(tr_index), 1, itr1(ITHWP1), 1, nsamp )
            call vmov ( Headers(hdr_index), 1, itr1(1), 1, ITRWRD )
            
            call wrtape (luout, itr1, obytes)

         ENDDO
         
      ENDDO
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++


c close data files 

 200  continue

      call lbclos ( luin1 )
      call lbclos ( luout )

      write(LERR,*)'FXYD: Normal Termination'
      write(LER,*)'FXYD: Normal Termination'
      stop

 999  continue

      call lbclos ( luin1 )
      call lbclos ( luout )

      write(LERR,*)'FXYD: ABNORMAL Termination'
      write(LER,*)'FXYD: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

       implicit none

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for fxydecon:'
      write(LER,*)' '
      write(LER,*)' fxydecon is a 3-D fxdecon program, similar to '
      write(LER,*)' fxdecon except that is works on 3-D data'
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '

      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-wdisk -- work data directory                (./)'

      write(LER,*)'-w1  --- window length in time (ms) -    (1500) '
      write(LER,*)'-w2  --- window length within a record   (ntrc) '
      write(LER,*)'-w3  --- window length inline (number of records)'

      write(LER,*)'-wo1  - window overlap multipler in time -  (1.5)'
      write(LER,*)'-wo2  - window overlap multipler in record  (1.5)'
      write(LER,*)'-wo3  - window overap multiplier inline     (1.5)'

      write(LER,*)'-l2   - operator length within the record    (3) '
      write(LER,*)'-l3   - operator length across the records   (3) '

      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'  fxydecon -N[] -O[] -w1[] -w2[] -w3[] -l1[] -l2[]'
      write(LER,*)' -wo1[] -wo2[] -wo3[]  -s[] -e[] -rs[] -re[] -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap1, otap, wdisk, ns, ne, irs, ire, ist, 
     :     iend,w1,w2,w3, wo1,wo2,wo3, l2,l3, 
     :     name, verbos )

       implicit none

#include <f77/iounit.h>

      integer ns, ne, ist, iend, irs, ire, argis
      integer l2,l3
      integer w1,w2,w3
      real wo1,wo2,wo3

      character  ntap1*(*), otap*(*), name*(*)
      character  wdisk*(*)

      logical    verbos

      call argi4 ( '-e', iend, 0, 0 )

      call argi4 ( '-l2', l2, 3, 3 )
      call argi4 ( '-l3', l3, 3, 3 )

      call argi4 ( '-ns', ns, 0, 0 )
      call argi4 ( '-ne', ne, 0, 0 )
      call argstr ( '-N', ntap1, ' ', ' ' ) 

      call argstr ( '-O', otap, ' ', ' ' ) 

      call argi4 ( '-rs', irs, 0, 0 )
      call argi4 ( '-re', ire, 0, 0 )

      call argi4 ( '-s', ist, 1, 1 )

      verbos = (argis('-V') .gt. 0)

      call argstr ( '-wdisk', wdisk, 
     :     './', './' ) 

      call argr4 ( '-wo1', wo1, 1.5, 1.5 )
      call argr4 ( '-wo2', wo2, 1.5, 1.5 )
      call argr4 ( '-wo3', wo3, 1.5, 1.5 )

      call argi4 ( '-w1', w1, -999, -999 )
      call argi4 ( '-w2', w2, -999, -999 )
      call argi4 ( '-w3', w3, -999, -999 )

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )
           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap1, otap, 
     :     nsamp, nsi, ntrc, nrec, iform, ns, ne,
     :     ngathers, w1,w2,w3, wo1,wo2,wo3, 
     :     wdisk, l2, l3,
     :     ist, iend, irs, ire, verbos)

      implicit none

#include <f77/iounit.h>       

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, nsi
      integer     ngathers, w1,w2,w3, ns, ne
      integer l2, l3
      integer nrec

      real                  wo1,wo2,wo3

      character  ntap1*(*), otap*(*)
      character  wdisk*(*)

      logical    verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap1
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name    =  ', otap
      write(LERR,*) ' temporary work data set =  ', wdisk
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' start trace             =  ', ns 
      write(LERR,*) ' end trace               =  ', ne 
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*) ' '
      write(LERR,*) ' number of gathers on input=', ngathers
      write(LERR,*) ' window size in time (w1)  =',w1
      write(LERR,*) ' window size (iline) (w2)  =',w2
      write(LERR,*) ' window size (xline) (w3)  =',w3
      write(LERR,*) ' window overlap mult (wo1) =', wo1
      write(LERR,*) ' window overlap mult (wo2) =', wo2
      write(LERR,*) ' window overlap mult (wo3) =', wo3

      write(LERR,*) ' l2 ( operator length 2)       =', l2
      write(LERR,*) ' l3 ( operator length 3)       =', l3


      write(LERR,*) ' '
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





