C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getqpf (tri, nsamp, lwin, nfreqfit, dt, null, L2, df,
     1                   qq, pf, ampls, work1, work2, work3, work4,
     2                   mem, morder, nfs, xReal, xImag, xAbs, x1,
     3                   cen,top,bot, cut,flim,raw)


c +================================================================== +
c | Subroutine to do the grunt work of getting the Q (qq) and peak    |
c | frequency (pf) vectors for a given data trace (tri).              |
c | Input parameters are:                                             |
c |   tri        - R(*) - Data vector                                 |
c |   nsamp      - I    - Length of  tri                              |
c |   lwin       - I    - Length of an analysis (DFT) window          |
c |   nfreqfit   - I    - number freqs to fit linear spectrum
c | Output :                                                          |
c |   qq           R(*) - Q vector                                    |
c |   pf           R(*) - Peak frequency vector                       |
c +================================================================== +

      integer  morder, lwin, nsamp, nfreqfit, delay, nfs, flim

      real     tri(*)
      real     qq(*), pf(*), ampls(*)

      real * 8 work1(*), work2(*), work3(*), work4(*)
      real * 8 xReal(*), xImag(*), xabs(*), x1(*)

      real * 8 dt8, cut8, df8
      real     null, cut
      logical  mem, L2, cen, top, bot, raw

      nf = nfreqfit
      delay = 0
      dt8  = dt
      cut8 = cut
      df8  = 1.2
      if (bot) then
         iw2 = lwin
      elseif (top) then
         iw2 = 1
      elseif (cen) then
         iw2 = lwin / 2
      endif

      llw = lwin

      do  mm = 1, nsamp+llw
        work1 (mm) = 0.
        work2 (mm) = 0.
        work3 (mm) = 0.
        work4 (mm) = 0.
        qq    (mm) = null
        pf    (mm) = 0.
      end do

      do mm = 1, 2*nfs
         xReal (mm) = 0.d0
         xImag (mm) = 0.d0
         xAbs (mm)  = 0.d0
         x1 (mm)    = 0.d0
      enddo

      istrt=1
      do while(tri(istrt).eq.0.)
       istrt = istrt+1
      end do
      istrt = istrt - lwin + 1
      if (istrt .le. 0) istrt = 1

      iend = nsamp
      do while(tri(iend).eq.0.)
       iend = iend - 1
      end do
      iend = iend + llw - 2

      ii = 0
      do  i = istrt, iend
          ii = ii + 1
          work1 (ii) = tri (i)
      enddo
      ns = ii

      if ( mem ) then

         if ( L2 ) then

            call qestm  ( lwin, nf, nfreqfit, ns, morder, delay, dt8,
     1                   nfs, work1, work2, work3, work4, cut8, df8, 
     2                   flim )
         else

            call qestm1 ( lwin, nf, nfreqfit, ns, morder, delay, dt8,
     1                   nfs, work1, work2, work3, work4, cut8, df8, 
     2                   flim )
         endif

      else
         if ( L2 ) then

            call qestf  ( lwin, nf, nfreqfit, ns, dt8, nfs,
     1           work1, work2, work3, work4, xReal, xImag, xAbs, x1,
     2           cut8, df8)
         else

            call qestf1 ( lwin, nf, nfreqfit, ns, dt8, nfs,
     1           work1, work2, work3, work4, xReal, xImag, xAbs, x1,
     2           cut8, df8)
         endif

      endif

      tsum=(istrt-1)*dt
      tsum=0.
      hsum=work2(1)

      do  i = 1, ns
          if (work2 (i) .lt. 0.0) then
             qqi = 27.3 / abs(work2 (i))
             if (.not. raw) then
                tott = istrt + i - 1
                tott = tott / 2.*dt
                if (tott .lt. 0) tott = 0.
                qqi = qqi * tott
             endif
             if (qqi .gt. null .OR. qqi .eq. 0.0) qqi = null
             qq (i+istrt+iw2-1) = qqi
             pf (i+istrt+iw2-1) = work3 (i) * df
             ampls (i+istrt+iw2-1) = work4 (i)
          else
             qq (i+istrt+iw2-1) = null
             pf (i+istrt+iw2-1) = 0.0
             ampls (i+istrt+iw2-1) = 0.0
          endif
      enddo

      return
      end
