C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  scale
C
C**********************************************************************C
C
C SCALE READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C applies a single scale factor to the data & writes the results to otap
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
c
c Changes:
c
c  Dec 12, 2000 - added -Mgate option to allow a gated mean calculation
c                 with application to the whole trace.  Choice of this
c                 option precludes distance limiting.  The gated mean
c                 is removed from all traces in the dataset.  Put in to
c                 deal with Foinaven OBC DC bias removal.
c
c               - also added implicit none and cleaned up resulting
c                 variable declaration
c  Garossino
C
c  Aug 13, 2001   - joe m. wade -
c                 modified allocation of itr, xtr, and xtrace arrays to
c                 be dynamic to allow for ever-increasing data sizes.
c	  
c                 
C     DECLARE VARIABLES
C

      implicit none

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare std USP variables

      integer nsamp, nsampo, nsi, ntrc, nrec, iform
      integer ist, iend, nst, ned, nrst, nred, JJ, KK
      integer luin , luout, lbytes, nbytes, obytes, lbyout, jerr
      integer argis
      integer itr
c     integer itr ( 3*SZLNHD )
c     integer lhed( 3*SZLNHD )

      real UnitSc
      real  xtr
c     real  xtr(3*SZLNHD)

      character name * 5, ntap * 256, otap * 256

      logical verbos

c declare local variables

      integer jtrc, nrecc, irec, itrc, idist, istatic, ip
      integer ifmt_Horz08,l_Horz08, ln_Horz08
      integer ifmt_TrcNum,l_TrcNum, ln_TrcNum
      integer ifmt_DstSgn,l_DstSgn, ln_DstSgn
      integer ifmt_RecNum,l_RecNum, ln_RecNum
      integer ifmt_StaCor,l_StaCor, ln_StaCor
      integer alloc_size,errcod,abort

      real xtrace
c     real xtrace(3*SZLNHD) 
      real lowlimit, upperlimit, range, rnsampo, dc, dist, amp
      real bias, beta, crit, xdist, val, rone

      logical GatedMean, lessth, npp, inv, mean, norm, ceil

      pointer (mem_itr, itr(1))
      pointer (mem_xtr, xtr(1))
      pointer (mem_xtrace, xtrace(1))

c initialize variables

c     equivalence ( itr(  1), lhed(1) )
      data name /'SCALE'/
      data luin / 1 /, lbytes / 0 /, nbytes / 0 /,abort / 0 /

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help()
         stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     get command line parameters
C**********************************************************************C

      call cmdln ( ntap, otap, ist, iend, nst, ned, nrst, nred, dist, 
     :     amp, inv, lessth, verbos, bias, beta, npp, mean, GatedMean, 
     :     norm, upperlimit, lowlimit, crit, ceil )

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      alloc_size = SZLNHD * SZSMPD
      errcod = 0
      call galloc(mem_itr,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) '       ',alloc_size,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'SCALE ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 100
      endif

      lbytes = 0
      call rtape ( luin, itr, lbytes  )
      if(lbytes .eq. 0) then
          write(LERR,*)'SCALE: no header read on dsn ',ntap
          write(LERR,*)'check existence of this file & rerun'
          stop
      endif
      call hlhprt ( itr , lbytes, name, 5, lerr )
#include <f77/saveh.h>

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('Horz08',ifmt_Horz08,l_Horz08,ln_Horz08,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-------------------------
c check input parameters
c-------------------------
      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)
      jtrc  = ntrc
      nrecc = nrec
      ist=ist/nsi
      iend=iend/nsi
      if(ist .lt. 1) ist=1
      if(iend .lt. 1) iend=nsamp
      nsampo = iend-ist+1
      rnsampo = float(nsampo)

c----------------------------
c  adjust output line header
c----------------------------

      call savew( itr, 'NumTrc', jtrc  , LINHED)
      call savew( itr, 'NumRec', nrecc , LINHED)

      obytes = SZTRHD + SZSMPD * nsamp
      call savhlh( itr, lbytes, lbyout)
      call wrtape(luout,itr,lbyout)

c------------------------------
c  printout program parameters
c------------------------------
c     if(verbos) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record  =  ', ntrc 
         write(LERR,*) ' Records per Line   =  ', nrec
         write(LERR,*) ' Output records     =  ', nrecc
         write(LERR,*) ' Format of Data     =  ', iform
         write(LERR,*) ' Analysis # samples   =  ',nsampo
         write(LERR,*) ' Process start time =  ',ist,' samps'
         write(LERR,*) ' Process end time   =  ',iend,' samps'
         write(LERR,*) ' Process start trc  =  ', nst
         write(LERR,*) ' Process end trc    =  ', ned
         write(LERR,*) ' Process start rec  =  ', nrst
         write(LERR,*) ' Process end rec    =  ', nred
         write(LERR,*) ' Scale factor       =  ',amp
         write(LERR,*) ' Exponent           =  ',beta
         write(LERR,*) ' Bias               =  ',bias
         write(LERR,*) ' No Polarity Pres.  =  ',npp
         write(LERR,*) ' Normalization      =  ',norm
         if ( norm ) then
            write(LERR,*) ' Low Norm limit     =  ',lowlimit
            write(LERR,*) ' High Norm limit     =  ',upperlimit
         endif
         write(LERR,*) ' dist               =  ',dist
         write(LERR,*) ' Scale less than dist? ', lessth
         write(LERR,*) ' Number output bytes=  ',obytes
         if (mean)
     1   write(LERR,*) ' Remove mean from input data'
         if (GatedMean)
     1   write(LERR,*) ' Remove gated mean from input data'
c     endif
 
      alloc_size = obytes
      errcod = 0
      call grealloc(mem_itr,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) '       ',alloc_size,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'SCAN ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 101
      endif
      call galloc(mem_xtr,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) '       ',alloc_size,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'SCAN ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 102
      endif
      call galloc(mem_xtrace,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) '       ',alloc_size,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'SCAN ERROR: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) '       FATAL'
	stop 103
      endif

C**********************************************************************C
C     READ TRACE, SCALE, WRITE OUTPUT
C**********************************************************************C
 
c-----------------------
c  skip records
c-----------------------

      nbytes = obytes
      call recrw (1,nrst-1,luin,ntrc,itr,luout, nbytes)
      if (nbytes  .eq. 0) go to 999

      if (norm) range = upperlimit - lowlimit

      DO 100  JJ = NRST, NRED

c------------------------
c  pass first par of rec
c------------------------
c           call skptrc(jj,1,nst-1,luin,nsamp,ntrc,itr,
c    1                 lbytes,nbytes,iform)
             nbytes = obytes
             call trcrw (JJ, 1, nst-1, luin, ntrc, itr, luout, nbytes)
             if (nbytes  .eq. 0) go to 999


           DO 99 KK = NST, NED

               nbytes = 0
               call rtape  ( luin , itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)

                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec   , TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        itrc   , TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        idist  , TRACEHEADER)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic , TRACEHEADER)

              if(verbos) then
                 write(LERR,*)' Record=  ',jj,'  Trace=  ',kk
              endif

c---------------------------------
c  scale only if not a dead trace
c---------------------------------
              IF(istatic .ne. 30000) THEN
                 xdist = idist
                 call vmov(xtr,1,xtrace,1,nsamp)

c----------------------------
c do trace normalization only
c----------------------------
                 if ( norm ) then
                    call normal( xtr, nsamp, lowlimit, upperlimit, 
     :                   range )

c----------------------------
c scale traces less than DIST
c----------------------------
                 elseif (lessth) then
                    if ( mean ) call rmean (xtrace, nsamp)
                    if (GatedMean) then
                       call gated_mean (xtrace, ist, iend, nsamp, 
     :                      rnsampo, dc )
                       call savew2(itr,ifmt_Horz08,l_Horz08, 
     :                      ln_Horz08, dc, TRACEHEADER)
                       call vmov ( xtrace, 1, xtr, 1, nsamp)
                    elseif(xdist .le. dist) then
c----------------------------
c no polarity preserved case
c----------------------------
                       if( npp ) then
                          do 800 ip = ist, iend
                             val = abs(xtrace(ip))
                             if (val .ne. 0.0) then
                                xtr(ip)=
     1                               ((val**beta) * amp) + bias
                             else
                                xtr(ip)= bias
                             endif
 800                      continue
                       else
c----------------------------
c polarity preserved case
c----------------------------
                          rone = 1.0
                          do 801 ip = ist, iend
                             val = xtrace(ip)
                             if (val .ne. 0.0) then
                                xtr(ip)=
     1                               (((abs(val)**beta) * amp)
     1                               * sign(rone,val)) + bias
                             else
                                xtr(ip)= bias
                             endif
 801                      continue
                       endif
                    endif
c
c--------------------------------
c scale traces greater than DIST
c--------------------------------
                 else
                    if (mean) call rmean (xtrace, nsamp)

                    if (GatedMean) then
                       call gated_mean (xtrace, ist, iend, nsamp, 
     :                      rnsampo, dc )
                       call savew2(itr,ifmt_Horz08,l_Horz08, 
     :                      ln_Horz08, dc, TRACEHEADER)
                       call vmov ( xtrace, 1, xtr, 1, nsamp)
                    elseif (xdist .ge. dist) then

c----------------------------
c no polarity preserved case
c----------------------------
                       if( npp ) then
                          do 802 ip = ist, iend
                             val = abs(xtrace(ip))
                             if (val .ne. 0.0) then
                                xtr(ip)=
     1                               ((val**beta) * amp) + bias
                             else
                                xtr(ip)= bias
                             endif
 802                      continue
                       else
c----------------------------
c polarity preserved case
c----------------------------
                          rone = 1.0
                          do 803 ip = ist, iend
                             val = xtrace(ip)
                             if (abs(val) .ne. 0.0) then
                                xtr(ip)=
     1                               (((abs(val)**beta) * amp)
     1                               * sign(rone,val)) + bias
                             else
                                xtr(ip)= bias
                             endif
 803                      continue
                       endif
                    endif

                 endif

              ENDIF

c---------------
c  check for amplitude ceiling?
c---------------
              if (ceil ) call ampchk ( xtr, nsamp, crit, KK, JJ, LERR)
c---------------
c  write output
c---------------
              call vmov  (xtr, 1, itr(ITHWP1), 1, nsamp)
              call wrtape(luout,itr,obytes)
   99      CONTINUE

c---------------------------------
c  pass remainder of rec
c---------------------------------
c          call skptrc(jj,ned+1,ntrc,luin,nsamp,ntrc,itr,
c    1                 lbytes,nbytes,iform)
           nbytes = obytes
           call trcrw (JJ, ned+1, ntrc, luin, ntrc, itr, luout, nbytes)

  100 CONTINUE

c------------------------
c  pass remainder of recs
      nbytes = obytes
      call recrw (nred+1, nrec, luin, ntrc, itr, luout, nbytes)
      if (nbytes .eq. 0) go to 999

  999 continue
       call lbclos(luin)
       call lbclos(luout)
      END

c--------------------------
c  online help section
c--------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for SCALE: scale data'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-amp[amp]  -- multiplying value'
        write(LER,*)'-exp[beta] -- exponent value'
        write(LER,*)'-bias[bias]-- scaling amplitude'
        write(LER,*)'-d[dist]   -- do scaling on part of spread   (all)'
        write(LER,*)'-s[ist]    -- process start time (ms) (first samp)'
        write(LER,*)'-e[iend]   -- process end time (ms)    (last samp)'
        write(LER,*)'-ns[nstr]  -- process start trace number   (first)'
        write(LER,*)'-ne[netr]  -- process end trace number      (last)'
        write(LER,*)'-rs[nrst]  -- process start record         (first)'
        write(LER,*)'-re[nred]  -- process end record            (last)'
        write(LER,*)'-np        -- no polarity preserved'
        write(LER,*)'-I         -- use 1/amp as scale factor'
        write(LER,*)'-L         -- do scaling for dists less than dist'
        write(LER,*)'              if not scale greater than dist'
        write(LER,*)'              (default is scale for all dists)'
        write(LER,*)'-M         -- remove mean from input traces'
        write(LER,*)'-Mgate     -- remove gated mean from input traces'
        write(LER,*)'-norm      -- normalize trace with new bounds'
        write(LER,*)'-l           lower limit of norm amplitudes  (0.0)'
        write(LER,*)'-u           upper limit of norm amplitudes  (1.0)'
        write(LER,*)'-c[ceil]   -- crash ceiling for trc amplitudes (0)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' scale -N[] -O[] -amp[] -s[] -e[] -ns[] -d[] -ne[]'
        write(LER,*)'       -rs[] -re[] [-np -M -Mgate -L -I -V] '
        write(LER,*)'       [-norm -l[] -u[] -c[] ] '
        write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c     iend  - I      end sample
c      ns   - I      start trace
c      ne   - I      stop end trace
c      rs   - I      start record
c      re   - I      stop end record
c    dist   - R      key distance
c    amp    - R      scaling amplitude
c    lessth - L      do scaling on dists .le. dist
c    inv    - L      take 1/amp as scale factor
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,ist,iend,ns,ne,irs,ire,dist,amp,
     :     inv,lessth,verbos,bias,beta,npp,mean, GatedMean, norm, 
     :     upperlimit, lowlimit,crit,ceil )
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    ist,iend,ns,ne,irs,ire, argis
      real       amp, dist, upperlimit, lowlimit
      logical    lessth, verbos, npp, inv, mean, norm, ceil
      logical GatedMean

           call argr4('-amp',amp,1.,1.)

           call argr4('-bias',bias,0.,0.)

           call argr4('-d',dist,-9999999.,-9999999.)

           call argr4('-exp',beta,1.,1.)
           call argi4('-e',iend,0,0)

           inv    = (argis('-I') .gt. 0)

           lessth = (argis('-L') .gt. 0)
           call argr4( '-l', lowlimit, 0., 0. )

           mean   = (argis('-M') .gt. 0)
           GatedMean   = (argis('-Mgate') .gt. 0)

           norm   = ( argis ( '-norm' ) .gt. 0 )
           call argi4('-ne',ne,0,0)
           npp = (argis('-np') .gt. 0)
           call argi4('-ns',ns,0,0)
           call argstr('-N',ntap,' ',' ') 

           call argstr('-O',otap,' ',' ') 

           call argi4('-re',ire,0,0)
           call argi4('-rs',irs,1,1)

           call argi4('-s',ist,1,1)

           call argr4( '-u', upperlimit, 1., 1. )
           call argr4( '-c', crit, 0., 0. )
           crit = abs ( crit )
           verbos = (argis('-V') .gt. 0)

           if (crit .ne. 0.0) then
              ceil = .true.
           else
              ceil = .false.
           endif

           if (inv) amp = 1./amp
      
      return
      end
