C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Decompose ( tri, nsamp, ist, iend, trbias, 
     :     nfreq, iwind, ihalf, Ctable, t, freq, radeg, 
     :     phase, normal_energy, normal_live, ampmax, amprms )

c variables passed from calling routine

      integer nsamp, ist, iend, nfreq, iwind, ihalf

      real tri(nsamp)
      real t(iwind+1)
      real freq(nfreq)
      real ampmax(nfreq)
      real amprms(nfreq)
      real radeg

      complex Ctable(iwind, nfreq)

      logical trbias, phase, normal_energy, normal_live

c local variables
      
      integer k, N_live

      real sumavg, xtmp, xr, xi, sumtmp,sum2

      complex cb, csum

c initialize variables


c do decomposition of this trace
      
      sumavg = 0.
                  
      if ( trbias ) then
         
         do i = ist, iend
            tri(i) = tri(i) * t(i-ist+1)
            sumavg = tri(i) + sumavg
         enddo
            
         sumavg=sumavg/(2*ihalf+1)

         do i=ist,iend
            tri(i) = tri(i) - sumavg
         enddo

      else

         do i=ist,iend
            tri(i) = tri(i) * t(i-ist+1)
         enddo

      endif

c     normalize by energy
      if ( normal_energy ) then
         sum2 = 0.0
         do i = ist, iend
            sum2 = sum2 + tri(i) * tri(i)
         enddo
         sum2 = sqrt(sum2)
         if (sum2 .GT. 0) then
            do i = ist, iend
               tri(i) = tri(i) / sum2
            enddo
         endif
      endif

c     normalize by number of live samples in window
      if (normal_live) then
         N_live = 0
         do i=ist,iend
            if (tri(i) .NE. 0.0) then
               N_live = N_live + 1
            endif
         enddo
         if (N_live .GE. 1) then
            do i=ist,iend
               tri(i) = tri(i) / N_live
            enddo
         endif
      endif
 
                  
      DO k = 1, nfreq

         cb = (0.,0.)
         csum=(0.,0.)
                     
         do i = ist, iend

            xtmp = tri(i)
            csum = Ctable(i-ist+1,k) * cmplx(xtmp,0.)
                        
            cb = csum + cb

         enddo
                  
c store spectral information in freq[frequency] array

         if (phase) then
            xr = real(cb)
            xi = aimag(cb)
            if(xr .eq. 0.) then
               freq(k)=0.
            else
               freq(k) = radeg*( atan2 (xi,xr))
            endif
         else
            call cvabs(cb,2,sumtmp,1,1)
            sumtmp = sumtmp / iwind
            freq(k) = sumtmp
            ampmax(k)=max(ampmax(k),freq(k))
            amprms(k)=amprms(k)+freq(k)**2  
            sumtmp=0.
         endif

      ENDDO

      return
      end
