C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- stacklay ----- ----- ----- ----- ----- ----- -----

c routine to produce an xsd output pickfile to contain the users input primary
c segments and N orders of multiples.  Routine gets dip information from input
c pickfile and velocity information from input velocity dataset in USP format.

c ----- get machine dependent parameters -----

#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables 


      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes
      integer     argis

      character   ntap*100, otap*100, name*8

      logical     verbos, query

c dimension program specific variables 

      integer     index(2*SZSMPM,2), count, nseg
      integer     indexOut(2*SZSMPM,2), nsegOut
      integer     mul, spinit, spincr, le1, PickSize
      integer     luvel, MultOrder, OutPickSize, pickOutndx

      real       TraceSpacing

      character  vtap*100, PickType*7
      character  mnemonic*6

c NOTE: the mnemonic variable is here only so I didn't have to 
c       change the pickread subroutine.  It is not used for anything
c       at the present time.

      logical    Simple, Flat

c variables used in dynamic memory allocation

      integer     abort, errcd1, errcd2, errcd3
      integer     errcd4, errcd5, errcd6, errcd7

      real	  records, traces, times, depths
      real        tracesOut, timesOut, velocities

      pointer     ( wkadr1, traces ( 200000 ) )
      pointer     ( wkadr2, times ( 200000 ) )
      pointer     ( wkadr3, records ( 200000 ) )
      pointer     ( wkadr4, tracesOut ( 200000 ) )
      pointer     ( wkadr5, timesOut ( 200000 ) )
      pointer     ( wkadr6, depths ( 200000 ) )
      pointer     ( wkadr7, velocities ( 200000 ) )

c Variable Definitions 
c
c ----- Integer -----
c
c     static : static for this trace 
c     index() : contains segment information (seq.rec,npicks) 
c     count : counter for traces() and times() arrays
c     nseg : number of segments in the pick file
c     mul : pick file time units override
c     spinit : initial shot point override
c     spincr : shot point increment override
c     le1 : length of pfile character string
c
c ----- Real -----
c
c     traces() : pick file entries
c     times() : pick file entries 
c
c ----- Character -----
c
c     pfile : pick file name
c     PickType : type of pickfile used (standard or header value at picks)
c

c Initialize variables

      data lbytes/0/
      data nbytes/0/
      data name/'STACKLAY'/
      data abort/0/
      data Simple/.false./
      data Flat/.false./

c give command line help if requested 

      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0 )

      if ( query )then
         call help()
         stop
      endif

c open printout file 

#include <f77/open.h>

c get command line input parameters 

      call cmdln ( ntap, otap, vtap, PickType, mul, spinit, spincr,  
     :     mnemonic, MultOrder, Simple, Flat, TraceSpacing, verbos )

c get logical unit numbers for vel data 

      call getln(luvel, vtap,'r', 1)

c read line header of input data save certain parameters

      call rtape(luvel,itr,lbytes)

      if(lbytes.eq.0)then
         write(LOT,*)'STACKLAY: no header read from unit ',vtap
         write(LOT,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c print hlh to print file

      call hlhprt (itr, lbytes, name, 8, LERR)

c verbose output of all pertinent information before processing begins

      call verbal ( nsamp, nsi, ntrc, nrec, iform, ntap, otap, 
     :     PickType, mul, spinit, spincr, vtap, MultOrder, Simple, 
     :     Flat, mnemonic, TraceSpacing, verbos )

c open input pick file 

      call alloclun ( luin )
      le1 = lenth(ntap)
      if (le1 .eq. 0) then
	write(LERR,*) 'FATAL ERROR: No input pick file specified'
	write(LER,*) 'stacklay: FATAL ERROR: No input pick file ',
     :    'specified'
	stop 100
      endif
      open ( luin, file = ntap(1:le1), status = 'old', err = 990 )

c Determine Size Requirements and allocate memory for input pick and output
c pick storage 

      call PickCount ( luin, NumPicks, PickType, nseg )

      PickSize = NumPicks * SZSMPD
      if ( Simple ) then
         OutPickSize = nseg * ntrc * nrec * SZSMPD
      else
         OutPickSize = nseg * MultOrder * ntrc * nrec * SZSMPD
      endif

      call galloc(wkadr1,PickSize,errcd1,abort)
      call galloc(wkadr2,PickSize,errcd2,abort)
      call galloc(wkadr3,PickSize,errcd3,abort)
      call galloc(wkadr4,OutPickSize,errcd4,abort)
      call galloc(wkadr5,OutPickSize,errcd5,abort)
      call galloc(wkadr6,OutPickSize,errcd6,abort)
      call galloc(wkadr7,PickSize,errcd7,abort)

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 4*PickSize,'  bytes'
         write(LERR,*) 3*OutPickSize,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 4*PickSize,'  bytes'
         write(LERR,*) 3*OutPickSize,'  bytes'
         write(LERR,*)' '
      endif
         
c read and qc pick file 

      call ReadPick ( luin, index, records, traces, times, count, 
     :     nseg, mul, spinit, spincr, PickType, mnemonic, ntrc, nsi, 
     :     verbos )

c sort the picks based on increasing record [or trace if appropriate] index

      call PickSort ( index, traces, times, count, nseg, nrec, ntrc )

c open output pickfile and load output pickfile header

      call alloclun (luout )
      le1 = lenth( otap )
      open ( luout, file = otap(1:le1), status = 'unknown', err = 991 )

      call PickHeader ( luout, nseg, MultOrder, Simple, nrec, ntrc, 
     :     nsamp, nsi )

c get velocity and depth info for all input picks

      call GetVelDepths ( nseg, index, traces, times, luvel, velocities, 
     :     depths, ntrc, nrec, nsamp, nsi )

c MULTIPLE GENERATION

      pickOutndx = 0
      nsegOut = 0

      DO JJ = 1, nseg

c build requested multiple picks [ add 1 to colour for each successive mode]

         call Multiple ( JJ, index, traces, times, velocities, 
     :        depths, indexOut, tracesOut, timesOut, Simple, Flat,
     :        MultOrder, pickOutndx, nsegOut, nsi, TraceSpacing )
      ENDDO         

c output multiple pick file

      call WritePick ( luout, indexOut, tracesOut, timesOut, Simple,  
     :     MultOrder, nsegOut, ntrc )

c close data files 

 999  continue

      call lbclos ( luvel )
      close ( luin )
      close ( luout )

      write(LERR,*)'end of prgm, processed',nrec,' record(s)',
     :             ' with ',ntrc, ' traces'
      write(LER,*)'STACKLAY: Normal Termination'

      stop

c error messages 

990   write(LERR,*) ' error opening input pick file: check spelling'
	write(LER,*) 'STACKLAY:  error opening input pick file: check spel
     :ling'
	stop

991	write(LERR,*) ' error opening output pick file: ',
     :    'check permissions'
	write(LER,*) 'STACKLAY:  error openning output pick file: ',
     :    'check permissions'
	stop

      end
