C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE UTOP: modify trace headers
C
C**********************************************************************C
c updated 18 June 1998 : James Gridley
c
c 	added option (-T[]) to write a single line of text to the 
c 	historical line header without writing the command line
c	parameterization.
C
C UTOP READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C AND requests user input as to what header words to modify
C
C SUBROUTINE CALLS: RTAPE, HLH, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

c     integer itr ( 2*SZLNHD )
      integer itr
      integer errcod,abort,alloc_size
      integer nsamp, nsi, ntrc, nrec, iform
      integer luin , lbytes, nbytes, luout
      integer argis,obytes,lbyout
      integer iwd(10), ihwd(10)
      integer iflag(10),ihflag(10)
      integer slufmt(10),sluind(10),slulng(10)
      integer RecNum, ifmt_RecNum, l_RecNum, ln_RecNum
      integer TrcNum, ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer StaCor, ifmt_StaCor, l_StaCor, ln_StaCor
      integer DstSgn, ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer DstUsg, ifmt_DstUsg, l_DstUsg, ln_DstUsg

c     real        wtrce(2*SZLNHD)
      real        wtrce
      real iwdr(10),ihwdr(10)

      character   grp*4, grpold*4
      character   name*4, ntap*255, otap*255
      character   name2*80
      character*24 lhw(10), ithw(10)
      character*1  icc(10)
      character*10 iwdc(10),ihwdc(10)

      logical verbos,query,dflag,rnum,strphlh,inplace

      pointer (mem_itr,itr(1))
      pointer (mem_wtrce,wtrce(1))
C
      DATA NAME     /'UTOP'/
      DATA LUIN / 1 /
      data LBYTES / 0 /
      data NBYTES / 0 /
      data abort / 0 /
      data icc /'0','1','2','3','4','5','6','7','8','9'/
      data verbos /.true./
      data inplace /.false./

C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = ( argis ( '-?' ) .gt. 0 .or. argis ('-h') .gt. 0 )
      if ( query ) then
         call help()
         stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     get main command line arguments
C**********************************************************************C
      call cmdln(ntap,otap,nso,nrr,ntrcc,grp,d0,scale,np,
     1     nsampn,verbos,dflag,rnum,strphlh,name2)

      call stoflt(grp,fgrp)

C**********************************************************************C
C     get  header words to change & their values from command line
C**********************************************************************C
      call  header(icc,lhw,iwd,iwdc,iwdr,ithw,ihwd,ihwdc,ihwdr,ih,ik,
     1     iflag,ihflag )

C**********************************************************************C
C     open data set logical units
C**********************************************************************C
      if ( ntap .ne. ' ' ) then
         if (ntap .eq. otap) then
            inplace = .true.
         else
            inplace = .false.
         endif
         write(LERR,*)' '
         write(LERR,*)'*** Changing file in place?  ',inplace,'  ***'
         write(LERR,*)' '
         if (inplace) then
            call lbopen ( luin, ntap, 'r+' )
	    call sislgbuf(luin,"off")
         else
            call lbopen ( luin, ntap, 'r' )
         endif
         write(LERR,*)'Opened ',ntap,' as unit ',luin
      else
         luin=0
         inplace = .false.
      endif

      if ( otap .ne. ' ' ) then
         if (inplace) then
            luout = luin
         else
            call lbopen ( luout, otap, 'w' )
         endif
         write(LERR,*)'Opened ',otap,' as unit ',luout
      else
         luout=1
         inplace = .false.
      endif

c - allocate space for the line header

      alloc_size = SZLNHD * SZSMPD
      errcod = 0
      call galloc( mem_itr, alloc_size, errcod, abort)
      if (errcod .ne. 0) then
         write(LERR,*) name,': ERROR'
         write(LERR,*) '      Unable to allocate ',alloc_size,
     :		'bytes for line header'
         write(LERR,*)'FATAL'
         write(LER,*) name,': ERROR'
         write(LER,*) '      Unable to allocate ',alloc_size,
     :		'bytes for line header'
         write(LER,*)'FATAL'
	 stop 100
      endif

      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES  )
      if(lbytes .eq. 0) then
         write(LERR,*)'UTOP: no header read on unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif

C**********************************************************************C
C     read & modify line header values
C**********************************************************************C
c jmg: check to see if we are going to write a single line of text
c	to the historcal line header and do the appropriate thing.

	if(name2(1:6) .eq. '-99999') then
      IF (.not. inplace)
     1     CALL hlhprt ( ITR , LBYTES, NAME, 4, LERR  )
	endif

	if (name2 .ne. '-99999') then
	length=lenth(name2)
          CALL hlhprt ( ITR , LBYTES, NAME2, length, LERR  )
	endif


#include <f77/saveh.h>
      if(nso .ne. 0) nsi=nso
      call savew(itr, 'SmpInt',  nsi  , LINHED)
c     if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD
      if(ntrc .gt. SZSMPM) ntrc=szsmpm
      if(np .gt. nsamp) np=nsamp
c----------------------------------------------------------------------
c     put in modified header values (note the change to I*2 to I*4 ival
c     note we have to do something special for character entries
c----------------------------------------------------------------------
c     changed by jmw 10/23/89
c     -- i use the f77/save.h file under usp/include directory
c        to check for character data. 
      do i=1,ih
         write(LERR,*)'Saving line header position ',lhw(i)(1:6),iwd(i)
         if (iflag(i) .eq. SAVE_CHARACTER_DEF) then
            call savew(itr, lhw(i)(1:6), iwdc(i), LINHED)
         else if ((iflag(i) .eq. SAVE_REAL_DEF) .or.
     1		(iflag(i) .eq. SAVE_FAKE_REAL_DEF)) then
            call savew(itr, lhw(i)(1:6), iwdr(i), LINHED)
         else
            call savew(itr, lhw(i)(1:6), iwd(i), LINHED)
         endif
      enddo
c----------------------------------------------------------------------
c     save new group interval a character at a time
c----------------------------------------------------------------------
      call saver(itr, 'GrpInt', grpold, LINHED)

c   - read the old group interval into an integer variable - j.m.wade 7/27/90
      call stoflt(grp,fogrp)

      if(verbos) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' New samples/trace  =  ', nsampn
         write(LERR,*) ' Sample Interval    =  ', nsi  
         if ( nso .ne. 0) 
     1        write(LERR,*) ' Sample Interval    =  ', nso,'  [new]'  
         write(LERR,*) ' Traces per Record  =  ', ntrc 
         write(LERR,*) ' Records per Line   =  ', nrec 
         write(LERR,*) ' New recs per line  =  ', nrr
         write(LERR,*) ' New trcs per rec   =  ', ntrcc
         write(LERR,*) ' Renumber recs/trcs?=  ',rnum
         write(LERR,*) ' Format of Data     =  ', iform
         write(LERR,*) ' Group interval     =  ',grpold
         write(LERR,*) ' New group interval =  ',grp
         if (strphlh)
     1        write(LERR,*)' Strip off historical line header'
      endif
c----------------------------------------------------------------------
c     save new samples, records, traces (if necessary)
c----------------------------------------------------------------------
      if(nsampn .ne. 0) then
         call savew(itr, 'NumSmp' , nsampn, LINHED)
      else
         nsampn = nsamp
      endif
      if (inplace .AND. nsampn .ne. nsamp) then
         write(LER,*)'UTOP: cannot modify trace length in place.'
         write(LERR,*)'UTOP: cannot modify trace length in place.'
         write(LER,*)'  Output must be a different file name or a pipe'
         write(LERR,*)'  Output must be a different file name or a pipe'
         stop 100
      endif
      if(nrr .ne. 0) then
         call savew(itr, 'NumRec' ,  nrr  , LINHED)
         nrec=nrr
      endif
      if(ntrcc .ne. 0) then
         call savew(itr, 'NumTrc' , ntrcc , LINHED)
         ntrc=ntrcc
      endif
      if(grp .ne. ' ') then
         write(LERR,*)'Saving new group interval ',grp
         call gpack(grp)
         call savew(itr, 'GrpInt' , grp, LINHED)
      endif

C**********************************************************************C
C     adjust output bytes and write out lineheader
C     but only if input is a pipe or we also change trace
C     headers...
C**********************************************************************C

      obytes = SZTRHD + SZSMPD * nsampn

      IF (.not. inplace) THEN

C**********************************************************************C
C     add local command line info to historical line header
C**********************************************************************C
c jmg: if writing to the historical line header skip the savhlh but
c	be sure lbyout = lbytes or a disaster will occur.
c 
	if (name2(1:6) .eq. '-99999') then
         call savhlh(itr, lbytes, lbyout)
	else
	lbyout=lbytes
	endif

         if (strphlh) then
            lbyout = HSTOFF
            nbyt = 2 * SZHFWD
            call savew( itr, 'HlhEnt',  0   , LINHED)
            call savew( itr, 'HlhByt', nbyt , LINHED)
         endif
         call wrtape ( luout, itr, lbyout )
      
C**********************************************************************C
C     If data is on disk and we only modify the line header...
C**********************************************************************C
      ELSE

         lbyout = lbytes
         call rwd    ( luout )
         call wrtape ( luout, itr, lbyout )
         write(LERR,*)' '
	 if (ik .eq. 0) then
            write(LERR,*)
     1           'Writing Line Header in place & exiting normally'
            write(LERR,*)' '
            go to 999
	 else
            write(LERR,*)'Writing Line Header in place'
	 endif

      ENDIF

c - allocate space for the trace data

       
      alloc_size = obytes
      if (nsamp .gt. nsampn)
     :  alloc_size = nsamp * SZSMPD + SZTRHD

      errcod = 0
      call grealloc( mem_itr, alloc_size, errcod, abort)
      if (errcod .ne. 0) then
           write(LERR,*) name,': ERROR'
           write(LERR,*) '      Unable to allocate ',alloc_size,
     :		'bytes for traces'
           write(LERR,*)'FATAL'
           write(LER,*) name,': ERROR'
           write(LER,*) '      Unable to allocate ',alloc_size,
     :		'bytes for traces'
           write(LER,*)'FATAL'
	   stop 100
      endif

      errcod = 0
      call galloc( mem_wtrce, alloc_size, errcod, abort)
      if (errcod .ne. 0) then
           write(LERR,*) name,': ERROR'
           write(LERR,*) '      Unable to allocate ',alloc_size,
     :		'bytes for traces'
           write(LERR,*)'FATAL'
           write(LER,*) name,': ERROR'
           write(LER,*) '      Unable to allocate ',alloc_size,
     :		'bytes for traces'
           write(LER,*)'FATAL'
	   stop 100
      endif

C**********************************************************************C
C
C     READ TRACE then modify trace header values if necessary
C
C**********************************************************************C
c
c-----------------------
c read 'til the cows
c come home

      call savelu('RecNum',ifmt_RecNum, l_RecNum, ln_RecNum,TRACEHEADER) 
      call savelu('TrcNum',ifmt_TrcNum, l_TrcNum, ln_TrcNum,TRACEHEADER) 
      call savelu('StaCor',ifmt_StaCor, l_StaCor, ln_StaCor,TRACEHEADER) 
      call savelu('DstSgn',ifmt_DstSgn, l_DstSgn, ln_DstSgn,TRACEHEADER) 
      call savelu('DstUsg',ifmt_DstUsg, l_DstUsg, ln_DstUsg,TRACEHEADER) 

      do i = 1, ik
         write(LERR,*)'Saving trace header position ',ithw(i)(1:6)
         call savelu(ithw(i)(1:6),slufmt(i),sluind(i),
     1        slulng(i),TRCHED)
         write(LERR,*)' slufmt,sluind,slulng= ',
     1        slufmt(i),sluind(i),slulng(i)
      enddo

c cycle through entire dataset.

      jj = 0

      DO WHILE ( 1 .eq. 1 )
         jj = jj + 1
        DO KK = 1, NTRC
            
            call vclr (wtrce,1,max(nsamp,nsampn))
            nbytes = 0
            call rtape  ( luin , itr, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call vmov (ITR(ITHWP1), 1, wtrce, 1, nsamp)
            
            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )
            
            if(verbos) then
               call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )
               call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :              TrcNum, TRACEHEADER )
               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )
c     
               write(LERR,*)'RI= ',RecNum,' Tr= ',TrcNum,' Trace dist= '
     &              ,DstSgn,' Static= ',StaCor
            endif
c -----
c
c     allow for changing of trace distances with input of a new near
c     offset
c
c -----

            if(d0 .ne. 0.) then

               if ( grp .ne. ' ') then
                  DstSgn = (kk-1)*fgrp + d0
               elseif ( grpold .ne. ' ') then
                  DstSgn = (kk-1)*fogrp + d0
               endif
               call savew2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :              DstSgn, TRACEHEADER )
               if (dflag) then
                  DstUsg = iabs(DstSgn)
                  call savew2( itr, ifmt_DstUsg, l_DstUsg, ln_DstUsg, 
     :                 DstUsg, TRACEHEADER )
               endif
            else
               
               DstSgn = scale*DstSgn
               call savew2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :              DstSgn, TRACEHEADER )
               if(dflag) then
                  DstUsg = iabs( DstSgn )
                  call savew2( itr, ifmt_DstUsg, l_DstUsg, ln_DstUsg, 
     :                 DstUsg, TRACEHEADER )
               endif
            endif

            if((nrr .ne. 0 .and. rnum) .OR. rnum) then
               call savew2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              jj, TRACEHEADER )
            endif
            if((ntrcc .ne. 0 .and. rnum) .OR. rnum) then
               call savew2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :              kk, TRACEHEADER )
            endif
c
            if(verbos) then
               write(LERR,*)'New header values'
               if(np .gt. 0) write(LERR,*)(wtrce(ii),ii=1,np)
            endif
c----------------------------------------------------------------------
c     save new trace values (note change from I*2 to I*4 in ival)
c----------------------------------------------------------------------
            do i=1,ik
               if (ihflag(i) .eq. SAVE_CHARACTER_DEF) then
                  call savew2(itr,slufmt(i),sluind(i),slulng(i),
     :                 ihwdc(i),TRACEHEADER)
               elseif ((ihflag(i) .eq. SAVE_REAL_DEF) .or.
     :         		(ihflag(i) .eq. SAVE_FAKE_REAL_DEF)) then
                  call savew2(itr,slufmt(i),sluind(i),slulng(i),
     :                 ihwdr(i),TRACEHEADER)
               else
                  call savew2(itr,slufmt(i),sluind(i),slulng(i),
     :                 ihwd(i),TRACEHEADER)
               endif
            enddo

            call vmov (wtrce, 1, ITR(ITHWP1), 1, nsamp)
            IF (.not. inplace) THEN
               call wrtape(luout,itr,obytes)
           else
               call bkspt(luin,1)
               call wrtape(luin,itr,nbytes)
            endif
c
         ENDDO
      ENDDO

 999  continue
      call lbclos(luin)
      if (.not. inplace)
     1     call lbclos(luout)
      stop
      END

      subroutine help
#include <f77/iounit.h>
c-----------------------------------------------------------------------------
c     online help screen
c-----------------------------------------------------------------------------
c
c - changed this from luer to ler so HP help screen would go to screen
c						- j.m.wade 6/7/93
c
       write(ler,*)' '
       write(ler,*)'Command Line Arguments for UTOP: '
       write(ler,*)'          change SIS headers'
       write(ler,*)' '
       write(ler,*)'Input....................................... (def)'
       write(ler,*)' '
       write(ler,*)'-N[ntap]   -- input data set'
       write(ler,*)'-O[otap]   -- output data set'
       write(ler,*)'-S[nsampn] -- new number of samples'
       write(ler,*)'-dt[nso]   -- new sample interval'
       write(ler,*)'-R[nrr]    -- new records per line'
       write(ler,*)'-L[ntrcc]  -- new traces per record'
       write(ler,*)'-G[grp]    -- new group interval'
       write(ler,*)'-D0[d0]    -- near offset: if not 0 then new trace'
       write(ler,*)'              distances are computed using -G '
       write(ler,*)'              entry above'
       write(ler,*)'-h0,9[s]   -- modify this line header structure key
     1, e.g. NumSmp'
       write(ler,*)'              to change number samples/trace'
       write(ler,*)'=[i]       -- immediately after each entry above '
       write(ler,*)'              (no blank), type equal followed by '
       write(ler,*)'              the value, eg -h0NumSmp=250'
       write(ler,*)'-k0,9[c]   -- modify this trace header structure ke 
     1y, e.g. UphlTm'
       write(ler,*)'              to change uphole time for every trace
     1'
       write(ler,*)'=[i]       -- immediately after each entry above '
       write(ler,*)'              (no blank), type equal followed by '
       write(ler,*)'              the value, eg -k0UphlTm=50'
       write(ler,*)'              trace changes are global at present'
       write(ler,*)'-s[scale]  -- scale trace distances'
       write(ler,*)'-p[np]     -- print p values of traces         (0)'
       write(ler,*)'-d         -- force unsigned tr dist = abs signed'
       write(ler,*)'-rnum      -- renumber records/traces sequentially'
       write(ler,*)'-H         -- strip off historical line header'
       write(ler,*)'-T[]       -- write single line of text to'
       write(ler,*)'              historical line header without'
       write(ler,*)'              writing command line parameters'
       write(ler,*)'-V         -- verbos printout'
       write(ler,*)' '
       write(ler,*)'Usage:'
       write(ler,*)'      utop -N[] -O[] -dt[] -R[] -L[] -G[] -D0[]'
       write(ler,*)'            -h(0,9)[] =[] -k(0,9)[] =[] -s[]'
       write(ler,*)'              -rnum -H -p[] -T[] -V'
       write(ler,*)' '
      return
      end

      subroutine cmdln(ntap,otap,nso,nrr,ntrcc,grp,d0,scale,np,
     1                 nsampn,verbos,dflag,rnum,strphlh,name2)
c-----
c     get command arguments
c
c     ntap  - C*255     input file name
c     otap  - C*255     output file name
c      nso  - I         new sample interval
c      nrr  - I         new records number
c    ntrcc  - I         new traces/record
c      grp  - C*4       new group interval
c       d0  - R         new near offset
c    scale  - R         scale factor for traces
c       np  - I         printout np trace values
c    nsampn - I         new samples/trace
c     verbos- L   verbose output or not
c     dflag - L   if true adjust the unsigned trace distance
c     rnum  - L   if true renumber records/trces
c   strphlh - L   if true strip off historical lineheader
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*), grp*4,name2*(*)
      logical   verbos, dflag, rnum, strphlh
      integer   argis,nso,nrr,ntrcc
      real      d0, scale

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4('-S',nsampn,0,0) 
            call argstr( '-T', name2, '-99999', '-99999' )
            call argi4('-dt',nso,0,0) 
            call argi4('-R',nrr,0,0)
            call argi4('-L',ntrcc,0,0)
            call argstr('-G',grp,' ',' ')
            call argr4('-D0',d0,0.,0.)
            call argr4('-s',scale,1.,1.)
            call argi4('-p',np,0,0)
            dflag =  ( argis( '-d' ) .gt. 0 )
            rnum  =  ( argis( '-rnum' ) .gt. 0 )
            strphlh= ( argis( '-H' ) .gt. 0 )
            verbos = ( argis( '-V' ) .gt. 0 )

            if(nrr .ne. 0) then
               write(LERR,*)' New # records/job  =  ',nrr
            endif
            if(ntrcc .ne. 0) then
               write(LERR,*)' New # traces/rec   =  ',ntrcc
            endif
            if(d0 .ne. 0. .and. grp .ne. ' ') then
               write(LERR,*)' Near offset        =  ',d0
               write(LERR,*)' New trace distances computed'
            endif
            write(LERR,*)  ' Scale trace dists  =  ',scale

      return
      end

      subroutine header(icc,lhw,iwd,iwdc,iwdr,
     1        ithw,ihwd,ihwdc,ihwdr,ih,ik,iflag,ihflag)
c-----
c     get command arguments for header word changes
c
c      icc  - C*1       number to append to command line key
c      lwd  - C*6       vector of line header structure keys
c      iwd  - I         vector of respective values for above keys
c     iwdc  - C         vector of single character entries for JOB # & OAC #
c     ithw  - C*6       vector of trace header structure keys
c-----
#include   <f77/iounit.h>
#include   <f77/sisdef.h>
      character*24 lhw(*), ithw(*)
      integer      iwd(*), ihwd(*)
      character*3  keyh, keyk
c  change iwdc to be an array of strings since saver and savew now
c  allow storage and retrieval of complete strings   - j.m.wade 10/18/89
c     character*1  icc(*), iwdc(*)
      character*1  icc(*)
      character*10 iwdc(*),ihwdc(*)
      real iwdr(*),ihwdr(*)
      integer      ih, ik, i, iflag(*), ihflag(*)

c
c #include <f77/save.h>

c                        get line header word postion
      ih=0
         do 21 i=1,10
           keyh='-h'//icc(i)
              call argstr(keyh,lhw(i),' ',' ')
           if(lhw(i) .eq. ' ') go to 1
           ih=ih+1
   21    continue
    1    continue

      call hdrarg(lhw,ih,LINHED,iflag,iwdc,iwd,iwdr)

c                       get trace header word postion
      ik=0
         do 23 i=1,10
           keyk='-k'//icc(i)
              call argstr(keyk,ithw(i),' ',' ')
           if(ithw(i) .eq. ' ') go to 2
           ik=ik+1
   23    continue
    2    continue

      call hdrarg(ithw,ik,TRCHED,ihflag,ihwdc,ihwd,ihwdr)

c                      printout header changes
      do 26 i=1,ih
         if(lhw(i) .ne. ' ') then
            if(iflag(i) .eq. SAVE_CHARACTER_DEF) then
              write(LERR,*)' Value of ',iwdc(i),
     1            ' in line header word= ',lhw(i)(1:6)
            else if((iflag(i) .eq. SAVE_REAL_DEF) .or.
     1      	(iflag(i) .eq. SAVE_FAKE_REAL_DEF)) then
              write(LERR,*)' Value of ',iwdr(i),
     1            ' in line header word= ',lhw(i)(1:6)
            else
              write(LERR,*)' Value of ',iwd(i),
     1            ' in line header word= ',lhw(i)(1:6)
            endif
         endif
   26 continue
      do 27 i=1,ik
         if(ithw(i) .ne. ' ') then
            if(ihflag(i) .eq. SAVE_CHARACTER_DEF) then
              write(LERR,*)' Value of ',ihwdc(i),
     1            ' in line header word= ',ithw(i)(1:6)
            else if((ihflag(i) .eq. SAVE_REAL_DEF) .or.
     1      	(ihflag(i) .eq. SAVE_FAKE_REAL_DEF)) then
              write(LERR,*)' Value of ',ihwdr(i),
     1            ' in line header word= ',ithw(i)(1:6)
            else
              write(LERR,*)' Value of ',ihwd(i),
     1            ' in line header word= ',ithw(i)(1:6)
            endif
         endif
   27 continue

      return
      end

      subroutine gpack(grp)
c-------------------------------------------------------------------------------- 
c  routine to pack the group entry characters so that they start on the rightmost
c  position of the 4 character array.  the routine makes sure the unused leftmost
c  entries are blanked
c
c    grp   - C*4   group array dimension
c    temp  - C*1   work area
c--------------------------------------------------------------------------------
      character  grp*4, temp*1
      leni = 0
      do 1 i = 1, 4
         if(grp(i:i) .ne. ' ') then
             leni = leni + 1
         endif
    1 continue
      j = 4
      do 2 i = leni, 1, -1
         temp = grp(i:i)
         grp(j:j) = temp
         j = j - 1
    2 continue
      do 3 i = 1, 4-leni
         grp(i:i) = ' '
    3 continue
      return
      end

