c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c -----------------  Main Routine -----------------------
c vpad - pad samples onto the first 3 axes of a dataset
c
c     Program Description:
c
c     Pad or remove samples on any of the first 3 axes of a dataset.
c     Negative pad values will remove samples.
c     Set the dead trace flag if desired.
c     Replicate samples by default, but also allow user control over
c       value in padded samples.
c
c     Program Changes:
c
c      - original written: July 27, 2001
c      - Version 1.0.1:    July 31, 2001   Fixed bug in nread logic -mjo
c
c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c declare standard USP variables 
      integer     ilhd(3*SZLNHD)
     
      integer     luin , luout
      integer     ibytes, obytes, lbytes, lbyout, nbytes
c      integer     nsamp, ntrc, nrec, iform
      integer     argis

      character   ntap*255, otap*255, name*4

      logical     verbose

c Program Specific _ dynamic memory variables
      integer TrcSzIn, RecSzIn, HdrSzIn
      integer TrcSzOut,RecSzOut,HdrSzOut
      integer TotalMem
      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, abort

      integer HdrIn(2),HdrOut(2)
      integer TrcIn(2),TrcOut(2)
      real    RecIn(2),RecOut(2)

      pointer (ptr_TrcIn,  TrcIn)
      pointer (ptr_TrcOut, TrcOut)
      pointer (ptr_RecIn,  RecIn)
      pointer (ptr_RecOut, RecOut)
      pointer (ptr_HdrIn,  HdrIn)
      pointer (ptr_HdrOut, HdrOut)

c Program Specific _ static memory variables
      integer n1_in, n2_in, n3_in
      integer n1_out, n2_out, n3_out
      integer n1b,n1e, n2b,n2e, n3b,n3e
      real    val, val_flag
      logical ldead, lnewrec

      integer hdr_index, tr_index
      integer k, kptr, nread, irec, itrc

c Variables for access to StaCor, RecNum and TrcNum trace headers
      integer ifmt_StaCor,l_StaCor,ln_StaCor
      integer ifmt_RecNum,l_RecNum,ln_RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum

c Initialize variables
      data val_flag/-1e+37/
      data abort/0/
      data name/"VPAD"/

c give command line help if requested
      if ( argis('-?')    .gt. 0 .or. 
     :     argis('-h')    .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
        call help()
        stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters
      call cmdln
     :       (ntap, otap, n1b,n1e, n2b,n2e, n3b,n3e, val,
     :        ldead, name, verbose)

c open input and output files
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c read input line header and save certain parameters
      call rtape(luin,ilhd,lbytes)
      if(lbytes.eq.0)then
        write(LER,*)name,': no line header on input file',ntap
        write(LER,*)'FATAL'
        stop
      endif

c print HLH to printout file 
      call hlhprt (ilhd, lbytes, name, 4, LERR)

c get sizes for dynamic allocation and i/o traces
      call saver(ilhd, 'NumSmp', n1_in, LINHED)
      call saver(ilhd, 'NumTrc', n2_in, LINHED)
      call saver(ilhd, 'NumRec', n3_in, LINHED)

      n1_out = n1_in + n1b + n1e
      n2_out = n2_in + n2b + n2e
      n3_out = n3_in + n3b + n3e

c     for traces
      TrcSzIn  = SZTRHD + n1_in*SZSMPD
      TrcSzOut = SZTRHD + n1_out*SZSMPD

c     for arrays
      RecSzIn  = n1_in*n2_in*SZSMPD
      RecSzOut = n1_out*n2_out*SZSMPD
      HdrSzIn  = SZTRHD*n2_in
      HdrSzOut = SZTRHD*n2_out

      TotalMem =  TrcSzIn  + RecSzIn  + HdrSzIn
     :          + TrcSzOut + RecSzOut + HdrSzOut

c     number bytes on input/output
      ibytes = TrcSzIn
      obytes = TrcSzOut

c dynamic memory allocation:  
      call galloc(ptr_TrcIn,  TrcSzIn,  errcd1, abort)
      call galloc(ptr_TrcOut, TrcSzOut, errcd2, abort)
      call galloc(ptr_RecIn,  RecSzIn,  errcd3, abort)
      call galloc(ptr_RecOut, RecSzOut, errcd4, abort)
      call galloc(ptr_HdrIn,  HdrSzIn,  errcd5, abort)
      call galloc(ptr_HdrOut, HdrSzOut, errcd6, abort)
    
      if (errcd1.ne.0 .or. errcd2.ne.0 .or. errcd3.ne.0 .or.
     :    errcd4.ne.0 .or. errcd5.ne.0 .or. errcd6.ne.0) then
        write(LERR,*)' '
        write(LERR,*)'Unable to allocate workspace: ',TotalMem,' bytes'
        write(LERR,*)'FATAL'
        write(LERR,*)' '
        write(LER,*)' '
        write(LER,*)'Unable to allocate workspace: ',TotalMem,' bytes'
        write(LER,*)'FATAL'
        write(LER,*)' '
        stop
      else
        write(LERR,*)' '
        write(LERR,*)'Allocated ',TotalMem,' bytes of workspace'
        write(LERR,*)' '
      endif

c initialize memory
      call vclr (TrcIn,  1, ITRWRD+n1_in)
      call vclr (TrcOut, 1, ITRWRD+n1_out)
      call vclr (RecIn,  1, n1_in*n2_in)
      call vclr (RecOut, 1, n1_out*n2_out)
      call vclr (HdrIn,  1, ITRWRD*n2_in)
      call vclr (HdrOut, 1, ITRWRD*n2_out)

c modify line header to reflect new sizes
      call savew(ilhd, 'NumSmp', n1_out, LINHED)
      call savew(ilhd, 'NumTrc', n2_out, LINHED)
      call savew(ilhd, 'NumRec', n3_out, LINHED)

c save out hlh and line header
      call savhlh (ilhd, lbytes, lbyout)
      call wrtape (luout, ilhd, lbyout)

c verbose output of all pertinent information before processing begins
      call verbal
     :       (ntap,otap, n1_in,n2_in,n3_in, n1_out,n2_out,n3_out,
     :        n1b,n1e, n2b,n2e, n3b,n3e, val,val_flag, ldead, verbose)

c Get the trace header info for StaCor so we can apply ldead when needed
c also get RecNum,TrcNum to adjust output numbering
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

c BEGIN PROCESSING 

c Seek into the input to the first useful record
c     SISSEEK positions the unit at the specified trace. If the trace
c     number is less than 1, the file is positioned at trace 1. If the
c     trace number is greater than the number of traces, the file is
c     positioned at EOF.
      if (n3b.lt.0) call sisseek(luin,n2_in*n3b+1)

c Loop over output axis 3
      do k=1,n3_out

c       find the relative record pointer into the input data
        kptr = k-n3b

c       is this a new record?
        lnewrec = .false.
        if (kptr.lt.1 .or. kptr.gt.n3_in) lnewrec = .true.

c       figure out if we need to read an input record for this k
        if (k.eq.1)                    nread = 1
        if (k.gt.1 .and. lnewrec)      nread = 0
        if (k.gt.1 .and. .not.lnewrec) nread = 1
        if (k.gt.1 .and. kptr.eq.1)    nread = 0

c       read and process nread records
        do irec=1,nread

c         loop over axis 2 to load a record
          tr_index = 1 - n1_in
          hdr_index = 1 - ITRWRD
          do itrc = 1,n2_in
            nbytes = 0
            call rtape(luin, TrcIn, nbytes)
            if(nbytes.eq.0)then
              write(LERR,*)'Read error on input at record ',
     :                      min(n3_in,max(1,kptr)),' trace= ',itrc
              stop
            endif
c           split data and headers
            tr_index = tr_index + n1_in
            hdr_index = hdr_index + ITRWRD
            call vmov(TrcIn, 1, HdrIn(hdr_index), 1, ITRWRD)
            call vmov(TrcIn(ITHWP1), 1, RecIn(tr_index), 1, n1_in)
          enddo

c         process the record
          call recpad
     :           (RecIn,n1_in,n2_in, RecOut,n1_out,n2_out,
     :            n1b,n1e, n2b,n2e, ldead, val,val_flag, lnewrec)

c         process the headers
          call hdrpad
     :           (HdrIn,n2_in, HdrOut,n2_out, ITRWRD, n2b,n2e,
     :            ldead, ifmt_StaCor,l_StaCor,ln_StaCor, lnewrec)

        enddo

c       reprocess record that was cleared in first read
        if (kptr.eq.1 .and. val.ne.val_flag) then
          call recpad
     :           (RecIn,n1_in,n2_in, RecOut,n1_out,n2_out,
     :            n1b,n1e, n2b,n2e, ldead, val,val_flag, lnewrec)
          call hdrpad
     :           (HdrIn,n2_in, HdrOut,n2_out, ITRWRD, n2b,n2e,
     :            ldead, ifmt_StaCor,l_StaCor,ln_StaCor, lnewrec)
        endif

c       reprocess ending records that haven't yet been cleared
        if (kptr.eq.n3_in+1 .and. val.ne.val_flag) then
          call recpad
     :           (RecIn,n1_in,n2_in, RecOut,n1_out,n2_out,
     :            n1b,n1e, n2b,n2e, ldead, val,val_flag, lnewrec)
          call hdrpad
     :           (HdrIn,n2_in, HdrOut,n2_out, ITRWRD, n2b,n2e,
     :            ldead, ifmt_StaCor,l_StaCor,ln_StaCor, lnewrec)
        endif

c       write the processed record
        tr_index = 1 - n1_out
        hdr_index = 1 - ITRWRD
        do itrc = 1,n2_out

c         First get the ptrs into the processed data and header arrays
          tr_index = tr_index + n1_out
          hdr_index = hdr_index + ITRWRD

c         Now glue headers and data together into an output vector
          call vmov (HdrOut(hdr_index), 1, TrcOut(1), 1, ITRWRD)
          call vmov (RecOut(tr_index), 1, TrcOut(ITHWP1), 1, n1_out)

c         Now adjust record and trace counters in the output header
          call savew2 (TrcOut,ifmt_RecNum,l_RecNum,ln_RecNum,k,
     :                 TRACEHEADER)
          call savew2 (TrcOut,ifmt_TrcNum,l_TrcNum,ln_TrcNum,itrc,
     :                 TRACEHEADER)

c         Now write the trace
          call wrtape (luout, TrcOut, obytes)

        enddo

c End of loop over output records
      enddo

c Close data files 
      call lbclos (luin)
      call lbclos (luout)
      write(LERR,*)name,': Normal Termination'
      write(LER,*)name,': Normal Termination'
      stop

      end


c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c provide terse online help [detailed help goes in man page]
      subroutine help()

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for vpad'
      write(LER,*)' '
      write(LER,*)'Input......................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]       -- input data set                (stdin:)'
      write(LER,*)'-O[]       -- output data set              (stdout:)'
      write(LER,*)' '
      write(LER,*)'-1b[n1b]   -- # Samples to pad at beg. of axis 1 (0)'
      write(LER,*)'-1e[n1e]   -- # Samples to pad at end  of axis 1 (0)'
      write(LER,*)'-2b[n2b]   -- # Samples to pad at beg. of axis 2 (0)'
      write(LER,*)'-2e[n2e]   -- # Samples to pad at end  of axis 2 (0)'
      write(LER,*)'-3b[n3b]   -- # Samples to pad at beg. of axis 3 (0)'
      write(LER,*)'-3e[n3e]   -- # Samples to pad at end  of axis 3 (0)'
      write(LER,*)' '
      write(LER,*)'-val[val]    -- Value for padded samples (Replicate)'
      write(LER,*)'-dead[ldead] -- Flag new traces as dead      (FALSE)'
      write(LER,*)' '
      write(LER,*)'-V           -- Verbose printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'  vpad -N[] -O[] -1b[] -1e[] -2b[] -2e[] -3b[] -3e[]'
      write(LER,*)'       [ -val[] -dead -V ]'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end


c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c pick up command line arguments 
      subroutine cmdln
     :       (ntap, otap, n1b,n1e, n2b,n2e, n3b,n3e, val,
     :        ldead, name, verbose)

#include <f77/iounit.h>

      integer    argis, n1b,n1e, n2b,n2e, n3b,n3e
      real       val
      character  ntap*(*), otap*(*), name*(*)
      logical    ldead, verbose

      call argstr('-N', ntap, ' ', ' ') 
      call argstr('-O', otap, ' ', ' ') 
      call argi4('-1b', n1b, 0, 0)
      call argi4('-1e', n1e, 0, 0)
      call argi4('-2b', n2b, 0, 0)
      call argi4('-2e', n2e, 0, 0)
      call argi4('-3b', n3b, 0, 0)
      call argi4('-3e', n3e, 0, 0)
      call argr4('-val', val, -1.0e+37, -1.0e+37 )
      verbose= (argis('-V') .gt. 0)
      ldead  = (argis('-dead') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's
      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

      return
      end


c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c verbal printout of pertinent program particulars
      subroutine verbal
     :       (ntap,otap, n1_in,n2_in,n3_in, n1_out,n2_out,n3_out,
     :        n1b,n1e, n2b,n2e, n3b,n3e, val,val_flag, ldead, verbose)

#include <f77/iounit.h>

      character  ntap*(*), otap*(*)
      integer    n1_in, n2_in, n3_in
      integer    n1_out,n2_out,n3_out
      integer    n1b,n1e, n2b,n2e, n3b,n3e
      real       val, val_flag
      logical    ldead, verbose

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*)'   input data set name   =  ',ntap
      write(LERR,*)'   samples per trace     =  ',n1_in
      write(LERR,*)'   traces per record     =  ',n2_in
      write(LERR,*)'   number of records     =  ',n3_in
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*)'   output data set name  =  ',otap
      write(LERR,*)'   samples per trace     =  ',n1_out
      write(LERR,*)'   samples per trace     =  ',n1_out
      write(LERR,*)'   traces per record     =  ',n2_out
      write(LERR,*)' '
      write(LERR,*)'   Axis 1 prepad         =  ',n1b
      write(LERR,*)'   Axis 1 postpad        =  ',n1e
      write(LERR,*)' '
      write(LERR,*)'   Axis 2 prepad         =  ',n2b
      write(LERR,*)'   Axis 2 postpad        =  ',n2e
      write(LERR,*)' '
      write(LERR,*)'   Axis 3 prepad         =  ',n3b
      write(LERR,*)'   Axis 3 postpad        =  ',n3e
      write(LERR,*)' '
      if ( val .ne. val_flag ) then
        write(LERR,*)'   Value padded          = ',val
        write(LERR,*)' '
      else
        write(LERR,*)'   Samples are replicated'
      endif
      if ( ldead ) then
        write(LERR,*)'   Padded traces are flagged dead'
      endif
      if ( verbose ) then
        write(LERR,*)'   Verbose printout requested'
      endif
      write(LERR,*)' '

      return
      end
