C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE XNDEX(V,Z,N,X,S,IX,tf)

#include <f77/lhdrsz.h>

C
C   PROGRAM TO CHANGE DEPTH TO A SAMPLE INDEX
C
C   INPUTS:
C          V--VELOCITY ARRAY OF MODEL
C          Z--DEPTH ARRAY
C          N--NUMBER OF INTERFACES IN GIVEN MODEL
C          X--DEPTH TO TRANSFORM
C          S--SAMPLE INTERVAL
C
C   OUTPUT:
C          IX--TIME INDEX CORRESPONDING TO GIVEN DEPTH
C
      DIMENSION V(1),Z(1)
      D=0.
      TT=0.
      DO 5 I=1,100*SZSMPM
C
C   IF I .GT. N WE ARE IN THE HALF-SPACE
C
      IF(I .GT. N) GO TO 3
      IF(X .GT. (D+Z(I))) GO TO 1
    3 TT=TT +   2.*(X-D)/V(I)
      GO TO 6
    1 TT=TT +   2.*Z(I)/V(I)
      D=D + Z(I)
    5 CONTINUE
    6 CONTINUE
      IX=IFIX(TT/S  + .5)
      RETURN
      END
      SUBROUTINE PEEQU1(N,C,P,Q,S)
C      COMPUTES THE POLYNOMIALS P(Z) AND Q(Z), AS WELL AS THE RATIONAL F
C      FOR THE REFLECTIVITY R(Z) AND THE TRANSMISSIVITY T(Z) * Z**(-N/2)
C      EACH LAYER HAS UNIT ONE-WAY TIME THICKNESS.
C     INPUTS
C      N=NUMBER OF UNIT ONE-WAY TIME THICKNESS LAYERS
C      C=N-LENGTH SUBSURFACE REFLECTION COEFFICIENT SERIES
C      S=-1.0 ... NORMAL STACK (C1,...CN) POLYNOMIALS
C       =+1.0 ... REVERSED STACK (CN,...C1) POLYNOMIALS
C     OUTPUTS
C      P= N+1 COEFFICIENTS OF POLYNOMIAL P(Z), ORDER N
C      Q= N+1 COEFFICIENTS OF POLYNOMIAL Q(Z), ORDER N
C     DIMENSION C(N),P(N+1),Q(N+1)
      DIMENSION C(*),P(*),Q(*)
      N1=N+1
      DO 1 I=1,N1
      P(I)=0.
    1 Q(I)=0.
      Q(1)=-C(1)*S
      N1=N-1
      IF(N1) 6,5,7
    7 CONTINUE
      DO 3 K=1,N1
      CC=C(K+1)
      DO 2 I=1,K
      PP=P(I)
      KI=K-I+1
      QQ=Q(KI)
      P(I)=PP-CC*QQ*S
    2 Q(KI)=QQ-CC*PP*S
      P(K+1)=0.
    3 Q(K+1)=-CC*S
    5 CONTINUE
      DO 4 I=1,N
      J=N-I+1
      P(J+1)=P(J)
    4 Q(J+1)=Q(J)
    6 P(1)=1.
      Q(1)=0.
      RETURN
      END
C
      SUBROUTINE RDISP(IA,IB,N,C0,C,Z,T,dt,nl)
C
C   DISPLAYS THE 1-D LAYERED MODEL
C   INPUT:
C          IA = SOURCE INTERFACE (0 - N)
C          IB = RECEIVER INTERFACE (0 -N)
C          N  = NUMBER OF SUBSURFACE LAYERS
C          C0 = SURFACE REFLECTION COEFFICIENT
C          C  = SUBSURFACE REFLECTION COEFFICIENTS
c          Z  = depths
c          T  = times
C
C
C   OUTPUT:
C           AS PER FORMAT STATEMENTS
C
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      DIMENSION C(1), Z(1), T(1)
      real  cc
      pointer (wkcc, cc(1))
      integer errcd, abort

      errcd = 0
      abort = 0
      dt2 = dt/2

      item = (n+1)*SZSMPD
      call galloc (wkcc, item, errcd, abort)
      if (errcd .ne. 0) then
        write(LERR,*)'FATAL ERROR in synth:'
        write(LERR,*)'Unable to allocate ',item,' bytes'
        write(LER ,*)'FATAL ERROR in synth:'
        write(LER ,*)'Unable to allocate ',item,' bytes'
        call ccexit (666)
      endif
C
      WRITE(LERR,104)
C
C   SET UP REFL. COEFF VECTOR USING C0,C1,...CN AS CC1,...,CCN+1
C
      call vmov(c,1,cc(2),1,n)
      CC(1)=C0
      tt = 0.
      N1=N+1
      K = 1

      DO 1 I=1,N1
        J=I-1
        t1 = tt - dt2
        t2 = tt + dt2
        if (T(k) .gt. t1 .AND. T(k) .lt. t2) then
            k = k + 1
        endif
        k1 = k - 1
        tt1 = tt
c       if (I .ne. 1) tt1 = tt1 - dt
        IF(J .NE. IA .AND. J .NE. IB) WRITE(LERR,100) J,CC(I)
        IF(J .EQ. IA .AND. J .EQ. IB) WRITE(LERR,101) J,CC(I),Z(k1),tt1
        IF(J .EQ. IA .AND. J .NE. IB) WRITE(LERR,102) J,CC(I),Z(k1),tt1
        IF(J .NE. IA .AND. J .EQ. IB) WRITE(LERR,103) J,CC(I),Z(k1),tt1
        tt = tt + dt
    1 CONTINUE

  100 FORMAT(5X,'--------------------',1X,'C',I5,'= ',F8.3)

  102 FORMAT(5X,'----S---------------',1X,'C',I5,'= ',F8.3,5x,'Z= ',
     1       f5.0,5x,'T= ',f10.5)

  101 FORMAT(5X,'----S---------R-----',1X,'C',I5,'= ',F8.3,5x,'Z= ',
     1       f5.0,5x,'T= ',f10.5)

  103 FORMAT(5X,'--------------R-----',1X,'C',I5,'= ',F8.3,5x,'Z= ',
     1       f5.0,5x,'T= ',f10.5)

      WRITE(LERR,104)
  104 FORMAT(/////)
      call gfree (wkcc)
      RETURN
      END

      SUBROUTINE POLYDV0(N,DVS,M,DVD,L,Q)
      DIMENSION DVS(*),DVD(*),Q(*)
      call vclr(q,1,L)
      call vmov(dvd,1,q,1,min0(m,l))
      DO 10 I=1,L
      Q(I)=Q(I)/DVS(1)
      IF(I .EQ. L) RETURN
      K=I
      ISUB=MIN0(N-1,L-I)
      DO 10 J=1,ISUB
      K=K+1
   10 Q(K)=Q(K)-Q(I)*DVS(J+1)
      RETURN
      END
C   ******************** NOTE *************************
C
C   CORRECTIONS MADE TO TRANSMISSION LOSS FACTORS TSA & TSB
C   BY INSERTION OF A CALL MOV STATEMENT.  SEE CHANGES BELOW.
C   CORRECTIONS MADE 11-15-82
C
C   ****************************************************
C
      SUBROUTINE SNTHET(DELT,NUM,N,IA,IB,C0,C,XU,XD,Y,PG,QG,PD,QD,PMCQ,
     1IWR,EP,EM,CP,P,Q,NG,TS,iflag,title,xa,xb,cc,cpmqa,time)
C
C   PROGRAM TO GENERATE SYNTHETIC AM USING LAYER MATRIX
C   FORMULATION OF ROBINSON AND TREITEL.   THE THEORY HAS BEEN
C   EXTENDED BY P. GUTOWSKI TO INCLUDE A BURIED SOURCE AND A BURIED
C   RECEIVER AT ARBITRARY DEPTHS, THAT IS, AT ARBITRARY MULTIPLES
C   OF Z**.5,  WHERE Z IS THE UNIT DELAY OPERATOR.  THE LAYERED
C   STRUCTURE IS THEN DEFINED IN TERMS OF LAYERS HAVING UNIT TWO
C   WAY TRAVEL TIME THICKNESS.
C   AT PRESENT THE INTERFACES AT WHICH THE SOURCE AND RECEIVER ARE
C   FOUND DO NOT CONTRIBUTE TO THE PRIMARY REFLECTIONS.
C   IN ORDER TO COMPUTE THE RESPONSE WE MUST COMPUTE SEVERAL OF THE
C   P AND Q POLYNOMIALS OF ROBINSON AND TREITEL:
C
C     P(J,N) REFERS TO THE P - POLYNOMIAL COMPUTED USING THE PARTIAL
C     LAYERED STACK CJ,CJ+1,...,CN.  THE COMPUTATION PROCEEDS AS
C     IF CJ WERE THE SURFACE REFLECTION COEFFICIENT.  P(0,N) IS THE
C     P - POLYNOMIAL FOR THE FULL LAYERED STACK C0,C1,...,CN, WHERE
C     C0 IS THE ACTUAL SURFACE REFLECTION COEFFICIENT.
C     Q(J,N) IS DEFINED IN A SIMILAR MANNER.
C
C     LET A BE THE SOURCE INTERFACE AND B BE THE RECEIVER INTERFACE
C     FOR A<B, SOURCE ABOVE RECEIVER:
C
C        UP RESPONSE AT B =
C
C        T*(Q(0,A) + P(0,A))Q(B,N)/(P(0,N) + C0*Q(0,N))
C
C        DOWN RESPONSE AT B =
C
C        T*(Q(0,A) + P(0,A))P(B,N)/(P(0,N) + C0*Q(0,N))
C
C     FOR A>B, RECEIVER ABOVE SOURCE:
C
C         UP RESPONSE AT B =
C
C         T'*(Q(A,N) + P(A,N))P(0,B)/(P(0,N) + C0*Q(0,N))
C
C         DOWN RESPONSE AT B =
C
C         T'*(Q(A,N) + P(A,N))Q(0,B)/(P(0,N) + C0*Q(0,N))
C
C
C         WHERE T= T1T2...TB Z*((B-A/2)/T1T2...TA
C
C               T'=T'1T'2...T'A-1 Z**((B-A)/2)/T'1T'2...T'B-1
C
C         ARE THE TRANSMISSION FACTORS
C
C   SUBROUTINES CALLED:
C
C                    PEEQU1
C                    PLT
C                    REVERS
C                    RDISP
C                    MOV
C                    FOLD
C                    POLYDV0
C
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      DIMENSION C(*),CC(*),PG(*),QG(*),PD(*),QD(*)
      DIMENSION P(*),Q(*),PMCQ(*),CPMQA(*),Y(*)
      DIMENSION XD(*),XU(*),TIME(*)
      DIMENSION CP(*),iwr(10),title(20)
      data      nrec/1/,iproc/1/
      save      SN
      ntr=iwr(7)
C
C   INITIALIZE P AND Q ARRAYS
C
      do  I=1,NUM
         PG(I)=0.
         QG(I)=0.
         PD(I)=0.
         QD(I)=0.
         P(I)=0.
         Q(I)=0.
         TIME(I)=0.
         CPMQA(I)=0.
      enddo
      do  I = 1, 3*num
         Y(I)=0.
         XU(I)=0.
         XD(I)=0.
      enddo
C
C   IF IFLAG .NE. 0 WE DO NOT NEED TO RECOMPUTE  PMCQ
C   BUT WE WILL HAVE NEW VALUES FOR IA & IB
C
      IF(IFLAG .EQ. 0) CALL vclr(pmcq,1,num)
      IF(IFLAG .NE. 0) GO TO 32
C
C   IA IS SOURCE INTERFACE
C   IB IS RECEIVER INTERFACE
C
C
C   C0 IS SURFACE REFECTION COEFFICIENT
C   N IS NUMBER OF LAYERS IN MODEL
C   NUM IS LENGTH OF AM TO BE DISPLAED
C
C   SET FLAG SN = 1.  FOR LAND CASE;  SN = -1.  FOR MARINE CASE
C
      IF(C0 .LE. 0.) SN=1.
      IF(C0 .GT. 0.) SN=-1.
C
   32 CONTINUE
C
C   WRITE PRIMARY REFLECTIONS
C
      II = iwr(1)
      IF(II .NE. 1 .or. iflag .gt. 0) GO TO 583
      call vclr(cc,1,num)
      call vmov(c,1,cc(2),1,n)
      CC(1)=C0
C

C
      call vsmul (cc,1,-sn,cc,1,n+1)
C
  583 CONTINUE
C
C   FIND DEEPEST OF EITHER SOURCE OR RECEIVER
C
      MAX=MAX0(IB,IA)
      N1=N+1
      IA1=IA+1
      IA2=IA-1
      IB1=IB+1
      IB2=IB-1
C
C   TIME DELAY BETWEEN SOURCE AND RECEIVER
C
      IDEL=INT(IABS(IA-IB)/2.)
C
C   READ IN C1,C2,...,CN
C
c     if(iwr(6) .ne. 0) CALL RDISP(IA,IB,N,C0,C)
C
C   IF IFLAG .NE. 0 DO NOT RECOMPUTE PMCQ
C
      IF(IFLAG .NE. 0) GO TO 71
C
C   COMPUTE P(0,N) AND Q(0,N) POLYNOMIALS
C
      CALL PEEQU1(N,C,P,Q,-1.)
C
C   COMPUTE P(0,N) + C0*Q(0,N)
C
      DO 1 J=1,N1
      PMCQ(J)= P(J) + C0*Q(J)
1     CONTINUE
      call polydv0(n1,pmcq,1,1.0,num,time)
      call vmov(time,1,pmcq,1,num)
   71 continue
C
C   CASES: 1.IA<IB   2.IA>IB
C
      IF(MAX .NE. IB) GO TO 3
C
C   CASE 1
C   SOURCE ABOVE RECEIVER
C
      WRITE(LERR,320)
  320 FORMAT(' SOURCE IS ABOVE RECEIVER ')
      IG=IB
      ID=IA
      GO TO 4
    3 CONTINUE
C
C   CASE 2
C   RECEIVER ABOVE SOURCE
C
      IG=IA
      ID=IB
      WRITE(LERR,321)
  321 FORMAT(' RECEIVER IS ABOVE SOURCE ')
    4 CONTINUE
C
C   SET UP INDICES FOR PARTIAL STACK POLYNOMIALS
C
      NG=N-IG
      IG1=IG+1
      NG1=NG+1
      ID1=ID+1
      ID2=ID-1
C
C   SET UP PARTIAL STACK  CIG,CIG+1,...,CN
C   WHERE CIG TAKES THE PLACE OF A SURFACE REFL COEFF
C
      call vmov(c(ig1),1,cc,1,ng)
      call vmov(c(ig1),1,cp,1,ng)
C
C   COMPUTE PARTIAL STACK POLYS  P(IG,N), Q(IG,N)
C
      CALL PEEQU1(NG,CC,PG,QG,-1.)
C
C   SET UP UPPER PARTIAL STACK  C0,C1,...,CID
C
      call vmov(c,1,cc(2),1,id2)
C
C   WE MUST INCLUDE C0 IN THE POLYNOMIAL COMPUTATIONS
C
      CC(1)=C0
C
C   COMPUTE UPPER PARTIAL STACK POLYS  P(0,ID), Q(0,ID)
C
      CALL PEEQU1(ID,CC,PD,QD,1.)
      CALL REVERS(ID,1.0,QD(2))
C
C   ALL POLYS NOW COMPUTED
C
      IF(MAX .NE. IB) GO TO 51
C
C   FOR IA<IB COMPUTE TRANSMISSION FACTORS
C
C
C   ADJUST REFL COEFFS FOR THE LAND CASE
C
      call vmov(c,1,cc,1,n)
      call vsmul (cc,1,-sn,cc,1,n)
C
      TSB=1.
      IF(IB .EQ. 0) GO TO 13
      DO 8 I=1,IB
    8 TSB=TSB*(1.+CC(I))
   13 TSA=1.
      IF(IA .EQ. 0) GO TO 14
      DO 9 I=1,IA
    9 TSA=TSA*(1.+CC(I))
   14 TS=TSB/TSA
      WRITE(LERR,417) TS
  417 FORMAT(' TRANSMISSION FACTOR FOR IB>IA = ',E15.8)
C
C   FOR IA<IB COMPUTE PARTIAL STACK POLY  P(0,ID) + Q(0,ID)
C
      call vmov(c,1,cc(2),1,n)
      CC(1)=C0
      CIA=CC(IA1)
      DO 11 J=1,IA1
   11 CPMQA(J)=(PD(J)-CIA*QD(J))*EM + (1.+CIA)*QD(J)*EP
C
C   FOR IA<IB COMPUTE:
C
C          UPWARD RESPONSE
C
      CALL FOLD(IA1,CPMQA,NG1,QG,LU,Y)
      if(iwr(10) .eq. 0) then
      call fold(num,pmcq,lu,y,nnum,xu)
      else
      call vclr(xu,1,num)
      call vmov(y,1,xu,1,lu)
      endif
C
C          DOWNWARD RESPONSE
C
      call vclr (y,1,lu)
      call vclr (xd,1,nnum)
      CALL FOLD(IA1,CPMQA,NG1,PG,LU,Y)
      if(iwr(10) .eq. 0) then
      call fold(num,pmcq,lu,y,nnum,xd)
      else
      call vclr(xd,1,num)
      call vmov(y,1,xd,1,lu)
      endif
C
   10 CONTINUE
C
C   APPLY TRANSMISSION FACTORS TO UPWARD & DOWNWARD TRACES
C   AND APPLY TIME DELAY FACTOR
C
      DO 12 I=1,NUM
      J=NUM-I+1
      XU(J+IDEL)=XU(J)*TS
   12 XD(J+IDEL)=XD(J)*TS
      IF(IDEL .EQ. 0) GO TO 17
      DO 16 I=1,IDEL
      XU(I)=0.
   16 XD(I)=0.
   17 CONTINUE
C
      II = iwr(2)
      IF(II .NE. 1) GO TO 31
C
C   PLOT UPWARD RESPONSE
C
   31 continue
      II = iwr(3)
      IF(II .NE. 1) GO TO 40
C
C   PLOT DOWNWARD RESPONSE
C
   40 CONTINUE
      II = iwr(4)
      IF(II .NE. 1) GO TO 50
C
C   TO FORM TOTAL RESPONSE SUM UGOING AND DOWNGOING WAVES
C
      if(iwr(4) .eq. 1) then
      DO 42 I=1,NUM
   42 Y(I)= (XU(I) + XD(I))
      endif
C
C
C   PLOT TOTAL RESPONSE
C
   50 CONTINUE
      RETURN
C
C   FOR IA>IB COMPUTE TRANSMISSION FACTOR
C
   51 TSB=1.
      TSA=1.
      call vmov(c,1,cc(2),1,n)
      CC(1)=0.
C
C   ADJUST REFL COEFFS FOR THE LAND CASE
C
      call vsmul (cc,1,-sn,cc,1,n+1)
      ircvr=iwr(5)
C
C   FOR IB=0, I.E. RECEIVER AT THE SURFACE WE HAVE A CHOICE:
C         IRCVR =  +1  -- RECEIVER IS JUST ABOVE FREE SURFACE
C         IRCVR =  -1  -- RECEIVER IS JUST BELOW FREE SURFACE
C
      IF(IB .NE. 0) GO TO 41
C
      IF(IRCVR .EQ. 1) GO TO 41
      CC(1)=0.0
      QD(1)=-C0
   41 CONTINUE
      IF(IA .EQ. 0) GO TO 55
      DO 52 I=1,IA
   52 TSA=TSA*(1.-CC(I))
      IF(ABS(TSA) .LT. 1.E-30) TSA=1.
   55 IF(IB .EQ. 0) GO TO 56
      DO 53 I=1,IB
   53 TSB=TSB*(1.-CC(I))
      IF(ABS(TSB) .LT. 1.E-30) TSB=1.
   56 CONTINUE
      TS=TSA/TSB
      WRITE(LERR,401) TS
  401 FORMAT(' TRANSMISSION FACTOR, IA>IB = ',E15.8)
C
C   FOR IA>IB COMPUTE PARTIAL STACK POLY  P0IG + Q0IG
C
      CIA=C(IA)
      DO 54 J=1,NG1
   54 CPMQA(J)= (PG(J)+CIA*QG(J))*EP + (1.-CIA)*QG(J)*EM
C
C   FOR IA>IB COMPUTE:
C
C          UPWARD RESPONSE
C
      CALL FOLD(NG1,CPMQA,IB1,PD,LU,Y)
      if(iwr(10) .eq. 0) then
      call fold(num,pmcq,lu,y,nnum,xu)
      else
      call vclr(xu,1,num)
      call vmov(y,1,xu,1,lu)
      endif
C
C          DOWNWARD RESPONSE
C
      CALL FOLD(NG1,CPMQA,IB1,QD,LU,Y)
      if(iwr(10) .eq. 0) then
      call fold(num,pmcq,lu,y,nnum,xd)
      else
      call vclr(xd,1,num)
      call vmov(y,1,xd,1,lu)
      endif
C
C   FOR IA>IB PROCEED TO PLOT SECTION
C
      GO TO 10
      END
C
