C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine WriteHeader(luout, FormatIn, FormatOut, NumEntries,
     :     sin, sout, luin, time_depth_curve, depth_time_curve, 
c xsd specifics
     :     Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit, NumFcns,
     :     Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset,
     :     Xsd_VelOffsetOverride, Xsd_VelUnitOverride,
     :     Xsd_SmpUnitOverride,
c usp specifics
     :     itr, lbytes, name, nsamp, nsi, ntrc, nrec, nsampo,
     :     Usp_SmpIntOverride, MBSdx, MBSdy, MBSdz, UnitSc_out,
     :     Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth,
c vds3d specifics
     :     Vds_StaticsMode, Vds_JobConstantStatic, Vds_MutePercent, 
     :     Vds_WaterBottom, Vds_MinLI, Vds_MaxLI, Vds_MinDI, Vds_MaxDI,
     :     Vds_LIinc, Vds_DIinc, Vds_InterpRadius, Vds_PrtWgtFlag, 
     :     Vds_BinsizeLI, Vds_BinsizeDI, Vds_NumScheme, Vds_DipAzimFlag,  
     :     Vds_OacLine, Vds_VelPrtInc,  
c ev3d specifics
     :     Earth_NumX, Earth_NumY, Earth_NumZ,
c omnivel specifics
     :     OACLin,LinNam,JobNum,DatTyp,PrcNam,APIWNo,CDPFLD,PrcDat,
     :     WatVel,vout,
c tdq specifics
     :     tdq_datum, tdq_c_units, verbos ) 

c routine to output velocity function in desired output format

#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c variables passed from calling routine

      integer luout, NumEntries, NumFcns, Usp_SmpIntOverride
      integer itr( SZLNHD ), nsamp, nsi, ntrc, nrec, nsampo, luin
      integer MBSdx, MBSdy, MBSdz
      integer Vds_StaticsMode, Vds_JobConstantStatic
      integer Vds_MutePercent, Vds_WaterBottom
      integer Vds_MinDI, Vds_MaxDI, Vds_MinLI, Vds_MaxLI
      integer Vds_LIinc, Vds_DIinc, Vds_InterpRadius
      integer Vds_NumScheme, Vds_DipAzimFlag, Vds_VelPrtInc
      integer Earth_NumX, Earth_NumY, Earth_NumZ

      real Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit 
      real Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset
      real Xsd_VelOffsetOverride, Xsd_VelUnitOverride
      real Xsd_SmpUnitOverride
      real Vds_BinsizeDI, Vds_BinsizeLI
      real Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth
      real UnitSc_out
      real tdq_datum

      character FormatOut*20, FormatIn*20, name*5, Vds_OacLine*7
      character sin*1, sout*1
      character tdq_c_units*6

cmam  add for omnivel
      character vout*1
      integer VelTyp

      logical time_depth_curve, depth_time_curve, verbos

      character OACLin*8, LinNam*8, JobNum*8, DatTyp*1, PrcNam*10,
     :          APIWNo*12, PrcDat*8
      integer*2 CDPFLD
      integer WatVel

c local variables

      real RecUnit, SmpUnit, VelUnit, RecOffset, VelOffset, SmpOffset

      character ukooa_card*80
      character No_Seg*6, Max_Pick*8, UnitRec*7, UnitTrc*7, UnitSmp*7
      character OffsetRec*9, OffsetTrc*9, OffsetSmp*9
      character NumRec*6, NumTrc*6, NumSmp*6
      character tdq_c_ftype*18, tdq_c_vout*5, tdq_c_lunits*17
      character tdq_c_datum*10, tdq_c_separator*46

c initialize variables

      ukooa_card = '            -999999999999999-999999999999999 '

c begin processing headers

      IF ( FormatOut .eq. 'xsd' .or.
     :     FormatOut .eq. 'vxos' .or.
     :     FormatOut .eq. 'xsdheader' ) then
         if ( abs(Xsd_RecUnit) .lt. 1.e-32 ) then
            RecUnit = 1.0
         else
            RecUnit = Xsd_RecUnit
         endif

         if ( abs(Xsd_VelUnit) .lt. 1.e-32 ) then
            VelUnit = 1.0
         else
            VelUnit = Xsd_VelUnit
         endif

         if ( abs(Xsd_SmpUnit) .lt. 1.e-32 ) then
            SmpUnit = 1.0
         else
            SmpUnit = Xsd_SmpUnit
         endif

         if ( abs(Xsd_RecOffset) .gt. 1.e-32 ) then
            RecOffset = Xsd_RecOffset
         else
            RecOffset = 0.0
         endif

         if ( abs(Xsd_VelOffset) .gt. 1.e-32 ) then
            VelOffset = Xsd_VelOffset
         else
            VelOffset = 0.0
         endif

         if ( abs(Xsd_SmpOffset) .gt. 1.e-32 ) then
            SmpOffset = Xsd_SmpOffset
         else
            SmpOffset = 0.0
         endif

         if ( abs(Xsd_VelUnitOverride) .gt. 1.e-32 ) then
            VelUnit = Xsd_VelUnitOverride
            Xsd_VelUnit = Xsd_VelUnitOverride
         endif
         
         if ( abs(Xsd_VelOffsetOverride) .gt. 1.e-32 ) then
            VelOffset = Xsd_VelOffsetOverride 
            Xsd_VelOffset = Xsd_VelOffsetOverride
         endif

         if ( abs(Xsd_SmpUnitOverride - 1.0) .gt. 1.e-32 ) then 
            SmpUnit = Xsd_SmpUnitOverride 
            Xsd_SmpUnit = Xsd_SmpUnitOverride
         endif

      ENDIF
         
      IF ( ( FormatIn .ne. FormatOut ) .and. 
     :     ( FormatIn .ne. 'charisma' ) ) then
 
c Handle variable cross-assignment between formats

         if ( FormatOut .eq. 'usp' ) then
            if ( FormatIn .eq. 'xsd' .or.
     :           FormatIn .eq. 'vxos' .or.
     :           FormatIn .eq. 'xsdheader' ) then
               if ( abs(Xsd_SmpUnit) .gt. 1.e-32 ) then
                  nsi = nint(Xsd_SmpUnit)
               else
                  nsi = 1
               endif

            elseif ( FormatIn .eq. 'tdfn' .or.
     :              FormatIn .eq. 'flat' .or.
     :              FormatIn .eq. 'vds3d' .or.
     :              FormatIn .eq. 'vip' .or.
     :              FormatIn .eq. 'flat3d' .or.
     :              FormatIn .eq. 'flat3d1' .or.
     :              FormatIn .eq. 'ev3d' .or.
     :              FormatIn .eq. 'kelman' .or.
     :              FormatIn .eq. 'disco' .or.
     :              FormatIn .eq. 'disco3d' .or.
     :              FormatIn .eq. 'disco3d1' .or.
     :              FormatIn .eq. 'disco3d3' .or.
     :              FormatIn .eq. 'disco3dxy' .or.
     :              FormatIn .eq. 'geco' .or.
     :              FormatIn .eq. 'agip' .or.
     :              FormatIn .eq. 'omnivel' .or.
     :              FormatIn .eq. 'promax' .or.
     :              FormatIn .eq. 'promax3d' .or.
     :              FormatIn .eq. 'western3d1' .or.
     :              FormatIn .eq. 'ukooa1' .or.
     :              FormatIn .eq. 'ukooa'.or.
     :              FormatIn .eq. 'ukooa2' ) then

               if ( nsi .eq. 0 ) then
                  if ( Usp_SmpIntOverride .eq. 0 ) then
                     nsi = 1
                     write(LERR,*) '  '       
                     write(LERR,*)'VOMIT: sample unit is 1 millisecond.'
                     write(LERR,*)'       Use -nsi on the command line'
                     write(LERR,*)'       to enter sample interval of '
                     write(LERR,*)'       your choice if this is not '
                     write(LERR,*)'       correct'
                     write(LERR,*)'WARNING'       
                     write(LERR,*)'  '       
                     write(LER,*)'  '       
                     write(LER,*)'VOMIT: sample unit is 1 millisecond.'
                     write(LER,*)'       Use -nsi on the command line'
                     write(LER,*)'       to enter sample interval of '
                     write(LER,*)'       your choice if this is not '
                     write(LER,*) '         correct'
                     write(LER,*) ' WARNING'       
                     write(LER,*) '  ' 
                  else
                     nsi = Usp_SmpIntOverride
                  endif
               endif
               
               if ( nsamp .eq. 0 ) then

c if number of samples not defined then check to see if user has specified a max
c time or depth for output.  If he has then use the approriate number of samples
c to allow that output

                  if ( abs(Usp_Depth2Time_MaxTime) .gt. 1.e-30) then
                     nsamp = Usp_Depth2Time_MaxTime / nsi
                  elseif ( Usp_Time2Depth_MaxDepth .gt. 1.e-30 ) then
                     nsamp = Usp_Time2Depth_MaxDepth / nsi
                  else
                     write(LERR,*) '  '       
                     write(LERR,*) ' VOMIT: number of samples to output'
                     write(LERR,*) '         is undefined.  Use -nsamp '
                     write(LERR,*) '         on the command line to '
                     write(LERR,*) '         enter the appropriate '
                     write(LERR,*) '         value and rerun'
                     write(LERR,*) ' FATAL'       
                     write(LERR,*) '  '       
                     write(LER,*) '  '       
                     write(LER,*) ' VOMIT: number of samples to output'
                     write(LER,*) '         is undefined.  Use -nsamp '
                     write(LER,*) '         on the command line to '
                     write(LER,*) '         enter the appropriate '
                     write(LER,*) '         value and rerun'
                     write(LER,*) ' FATAL'       
                     stop
                  endif
               endif

               if ( nrec .eq. 0 ) then
                  nrec = NumFcns
               endif

               if ( ntrc .eq. 0 ) then
                  ntrc = 1
               endif

            endif
         endif

c xsd output policeman to check for trace units and offset which should
c usually be set when working with velspec output as most people start
c their velspec analysis at 1000 or 1500 m/s so that there should be
c a velocity offset.  Also most people don't examine every velocity
c so there should also be a velocity units that is not unity.

         if ( FormatOut .eq. 'xsd' .or. 
     :        FormatOut .eq. 'vxos' .or.
     :        FormatOut .eq. 'xsdheader' ) then

            if ( FormatIn .eq. 'tdfn' .or.
     :           FormatIn .eq. 'flat' .or.
     :           FormatIn .eq. 'usp' .or.
     :           FormatIn .eq. 'disco3d' .or.
     :           FormatIn .eq. 'disco' ) then
               if ( nsi .gt. 0 ) then
                  SmpUnit = float(nsi)
                  Xsd_SmpUnit = SmpUnit
                  SmpOffset = float(0 - nsi)
                  Xsd_SmpOffset = SmpOffset
               elseif ( Usp_SmpIntOverride .gt. 0 ) then
                  SmpUnit = float(Usp_SmpIntOverride)
                  Xsd_SmpUnit = SmpUnit
                  SmpOffset = float(0 - Usp_SmpIntOverride)
                  Xsd_SmpOffset = SmpOffset
               else
                  SmpUnit = 1.0
                  Xsd_SmpUnit = SmpUnit
                  SmpOffset = 0.0 - 1.0
                  Xsd_SmpOffset = SmpOffset
                  
                  write(LERR,*) '  '       
                  write(LERR,*) ' VOMIT: sample unit is 1. If you wish'
                  write(LERR,*) '         to load the output data to '
                  write(LERR,*) '         xsd for overlay on your data '
                  write(LERR,*) '         you willneed to supply the '
                  write(LERR,*) '         correct -nsi or -osi entry on' 
                  write(LERR,*) '         the command line.'
                  write(LERR,*) ' WARNING'       
                  write(LERR,*) '  '       
                  write(LER,*) '  '       
                  write(LER,*) ' VOMIT: sample unit is 1. If you wish'
                  write(LER,*) '         to load the output data to '
                  write(LER,*) '         xsd for overlay on your data '
                  write(LER,*) '         you willneed to supply the '
                  write(LER,*) '         correct -nsi or -osi entry on' 
                  write(LER,*) '         the command line.'
                  write(LER,*) ' WARNING'       
                  write(LER,*) '  '       
               endif

            endif
            
            if ( FormatIn .eq. 'vxos' ) then
               if ( nsi .gt. 0 ) then
                  SmpUnit = float(nsi)
                  Xsd_SmpUnit = SmpUnit
                  SmpOffset = float(0 - nsi)
                  Xsd_SmpOffset = SmpOffset
               else
                  SmpUnit = 1.0
                  Xsd_SmpUnit = SmpUnit
                  SmpOffset = 0.0 - 1.0
                  Xsd_SmpOffset = SmpOffset
               endif                     
            endif
            

            if ( abs(VelOffset) .lt. 1.e-32 .and. 
     :           FormatOut .ne. 'vxos' ) then
               write(LERR,*) '  '       
               write(LERR,*) ' VOMIT: There is no velocity offset'
               write(LERR,*) '         present.  If you wish to load'
               write(LERR,*) '         the output data to xsd for '
               write(LERR,*) '         overlay on your data you will'
               write(LERR,*) '         need to supply a -v0 entry on '
               write(LERR,*) '         the command line.'
               write(LERR,*) ' WARNING'       
               write(LERR,*) '  '       
               write(LER,*) '  '       
               write(LER,*) ' VOMIT: There is no velocity offset'
               write(LER,*) '         present.  If you wish to load'
               write(LER,*) '         the output data to xsd for '
               write(LER,*) '         overlay on your data you will'
               write(LER,*) '         need to supply a -v0 entry on '
               write(LER,*) '         the command line.'
               write(LER,*) ' WARNING'       
               write(LER,*) '  '       
            endif
            if ( abs(VelUnit - 1.0 ) .lt. 1.e-32 .and. 
     :           FormatOut .ne. 'vxos' ) then
               write(LERR,*) '  '       
               write(LERR,*) ' VOMIT: velocity unit multiplier is '
               write(LERR,*) '         unity.  If you wish to load'
               write(LERR,*) '         the output data to xsd for '
               write(LERR,*) '         overlay on your data you will'
               write(LERR,*) '         need to supply a -dv entry on '
               write(LERR,*) '         the command line.'
               write(LERR,*) ' WARNING'       
               write(LERR,*) '  '       
               write(LER,*) '  '       
               write(LER,*) ' VOMIT: velocity unit multiplier is '
               write(LER,*) '         unity.  If you wish to load'
               write(LER,*) '         the output data to xsd for '
               write(LER,*) '         overlay on your data you will'
               write(LER,*) '         need to supply a -dv entry on '
               write(LER,*) '         the command line.'
               write(LER,*) ' WARNING'       
               write(LER,*) '  '       
            endif
         endif

         if ( FormatOut .eq. 'vxos' ) then
            if ( Xsd_VelUnit .lt. 1.e-32) then
               write(LERR,*) '  '       
               write(LERR,*) ' VOMIT: velocity unit multiplier is '
               write(LERR,*) '         undefined.  You need to '
               write(LERR,*) '         supply a -dv entry on '
               write(LERR,*) '         the command line.'
               write(LERR,*) ' FATAL'       
               write(LERR,*) '  '       
               write(LER,*) '  '       
               write(LER,*) ' VOMIT: velocity unit multiplier is '
               write(LER,*) '         undefined.  You need to '
               write(LER,*) '         supply a -dv entry on '
               write(LER,*) '         the command line.'
               write(LER,*) ' FATAL'       
               write(LER,*) '  '   
               stop
            endif
            if ( Xsd_VelOffset .lt. 1.e-32) then
               write(LERR,*) '  '       
               write(LERR,*) ' VOMIT: velocity offset is '
               write(LERR,*) '         undefined.  You need to '
               write(LERR,*) '         supply a -v0 entry on '
               write(LERR,*) '         the command line.'
               write(LERR,*) ' WARNING'       
               write(LERR,*) '  '       
               write(LER,*) '  '       
               write(LER,*) ' VOMIT: velocity offset is '
               write(LER,*) '         undefined.  You need to '
               write(LER,*) '         supply a -v0 entry on '
               write(LER,*) '         the command line.'
               write(LER,*) ' WARNING'       
               write(LER,*) '  '   
            endif
         endif
            
      ENDIF

c determine output format and act appropriately

      IF ( FormatOut .eq. 'xsd' .or. FormatOut .eq. 'vxos' ) then

c write pick file header assuming new XSD format.

         write ( luout, 10) RecUnit, VelUnit, SmpUnit, nrec,
     :        ntrc, nsamp, RecOffset, VelOffset, SmpOffset, 
     :        NumFcns, NumEntries
 10      format('Units ',f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5,
     :  ' Offset ',f12.6,1x,f12.6,1x,f12.6,' Count ',i5,1x,i5)
         return
       
      ELSEIF ( FormatOut .eq. 'xsdheader' ) then

         No_Seg = 'No_Seg'
         Max_Pick = 'Max_Pick'
         UnitRec = 'UnitRec'
         UnitTrc = 'UnitTrc'
         UnitSmp = 'UnitSmp'
         OffsetRec = 'OffsetRec'
         OffsetTrc = 'OffsetTrc'
         OffsetSmp = 'OffsetSmp'
         NumRec = 'NumRec'
         NumTrc = 'NumTrc'
         NumSmp = 'NumSmp'

c write file header
      
         write(luout,'(A6,5x,f17.6)')No_Seg, float(NumFcns)
         write(luout,'(A8,3x,f17.6)')Max_Pick, float(NumEntries)
         write(luout,'(A7,4x,f17.6)')UnitRec, RecUnit
         write(luout,'(A7,4x,f17.6)')UnitTrc, VelUnit
         write(luout,'(A7,4x,f17.6)')UnitSmp, SmpUnit
         write(luout,'(A9,2x,f17.6)')OffsetRec, RecOffset
         write(luout,'(A9,2x,f17.6)')OffsetTrc, VelOffset
         write(luout,'(A9,2x,f17.6)')OffsetSmp,  SmpOffset
         write(luout,'(A6,5x,f17.6)')NumRec, float(nrec)
         write(luout,'(A6,5x,f17.6)')NumTrc, float(ntrc)
         write(luout,'(A6,5x,f17.6)')NumSmp, float(nsamp)
         return

      ELSEIF ( FormatOut .eq. 'usp' ) then

c print the historical line header to the printout file 

         write(LERR,*)' '
         write(LERR,*)' Historical Line Header '
         write(LERR,*)' '

         call hlhprt (itr, lbytes, name, 5, LERR)
 
c update line header for changes on output

         if ( FormatIn .eq. 'xsd' .or. 
     :        FormatIn .eq. 'xsdheader' .or. 
     :        FormatIn .eq. 'vxos' .or. 
     :        ntrc .eq. 0 ) ntrc = 1

         if ( nsampo .gt. 0 ) then
            call savew ( itr, 'NumSmp',  nsampo, LINHED )
         else
            call savew ( itr, 'NumSmp',  nsamp, LINHED )
         endif
         call savew ( itr, 'Dx1000',  MBSdx, LINHED )
         call savew ( itr, 'Dy1000',  MBSdy, LINHED )
         call savew ( itr, 'Dz1000',  MBSdz, LINHED )

c if we are using depth output then the units flag should be
c unity as we will be using either feet or meters, if kilofeet or 
c something stupid like this is used then all bets are off.
         
         if ( sout .eq. 'T' ) then
            call savew ( itr, 'UnitSc',  UnitSc_out, LINHED )
         else
            call savew ( itr, 'UnitSc', 1.0, LINHED )
         endif

         if ( Usp_SmpIntOverride .ne. 0 ) then
            call savew ( itr, 'SmpInt', Usp_SmpIntOverride   , LINHED )
         else            
            call savew ( itr, 'SmpInt', nsi   , LINHED )
         endif

         call savew ( itr, 'NumTrc', ntrc  , LINHED )
         call savew ( itr, 'NumRec', nrec  , LINHED )
         call savew ( itr, 'Format', 3  , LINHED )

c if omnivel, load line header info
         if (FormatIn .eq. 'omnivel' ) then
            call savew (itr,'OACLin',OACLin,LINHED)
            call savew (itr,'LinNam',LinNam,LINHED)
            call savew (itr,'JobNum',JobNum,LINHED)
            call savew (itr,'DatTyp',DatTyp,LINHED)
            call savew (itr,'PrcNam',PrcNam,LINHED)
            call savew (itr,'APIWNo',APIWNo,LINHED)
            call savew (itr,'CDPFld',CDPFLD,LINHED)
            call savew (itr,'PrcDat',PrcDat,LINHED)
            call savew (itr,'WatVel',WatVel,LINHED)
cmam convert vout code to int and put into VelTyp
            if (vout.eq.'R') then
               VelTyp = 0
            elseif (vout.eq.'A') then
               VelTyp = 1
            elseif (vout.eq.'I') then
               VelTyp = 2
            else
               VelTyp = 3
            endif
            call savew (itr,'VelTyp',VelTyp,LINHED)
         endif


c move hlh into output line header 
 
         call savhlh ( itr, lbytes, lbyout )

c write usp line header

         call wrtape ( luout, itr, lbyout )
         return
        
      ELSEIF ( FormatOut .eq. 'vds3d' ) then

c write 1MC3D card

         write ( luout, 21 ) Vds_StaticsMode,  
     :        Vds_JobConstantStatic, Vds_MutePercent, Vds_WaterBottom, 
     :        Vds_MinLI, Vds_MaxLI, Vds_MinDI, Vds_MaxDI, Vds_LIinc, 
     :        Vds_DIinc, Vds_InterpRadius, Vds_VelPrtInc,
     :        Vds_PrtWgtFlag, nint(Vds_BinsizeLI), nint(Vds_BinsizeDI), 
     :        Vds_NumScheme, Vds_DipAzimFlag, Vds_OacLine, 
     :        Vds_VelPrtInc
 21      format('1MC3D',i1,i5,i3,i1,8i5,i1,2i5,2i1,a7,i5)

      ELSEIF ( FormatOut .eq. 'ukooa' .or. FormatOut .eq. 'ukooa1') then
         
         if ( FormatIn .eq. 'ukooa' .or. FormatIn .eq. 'ukooa1') then

c do a straight copy of the head lines

            rewind(luin)
            do i = 1, 4
               read( luin, '(a80)' ) ukooa_card
               write( luout, '(a80)' ) ukooa_card
            enddo
         else
            write ( luout, '(///,a80)' ) ukooa_card
         endif
         
      ELSEIF ( FormatOut .eq. 'tdq' .or. FormatOut .eq. 'tdq2') then

c determine outout velocity flag for Landmark, possibilities are:
c
c  TVave =time, average vel 
c  TVint =time, interval velocity
c  TVrms =time, rms vel
c  TD    =time, depth
c  DVave =Depth, average vel 
c  DVint =Depth, interval velocity
c  DVrms =Depth, rms vel
c  DT    =Depth, two-way time
c 

         if ( sout .eq. 'T' ) then
            if (vout .eq. 'A' ) tdq_c_vout = 'TVave'
            if (vout .eq. 'I' ) tdq_c_vout = 'TVint'
            if (vout .eq.'R' ) tdq_c_vout = 'TVrms'
         elseif ( sout .eq. 'D' ) then
            if (vout .eq. 'A' ) tdq_c_vout = 'DVave'
            if (vout .eq. 'I' ) tdq_c_vout = 'DVint'
            if (vout .eq. 'R' ) tdq_c_vout = 'DVrms'
         endif
         if ( time_depth_curve ) tdq_c_vout = 'TD'
         if ( depth_time_curve ) tdq_c_vout = 'DT'
      
         tdq_c_ftype = '# FUNCTION_TYPE = '
         tdq_c_lunits = '# LINEAR_UNITS = '
         tdq_c_datum = '# DATUM = '
         tdq_c_separator = '#-------------------------------------------
     :--'

c write Landmark TDQ output header

         write( luout, '(a18,a5)' ) tdq_c_ftype, tdq_c_vout
         write( luout, '(a17,a6)' ) tdq_c_lunits, tdq_c_units
         write( luout, '(a10,f7.1)' ) tdq_c_datum, tdq_datum
         write( luout, '(a46)' ) tdq_c_separator


      ENDIF
      
      return
      end
