!...|....1....|....2....|....3....|....4....|....5....|....6....|....7....|....8
!*******************************************************************************
!
! Subroutine to resample a Vz trace from an input space to an output space and
! fill regions above and below the depths in the input Vz with user difined
! values.
!
!*******************************************************************************
      subroutine rsamp_vel_trc ( Vel_in,  z0_in, dz_in, nz_in,  zsm_in, 
     :  Vel_out, z0_out,dz_out,nz_out, zlast_out,topfill,botfill, usr_z)

      implicit none

! Arguments

      integer    :: nz_in,nz_out
      real       :: dz_in,dz_out, z0_in,z0_out, zsm_in,zlast_out
      real       :: topfill,botfill, usr_z
      real       :: Vel_in(nz_in),Vel_out(nz_out)

! Local variables

      integer    :: ier,iz,iz1,iz2,iz3,nz_rsamp, iusr_z
      real       :: dz_adjust
      real       :: zmap_in(nz_in), zmap_out(nz_out)
!-------------------------------------------------------------------------------
! Done with declarations
!-------------------------------------------------------------------------------

! Fill the region above Vel_in

      iz1 = int((z0_in-z0_out)/dz_out) + 1
      if ( dz_out*(iz1-1) == (z0_in-z0_out) ) iz1 = iz1-1
      Vel_out(1:iz1) = topfill


! Fill the region below zlast_out

      iz2 = nint((zlast_out-z0_out)/dz_out) + 1
      if ( dz_out*(iz2) == (zlast_out-z0_out) ) iz2 = iz2+1
      Vel_out(iz2:nz_out) = botfill


! Fill the zmap for output (this is trivial)

      zmap_out(1:nz_out) = z0_out + dz_out*(/(iz,iz=0,nz_out-1)/)


! Fill the zmap for input
! (this is more complicated because the Vz is stretched/squeezed down to
!  usr_z, then continues at the normal dz below that)

      dz_adjust = dz_in/(usr_z/(zsm_in-z0_in))
      iusr_z = min( int(usr_z/dz_in)+1 , nz_in )

      zmap_in(1:iusr_z) = z0_in + dz_adjust*(/(iz,iz=0,iusr_z-1)/)
      zmap_in(iusr_z+1:nz_in) = zmap_in(iusr_z) + 
     :  dz_in*(/(iz,iz=1,nz_in-iusr_z)/)


! Resample the input Vz onto the output trace

      ! set limits on iz1 and iz2 to insure linear_rsamp stays within
      ! the array boundaries.
      iz1 = max(0,iz1)
      iz2 = min(nz_out+1,iz2)
      nz_rsamp = iz2 - iz1 - 1
      call linear_rsamp (zmap_in,        Vel_in,        nz_in, 
     : zmap_out(iz1+1),Vel_out(iz1+1),nz_rsamp, ier)
 
! All done

      return
      end subroutine rsamp_vel_trc
