c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
C***********************************************************************
C Copyright 2001, Allied Geophysics, Inc. All Rights Reserved          *
C***********************************************************************
c***********************************************************************
c Fill holes in a map ... or any array with a mask
c***********************************************************************
      subroutine fillmap (in,n1,n2, out, emask,
     :                    rmask_i1,rmask_i2,npt_mask,lmask,
     :                    interp1,interp2,
     :                    datain1,dataout1,xin1,xout1,
     :                    datain2,dataout2,xin2,xout2)

      implicit none

c Arguments
      integer n1,n2, npt_mask
      integer rmask_i1(npt_mask), rmask_i2(npt_mask)
      real    in(n1,n2), out(n1,n2), interp1(n1,n2), interp2(n1,n2)
      real    datain1(n1),dataout1(n1),xin1(n1),xout1(n1)
      real    datain2(n2),dataout2(n2),xin2(n2),xout2(n2)
      real    emask
      logical lmask

c Local variables
      integer i1,i2, ihere, ifirst,ilast, nin,nout, ier
      integer imask,i1_here,i2_here
      logical lfound

c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------

c First, establish the output coordinates for both axes
      do i1=1,n1
        xout1(i1) = i1
      enddo
      do i2=1,n2
        xout2(i2) = i2
      enddo

c Next, loop over axis 2, setting up and interpolating on axis 1
      do i2 = 1,n2

c       initialize output data
        do i1=1,n1
          dataout1(i1) = in(i1,i2)
        enddo

c       fill input data and coord vectors
        ihere = 0
        do i1 = 1,n1
          if(in(i1,i2) .ne. emask) then
            ihere = ihere+1
            datain1(ihere) = in(i1,i2)
            xin1(ihere) = xout1(i1)
          endif
        enddo

        if (ihere.gt.1) then
c         get output data index limits
          ifirst = 0
          i1 = 0
          do while (ifirst.eq.0 .and. i1.lt.n1)
            i1 = i1+1
            if (in(i1,i2).ne.emask) ifirst = i1
          enddo

          ilast = 0
          i1 = n1+1
          do while (ilast.eq.0 .and. i1.gt.1)
            i1 = i1-1
            if (in(i1,i2).ne.emask) ilast = i1
          enddo

          nin = ihere
          nout = ilast-ifirst+1

c         do the interpolation
          call linear_rsamp
     :           (xin1,datain1,nin,
     :            xout1(ifirst),dataout1(ifirst),nout,ier)
        endif

c       copy the result into the interp1 array
        do i1 = ifirst,ilast
          interp1(i1,i2) = dataout1(i1)
        enddo

      enddo

c Do it all again, looping over axis 1, setting up and interpolating on axis 2
      do i1 = 1,n1

c       initialize output data
        do i2=1,n2
          dataout2(i2) = in(i1,i2)
        enddo

c       fill input data and coord vectors
        ihere = 0
        do i2 = 1,n2
          if(in(i1,i2) .ne. emask) then
            ihere = ihere+1
            datain2(ihere) = in(i1,i2)
            xin2(ihere) = xout2(i2)
          endif
        enddo

        if (ihere.gt.1) then
c         get output data index limits
          ifirst = 0
          i2 = 0
          do while (ifirst.eq.0 .and. i2.lt.n2)
            i2 = i2+1
            if (in(i1,i2).ne.emask) ifirst = i2
          enddo

          ilast = 0
          i2 = n2+1
          do while (ilast.eq.0 .and. i2.gt.1)
            i2 = i2-1
            if (in(i1,i2).ne.emask) ilast = i2
          enddo

          nin = ihere
          nout = ilast-ifirst+1

c         do the interpolation
          call linear_rsamp
     :           (xin2,datain2,nin,
     :            xout2(ifirst),dataout2(ifirst),nout,ier)
        endif

c       copy the result into the interp2 array
        do i2 = ifirst,ilast
          interp2(i1,i2) = dataout2(i2)
        enddo

      enddo

c Next, combine interp1() and interp2() to form out()
      do i2=1,n2
        do i1=1,n1
          if(interp1(i1,i2).ne.emask .and. interp2(i1,i2).eq.emask)
     :      out(i1,i2) = interp1(i1,i2)
          if(interp1(i1,i2).eq.emask .and. interp2(i1,i2).ne.emask)
     :      out(i1,i2) = interp2(i1,i2)
          if(interp1(i1,i2).ne.emask .and. interp2(i1,i2).ne.emask)
     :      out(i1,i2) = ( interp1(i1,i2) + interp2(i1,i2) )/2.0
        enddo
      enddo

c Finally, if the distance mask is used, apply it.
      if (lmask) then
        do i2 = 1,n2
          do i1 = 1,n1
            if (in(i1,i2) .eq. emask) then
              lfound = .false.
              imask = 0
              do while (imask.lt.npt_mask .and. .not.lfound)
                imask = imask + 1
                i1_here = min( n1, max(1,i1+rmask_i1(imask)) )
                i2_here = min( n2, max(1,i2+rmask_i2(imask)) )
                if (in(i1_here,i2_here) .ne. emask) lfound = .true.
              enddo
              if (.not.lfound) out(i1,i2) = emask
            endif
          enddo
        enddo
      endif

c All done
      return
      end
