c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
C***********************************************************************
C Copyright 2001, Allied Geophysics, Inc. All Rights Reserved          *
C***********************************************************************
c***********************************************************************
c set the index arrays for i1 and i2 for grid points inside a circle
c***********************************************************************
      subroutine set_mask_pts(d1,d2,radius,npt_mask,rmask_i1,rmask_i2)
      
      implicit none

c Arguments
      integer npt_mask
      integer rmask_i1(npt_mask),rmask_i2(npt_mask)
      real    d1,d2,radius

c Local variables
      integer npt1,npt2, icenter1,icenter2, i1,i2, ipt_here
      real    dist, dist2
      
c Do it
      npt1 = int(radius/d1) + 1
      npt2 = int(radius/d2) + 1
      icenter1 = (npt1-1)/2
      icenter2 = (npt2-1)/2

      ipt_here = 0

      do i2 = 1,npt2
        dist2 = (icenter2-i2)**2
        do i1 = 1,npt1
          dist = sqrt((icenter1-i1)**2 + dist2)
          if (dist .le. radius)then
            ipt_here = ipt_here+1
            rmask_i1(ipt_here) = i1-icenter1
            rmask_i1(ipt_here) = i2-icenter2
          endif
        enddo
      enddo
      
c Done
      return
      end
