c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c**********************************************************************
c This subroutine smooths volumes with an 'izsmth*ixsmth*iysmth' point
c smoother. It looks for an embedded mask value which is NOT used in
c smoothing but is passed to the output.
c**********************************************************************
 
      subroutine Smooth3d(in, out, izsmth, ixsmth, iysmth,
     :                    nz, nx, ny, emask)
 
      integer   izsmth, ixsmth, iysmth, nz, nx, ny
      real      in(nz,nx,ny), out(nz,nx,ny)
      real      emask

      integer   izradius, ixradius, iyradius, idiv
      integer   i, j, k, l, l1, l2, m, m1, m2, n, n1, n2
      real      sum

c  make sure the smoother widths are odd numbers
      if (mod(float(izsmth),2.0) .eq. 0.0) izsmth = izsmth + 1
      if (mod(float(ixsmth),2.0) .eq. 0.0) ixsmth = ixsmth + 1
      if (mod(float(iysmth),2.0) .eq. 0.0) iysmth = iysmth + 1

c  do the smoothing
      izradius = (izsmth-1) / 2
      ixradius = (ixsmth-1) / 2
      iyradius = (iysmth-1) / 2

c   loop over input volume (set range of samples to use in smoothing)

      do k = 1, ny
        n1 = max(1,k-iyradius)
        n2 = min(ny,k+iyradius)

        do j = 1, nx
          m1 = max(1,j-ixradius)
          m2 = min(nx,j+ixradius)

          do i = 1, nz
            l1 = max(1,i-izradius)
            l2 = min(nz,i+izradius)


c   if the input is masked then emask the output
            IF ( in(i,j,k) .eq. emask ) then
              out(i,j,k) = emask
            ELSE

c   otherwise do the work
              sum  = 0.0
              idiv = 0

c   loop over the values inside the smoothing window
              do n = n1,n2
                do m = m1,m2
                  do l = l1,l2

c   only include the value in the summation if it is not masked
                    if (in(l,m,n) .ne. emask) then
                      sum = sum + in(l,m,n)
                      idiv = idiv + 1
                    endif

                  enddo
                enddo
              enddo

c   normalize the output value
              out(i,j,k) = sum / float(idiv)

            ENDIF

          enddo
        enddo
      enddo

      return
      end
