c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c**********************************************************************
c This subroutine smooths volumes with an 'nz*nx*ny' point smoother.
c**********************************************************************
 
      subroutine SmoothNM(in, out, izsmth, ixsmth, iysmth,
     :                    nz, nx, ny)
 
      integer   izsmth, ixsmth, iysmth, nz, nx, ny
      real      in(nz,nx,ny), out(nz,nx,ny)

      integer   izradius, ixradius, iyradius, idiv
      integer   i, j, k, l, l1, l2, m, m1, m2, n, n1, n2
      real      sum

c  make sure the smoother widths are odd numbers
      if (mod(float(izsmth),2.0) .eq. 0.0 ) izsmth = izsmth + 1
      if (mod(float(ixsmth),2.0) .eq. 0.0 ) ixsmth = ixsmth + 1
      if (mod(float(iysmth),2.0) .eq. 0.0 ) iysmth = iysmth + 1

c  do the smoothing
      izradius = (izsmth-1) / 2
      ixradius = (ixsmth-1) / 2
      iyradius = (iysmth-1) / 2

c   loop over input volume (set range of samples to use in smoothing)

      do k = 1, ny
        n1 = max(1,k-iyradius)
        n2 = min(ny,k+iyradius)

        do j = 1, nx
          m1 = max(1,j-ixradius)
          m2 = min(nx,j+ixradius)

          do i = 1, nz
            l1 = max(1,i-izradius)
            l2 = min(nz,i+izradius)

            sum  = 0.0
            idiv = ((n2-n1)+1)*((m2-m1)+1)*((l2-l1)+1)

c   loop over the values inside the smoothing window
c   normalize the output value
            do n = n1,n2
              do m = m1,m2
                do l = l1,l2
                  sum = sum + in(l,m,n)
                enddo
              enddo
            enddo

            out(i,j,k) = sum / float(idiv)

          enddo
        enddo
      enddo

      return
      end
