/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*	paul2.c:	function  qestf() 
   	Author:		Xingkang Li
   	Date:   	July 1, 1997
*/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <localsys.h>

#ifdef CRAY
#define qestf_ QESTF
#endif
#ifdef hpux
#define qestf_ qestf
#endif

#ifndef M_PI
   #define M_PI 3.14159265358979323846 
#endif


/* 	qestf: estimate the slope of short time Fourier transform 
 *	(	winLength: 	the width of the data selecting window; 
 *		freqNum:	the number of discrete frequency samples; 
 *		fitDataNum:	the number of the frequency samples used 
 *				for slope estimation;
 *		dataLength:	the length of the whole data; 
 *		data:		1-d data array;
 *		output:		1-d array of the estimate of the slope.  
 *		peakf:		1-d array of the integer peak frequency 
 *              peaka:          1-d array of the peak amplitude;
 *	)			 
 */ 
 
int qestf_(int *winLength, int *freqNum, int *fitDataNum, int *dataLength, 
		double *dt, int *nfs, double *data, double *output, double *peakf,
		double *peaka, double *xReal, double *xImag, double *xAbs, double *x1, double *cut , double *df)
{
  int linearInt(int, int, double *);
  double peakFit(int, double *);
  int adaptDFT(int, int, int, double, double, double *,double *, double *);
  
  double samplingPeriod = *dt;
  double sscale = *df;


  int i, j, k, n;
  int freqMax;
  double fac;
  double arg;
  double maxValue;
  double ave;
  double last_slope;
  double last_peakf;
  int N = *nfs;
  int NF;

/*  I am commenting this next part out and allocating memory in
    the main as we are getting a segmentation fault here and I
    cannot see why...pgag

  double *xReal, *xImag, *xAbs, *x1;

  xReal= malloc((N+1)*sizeof(double));
  xImag= malloc((N+1)*sizeof(double));
  xAbs= malloc((N+1)*sizeof(double));
  x1= malloc((N+1)*sizeof(double));

  */

   
/*
  fac = sscale*N*samplingPeriod;
*/

  fac = 1./(*df);

  /* Calculate the initial DFT */
  for (k=0;k<=N;k++)
  {   
      xReal[k]=0.0;
      xImag[k]=0.0;
      for (n=0;n<*winLength;n++)
      {   
          arg = 2.0*M_PI*((double) k)*((double) n)/ *freqNum;
          xReal[k]+=data[n]*cos ( arg);
          xImag[k]-=data[n]*sin ( arg);
      }
      xAbs[k]= xReal[k]*xReal[k]+ xImag[k]*xImag[k];
  }

  /* Find the value and the location of the maximum */

  for (i=0; i<=*dataLength-*winLength;i++) {       
      maxValue=0.0;
      freqMax=0;
      for (j=0;j<N;j++)
      {   if (maxValue <= xAbs[j])
          {  maxValue=xAbs[j];
             freqMax=j;
	     peakf[i] = freqMax;
             peaka[i] = sqrt (maxValue);
          }
      }

/* if ( i%100 == 0 ) {
 for (j=1;j<=N;j++) fprintf(stderr,"%d  %f\n",j,xAbs[j]);
 fprintf(stderr,"\n");
 } */
      
      /* Find the logarithm of the normalized DFT */
      for (j=freqMax;j<=N;j++) {
          x1[j-freqMax]=10.*log10(xAbs[j]/maxValue/N); 
      }
          
/*      linearInt(1, N-freqMax+1, x1); */
      NF = *cut * (N-freqMax+1);
      output[i] = peakFit(NF,x1) * fac;
      adaptDFT(*winLength, *freqNum, N, data[i], data[i+ *winLength],
                xReal, xImag, xAbs); 
  }

  last_peakf = peakf[*dataLength-*winLength];
  last_slope = output[*dataLength-*winLength];

  for (i=*dataLength-*winLength+1; i<*dataLength;i++) {
      output [i] = last_slope;
      peakf  [i] = last_peakf;
      peaka  [i] = 0.0;
  }
  
}

/* 	adaptDFT: 	calculate DFT adaptively 
 *	(	winLength: 	the width of the data selecting window; 
 *		freqNum:	the number of discrete frequency samples; 
 *		N:      	freqNum/2 - 1;
 *		firstSample:	first sample in the previous windowed data; 
 *		newSample:	new sample in the current windowed data; 
 *		xReal:		real value of the DFT;
 *		xImag:		imaginary value of the DFT; 
 *		xAbs:		absolute value of the DFT.
 *	)			 
 */ 
 
int adaptDFT(int winLength, int freqNum, int N, double firstSample, 
    double newSample, double *xReal, double *xImag, double *xAbs) {
  int k;
  double r, fN, temp1, temp2, arg, arg1, arg2;
  
  fN=freqNum;
  r=(winLength-1)/fN;
  
  for (k=0;k<=N;k++) {
      arg = 2.0*M_PI*((double) k);
      arg1 = arg / fN;
      arg2 = arg * r;
      temp1=( xReal[k]-firstSample )*cos(arg1)
                -xImag[k]*sin(arg1)
                +newSample*cos(arg2);
      temp2=( xReal[k]-firstSample )*sin(arg1)
                +xImag[k]*cos(arg1)
                -newSample*sin(arg2);

      xReal[k]=temp1;
      xImag[k]=temp2;          

      xAbs[k]= temp1 * temp1 + temp2 * temp2;
      xAbs[k]/= N;
  }
}
