C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE getq(IRI, JR, TT, Q, NC, nsamp, dt, flag, qi,scalv,
     1                ipass, nsets, luq, qtape, nsampq, ITHWP1, itr,
     2                ifmt_TrcNum,l_TrcNum,ln_TrcNum, nsi, nsiq,
     3                ifmt_VPick1,l_VPick1,ln_VPick1, rsamp, ist,
     4                ifmt_RecNum,l_RecNum,ln_RecNum,verbos,rmute,
     5                ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_LinInd,
     6                l_LinInd, ln_LinInd,
     5                tabl1, tabl2, work, qnull, scale,qmin, constq)
C *********************************************************************** C
C *   Subroutine to find the velocity function closest to the          
C *   current cdp and compute the coefficients.  If the coefficients    
C *   are "current", it simply returns the coefficients                 
C *                                                                    
C *   INPUT:                                                          
C *                                                                  
C *     IRI    - I*4   -  Current RI #                              
C *      JR    - I*4() -  Vector of RI #'s for Q functions      
C *      TT    - R*4() -  Matrix of times for Q vector      
C *       C    - R*4() -  Matrix of Q's                    
C *      NC    - I*4() -  Vector of #pts in each Q functio
C *   nsamp    - I*$   -  Trace length for Q expansion/in
C *     dt     - R*4   -  Sample interval in sec.       
C *   flag     - I*4   -  Q-type:                  
C *                       0 = average (simply expand the fu
C *                       1 = instantaneous (integrate)
C *                          
C *   OUTPUT :                                                    
C *                                                              
C *      QI    - R*4() -  Q vector                              
C *   SCALV    - R*4() -  Scaling vector for QI                
C *                                                           
C *********************************************************************** C
#include <f77/iounit.h>
      DIMENSION TT(64,*), Q(64,*), qi(*)
      DIMENSION WT(65), WV(65),W1(3000), W2(3000)
      REAL      tabl1 (nsamp), tabl2 (nsamp)
      REAL      work (nsamp), scalv(*)
      INTEGER   JR(*), NC(*)
      integer   itr(*)
      integer   ifmt_TrcNum,l_TrcNum, ln_TrcNum
      integer   ifmt_RecNum,l_RecNum, ln_RecNum
      integer   ifmt_VPick1,l_VPick1, ln_VPick1
      integer   nsets, ipass, flag
      logical   qtape, verbos, rmute, rsamp, constq

c     SAVE ipass, nsets

c     tmax = (nsamp-1)*dt*1000
      tmax = (nsamp)*dt*1000
      itmax = tmax
      tmax = itmax

c----
c   if we are reading a Q-tape data set we simply make sure it's
c   as long as our input data
c   also guard against mute zones: make zero Q = qnull (def = 500)
c----
      IF ( qtape ) THEN

         call rtape (luq, itr, nbytes)
         if (nbytes .ne. 0) then
             call vsmul (itr(ITHWP1), 1, scale, qi, 1, nsampq)

             if (rsamp) then

                do  ii = 1, nsampq
                    if (qi(ii) .eq. 0.) qi (ii) = qnull
                enddo

                call Linterp (qi, nsampq, work, nsamp, tabl1, tabl2)
                call vmov (work, 1, qi, 1, nsamp)

             else

                if (nsampq .lt. nsamp) then
                    do  i = nsampq+1, nsamp
                        qi (i) = qi (nsampq)
                    enddo
                endif

             endif

             if ( rmute ) then
               call saver2(itr,ifmt_VPick1,l_VPick1, ln_VPick1,
     1                     mute_start, 1)
cxia               mute_start = mute_start / nsi
c place the mute 50 ms from the start of the mute
               mute_start = (mute_start + 50) / nsi
               call resmut (qi, mute_start, nsamp)
             endif
             if (verbos) then
               call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                     itrc, 1)
               call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irec, 1)
               call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                     idi , 1)
               call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                     ili , 1)
               write(LERR,*)'read Q trace rec= ',irec,' trc= ',itrc,
     1         '  LI/DI ',ili,idi
             endif
             do  i = 1, nsamp
                 amp = qi (i)
                 if (amp .eq. 0.0) then
                     qi (i) = qnull
                 endif
                 amp = qi (i)
                 if (amp .lt. qmin) qi (i) = qmin
             enddo

             if (ist .gt. 1) then
                 do  i = 1, ist
                     qi (i) = qnull
                 enddo
             endif
c**************************************************************************
C* convert to harmonic average if the input Q has not been averaged already
C* - Ganyuan Xia 10/11/00
	     if (flag .eq. 1) then
		call RUNAVG_HM(qi,work,nsamp)
	     do i=1, nsamp
		qi(i) = work(i)
	     enddo
             do  i = 1, nsamp
                 amp = qi (i)
                 if (amp .eq. 0.0) then
                     qi (i) = qnull
                 endif
                 if (amp .lt. qmin) qi (i) = qmin
             enddo
	     endif
c*************************************************************************
             call scalqv (qi, scalv, nsamp, dt)

         else

             return

         endif
c----
c   otherwise we have to read the appropriate Q function from the
c   card file and expand it
c----
      ELSE

      lclr = 500
      do i=1,lclr
       w1(i)=0.
       w2(i)=0.
      end do
      if(ipass.eq.0)then
        nsets = 0
        do 200 I=1,70
        if(nc(i).ne.0.and.jr(i).ne.0)  nsets = nsets + 1
  200   continue
        ipass = 1
      endif
      do i=1,65
       wt(i)=0.
       wv(i)=0.
      end do

      IF(nsets.gt.1)then

         DO 210 I = 2, nsets

             IF (iri .ge. jr(i-1) .AND. iri .le. jr(i)) THEN
                 k = i
                 k1 = i-1

                 if(flag.eq.0)then
                    call bqtr(tt(1,k),q(1,k),nc(k),nsamp,dt,w2)
                    call bqtr(tt(1,k1),q(1,k1),nc(k1),nsamp,dt,w1)
                 else
                    call runavg(tt(1,k),q(1,k),w2,nsamp,dt)
                    call runavg(tt(1,k1),q(1,k1),w1,nsamp,dt)
                 endif

                 if (jr(k) .ne. jr(k1)) then
                     slope = float((iri-jr(k1))) /
     1                       float(jr(k)-jr(k1))
                 else
                     slope = 0.
                 endif

                 do 100 L = 1,nsamp
                    qi(L)= w1(L) + (w2(L)-w1(L))*slope
  100            continue
             do  j = 1, nsamp
                 amp = qi (j)
                 if (amp .eq. 0.0) then
                     qi (j) = qnull
                 endif
                 if (amp .lt. qmin) qi (j) = qmin
             enddo

                 call scalqv(qi,scalv,nsamp,dt)
                 return

             ELSEIF (iri .lt. jr(i-1)) THEN
	write(0,*) "execute"

                 if(flag.eq.0)then
                    call bqtr(tt(1,1),q(1,1),nc(1),nsamp,dt,w1)
                 else
                    call runavg(tt(1,1),q(1,1),w1,nsamp,dt)
                 endif
 
                 do 300 L = 1,nsamp
                    qi(L)= w1(L)
  300            continue
             do  j = 1, nsamp
                 amp = qi (j)
                 if (amp .eq. 0.0) then
                     qi (j) = qnull
                 endif
                 if (amp .lt. qmin) qi (j) = qmin
             enddo

                 call scalqv(qi,scalv,nsamp,dt)
                 return


             ENDIF

  210 CONTINUE

      ELSE
               if(flag.eq.0)then
                   call bqtr(tt(1,1),q(1,1),nc(1),nsamp,dt,qi)
               else
                   call runavg(tt(1,1),q(1,1),qi,nsamp,dt)
               endif
             do  j = 1, nsamp
                 amp = qi (j)
                 if (amp .eq. 0.0) then
                     qi (j) = qnull
                 endif
                 if (amp .lt. qmin) qi (j) = qmin
             enddo

               if (.not.constq) call scalqv(qi,scalv,nsamp,dt)
               return

      ENDIF

      ENDIF
c----

      END
      SUBROUTINE bqtr(TIME,VEL,NVEL,NS,SR,V)
C ******************************************************************** C
C *                                                                  * C
C * Subroutine to create a trace-length expansion of a velocity      * C
C * function.  Inputs are:                                           * C
C *                                                                  * C
C *  TIME - R*4() - Vector of function times, in sec.                * C
C *  VEL  - R*4() - Vector of function velocities                    * C
C *  NVEL - I*4   - Number points in this velocity function          * C
C *  NS   - I*4   - Number of samples in the trace                   * C
C *  SR   - R*4   - Sample interval in seconds                       * C
C *                                                                  * C
C *  Output is                                                       * C
C *  V    - R*4() - Output velocity trace                            * C
C *                                                                  * C
C ******************************************************************** C
      DIMENSION TIME(*),VEL(*),V(*)
      real      sr
      integer   NS, NVEL
      xsr = sr*1000
      do 200 i=2,nvel
        il1 = time(i-1)/xsr + 1.5
        il2 = time(i)/xsr + 1.5
        if(i.eq.2.and.il1.gt.1)then
          do 50 j=1,il1
   50      v(j)= vel(1)
        endif
        dvel = vel(i)-vel(i-1)
        slope = dvel/float(il2-il1)
        xk = 0.
        il21=il2-1
        do 100 j=il1,il21
          v(j)= xk * slope + vel(i-1)
          xk = xk + 1.
  100   continue
        if(i.eq.nvel.and.il2.lt.ns)then
          do 150 j=il2,ns
  150      v(j)=vel(i)
        endif
  200 continue
c        do  700 ii = 1, ns
c           print*,'ii= ',ii,v(ii)
c700     continue
      RETURN
      END
