      subroutine rshift(u,nt,ntnew,sv,omega,expphi) 

      implicit none

c declare variables passed from calling routine

      integer nt, ntnew

      real sv
      real u(ntnew)
      real omega(ntnew/2 + 1)

      complex expphi(ntnew/2 + 1)  

c declare local variables

      integer mute, k, isv, ii, i, iomega, nzero, m

      real dsv, arg

C_______________________________________________________________________
C     DETERMINE FRONT END MUTE
C_______________________________________________________________________
      MUTE=0
      do k=1,nt
         if(u(k) .eq. 0.) then
            mute=mute+1
         else
            go to 10001
         endif
      enddo
10001 continue

C_______________________________________________________________________
C     determine if shift is a whole sample. If so things are
c     a whole lot simpler - and faster
C_______________________________________________________________________
      isv = int (sv)
      dsv = float(isv) - sv

      if (dsv .eq. 0.0) then
         if (isv .lt. 0) then

            ii = 0
            do  i = iabs(isv)+1, nt
               ii = ii + 1
               u (ii) = u (i)
            enddo

         elseif (isv .gt. 0) then

            do  i = nt, 1, -1
               u (i+isv) = u (i)
            enddo
            do  i = 1, isv
               u (i) = 0.0
            enddo

         endif

c FFT phase shift not required,restore mute then go get next trace

         go to 29999

      endif

C-----------------------------------------------------------------------
C     calculate phase shift operator in frequency domain.
c     this will vectorize on the cray.
C-----------------------------------------------------------------------

      do iomega = 1,ntnew/2+1
         arg = -omega(iomega) * sv
         expphi(iomega) = cmplx(cos(arg),sin(arg))
      enddo

C-----------------------------------------------------------------------
C     pad end of trace with zeros.           
C-----------------------------------------------------------------------

      NZERO=NTNEW-NT
      CALL VCLR(U(NT+1),1,NZERO)

C-----------------------------------------------------------------------
C     TAKE FORWARD FFT FROM T TO OMEGA
C     A REAL TO COMPLEX FFT (IN PLACE) then unpack to ntnew/2 + 1 estimates
c     prior to complex phase shift mulitplication
C-----------------------------------------------------------------------

      CALL RFFT(U(1),NTNEW,1)
      CALL RFFTSC(U(1),NTNEW,3,1)

C-----------------------------------------------------------------------
C     perform phase shift in the frequency domain.
C-----------------------------------------------------------------------

      call cvmul(u,2,expphi,2,u,2,ntnew/2+1,1)

C-----------------------------------------------------------------------
c     repack [without scaling] to rfft packed format
C     TAKE INVERSE FFT FROM OMEGA TO T
C     A COMPLEX TO REAL FFT (IN PLACE)
C-----------------------------------------------------------------------

      CALL RFFTSC(U(1),NTNEW,-3,0)
      call rfft(u(1),ntnew,-1)

C-----------------------------------------------------------------------
C     apply front end mute to kill positive wrap around.
C-----------------------------------------------------------------------

29999 continue

      m=nint(sv)
      do k=1,mute+m
         u(k)=0.       
      enddo

C-----------------------------------------------------------------------
C     apply back end mute to kill negative wrap around.
c     only need to apply to OUTPUT end of trace at nt, vs ntnew.
C-----------------------------------------------------------------------

      do k=nt+1+m,nt 
         u(k)=0.  
      enddo
c
      RETURN
      END
