c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
C***********************************************************************
C  Copyright 2002, Allied Geophysics, Inc.   All Rights Reserved       *
C***********************************************************************
c***********************************************************************
c Collection of subroutines for unary operations between arrays that
c have embedded masks
c***********************************************************************

c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c add live samples of 2 traces together
c***********************************************************************
      subroutine sum_fxn(in,out,n1,scalar,bias,lmask,emask,ifile)

      implicit none

c Arguments
      integer n1,ifile
      real    in(n1), out(n1), scalar, bias, emask
      logical lmask

c Local variables
      integer i1
c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------
c catch the setup condition
      if (ifile.eq.1) then
        call scale_trc(out,n1,scalar,bias,lmask,emask)
        return
      endif

c scale the input trace
      call scale_trc(in,n1,scalar,bias,lmask,emask)

c add traces together
      if (lmask) then
        do i1 = 1,n1
          if(in(i1).ne.emask .and. out(i1).ne.emask)
     :      out(i1) = out(i1) + in(i1)
        enddo
      else
        do i1 = 1,n1
          out(i1) = out(i1) + in(i1)
        enddo
      endif

c All done
      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c multiply 2 traces together
c***********************************************************************
      subroutine mult_fxn(in,out,n1,scalar,bias,lmask,emask,ifile)

      implicit none

c Arguments
      integer n1,ifile
      real    in(n1), out(n1), scalar, bias, emask
      logical lmask

c Local variables
      integer i1
c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------
c catch the setup condition
      if (ifile.eq.1) then
        call scale_trc(out,n1,scalar,bias,lmask,emask)
        return
      endif

c scale the input trace
      call scale_trc(in,n1,scalar,bias,lmask,emask)

c multiply traces together
      if (lmask) then
        do i1 = 1,n1
          if(in(i1).ne.emask .and. out(i1).ne.emask)
     :      out(i1) = out(i1) * in(i1)
        enddo
      else
        do i1 = 1,n1
          out(i1) = out(i1) * in(i1)
        enddo
      endif

c All done
      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c divide the output by the input
c***********************************************************************
      subroutine div_fxn(in,out,n1,scalar,bias,lmask,emask,ifile)

      implicit none

c Arguments
      integer n1,ifile
      real    in(n1), out(n1), scalar, bias, emask
      logical lmask

c Local variables
      integer i1
c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------
c catch the setup condition
      if (ifile.eq.1) then
        call scale_trc(out,n1,scalar,bias,lmask,emask)
        return
      endif

c scale the input trace
      call scale_trc(in,n1,scalar,bias,lmask,emask)

c divide in into out
      if (lmask) then
        do i1 = 1,n1
          if(in(i1).ne.emask .and. out(i1).ne.emask)
     :      out(i1) = out(i1) / in(i1)
        enddo
      else
        do i1 = 1,n1
          out(i1) = out(i1) / in(i1)
        enddo
      endif

c All done
      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c take the minumum of live values
c***********************************************************************
      subroutine min_fxn(in,out,n1,scalar,bias,lmask,emask,ifile)

      implicit none

c Arguments
      integer n1,ifile
      real    in(n1), out(n1), scalar, bias, emask
      logical lmask

c Local variables
      integer i1
c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------
c catch the setup condition
      if (ifile.eq.1) then
        call scale_trc(out,n1,scalar,bias,lmask,emask)
        return
      endif

c scale the input trace
      call scale_trc(in,n1,scalar,bias,lmask,emask)

c take he minimum of 2 traces
      if (lmask) then
        do i1 = 1,n1
          if(in(i1).ne.emask .and. out(i1).ne.emask)
     :      out(i1) = min(out(i1),in(i1))
        enddo
      else
        do i1 = 1,n1
          out(i1) = min(out(i1),in(i1))
        enddo
      endif

c All done
      return
      end
            


c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c take the maxumum of live values
c***********************************************************************
      subroutine max_fxn(in,out,n1,scalar,bias,lmask,emask,ifile)

      implicit none

c Arguments
      integer n1,ifile
      real    in(n1), out(n1), scalar, bias, emask
      logical lmask

c Local variables
      integer i1
c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------
c catch the setup condition
      if (ifile.eq.1) then
        call scale_trc(out,n1,scalar,bias,lmask,emask)
        return
      endif

c scale the input trace
      call scale_trc(in,n1,scalar,bias,lmask,emask)

c take the maximum of 2 traces
      if (lmask) then
        do i1 = 1,n1
          if(in(i1).ne.emask .and. out(i1).ne.emask)
     :      out(i1) = max(out(i1),in(i1))
        enddo
      else
        do i1 = 1,n1
          out(i1) = max(out(i1),in(i1))
        enddo
      endif

c All done
      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c create the union of live values - discard 2nd if value is already live
c***********************************************************************
      subroutine union_fxn(in,out,n1,scalar,bias,lmask,emask,ifile)

      implicit none

c Arguments
      integer n1,ifile
      real    in(n1), out(n1), scalar, bias, emask
      logical lmask

c Local variables
      integer i1
c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------
c catch the setup condition
      if (ifile.eq.1) then
        call scale_trc(out,n1,scalar,bias,lmask,emask)
        return
      endif

      if (lmask) then

c scale the input trace
        call scale_trc(in,n1,scalar,bias,lmask,emask)

c find the union of 2 traces
        do i1 = 1,n1
          if(out(i1).eq.emask) out(i1) = in(i1)
        enddo

      endif

c All done
      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c Clip the live values in a trace
c***********************************************************************
      subroutine clip_fxn(trc,n1,minval,maxval,scalar,bias,lmask,emask)

      implicit none

c Arguments
      integer n1
      real    trc(n1), minval, maxval, scalar, bias, emask
      logical lmask

c Local variables
      integer i1
c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------
c scale the input trace
      call scale_trc(trc,n1,scalar,bias,lmask,emask)

c clip samples
      if (lmask) then
        do i1 = 1,n1
          if(trc(i1).ne.emask)
     :      trc(i1) = min(max(trc(i1),minval),maxval)
        enddo
      else
        do i1 = 1,n1
          trc(i1) = min(max(trc(i1),minval),maxval)
        enddo
      endif

c All done
      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c Change one specified value with another
c***********************************************************************
      subroutine change_fxn(trc,n1,oldval,newval,scalar,bias,
     :                      lmask,emask)

      implicit none

c Arguments
      integer n1
      real    trc(n1), oldval, newval, scalar, bias, emask
      logical lmask

c Local variables
      integer i1
c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------
c scale the input trace
      call scale_trc(trc,n1,scalar,bias,lmask,emask)

c swap values where appropriate
      do i1 = 1,n1
        if(trc(i1).eq.oldval) trc(i1) = newval
      enddo

c All done
      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c scale and bias a trace in presence of possible no data flag
c***********************************************************************
      subroutine scale_trc(trc,n1,scalar,bias,lmask,emask)

      implicit none

c Arguments
      integer n1
      real    trc(n1),scalar,bias,emask
      logical lmask

c Local variables
      integer i1
c-----------------------------------------------------------------------
c Done with declarations
c-----------------------------------------------------------------------
      if (scalar.eq.1.0 .and. bias.eq.0.0) return

      if (bias.eq.0.0) then
        if (lmask) then
          do i1 = 1,n1
            if (trc(i1).ne.emask) trc(i1)=scalar*trc(i1)
          enddo
        else
          do i1 = 1,n1
            trc(i1)=scalar*trc(i1)
          enddo
        endif
        return
      endif

      if (scalar.eq.1.0) then
        if (lmask) then
          do i1 = 1,n1
            if (trc(i1).ne.emask) trc(i1)=trc(i1)+bias
          enddo
        else
          do i1 = 1,n1
            trc(i1)=trc(i1)+bias
          enddo
        endif
        return
      endif

      if (lmask) then
        do i1 = 1,n1
          if (trc(i1).ne.emask) trc(i1)=scalar*trc(i1)+bias
        enddo
      else
        do i1 = 1,n1
          trc(i1)=scalar*trc(i1)+bias
        enddo
      endif

      return
      end
