c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c  Subroutine stats1 accumulates info for mean and rms value
c  calculation.
c
      subroutine stats1 ( Samples, numsmp, nlive, min_val, max_val,
     :                    cum_val, cum_sqr, emask, default_mask)

      implicit none

      integer   nlive,numsmp, i
      real      Samples(numsmp)
      real      min_val,max_val, emask, default_mask
      real*8    cum_val,cum_sqr

      if ( emask .eq. default_mask ) then
        nlive = nlive + numsmp
        do i=1,numsmp
          min_val = min(Samples(i),min_val)
          max_val = max(Samples(i),max_val)
          cum_val = cum_val + Samples(i)
          cum_sqr = cum_sqr + Samples(i)*Samples(i)
        enddo
      else
        do i=1,numsmp
          if ( Samples(i) .ne. emask ) then
            min_val = min(Samples(i),min_val)
            max_val = max(Samples(i),max_val)
            cum_val = cum_val + Samples(i)
            cum_sqr = cum_sqr + Samples(i)*Samples(i)
            nlive = nlive + 1
          endif
        enddo
      endif

      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c  Subroutine stats2 accumulates info for standard deviation and 
c  variance calculation.
c
      subroutine stats2 (Samples, numsmp, mean_val, cum_std_val,
     :                   emask, default_mask)

      integer   numsmp
      real      Samples(numsmp)
      real      mean_val, emask, default_mask
      real*8    cum_std_val

      if ( emask .eq. default_mask ) then

        do i=1,numsmp
          cum_std_val = cum_std_val + (Samples(i)-mean_val)**2
        enddo

      else

        do i=1,numsmp
          if ( Samples(i) .ne. emask ) then
            cum_std_val = cum_std_val + (Samples(i)-mean_val)**2
          endif
        enddo

      endif

      return
      end



c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c  Subroutine stats3 accumulates info for skewness (gamma) calculation.
c
      subroutine stats3 (Samples, numsmp, mean_val, std_val, cum_gamma,
     :                   emask, default_mask)

      integer   numsmp
      real      Samples(numsmp)
      real      mean_val, std_val, emask, default_mask
      real*8    cum_gamma

      if ( emask .eq. default_mask ) then

        do i=1,numsmp
          cum_gamma = cum_gamma+((Samples(i)-mean_val)/std_val)**3
        enddo

      else

        do i=1,numsmp
          if ( Samples(i) .ne. emask ) then
            cum_gamma = cum_gamma+((Samples(i)-mean_val)/std_val)**3
          endif
        enddo

      endif

      return
      end
