/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  getting the seismic data.
*/

#include "xdisplayP.h"
#include "prototyping.h"
#include "ut_defs.h"

#define TIME_OUT 300000	/* Timeout of 5 minutes. */
/* #define NO_TIME_OUT */

extern String		ServerName;
extern XtAppContext	app_context;
extern Widget		main_form;
extern Widget		open_file_form;

extern int open_file_init;
extern int max_traces;
extern char old_filename[1024];

Widget text_file[5];
Widget dir[4];
XtIntervalId time_out;
int file_rc=(-1);
Boolean dir_flag[4];
Boolean server_flag=False,restart_flag=True;
Boolean disco_flag=False;
float axis_units[3]={1.0,1.0,1.0};         /* Units for axis. */
float axis_offset[3]={0.0,0.0,0.0};        /* Offsets for axis. */
char *header;
char directory[4][1024],colorname[80];

static CB_PROTO( getCB )
static unsigned char *transpose( unsigned char *a, int n, int m );

static Widget reclabel;
static Widget expand_text[2];
static Widget text[24];
static Widget text_server[2];
static Widget toggle_axis=NULL;
static Widget toggle_style=NULL;
static Widget toggle_invert=NULL;
static Widget toggle_flip=NULL;
static Widget toggle_upside=NULL;
static Widget toggle_swap=NULL;
static Widget toggle_trace=NULL;
static Widget toggle_movie=NULL;
static Widget toggle_sort[3];
static Widget toggle_scale[5];
static int sort_mode=0;
static int scale_mode=1;
static long id_previous=0;                         /* Previous window. */
static int s_offset=0;
static Boolean get_data_flag=0;
static float s_scalar=1.0;
static float s_exponent=0.0;
static float hor_zoom=1.0,ver_zoom=1.0;
static Boolean axis_flag=True;
static Boolean style_flag=False;
static Boolean invert_flag=False;
static Boolean trace_flag=True;
static Boolean movie_flag=False;

void Size4dCB(Widget w, long id, XtPointer call_data)
{
   char string[256];
   int n4;
   int s4;

   sscanf(XmTextGetString(expand_text[0]),"%d",&n4);
   sscanf(XmTextGetString(expand_text[1]),"%d",&s4);
 
   if (n4<1) {
     sprintf(string,"4D size must be greater than zero\n");
     error_message(string);
     return;
   }

   if (nrec[id]%n4!=0) {
     sprintf(string,"4D size must be integer divisor of %d\n",nrec[id]);
     error_message(string);
     return;
   }

   if (s4<1 || s4>n4) {
     sprintf(string,"4D start must be > zero and <= %d\n",n4);
     error_message(string);
     return;
   }

   sprintf(string,"Record [1-%d]",nrec[id]/n4);
   XtVaSetValues(reclabel,XmNlabelString,XMstr(string),NULL);
}

/*
  This function displays the parameters
  for starting the data server.
*/
void start_serverCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog_form;
  Widget label;
  Widget button;
  long id;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  dialog_form=XmCreateFormDialogVa(w,"form",
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,XMstr("Server Parameters"),
				   XtNmanageChild,False,
				   NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"server.help"); 

  label = XmCreateLabelVa(dialog_form,"Host Computer", 
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNleftOffset,MAGIC_SPACING,
			  XmNtopAttachment,XmATTACH_FORM,
			  XmNtopOffset,MAGIC_SPACING,
			  NULL);

  text_server[0]=XmCreateTextVa(dialog_form,"text",
				XmNvalue,hostname,
				XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				XmNtopWidget,label,
				XmNtopOffset,-6,
				XmNleftAttachment,XmATTACH_WIDGET,
				XmNleftWidget,label,
				XmNleftOffset,10,
				XmNrightAttachment,XmATTACH_FORM,
				XmNactivateCallback,
				CBlist( show_watchCB, dialog_form,
					serverCB, (XtPointer)id,
					hide_watchCB, dialog_form,
					destroyCB, dialog_form,
					NULL ),
				NULL);

  label = XmCreateLabelVa(dialog_form,"Login",
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,label,
			  XmNtopOffset,MAGIC_SPACING,
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNleftOffset,MAGIC_SPACING,
			  NULL);

  text_server[1]=XmCreateTextVa(dialog_form,"text",
				XmNvalue,username,
				XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				XmNtopWidget,label,
				XmNtopOffset,-6,
				XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
				XmNleftWidget,text_server[0],
				XmNrightAttachment,XmATTACH_FORM,
				XmNactivateCallback,
				CBlist( show_watchCB, dialog_form,
					serverCB, (XtPointer)id,
					hide_watchCB, dialog_form,
					destroyCB, dialog_form,
					NULL ),
				NULL);

  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,text_server[1],
			      XmNtopOffset,10,
			      XmNleftAttachment,XmATTACH_FORM,
			      XmNbottomAttachment,XmATTACH_FORM,
			      NULL);
  XtAddCallback(button,XmNactivateCallback,show_watchCB,xdisplay[id].window);
  XtAddCallback(button,XmNactivateCallback,serverCB,(XtPointer)id);/* RJM: changed to id only */
  XtAddCallback(button,XmNactivateCallback,hide_watchCB,xdisplay[id].window);

  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			      XmNtopWidget,button,
			      XmNrightAttachment,XmATTACH_FORM,
			      XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
			      XmNbottomWidget,button,
			      NULL);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form);

  XtManageChild(dialog_form);
}



/*
  This function starts the data server
  by calling amoco_start_server.
*/
void serverCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id = (long)client_data;
  char *str,machine_type[3],*c;
  char login[80];

				/* Check if a server is already running
				   if so end it so a new one can be started. */
  if (server_flag) {
    amoco_end_server();
    restart_flag=True;
  }

				/* Get hostname from text widget. */
  XtVaGetValues(text_server[0],
		XmNvalue,&str,
		NULL);
  strcpy(hostname,str);
  XtFree(str);

  if( (int)strlen( hostname ) > 1  &&  (c=strchr( hostname, (int)'=' )) )
     strcpy( c, c+1 );	/* RJM: added: handles embedded '=' sign in hostname */

  strcpy(xdisplay[0].hostname,hostname);
  
	
			/* Get login from text widget. */
  XtVaGetValues(text_server[1],
		XmNvalue,&str,
		NULL);
  strcpy(login,str);
  XtFree(str);
				/* Set machine type for xsd_server. */
#ifdef CRAY
  sprintf(machine_type,"1");
#else
  sprintf(machine_type,"0");
#endif  

				/* Check if the remote filer box has
				   been created if so recreate a new
				   one. This is so the remote filer
				   box shows files from the new server. */
  if (open_file_init==1) {
    open_file_init=0;
    if (open_file_form!=NULL) {
      XtDestroyWidget(open_file_form);
      open_file_form=NULL;
    }
  }

#ifndef COMPRESS
  amoco_start_server(hostname,login,ServerName,machine_type);
#else
  amoco_start_server(hostname,login,"cxsd_server2",machine_type);
#endif

				/* This function call set the range 
				   where the data should be scaled. */
  amoco_color_range((int)(start_color&0xffffffff),(int)(end_color&0xffffffff));

				/* Sets timeout callback to check
				   the if the xsd_server is still running. */
#ifndef NO_TIME_OUT
  time_out=XtAppAddTimeOut(app_context,TIME_OUT,check_server,(XtPointer)id);
#endif

				/* server_flag is set to indicate the
				   server is running. */
  server_flag=True;

				/* Restart_flag indicates a new remote
				   filer box needs to be recreated. */
  if (restart_flag)
    fileCB(main_form,(XtPointer)id,call_data);
}



/*
  This function checks the data
  server to see if it is still
  alive.
*/
void check_server(XtPointer id,XtIntervalId *id_tmp)
{
  char buf[1024+1];
  int error;

				/* Sets timeout callback to check
				   the if the xsd_server is still running. */
#ifndef NO_TIME_OUT
  time_out=XtAppAddTimeOut(app_context,TIME_OUT,check_server,id);
#endif

				/* Check if server is still alive. */
  error=amoco_check_server(buf);
  if (error==-1) {
#ifndef NO_TIME_OUT
    XtRemoveTimeOut(time_out);	/* abort error dialog pop-up */
#endif
    error_message(buf);
    error_message("Server error (1). Try restarting server.");
  }
}



/*
  This function send a command to
  the data server to get the line header.
*/
void get_dataCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  String str;
  int n,offset;
  long id;	/* RJM: handle 64-bit architectures */

  id=next_image();

				/* Get new directories. */
  XtVaGetValues(text_file[0],
		XmNvalue,&str,
		NULL);
  strcpy(&directory[0][0],str);
  XtVaGetValues(text_file[1],
		XmNvalue,&str,
		NULL);
  strcpy(&directory[1][0],str);
  XtVaGetValues(text_file[2],
		XmNvalue,&str,
		NULL);
  strcpy(&directory[2][0],str);
  XtVaGetValues(text_file[3],
		XmNvalue,&str,
		NULL);
  strcpy(&directory[3][0],str);

				/* Check the toggles for the 
				   current directory. */
  dir_flag[0]=XmToggleButtonGetState(dir[0]);
  dir_flag[1]=XmToggleButtonGetState(dir[1]);
  dir_flag[2]=XmToggleButtonGetState(dir[2]);
  dir_flag[3]=XmToggleButtonGetState(dir[3]);

				/* Set filename with the current directory.*/
  if (dir_flag[0])
    strcpy(xdisplay[id].filename,&directory[0][0]);
  if (dir_flag[1])
    strcpy(xdisplay[id].filename,&directory[1][0]);
  if (dir_flag[2])
    strcpy(xdisplay[id].filename,&directory[2][0]);
  if (dir_flag[3])
    strcpy(xdisplay[id].filename,&directory[3][0]);

				/* Remove any wildcard filename */
  str = strchr(xdisplay[id].filename,'*');
  if (str) {
    *str = '\0';
    str = strrchr(xdisplay[id].filename,'/');
    if (str) str[1] = '\0';
  }

				/* Check if "/" is at the end of the 
				   directory name. If not add it. */
  if (strcmp(&xdisplay[id].filename[strlen(xdisplay[id].filename)-1],"/")!=0)
    strcat(xdisplay[id].filename,"/");

				/* Get filename from text widget and 
				   append it to the directory name. */
  XtVaGetValues(text_file[4],
		XmNvalue,&str,
		NULL);
  strcpy(buf,str);
  strcat(xdisplay[id].filename,buf);

				/* Store the filename so when the remote
				   filer is displayed again it has the last
				   filename in the selection area. */
  strcpy(old_filename,buf);

  if( strstr( ServerName, "dds" ) )
	if( !autoFormatDetectionWidget
	||  XmToggleButtonGetState( autoFormatDetectionWidget ) )
		amoco_detect_format();
	else
		specifyFormat( w, str );

				/* Check if server is still running. */
  if (amoco_check_server(buf)==-1) {
#ifndef NO_TIME_OUT
    XtRemoveTimeOut(time_out);	/* abort error dialog pop-up */
#endif
    error_message(buf);
    error_message("Server error (2). Try restarting server.");
    xdisplay[id].init=0;
    return;
  }
				/* Get the line header for the seimic file. */
  file_rc=amoco_read_line_header(&header,xdisplay[id].filename);

				/* Check file_rc for error. */
  if (file_rc < 0) {
    reportDSerror( file_rc );
    xdisplay[id].init=0;
    return;
  }
  switch (file_rc) {
  case 1: disco_flag=False; break;
  case 2: disco_flag=True; break;
  }
				/* Get hostname for that file. */
  strcpy(xdisplay[id].hostname,hostname);

				/* Set the number of record, traces, 
				   and samples from the header. */
  if (disco_flag) {
    sscanf(header,"%s",buf);
    sscanf(buf,"%d",&nrec[id]);
    offset=strlen(buf)+1;
    sscanf(&header[offset],"%s",buf);
    sscanf(buf,"%d",&ntrace[id]);
    offset+=strlen(buf)+1;
    sscanf(&header[offset],"%s",buf);
    sscanf(buf,"%d",&nsamp[id]);
    offset+=strlen(buf)+1;

    rec_list[id]=(int *)malloc(nrec[id]*sizeof(int));
    for (n=0; n<nrec[id]; n++) {
      sscanf(&header[offset],"%s",buf);
      sscanf(buf,"%d",(rec_list[id]+n));
      offset+=strlen(buf)+1;
    }
  } else {
    C_SAVER((int*)header,"NumRec",&nrec[id],0);
    C_SAVER((int*)header,"NumTrc",&ntrace[id],0);
    C_SAVER((int*)header,"NumSmp",&nsamp[id],0);
    C_SAVER((int*)header,"NumCmp",&n4[id],0);
    if (n4[id]<1) n4[id]=1;
    if (n4[id]>nrec[id]) n4[id]=1;
    if (nrec[id]%n4[id]!=0) n4[id]=1;
  }

  if (verbose)
    fprintf(stderr,"%d records, %d traces, %d samples\n",nrec[id],ntrace[id],nsamp[id]);

				/* Set the initial values of the 
				   parameter window. */
  s4[id]=1;
  srec[id]=1; erec[id]=1; irec[id]=1;
  strace[id]=1; etrace[id]=ntrace[id]; itrace[id]=1;
  ssamp[id]=1; esamp[id]=nsamp[id]; isamp[id]=1;

				/* Call data to display parameter window. */
  data(main_form,id,True);
  if(header)
    free(header);
  header=NULL;
}


/*
  This function clear the window
  init flag so the window can be
  used again. This function is
  called when the cancel button
  on retrieve data is pressed.
*/
void get_cancelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  get_data_flag=False;

  xdisplay[(long)client_data].init=0;
}


/*
  This function displays the records,
  traces and sample parameters to be
  send to the data server.
*/
void data(Widget w, long id, Boolean flag_old)
         
                      /* flag_old indicates the old setting are to be used */
{
  Widget dialog_form;
  Widget dialog_window;
  Widget form,tform;
  Widget slabel;
  Widget frame,tframe;
  Widget label;
  Widget button;
  Widget row_column;
  Widget error;
  Widget text_disco;
  char *tmp_buf;
  int n;
  char number[80];

  if (file_rc==-1) {
    start_serverCB(w,(XtPointer)id,NULL);
    return;
  }

  if (get_data_flag) {
    xdisplay[id].init=0;
    return;
  }

  get_data_flag=True;

				/* Set the dialog title. */
  if (disco_flag) 
    sprintf(buf,"Server Parameters - File: %s (Disco)",xdisplay[id].filename);
  else
    sprintf(buf,"Server Parameters - File: %s",xdisplay[id].filename);

  dialog_form=XmCreateFormDialogVa(w,"form",
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,XMstr(buf),
				   XtNmanageChild,False,
				   NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"parameter.help"); 

  /*
   * binary data selection
   */
  frame=XmCreateFrameVa(dialog_form,"frame",
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);
			
  form=XmCreateFormVa(frame,"form",NULL);

  /* DWN change to form instead of row column management */

  dialog_window=XmCreateFormVa(form,"form",
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_FORM,
				    XmNtopOffset,10,
				    NULL);

  slabel=XmCreateLabelVa(dialog_window,"Axis   Size ",
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_FORM,
                NULL);

  tform=XmCreateFormVa(dialog_window,"form",
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_WIDGET,
				    XmNtopWidget,slabel,
				    NULL);

  label=XmCreateLabelVa(tform,"4-D   ",
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_FORM,
				    XmNtopOffset,8,
                NULL);

  sprintf(number,"%d",n4[id]);
  expand_text[0]=XmCreateTextVa(tform,"text",
				XmNvalue,number,
				XmNcolumns,8,
				XmNleftAttachment,XmATTACH_WIDGET,
				XmNleftWidget,label,
				XmNtopAttachment,XmATTACH_FORM,
				XmNactivateCallback,
				CBl((XtCallbackProc)Size4dCB,(XtPointer)id),
				NULL);

/* this pops up error whenever you leave the parameter dialog, very bad
   and I don't know how to fix it.
                XmNlosingFocusCallback,CBl((XtCallbackProc)Size4dCB,(XtPointer)id),
*/

  sprintf(number,"%d",s4[id]);
  expand_text[1]=XmCreateTextVa(dialog_window,"text",
				XmNvalue,number,
				XmNcolumns,8,
				XmNleftAttachment,XmATTACH_WIDGET,
				XmNleftWidget,tform,
				XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				XmNtopWidget,tform,
				XmNactivateCallback,
				CBl((XtCallbackProc)Size4dCB,(XtPointer)id),
				NULL);


  sprintf(number,"%d",srec[id]-((s4[id]-1)*nrec[id]/n4[id]));
  text[0]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,number,
			 XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNleftWidget,expand_text[1],
			 XmNtopAttachment,XmATTACH_WIDGET,
			 XmNtopWidget,expand_text[1],
			 NULL);

  sprintf(number,"%d",strace[id]);
  text[1]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,number,
			 XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNleftWidget,expand_text[1],
			 XmNtopAttachment,XmATTACH_WIDGET,
			 XmNtopWidget,text[0],
			 NULL);

  sprintf(number,"%d",ssamp[id]);
  text[2]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,number,
			 XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNleftWidget,expand_text[1],
			 XmNtopAttachment,XmATTACH_WIDGET,
			 XmNtopWidget,text[1],
			 NULL);


  sprintf(number,"Record [1-%d]",nrec[id]/n4[id]);
  reclabel=XmCreateLabelVa(dialog_window,number,
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,text[0],
				    XmNtopOffset,10,
				    XmNrightAttachment,XmATTACH_WIDGET,
				    XmNrightWidget,text[0],
                XmNalignment,XmALIGNMENT_BEGINNING,
                NULL);

  sprintf(number,"Trace  [1-%d]",ntrace[id]);
  label=XmCreateLabelVa(dialog_window,number,
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,text[1],
				    XmNtopOffset,10,
				    XmNrightAttachment,XmATTACH_WIDGET,
				    XmNrightWidget,text[1],
                XmNalignment,XmALIGNMENT_BEGINNING,
                NULL);

  sprintf(number,"Sample [1-%d]",nsamp[id]);
  label=XmCreateLabelVa(dialog_window,number,
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
				    XmNtopWidget,text[2],
				    XmNtopOffset,10,
				    XmNrightAttachment,XmATTACH_WIDGET,
				    XmNrightWidget,text[2],
                XmNalignment,XmALIGNMENT_BEGINNING,
                NULL);


  sprintf(number,"%d",erec[id]-((s4[id]-1)*nrec[id]/n4[id]));
  text[3]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,number,
			 XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[0],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[0],
			 NULL);

  sprintf(number,"%d",etrace[id]);
  text[4]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,number,
			 XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[1],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[1],
			 NULL);

  sprintf(number,"%d",esamp[id]);
  text[5]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,number,
			 XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[2],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[2],
			 NULL);

  sprintf(number,"%d",irec[id]);
  text[6]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,number,
			 XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[3],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[3],
			 NULL);
			 
  sprintf(number,"%d",itrace[id]);
  text[7]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,number,
			 XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[4],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[4],
			 NULL);

  sprintf(number,"%d",isamp[id]);
  text[8]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,number,
			 XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[5],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[5],
			 NULL);


  sprintf(number,"%f",axis_units[0]);
  text[9]=XmCreateTextVa(dialog_window,"text",
	 		 XmNvalue,number,
			 XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[6],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[6],
			 NULL);

  sprintf(number,"%f",axis_units[1]);
  text[10]=XmCreateTextVa(dialog_window,"text",
			  XmNvalue,number,
			  XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[7],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[7],
			  NULL);

  sprintf(number,"%f",axis_units[2]);
  text[11]=XmCreateTextVa(dialog_window,"text",
			  XmNvalue,number,
			  XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[8],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[8],
			  NULL);

  sprintf(number,"%f",axis_offset[0]);
  text[12]=XmCreateTextVa(dialog_window,"text",
			  XmNvalue,number,
			  XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[9],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[9],
			  NULL);

  sprintf(number,"%f",axis_offset[1]);
  text[13]=XmCreateTextVa(dialog_window,"text",
			  XmNvalue,number,
			  XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[10],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[10],
			  NULL);

  sprintf(number,"%f",axis_offset[2]);
  text[14]=XmCreateTextVa(dialog_window,"text",
     		  XmNvalue,number,
			  XmNcolumns,8,
			 XmNleftAttachment,XmATTACH_WIDGET,
			 XmNleftWidget,text[11],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,text[11],
      	  NULL);


  label=XmCreateLabelVa(dialog_window,"Start",
			 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNleftWidget,expand_text[1],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,slabel,
                NULL);

  label=XmCreateLabelVa(dialog_window,"End",
			 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNleftWidget,text[3],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,slabel,
                NULL);

  label=XmCreateLabelVa(dialog_window,"Inc",
			 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNleftWidget,text[6],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,slabel,
                NULL);

  label=XmCreateLabelVa(dialog_window,"Units",
			 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNleftWidget,text[9],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,slabel,
                NULL);

  label=XmCreateLabelVa(dialog_window,"Offset",
			 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNleftWidget,text[12],
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,slabel,
			NULL);

  /*
   * scale type
   */
  frame=XmCreateFrameVa(dialog_form,"frame",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,frame,
			XmNrightAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,50,
			NULL);

  form=XmCreateFormVa(frame,"form",NULL);

  label=XmCreateLabelVa(form,"Scaling Type:",
			   NULL);

  row_column=XmCreateRadioBoxVa(form,"row_column",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,label,
				XmNleftAttachment,XmATTACH_WIDGET,
				XmNleftWidget,label,
				NULL);

  toggle_scale[0]=XmCreateToggleButtonVa(row_column,"Fixed Scaling",NULL);
  toggle_scale[1]=XmCreateToggleButtonVa(row_column,"Maximum Scaling",NULL);
  toggle_scale[2]=XmCreateToggleButtonVa(row_column,"Range Scaling",NULL);
  toggle_scale[3]=XmCreateToggleButtonVa(row_column,"Histogram Scaling",NULL);
  toggle_scale[4]=XmCreateToggleButtonVa(row_column,"MinMax Scaling",NULL);

  XtAddCallback(toggle_scale[0],XmNvalueChangedCallback,set_scale_modeCB,0);
  XtAddCallback(toggle_scale[1],XmNvalueChangedCallback,set_scale_modeCB,0);
  XtAddCallback(toggle_scale[2],XmNvalueChangedCallback,set_scale_modeCB,0);
  XtAddCallback(toggle_scale[3],XmNvalueChangedCallback,set_scale_modeCB,0);
  XtAddCallback(toggle_scale[4],XmNvalueChangedCallback,set_scale_modeCB,0);

  if (flag_old) {
    switch (scale_mode) {
    case 0: XmToggleButtonSetState(toggle_scale[3],True,False); break;
    case 1: XmToggleButtonSetState(toggle_scale[1],True,False); break;
    case 2: XmToggleButtonSetState(toggle_scale[0],True,False); break;
    case 3: XmToggleButtonSetState(toggle_scale[0],True,True);  break;
    case 5: XmToggleButtonSetState(toggle_scale[4],True,False); break;
    }
  } else {
    scale_mode=2;
    XmToggleButtonSetState(toggle_scale[0],True,False);
  }

  /*
   * Sort type
   */
  tframe=XmCreateFrameVa(dialog_form,"frame",
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,frame,
			 XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNbottomWidget,frame,
			 XmNrightAttachment,XmATTACH_WIDGET,
			 XmNrightWidget,frame,
			 XmNleftAttachment,XmATTACH_FORM,
			 NULL);

  form=XmCreateFormVa(tframe,"form",NULL);

  label=XmCreateLabelVa(form,"Retrieval Type:",
			   XmNtopAttachment,XmATTACH_FORM,
			   XmNleftAttachment,XmATTACH_FORM,
			   NULL);

  row_column=XmCreateRadioBoxVa(form,"row_column",
			      XmNleftAttachment,XmATTACH_WIDGET,
			      XmNleftWidget,label,
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,label,
			      NULL);

  toggle_sort[0]=XmCreateToggleButtonVa(row_column,"No Sorting",NULL);
  toggle_sort[1]=XmCreateToggleButtonVa(row_column,"Sort Records",NULL);
  toggle_sort[2]=XmCreateToggleButtonVa(row_column,"Movie",NULL);

  XtAddCallback(toggle_sort[0],XmNvalueChangedCallback,set_sort_modeCB,0);
  XtAddCallback(toggle_sort[1],XmNvalueChangedCallback,set_sort_modeCB,0);
  XtAddCallback(toggle_sort[2],XmNvalueChangedCallback,set_sort_modeCB,0);

  XmToggleButtonSetState(toggle_sort[sort_mode],True,False);
  if (xdisplay[id].sort) {
    XmToggleButtonSetState(toggle_sort[0],False,False);
    XmToggleButtonSetState(toggle_sort[1],True,False);
    XmToggleButtonSetState(toggle_sort[2],False,False);
  } else { 
    if (!flag_old) {
      XmToggleButtonSetState(toggle_sort[0],True,False);
      XmToggleButtonSetState(toggle_sort[1],False,False);
      XmToggleButtonSetState(toggle_sort[2],False,False);
    }
  }
  
  /*
   * scale parameters
   */
  frame=XmCreateFrameVa(dialog_form,"frame",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,frame,
			XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNleftWidget,frame,
			XmNrightAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNrightWidget,frame,
			NULL);
  
  form=XmCreateFormVa(frame,"form",NULL);
  
  if (!flag_old) {
    s_scalar=xdisplay[id].scalar;
    s_offset=xdisplay[id].offset;
  }
  
  label=XmCreateLabelVa(form,"Scalar",
			   XmNtopOffset,10,
			   XmNtopAttachment,XmATTACH_FORM,
			   XmNleftAttachment,XmATTACH_FORM,
			   NULL);
  
  sprintf(number,"%e",s_scalar);
  text[18]=XmCreateTextVa(form,"text",
			  XmNtopAttachment,XmATTACH_FORM,
			  XmNleftAttachment,XmATTACH_WIDGET,
			  XmNleftWidget,label,
			  XmNvalue,number,
			  XmNcolumns,12,
			  NULL);
  
  label=XmCreateLabelVa(form,"Offset %",
			   XmNtopOffset,10,
			   XmNtopAttachment,XmATTACH_FORM,
			   XmNleftAttachment,XmATTACH_WIDGET,
			   XmNleftWidget,text[18],
			   NULL);
  
  sprintf(number,"%d",s_offset);
  text[19]=XmCreateTextVa(form,"text",
			  XmNtopAttachment,XmATTACH_FORM,
			  XmNleftAttachment,XmATTACH_WIDGET,
			  XmNleftWidget,label,
			  XmNvalue,number,
			  XmNcolumns,3,
			  NULL);
  
  label=XmCreateLabelVa(form,"Scale Exponent",
			   XmNtopOffset,15,
			   XmNtopAttachment,XmATTACH_WIDGET,
			   XmNtopWidget,text[19],
			   XmNleftAttachment,XmATTACH_FORM,
			   NULL);
  
  sprintf(number,"%e",s_exponent);
  text[23]=XmCreateTextVa(form,"text",
			  XmNtopOffset,5,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,text[19],
			  XmNleftAttachment,XmATTACH_WIDGET,
			  XmNleftWidget,label,
			  XmNvalue,number,
			  XmNcolumns,12,
			  NULL);
  
  label=XmCreateLabelVa(form,"Range Min",
			   XmNtopOffset,15,
			   XmNtopAttachment,XmATTACH_WIDGET,
			   XmNtopWidget,text[23],
			   XmNleftAttachment,XmATTACH_FORM,
			   NULL);
  
  sprintf(number,"%d",0);
  text[21]=XmCreateTextVa(form,"text",
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,text[23],
			  XmNtopOffset,5,
			  XmNleftAttachment,XmATTACH_WIDGET,
			  XmNleftWidget,label,
			  XmNvalue,number,
			  XmNcolumns,8,
			  NULL);
  
  label=XmCreateLabelVa(form,"Max",
			   XmNtopAttachment,XmATTACH_WIDGET,
			   XmNtopWidget,text[23],
			   XmNtopOffset,15,
			   XmNleftAttachment,XmATTACH_WIDGET,
			   XmNleftWidget,text[21],
			   NULL);
  
  sprintf(number,"%d",0);
  text[22]=XmCreateTextVa(form,"text",
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,text[23],
			  XmNtopOffset,5,
			  XmNleftAttachment,XmATTACH_WIDGET,
			  XmNleftWidget,label,
			  XmNvalue,number,
			  XmNcolumns,8,
			  NULL);

  /*
   * zoom parameters
   */
  tframe=XmCreateFrameVa(dialog_form,"frame",
			 XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNtopWidget,frame,
			 XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNbottomWidget,frame,
			 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNleftWidget,tframe,
			 XmNrightAttachment,XmATTACH_OPPOSITE_WIDGET,
			 XmNrightWidget,tframe,
			 NULL);

  form=XmCreateFormVa(tframe,"form",NULL);

  dialog_window=XmCreateRowColumnVa(form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,2,
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNrightAttachment,XmATTACH_FORM,
				    NULL);

  (void)XmCreateLabelVa(dialog_window,"Horizontal Zoom",NULL);
  (void)XmCreateLabelVa(dialog_window,"Vertical Zoom",NULL);

  sprintf(number,"%f",hor_zoom);
  text[15]=XmCreateTextVa(dialog_window,"text",
			  XmNvalue,number,
			  XmNcolumns,4,
			  NULL);

  sprintf(number,"%f",ver_zoom);
  text[16]=XmCreateTextVa(dialog_window,"text",
			  XmNvalue,number,
			  XmNcolumns,4,
			  NULL);
  
  /*
   * plot parameters
   */
  frame=XmCreateFrameVa(dialog_form,"frame",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,frame,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);
  
  form=XmCreateFormVa(frame,"form",NULL);
  
  toggle_axis=XmCreateToggleButtonVa(form,"Plot Axes",
				     XmNtopAttachment,XmATTACH_FORM,
				     XmNleftAttachment,XmATTACH_FORM,
				     NULL);
  XmToggleButtonSetState(toggle_axis,axis_flag,False);
  
  toggle_invert=XmCreateToggleButtonVa(form,"Invert Data",
				     XmNtopAttachment,XmATTACH_FORM,
				     XmNleftAttachment,XmATTACH_WIDGET,
				     XmNleftWidget,toggle_axis,
				     XmNleftOffset,20,
				     NULL);
  XmToggleButtonSetState(toggle_invert,invert_flag,False);
  
  toggle_flip=XmCreateToggleButtonVa(form,"Plot Reverse",
				     XmNtopAttachment,XmATTACH_WIDGET,
				     XmNtopWidget,toggle_axis,
				     XmNleftAttachment,XmATTACH_FORM,
				     NULL);
  XmToggleButtonSetState(toggle_flip,xdisplay[id].flip_flag,False);
  
  toggle_upside=XmCreateToggleButtonVa(form,"Plot Upside Down",
				       XmNtopAttachment,XmATTACH_WIDGET,
				       XmNtopWidget,toggle_axis,
				       XmNleftAttachment,XmATTACH_WIDGET,
				       XmNleftWidget,toggle_flip,
				       XmNleftOffset,20,
				       NULL);
  XmToggleButtonSetState(toggle_upside,xdisplay[id].upside_flag,False);

  toggle_swap=XmCreateToggleButtonVa(form,"Plot Transposed",
				       XmNtopAttachment,XmATTACH_WIDGET,
				       XmNtopWidget,toggle_axis,
				       XmNleftAttachment,XmATTACH_WIDGET,
				       XmNleftWidget,toggle_upside,
				       XmNleftOffset,20,
				       NULL);
  XmToggleButtonSetState(toggle_swap,xdisplay[id].swap_flag,False);
  
  toggle_trace=XmCreateToggleButtonVa(form,"Retrieve Trace Header",
				      XmNtopAttachment,XmATTACH_WIDGET,
				      XmNtopWidget,toggle_flip,
				      XmNleftAttachment,XmATTACH_FORM,
				      NULL);
  XmToggleButtonSetState(toggle_trace,trace_flag,False);
  
  /* DWN add to support new header annotation */
  toggle_style=XmCreateToggleButtonVa(form,"Axes uses Trace Header",
				     XmNtopAttachment,XmATTACH_WIDGET,
				     XmNtopWidget,toggle_flip,
				     XmNleftAttachment,XmATTACH_WIDGET,
				     XmNleftWidget,toggle_trace,
				     XmNleftOffset,20,
				     NULL);
  XmToggleButtonSetState(toggle_style,style_flag,False);
  
  toggle_movie=XmCreateToggleButtonVa(form,"Hide Movie Windows",
				      XmNtopAttachment,XmATTACH_WIDGET,
				      XmNtopWidget,toggle_trace,
				      XmNleftAttachment,XmATTACH_FORM,
				      NULL);
  XmToggleButtonSetState(toggle_movie,movie_flag,False);
  
  sprintf(buf,"%d",max_traces);
  text[20]=XmCreateTextVa(form,"text",
			  XmNvalue,buf,
			  XmNcolumns,9, 
			  XmNrightAttachment,XmATTACH_FORM,
			  XmNtopAttachment,XmATTACH_FORM,
			  NULL);
  
  sprintf(buf,"Max # of Traces");
  (void)XmCreateLabelVa(form,"label",
			   XmNlabelString,XMstr(buf),
			   XmNrightAttachment,XmATTACH_WIDGET,
			   XmNrightWidget,text[20],
			   XmNtopAttachment,XmATTACH_FORM,
			   XmNtopOffset,5,
			   NULL);
  
  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,frame,
			      XmNtopOffset,5,
			      XmNleftAttachment,XmATTACH_FORM,
			      XmNbottomAttachment,XmATTACH_FORM,
			      NULL);
  
  XtAddCallback(button,XmNactivateCallback,show_watchCB,w);
  XtAddCallback(button,XmNactivateCallback,check_parametersCB,(XtPointer)id); 
  XtAddCallback(button,XmNactivateCallback,hide_watchCB,w);
  
  form=XmCreateFormVa(dialog_form,"form",
		      XmNtopAttachment,XmATTACH_WIDGET,
		      XmNtopWidget,frame,
		      XmNtopOffset,5,
		      XmNbottomAttachment,XmATTACH_FORM, 
		      XmNleftAttachment,XmATTACH_POSITION,
		      XmNleftPosition,40, 
		      NULL);
  
  button=XmCreatePushButtonVa(form,"Previous Settings",
			      XmNtopAttachment,XmATTACH_FORM, 
			      XmNbottomAttachment,XmATTACH_FORM, 
			      XmNleftAttachment,XmATTACH_FORM, 
			      XmNrightAttachment,XmATTACH_FORM, 
			      NULL);
  
  XtAddCallback(button,XmNactivateCallback,previousCB,(XtPointer)id);
  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,frame,
			      XmNtopOffset,5,
			      XmNrightAttachment,XmATTACH_FORM,
			      XmNbottomAttachment,XmATTACH_FORM,
			      NULL);
  
  XtAddCallback(button,XmNactivateCallback,get_cancelCB,(XtPointer)id);
  XtAddCallback(button,XmNactivateCallback,destroyCB,(XtPointer)dialog_form);
  
  XtManageChild(dialog_form);
  
				/* Check min and max of the number
				   receive from the seismic header. */
/*if ((nrec[id]<1)||(nrec[id]>20000)||    RJM: dumb check if dataset is 1trc/rec
      (nsamp[id]<1)||(nsamp[id]>20000)||
      (ntrace[id]<1)||(ntrace[id]>20000)) {
*/
  if( nrec[id] < 1
  ||  nsamp[id] < 1
  ||  ntrace[id] < 1 )
  {
    XBell(display,100);

    error=XmCreateErrorDialogVa(dialog_form,"error",
				XmNmessageString,
				XMstr("This does not look like a valid data file."),
				XmNdialogTitle,XMstr("Error Message"),
				NULL);
    XtAddCallback(error,XmNokCallback,destroyCB,error);
    XtAddCallback(error,XmNcancelCallback,destroyCB,error);

  }

  if (disco_flag) {
    dialog_form=XmCreateFormDialogVa(w,"dataform",
				     XmNmarginHeight,10,
				     XmNmarginWidth,10,
				     XmNdeleteResponse,XmDO_NOTHING,
				     XmNdialogTitle,
				     XMstr("Disco Record Numbers"),
				     XtNmanageChild,False,
				     NULL);
    XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"mail.help");
    
    sprintf(buf,"Comment about xsd for user %s.\n\n",getlogin());
    
    tmp_buf=malloc((nrec[id]+2)*20);
    sprintf(tmp_buf,"Sequence #     Record #\n");
    for (n=0; n<nrec[id]; n++) {
      sprintf(buf,"%6d       %6d\n",n+1,*(rec_list[id]+n));
      strcat(tmp_buf,buf);
    }
    strcat(tmp_buf,"  ");
    text_disco=XmCreateScrolledTextVa(dialog_form,"comment",
				      XmNvalue,tmp_buf,
				      XmNrows,24,
				      XmNcolumns,25,
				      XmNeditMode,XmMULTI_LINE_EDIT,
				      XmNtopAttachment,XmATTACH_FORM,
				      XmNleftAttachment,XmATTACH_FORM,
				      XmNrightAttachment,XmATTACH_FORM,
				      NULL);
    
    button=XmCreatePushButtonVa(dialog_form,"Cancel",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,text_disco,
				XmNtopOffset,10,
				XmNbottomAttachment,XmATTACH_FORM,
				XmNleftAttachment,XmATTACH_FORM,  
				NULL);
    XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form);
    
    XtManageChild(dialog_form);
  }
}


/*
  This function sets the type
  of scaling for the data retrieval.
*/
void set_scale_modeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  if (XmToggleButtonGetState(toggle_scale[0]))
    scale_mode=2;

  if (XmToggleButtonGetState(toggle_scale[1])) {
    scale_mode=1;
    s_scalar=1.0;
    s_offset=0;
    s_exponent=0.0;
    sprintf(buf,"%e",s_scalar);
    XtSetArg(args[0],XmNvalue,buf);
    XtSetValues(text[18],args,1);
    sprintf(buf,"%d",s_offset);
    XtSetArg(args[0],XmNvalue,buf);
    XtSetValues(text[19],args,1);
    sprintf(buf,"%e",s_exponent);
    XtSetArg(args[0],XmNvalue,buf);
    XtSetValues(text[23],args,1);
  }

  if (XmToggleButtonGetState(toggle_scale[2]))
    scale_mode=3;

  if (XmToggleButtonGetState(toggle_scale[3])) {
    scale_mode=0;
    s_scalar=.98;
    s_offset=0;
    s_exponent=0;
    sprintf(buf,"%e",s_scalar);
    XtSetArg(args[0],XmNvalue,buf);
    XtSetValues(text[18],args,1);
    sprintf(buf,"%d",s_offset);
    XtSetArg(args[0],XmNvalue,buf);
    XtSetValues(text[19],args,1);
    sprintf(buf,"%e",s_exponent);
    XtSetArg(args[0],XmNvalue,buf);
    XtSetValues(text[23],args,1);
  }

  if (XmToggleButtonGetState(toggle_scale[4])) {
    scale_mode=5;
    s_scalar=1.0;
    s_offset=0;
    s_exponent=0.0;
    sprintf(buf,"%e",s_scalar);
    XtSetArg(args[0],XmNvalue,buf);
    XtSetValues(text[18],args,1);
    sprintf(buf,"%d",s_offset);
    XtSetArg(args[0],XmNvalue,buf);
    XtSetValues(text[19],args,1);
    sprintf(buf,"%e",s_exponent);
    XtSetArg(args[0],XmNvalue,buf);
    XtSetValues(text[23],args,1);
  }
}


/* 
  This function sets the type 
  of sorting for the data retrieval.
*/
void set_sort_modeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  if (XmToggleButtonGetState(toggle_sort[0]))
    sort_mode=0;

  if (XmToggleButtonGetState(toggle_sort[1]))
    sort_mode=1;

  if (XmToggleButtonGetState(toggle_sort[2]))
    sort_mode=2;
}


/* 
  This function sets the parameters
  back to previous values.
*/
void previousCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id,old_id;	/* RJM: handle 64-bit architectures */
  char number[1024];
  
  id=(long)id_previous;
  old_id=(long)client_data;
  
  if ((id==0)||(xdisplay[id].init!=-1))
    return;
  
  /* Reset the parameters. */

  if (nrec[id]==nrec[old_id]) {
    sprintf(number,"%d",n4[id]);
    XtVaSetValues(expand_text[0],
		  XmNvalue,number,
        NULL);
    sprintf(number,"%d",s4[id]);
    XtVaSetValues(expand_text[1],
		  XmNvalue,number,
        NULL);
    sprintf(number,"Record [1-%d]",nrec[id]/n4[id]);
    XtVaSetValues(reclabel,XmNlabelString,XMstr(number),NULL);

    sprintf(number,"%d",srec[id]-((s4[id]-1)*nrec[id]/n4[id]));
    XtVaSetValues(text[0],
		  XmNvalue,number,
		  NULL);
    sprintf(number,"%d",erec[id]-((s4[id]-1)*nrec[id]/n4[id]));
    XtVaSetValues(text[3],
		  XmNvalue,number,
		  NULL);
  } else {
    /* must be a different dataset since nrecs don't match, so don't monkey
       with the 4D stuff, it won't make sense */
    sprintf(number,"1");
    XtVaSetValues(expand_text[0],
		  XmNvalue,number,
        NULL);
    sprintf(number,"1");
    XtVaSetValues(expand_text[1],
		  XmNvalue,number,
        NULL);
    sprintf(number,"%d",srec[id]);
    XtVaSetValues(text[0],
		  XmNvalue,number,
		  NULL);
    sprintf(number,"%d",erec[id]);
    XtVaSetValues(text[3],
		  XmNvalue,number,
		  NULL);
  }

  sprintf(number,"%d",strace[id]);
  XtVaSetValues(text[1],
		XmNvalue,number,
		NULL);
  sprintf(number,"%d",ssamp[id]);
  XtVaSetValues(text[2],
		XmNvalue,number,
		NULL);
  sprintf(number,"%d",etrace[id]);
  XtVaSetValues(text[4],
		XmNvalue,number,
		NULL);
  sprintf(number,"%d",esamp[id]);
  XtVaSetValues(text[5],
		XmNvalue,number,
		NULL);
  sprintf(number,"%d",irec[id]);
  XtVaSetValues(text[6],
		XmNvalue,number,
		NULL);
  sprintf(number,"%d",itrace[id]);
  XtVaSetValues(text[7],
		XmNvalue,number,
		NULL);
  sprintf(number,"%d",isamp[id]);
  XtVaSetValues(text[8],
		XmNvalue,number,
		NULL);
  
  sprintf(number,"%f",axis_units[0]);
  XtVaSetValues(text[9],
		XmNvalue,number,
		NULL);
  sprintf(number,"%f",axis_units[1]);
  XtVaSetValues(text[10],
		XmNvalue,number,
		NULL);
  sprintf(number,"%f",axis_units[2]);
  XtVaSetValues(text[11],
		XmNvalue,number,
		NULL);
  
  sprintf(number,"%f",axis_offset[0]);
  XtVaSetValues(text[12],
		XmNvalue,number,
		NULL);
  sprintf(number,"%f",axis_offset[1]);
  XtVaSetValues(text[13],
		XmNvalue,number,
		NULL);
  sprintf(number,"%f",axis_offset[2]);
  XtVaSetValues(text[14],
		XmNvalue,number,
		NULL);

  XmToggleButtonSetState(toggle_invert,invert_flag,False);
  XmToggleButtonSetState(toggle_flip,xdisplay[id].flip_flag,False);
  XmToggleButtonSetState(toggle_upside,xdisplay[id].upside_flag,False);
  XmToggleButtonSetState(toggle_swap,xdisplay[id].swap_flag,False);
  XmToggleButtonSetState(toggle_trace,trace_flag,False);
}


/*
  This function checks if the parameters
  are valued for this seismic section.
*/
void check_parametersCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id = (long)client_data;
  char string[1024];
  char *str;
  int width;
  float min,max;
  int n3,s3,e3;
  
  get_data_flag=False;

				/* Flush display so dialog disappears. */
  XmUpdateDisplay(w);

				/* Store window id for previous setting.  */
  id_previous=id;

  xdisplay[id].sort=sort_mode;
  xdisplay[id].middle=1;
  
				/* Get data retrieval prarameters. */

  XtVaGetValues(expand_text[0],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&n4[id]);
  XtFree(str);
  XtVaGetValues(expand_text[1],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&s4[id]);
  XtFree(str);

  XtVaGetValues(text[0],
		XmNvalue,&str,
		NULL);
/*
  sscanf(str,"%d",&srec[id]);
*/
  sscanf(str,"%d",&s3);
  XtFree(str);
  XtVaGetValues(text[1],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&strace[id]);
  XtFree(str);
  XtVaGetValues(text[2],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&ssamp[id]);
  XtFree(str);
  XtVaGetValues(text[3],
		XmNvalue,&str,
		NULL);
/*
  sscanf(str,"%d",&erec[id]);
*/
  sscanf(str,"%d",&e3);
  XtFree(str);
  XtVaGetValues(text[4],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&etrace[id]);
  XtFree(str);
  XtVaGetValues(text[5],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&esamp[id]);
  XtFree(str);
  XtVaGetValues(text[6],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&irec[id]);
  XtFree(str);
  XtVaGetValues(text[7],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&itrace[id]);
  XtFree(str);
  XtVaGetValues(text[8],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&isamp[id]);
  XtFree(str);

  XtVaGetValues(text[9],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%f",&axis_units[0]);
  XtFree(str);
  XtVaGetValues(text[10],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%f",&axis_units[1]);
  XtFree(str);
  XtVaGetValues(text[11],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%f",&axis_units[2]);
  XtFree(str);

  XtVaGetValues(text[12],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%f",&axis_offset[0]);
  XtFree(str);
  XtVaGetValues(text[13],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%f",&axis_offset[1]);
  XtFree(str);
  XtVaGetValues(text[14],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%f",&axis_offset[2]);
  XtFree(str);

  xdisplay[id].axis_units[0]=axis_units[0];
  xdisplay[id].axis_units[1]=axis_units[1];
  xdisplay[id].axis_units[2]=axis_units[2];
  xdisplay[id].axis_offset[0]=axis_offset[0];
  xdisplay[id].axis_offset[1]=axis_offset[1];
  xdisplay[id].axis_offset[2]=axis_offset[2];

  XtVaGetValues(text[15],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%f",&hor_zoom);
  XtFree(str);
  XtVaGetValues(text[16],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%f",&ver_zoom);
  XtFree(str);

  XtVaGetValues(text[18],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%e",&s_scalar);
  XtFree(str);
  XtVaGetValues(text[19],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&s_offset);
  XtFree(str);
  XtVaGetValues(text[23],
		XmNvalue,&str,
		NULL);
  sscanf(str,"%e",&s_exponent);
  XtFree(str);
  
  if (scale_mode==3) {	/* Range Scaling */
    XtVaGetValues(text[21],
		XmNvalue,&str,
		NULL);
    sscanf(str,"%f",&min);
    XtFree(str);
    XtVaGetValues(text[22],
		XmNvalue,&str,
		NULL);
    sscanf(str,"%f",&max);
    XtFree(str);

/*  s_scalar=(float)(start_color-end_color-1)/(float)(min-max); RJM: comment out
: incorrect */
/*  s_scalar=(float)(end_color-start_color+1)/(float)(max-min); */
    s_scalar=(float)(end_color-start_color)/(float)(max-min);
    s_scalar/=100.0;
#ifdef DEBUG
	printf( "data.c: check_parametersCB: s_scalar=%f, min=%f, max=%f\n", s_scalar, min, max );
#endif

    s_offset=(int)((int)start_color-(min*s_scalar*100.0));
    s_offset-=((int)(end_color-start_color+1)/2+start_color);
    s_offset=(int)(100.0*s_offset/(float)(end_color-start_color+1));
#ifdef DEBUG
	printf( "data.c: check_parametersCB: s_offset=%f\n", s_offset );
#endif

/*  s_scalar=(float)(start_color-end_color-1)/(float)(min-max); RJM: comment out: incorrect */
/*
    s_scalar=(float)(end_color-start_color)/(float)(max-min);
    s_scalar/=100.0;
*/

/*
    s_offset=(int)((int)start_color-(min*s_scalar*100.0));
*/
/*  s_offset-=((int)(end_color-start_color+1)/2+start_color); RJM: Horn idiocity */
/*  s_offset=(int)(100.0*s_offset/(float)(end_color-start_color)); RJM: more Horn idiocity */
  }

  XtVaGetValues(text[20],   
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&max_traces);
  XtFree(str);

  xdisplay[id].flip_flag=XmToggleButtonGetState(toggle_flip);
  xdisplay[id].upside_flag=XmToggleButtonGetState(toggle_upside);
  xdisplay[id].swap_flag=XmToggleButtonGetState(toggle_swap);

  invert_flag=XmToggleButtonGetState(toggle_invert);
  trace_flag=XmToggleButtonGetState(toggle_trace);
  movie_flag=XmToggleButtonGetState(toggle_movie);

  axis_flag=XmToggleButtonGetState(toggle_axis);
  xdisplay[id].axis_flag=axis_flag;

  style_flag=XmToggleButtonGetState(toggle_style);
  xdisplay[id].axis_style=style_flag;

  if (s_exponent>5) {
    error_message("Scale exponent value is too large.");
    xdisplay[id].init=0;
    return;
  }

  /* check 4D parameters */

  if (n4[id]<1) {
    sprintf(string,"4D size must be greater than zero,\nset 4D size and start to 1 do disable 4D mode.");
    error_message(string);
    return;
  }

  if (nrec[id]%n4[id]!=0) {
    sprintf(string,"4D size must be integer divisor of %d,\n set 4D size and start to 1 do disable 4D mode.",nrec[id]);
    error_message(string);
    return;
  }

  if (s4[id]<1 || s4[id]>n4[id]) {
    sprintf(string,"4D start must be > zero and <= %d,\n set 4D size and start to 1 do disable 4D mode.",n4[id]);
    error_message(string);
    return;
  }

  /* DWN modify number of record based on 4D size */
  n3=nrec[id]/n4[id];

				/* Check for valid record parameters. */
/*
  if ((srec[id]<1)||(srec[id]>nrec[id])||
      (erec[id]<1)||(erec[id]>nrec[id])||
      (srec[id]>erec[id])) {
*/
  if ((s3<1)||(s3>n3)||
      (e3<1)||(e3>n3)||
      (s3>e3)) {
    error_message("Out of range for record.");
    xdisplay[id].init=0;
    return;
  }

  /* DWN modify record parameters based on 4D parameters */
  srec[id]=(s4[id]-1)*n3+s3;
  erec[id]=(s4[id]-1)*n3+e3;

				/* Check for valid trace parameters. */
  if ((strace[id]<1)||(strace[id]>ntrace[id])||
      (etrace[id]<1)||(etrace[id]>ntrace[id])||
      (strace[id]>etrace[id])) {
    error_message("Out of range for trace.");
    xdisplay[id].init=0;
    return;
  }
				/* Check for valid sample parameters. */
  if ((ssamp[id]<1)||(ssamp[id]>nsamp[id])||
      (esamp[id]<1)||(esamp[id]>nsamp[id])||
      (ssamp[id]>esamp[id])) {
    error_message("Out of range for sample.");
    xdisplay[id].init=0;
    return;
  }

				/* Check for valid increment parameters. */
  if ((irec[id]<=0)||(isamp[id]<=0)||(itrace[id]<=0)) {
    error_message("Cannot use those increments.");
    xdisplay[id].init=0;
    return;
  }

				/* Compute the width. */
  if (sort_mode==2) 
    width=(((etrace[id]-strace[id])/itrace[id])+1);
  else
    width=(((erec[id]-srec[id])/irec[id])+1)*
      (((etrace[id]-strace[id])/itrace[id])+1);

				/* Special case for time slice. */
  if (ssamp[id]==esamp[id])
    width=((etrace[id]-strace[id])/itrace[id])+1;


				/* Check if user is trying to 
				   retrive too much data. */
  if (width > max_traces) {      
    max_verifyCB(w,(XtPointer)id,call_data);
    return;
  }

				/* Check if user is trying to 
				   retrive too much data. */
/* DWN always check for too many movies, not just when hidden
  if (movie_flag)
*/
  if (XmToggleButtonGetState(toggle_sort[2]))
    if ((erec[id]-srec[id]+1)/irec[id]>10) {
      movie_verify(id);
      return;
    }


/*
fprintf(stderr,"Requesting nrec %d   srec %d   erec %d   irec %d\n",
                nrec[id],srec[id],erec[id],irec[id]);
*/

				/* Go and get data. */
  getCB(w,(XtPointer)id,call_data);
}


/*
  This function verifies that the
  user want to retrieve X number
  of traces (in case the user made
  a mistake in the parameter window).
*/
void movie_verify(long id)
{
  Widget dialog;
  int root_x,root_y;

  XBell(display,100);
  locate_cursor(&root_x,&root_y);

  sprintf(buf,"Do you want to retrieve %d movie slices?",(erec[id]-srec[id]+1)/irec[id]);
  dialog=XmCreateQuestionDialogVa(top_level,"Maximum Movie",
				  XmNdefaultPosition,False,
				  XmNx,root_x,
				  XmNy,root_y,
				  XmNmessageString,XMstr(buf),
				  XmNdialogTitle,XMstr("Maximum Movie"),
				  XmNokLabelString,XMstr(" Yes "),
				  XmNcancelLabelString,XMstr("No"),
				  NULL);
  XtAddCallback(dialog,XmNokCallback,getCB,(XtPointer)id);
  XtAddCallback(dialog,XmNokCallback,destroyCB,(XtPointer)dialog);
  XtAddCallback(dialog,XmNcancelCallback,destroyCB,(XtPointer)dialog);
}

/*
  This function verifies that the
  user want to retrieve X number
  of traces (in case the user made
  a mistake in the parameter window).
*/
void max_verifyCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog;
  int width,root_x,root_y;
  long id;	/* RJM: handle 64-bit architectures */

				/* Flush display so dialog disappears. */
  XmUpdateDisplay(w);

  id=(long)client_data;

				/* Compute the width. */
  if (sort_mode==2) 
    width=(((etrace[id]-strace[id])/itrace[id])+1);
  else
    width=(((erec[id]-srec[id])/irec[id])+1)*
      (((etrace[id]-strace[id])/itrace[id])+1);

  XBell(display,100);
  locate_cursor(&root_x,&root_y);

  sprintf(buf,"Do you want to retrieve %d traces?",width);

  dialog=XmCreateQuestionDialogVa(top_level,"Maximum Traces",
				  XmNdefaultPosition,False,
				  XmNx,root_x,
				  XmNy,root_y,
				  XmNmessageString,XMstr(buf),
				  XmNdialogTitle,XMstr("Maximum Traces"),
				  XmNokLabelString,XMstr(" Yes "),
				  XmNcancelLabelString,XMstr("No"),
				  NULL);
  XtAddCallback(dialog,XmNokCallback,getCB,client_data);
  XtAddCallback(dialog,XmNokCallback,destroyCB,dialog);
  XtAddCallback(dialog,XmNcancelCallback,destroyCB,dialog);
}


/*
  This function send a command to
  the data server to get the data.
*/
static void getCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget window_form;
  unsigned char *data, *transpose_image, temp;
  int width,height,width_temp;
  int x,y,error;
  int m,n;
  long id;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  XmUpdateDisplay(w);

				/* Retrieving data for movie. */
  if ((sort_mode==2)&&(ssamp[id]!=esamp[id])) {
    get_animation(id);
    sort_mode = 0;
    XmToggleButtonSetState(toggle_sort[0],True,False);
    XmToggleButtonSetState(toggle_sort[1],False,False);
    XmToggleButtonSetState(toggle_sort[2],False,False);
    return;
  }

				/* Compute the width and height of image. */
  if (ssamp[id]!=esamp[id]) {
    width=(((erec[id]-srec[id])/irec[id])+1)*
      (((etrace[id]-strace[id])/itrace[id])+1);
    height=((esamp[id]-ssamp[id])/isamp[id])+1;
  } else {
    /* trace_flag=False; - this made single sample plots break - jmw 1/14/01 */
    width=((etrace[id]-strace[id])/itrace[id])+1;
    height=((erec[id]-srec[id])/irec[id])+1;
  }

				/* Allocate memory for trace header. */
/*traceH[id]=(unsigned char *)malloc(width*256*sizeof(char));
  memset((char *)traceH[id],0,width*256*sizeof(char));
RJM */
  traceH[id]=(unsigned char *)calloc(width, 256*sizeof(char));

				/* Check if the data is to be zoomed. */
  if ((hor_zoom==1.0)&&(ver_zoom==1.0)) {
				/* Allocate memory for data. */
    raster[id]=(unsigned char *)malloc(width*height*sizeof(char));
    error=amoco_check_server(buf);
    if (error==-1) {
#ifndef NO_TIME_OUT
      XtRemoveTimeOut(time_out);	/* abort error dialog pop-up */
#endif
      error_message(buf);
      error_message("Server error (3). Try restarting server.");
      xdisplay[id].init=0;
      return;
    }
    error=amoco_read_data(raster[id],traceH[id],xdisplay[id].filename,
			  srec[id],erec[id],irec[id],strace[id],etrace[id],
			  itrace[id],ssamp[id],esamp[id],isamp[id],
			  scale_mode,s_offset,s_scalar,s_exponent,
			  xdisplay[id].sort,trace_flag,invert_flag);
    if (error < 0) {
      reportDSerror( error );
      xdisplay[id].init=0;
      return;
    }
  } else {
    data=(unsigned char *)malloc(width*height*sizeof(char));
    error=amoco_check_server(buf);
    if (error==-1) {
#ifndef NO_TIME_OUT
      XtRemoveTimeOut(time_out);	/* abort error dialog pop-up */
#endif
      error_message(buf);
      error_message("Server error (4). Try restarting server.");
      xdisplay[id].init=0;
      return;
    }
				/* Read seismic data and trace header. */
    error=amoco_read_data(data,traceH[id],xdisplay[id].filename,
			  srec[id],erec[id],irec[id],strace[id],etrace[id],
			  itrace[id],ssamp[id],esamp[id],isamp[id],
			  scale_mode,s_offset,s_scalar,s_exponent,
			  xdisplay[id].sort,trace_flag,invert_flag);
    if (error < 0) {
      reportDSerror( error );
      xdisplay[id].init=0;
      if(data)
        free((char *)data); 
      data=NULL;
      return;
    }
    width_temp=width;
    width*=hor_zoom;
    height*=ver_zoom;
				/* Allocate memory for zoomed data. */
    raster[id]=(unsigned char *)malloc(width*height*sizeof(char));
				/* Zoom data. */
    for (y=0; y<height; y++)
      for (x=0; x<width; x++)
	*(raster[id]+x+y*width)=*(data+(int)(x/hor_zoom)+
				  (int)(y/ver_zoom)*width_temp);
    if(data)
      free((char *)data); 
    data=NULL;
  }

  /* Get the scale and offset factors used. */
  xdisplay[id].offset=amoco_offset();
  xdisplay[id].scalar=amoco_scalar();

  /* Flip raster image right to left. */
  if (xdisplay[id].flip_flag) {	
    for (m=0; m<height; m++)
      for (n=0; n<(width/2); n++) {
	temp=*(raster[id]+n+m*width);
	*(raster[id]+n+m*width)=*(raster[id]+(width-n-1)+m*width);
	*(raster[id]+(width-n-1)+m*width)=temp;
      }
  }
				
  /* Flip raster image upside-down. */
  if (xdisplay[id].upside_flag) {
    for (m=0; m<(height/2); m++)
      for (n=0; n<width; n++) {
	temp=*(raster[id]+n+m*width);
	*(raster[id]+n+m*width)=*(raster[id]+n+(height-m-1)*width);
	*(raster[id]+n+(height-m-1)*width)=temp;
      }
  }

  /* Swap x & y axes */
  if (xdisplay[id].swap_flag)
  {
	transpose_image = transpose( raster[id], width, height );
	free( raster[id] );
	raster[id] = transpose_image;
  }

  xdisplay[id].image=XCreateImage(display,visual,screenDepth,ZPixmap,
	0,(char *)raster[id],
	xdisplay[id].swap_flag ? height : width,	/* RJM */
	xdisplay[id].swap_flag ? width : height,	/* RJM */
	screenDepth,0);
  if (xdisplay[id].image==NULL) {
    fprintf(stderr,"getCB: error can not create image space.\n");
    exit(1);
  }

  xdisplay[id].parent=id;
  xdisplay[id].pick_x=1.0/hor_zoom;
  xdisplay[id].pick_y=1.0/ver_zoom;

				/* Find best screen size. */
  screen_size( id, &width, &height );

				/* Creates new window. */
  n=0;

  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XmNwidth,width); n++;	/* RJM: args[0] --> args[n] */
  XtSetArg(args[n],XmNheight,height+MIN_HEIGHT); n++;
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;	/* RJM added */
  XtSetArg(args[n],XtNdepth,screenDepth); n++;	/* RJM added */
/*xdisplay[id].window=XtAppCreateShell("xsd","move",
  				       topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
  xdisplay[id].window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
  				       topLevelShellWidgetClass,display,args,n);
  quit_frame(xdisplay[id].window);
  XtResizeWindow(xdisplay[id].window);

  window_form=XmCreateFormVa(xdisplay[id].window,"form",NULL);

                                /* Indicate general mode. */
  xdisplay[id].mode=1;
  set_mode_label(1,id);

				/* Creates drop-down menus. */
  app_menus(window_form,id,False);

				/* Sets color initially to global. */
  raster_color_red[id]=global_red;
  raster_color_green[id]=global_green;
  raster_color_blue[id]=global_blue;

				/* Creates image. */
  xdisplay_image(id,xdisplay[id].window,window_form,width,height);

  XtRealizeWidget(xdisplay[id].window);
    
  window_title(buf,id);

  XtVaSetValues(xdisplay[id].window,
		XmNtitle,buf,
		NULL);
}


/*
  This function puts each record
  in a separate window so they
  can be animated.
*/
void get_animation(long id)
{
  Widget window_form;
  Widget main_window;
  int rec_count,start_rec,end_rec,incr_rec,num_rec;
  int start_trace,end_trace,incr_trace,num_trace;
  int start_sample,end_sample,incr_sample,num_sample;
  int width,height,error,width_temp,x,y;
  int m,n,temp;
  Boolean flip_flag,upside_flag,swap_flag;
  char tmp[1024];
  unsigned char *data, *transpose_image;
  
				/* Store initial values. */
  start_rec=srec[id];
  end_rec=erec[id];
  incr_rec=irec[id];
  num_rec=nrec[id];
  start_trace=strace[id];
  end_trace=etrace[id];
  incr_trace=itrace[id];
  num_trace=ntrace[id];
  start_sample=ssamp[id];
  end_sample=esamp[id];
  incr_sample=isamp[id];
  num_sample=nsamp[id];
  flip_flag=xdisplay[id].flip_flag;
  upside_flag=xdisplay[id].upside_flag;
  swap_flag=xdisplay[id].swap_flag;
  strcpy(tmp,xdisplay[id].filename);
  xdisplay[id].init=0;

				/* Loop through each record and 
				   create a window. */
  for (rec_count=start_rec; rec_count<=end_rec; rec_count+=incr_rec) {
    id=next_image();
    xdisplay[id].axis_units[0]=axis_units[0];
    xdisplay[id].axis_units[1]=axis_units[1];
    xdisplay[id].axis_units[2]=axis_units[2];
    xdisplay[id].axis_offset[0]=axis_offset[0];
    xdisplay[id].axis_offset[1]=axis_offset[1];
    xdisplay[id].axis_offset[2]=axis_offset[2];
    srec[id]=rec_count;
    erec[id]=rec_count;
    irec[id]=1;
    nrec[id]=num_rec;
    strace[id]=start_trace;
    etrace[id]=end_trace;
    itrace[id]=incr_trace;
    ntrace[id]=num_trace;
    ssamp[id]=start_sample;
    esamp[id]=end_sample;
    isamp[id]=incr_sample;
    nsamp[id]=num_sample;
    xdisplay[id].flip_flag=flip_flag;
    xdisplay[id].upside_flag=upside_flag;
    xdisplay[id].swap_flag=swap_flag;
    strcpy(xdisplay[id].filename,tmp);
    xdisplay[id].sort=0;
    xdisplay[id].middle=1;
    width=(((etrace[id]-strace[id])/itrace[id])+1);
    height=((esamp[id]-ssamp[id])/isamp[id])+1;
    
    if (axis_flag)
      xdisplay[id].axis_flag=True;
    if (style_flag)
      xdisplay[id].axis_style=True;

				/* Allocate memory for trace header. */
/*  traceH[id]=(unsigned char *)malloc(width*256*sizeof(char));
    memset((char *)traceH[id],0,width*256*sizeof(char));
RJM */
    traceH[id]=(unsigned char *)calloc(width, 256*sizeof(char));

				/* Check if the data is to be zoomed. */
    if ((hor_zoom==1.0)&&(ver_zoom==1.0)) {
				/* Allocate memory for data. */
      raster[id]=(unsigned char *)malloc(width*height*sizeof(char));
      error=amoco_check_server(buf);
      if (error==-1) {
#ifndef NO_TIME_OUT
        XtRemoveTimeOut(time_out);	/* abort error dialog pop-up */
#endif
        error_message(buf);
        error_message("Server error (5). Try restarting server.");
	xdisplay[id].init=0;
	return;
      }

				/* Read seismic data and trace header. */
      error=amoco_read_data(raster[id],traceH[id],xdisplay[id].filename,
			    srec[id],erec[id],irec[id],strace[id],etrace[id],
			    itrace[id],ssamp[id],esamp[id],isamp[id],
			    scale_mode,s_offset,s_scalar,s_exponent,
			    xdisplay[id].sort,trace_flag,invert_flag);
      if (error < 0) {
        reportDSerror( error );
	xdisplay[id].init=0;
	return;
      }
    } else {
				/* Allocate memory for data. */
      data=(unsigned char *)malloc(width*height*sizeof(char));
      error=amoco_check_server(buf);
      if (error==-1) {
#ifndef NO_TIME_OUT
        XtRemoveTimeOut(time_out);	/* abort error dialog pop-up */
#endif
        error_message(buf);
        error_message("Server error (6). Try restarting server.");
	xdisplay[id].init=0;
	return;
      }
				/* Read seismic data and trace header. */
      error=amoco_read_data(data,traceH[id],xdisplay[id].filename,
			    srec[id],erec[id],irec[id],strace[id],etrace[id],
			    itrace[id],ssamp[id],esamp[id],isamp[id],
			    scale_mode,s_offset,s_scalar,s_exponent,
			    xdisplay[id].sort,trace_flag,invert_flag);
      if (error < 0) {
        reportDSerror( error );
	xdisplay[id].init=0;
	return;
      }
      width_temp=width;
      width*=hor_zoom;
      height*=ver_zoom;
				/* Allocate memory for zoomed data. */
      raster[id]=(unsigned char *)malloc(width*height*sizeof(char));
      for (y=0; y<height; y++)
	for (x=0; x<width; x++)
	  *(raster[id]+x+y*width)=*(data+(int)(x/hor_zoom)+
				    (int)(y/ver_zoom)*width_temp);
      if(data)
        free((char *)data); 
      data=NULL;
    }
    xdisplay[id].offset=amoco_offset();
    xdisplay[id].scalar=amoco_scalar();
    
				/* Flip raster image. */
    if (xdisplay[id].flip_flag) {  
      for (m=0; m<height; m++)
	for (n=0; n<(width/2); n++) {
	  temp=*(raster[id]+n+m*width);
	  *(raster[id]+n+m*width)=*(raster[id]+(width-n-1)+m*width);
	  *(raster[id]+(width-n-1)+m*width)=temp;
	}
    }

				/* Flip raster image upside-down. */
    if (xdisplay[id].upside_flag) {  
      for (m=0; m<(height/2); m++)
	for (n=0; n<width; n++) {
	  temp=*(raster[id]+n+m*width);
	  *(raster[id]+n+m*width)=*(raster[id]+n+(height-m-1)*width);
	  *(raster[id]+n+(height-m-1)*width)=temp;
	}
    }

    if( xdisplay[id].swap_flag )	/* Swap x & y axes */	/* RJM */
    {
	transpose_image = transpose( raster[id], width, height );
	free( raster[id] );
	raster[id] = transpose_image;
    }

    xdisplay[id].image=XCreateImage(display,visual,screenDepth,ZPixmap,
	0,(char *)raster[id],
	xdisplay[id].swap_flag ? height : width,	/* RJM */
	xdisplay[id].swap_flag ? width : height,	/* RJM */
	screenDepth,0);
    
    if (xdisplay[id].image==NULL) {
      fprintf(stderr,"get_animation error: can not create image space.\n");
      exit(2);
    }
    
    xdisplay[id].parent=id;
    xdisplay[id].pick_x=1.0/hor_zoom;
    xdisplay[id].pick_y=1.0/ver_zoom;
    
    screen_size( id, &width, &height );
    
				/* Creates new window. */
    n=0;
    XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
    XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
    XtSetArg(args[n],XmNwidth,width); n++;
    XtSetArg(args[n],XmNheight,height+MIN_HEIGHT); n++;
    if (movie_flag) {
      XtSetArg(args[n],XmNmappedWhenManaged,False); n++;
      xdisplay[id].hide_flag=True;
    }
    XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
    XtSetArg(args[n],XtNvisual,visual); n++;	/* RJM: added */
    XtSetArg(args[n],XtNdepth,screenDepth); n++;	/* RJM: added */
/*  xdisplay[id].window=XtAppCreateShell("xsd","animation",
				 topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
    xdisplay[id].window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
				 topLevelShellWidgetClass,display,args,n);
    quit_frame(xdisplay[id].window);
    XtResizeWindow(xdisplay[id].window);

    main_window=XmCreateMainWindowVa(xdisplay[id].window,"child_form",
				     XmNshowSeparator,True,
				     NULL);

    window_form=XmCreateFormVa(main_window,"form",  
			       XmNwidth,width,
			       NULL);

                                /* Indicate general mode. */
    xdisplay[id].mode=1;
    set_mode_label(1,id);

				/* Creates drop-down menus. */
    app_menus(window_form,id,False);

				/* Sets color initially to global. */
    raster_color_red[id]=raster_color_red[0];
    raster_color_green[id]=raster_color_green[0];
    raster_color_blue[id]=raster_color_blue[0];

				/* Creates image. */
    xdisplay_image(id,xdisplay[id].window,window_form,width,height);

    XtRealizeWidget(xdisplay[id].window);

    window_title(buf,id);
    XtVaSetValues(xdisplay[id].window,
		  XmNtitle,buf,
		  NULL);
  }
  if (movie_flag) msg_message("Done retrieving movie.");
}


static unsigned char *transpose( unsigned char *a, int n, int m )
{
	unsigned char	*b, *abase, *aptr, *bptr;

	b = (unsigned char*)malloc( n*m * sizeof( unsigned char* ) );
	if( b == NULL )
		return NULL;

	for( abase = a, bptr = b; abase < a+n; abase++ )
		for( aptr = abase; aptr < a+n*m; aptr+=n, bptr++ )
			*bptr = *aptr;

	return b;
}
