/*
 * REQUIRED MOTIF INCLUDE FILES
 */
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/MainW.h>
#include <Xm/RowColumn.h>
#include "HelpObject.h"
#include "CascadeB.h"

/*
 * USER SUPPLIED INCLUDE FILES
 */

/* DEFINE SECTION */
#define APPLICATION_NAME "help"
#define APPLICATION_CLASS "help"

#define TEST FALSE

/* GLOBAL WIDGET VARIABLES */
Widget Shell;
Widget MainWindow;
Widget menuBar;
Widget testhelp, testhelpfile, testhelptext;

/* MAIN PROGRAM */
main(argc, argv)
int argc;
char **argv;
{
    Display *display;
    Arg 	args[25];
    int 	argcnt;
    XtAppContext context;


static char *version[] = { "         Help System          ",
                           "   Motif style guide version  ",
                           "         Version 1.0          ",
                           NULL};

static HelpItem tutorial  = {"File", "On_Tutorial_Text"};
static HelpItem whatsnext = {"File", "main.c"};

static HelpList helplist[] = { 
      {"On Keys Text",            {"File", "On_Keys_Text"} },
      {"default widget help",     {"File", "default_widget_help"} },
      {"On Tutorial Help",        {"File", "On_Tutorial_Help"} },
      {"On Tutorial Text",        {"File", "On_Tutorial_Text"} },
      {"On Version Help",         {"File", "On_Version_Help"} },
      {"On Context Help",         {"File", "On_Context_Help"} },
      {"On Windows Help",         {"File", "On_Windows_Help"} },
      {"On Help Help",            {"File", "On_Help_Help"} },
      {"On Windows Text",         {"File", "On_Windows_Text"} },
      {"On Index Help",           {"File", "On_Index_Help"} },
      {"On Keys Help",            {"File", "On_Keys_Help"} },
      {"Help defaults",           {"File", "Help_defaults"} },
      {"Makefile",                {"File", "Makefile"} },
      {"HelpObject.c",            {"File", "HelpObject.c"} },
      {"HelpObject.h",            {"File", "HelpObject.h"} },
      {"XuCreateHelpPulldown.c",  {"File", "XuCreateHelpPulldown.c"} },
      {"main.c",                  {"File", "main.c"} },
      {"NO FILE",                 {"File", "NO_FILE"} },
      {NULL,                      {NULL,   NULL} }
      };

HelpItem *helpptr1, *helpptr2, *helpptr3;


    XtToolkitInitialize();
    context = XtCreateApplicationContext();
    display = XtOpenDisplay(context, 0, APPLICATION_NAME, APPLICATION_CLASS,
        0, 0, &argc, argv);
    if(display == NULL)
    {
	XtWarning("cannot open display");
	exit(1);
    }


    argcnt = 0;
    XtSetArg(args[argcnt], XmNtitle, "Main Menu"); argcnt++;
    Shell = XtAppCreateShell( APPLICATION_NAME, APPLICATION_CLASS,
        applicationShellWidgetClass, display, args, argcnt);

    argcnt = 0;
    MainWindow = XtCreateWidget("mainWindow", xmMainWindowWidgetClass,
                Shell, args, argcnt);
    XtManageChild(MainWindow);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_BAR); argcnt++;
    menuBar = XtCreateWidget("menuBar", xmRowColumnWidgetClass,
                MainWindow, args, argcnt);
    XtManageChild(menuBar);
    XuSet_Help(menuBar,"File", "default_widget_help");

    argcnt=0;
    testhelp = XmCreateCascadeButton(menuBar, "Test Help", args, argcnt);
    XuSet_Help(testhelp,"File", "testhelp.help");
    XtManageChild(testhelp);

    argcnt=0;
    testhelpfile = XmCreateCascadeButton(menuBar, "Test File", args, argcnt);
    XuSet_Help(testhelpfile,"Path", "/home/gpsa/zjrs10/Motifex/help/testhelpfile.help");
    XtManageChild(testhelpfile);

    argcnt=0;
    testhelptext = XmCreateCascadeButton(menuBar, "Test Text", args, argcnt);
    XuSet_Help(testhelptext, "Text", 
               "Test of XuSet_Help call with text string input. XuHelper display.");
    XtManageChild(testhelptext);


/****************************************************************************/
    XuCreateHelpPulldown(menuBar,  ".",  helplist,  version,  TRUE,
                                   TRUE, &tutorial, TRUE); 

    XuSet_Help_Shell(Shell);            
    XuSet_Help_Whats_Next(&whatsnext);

    XtRealizeWidget(Shell);

    if(TEST) {
       helpptr1 = XuDisplay_Help("File", "testhelpdisplay.help");
       helpptr2 = XuDisplay_Help("Path", "./testfiledisplay.help");
       helpptr3 = XuDisplay_Help("Text", 
                                 "Test of text display via XuDisplayHelp");
      }

    XtAppMainLoop(context);
}
