/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	"chd.h"

do_def(s, l, a)
char	*s, **a;
int	l;
	{
	char	*p, *vol = NULL, line[256];
	int	i, status = CHD_FULL, slot = 0, mask = 0, abbrev();
	struct chd_struct	*z, samp, *chd_srch();

	for (i= 0, p = a[i]; p != NULL; i++, p = a[i]) {
		if (abbrev("VOLUME", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				vol = a[i];
			}
		else if (abbrev("SLOT", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				(void) sscanf(a[i], "%d", &slot);
			}
		else if (abbrev("SCRATCH", p, 2))
			status = CHD_SCRATCH;
		}

	if (slot == 0 || vol == NULL)
		post_msg(440, "Usage: Alloc Volume VVVVVVVV Slot NN [SCratch]");
	else	{
		chd_fill(&samp, 0, 0, CHD_SLOT, CHD_EMPTY, vol);
		if ((z = chd_srch(CHDX, &samp, CHD_VOL))) {
			(void) sprintf(line,
				"Vol \"%s\" Already Allocated", vol);
			post_msg(440, line);
			}
		else	{
			chd_fill(&samp, slot, 0, CHD_SLOT, CHD_EMPTY, vol);
			if (!(z = chd_srch(CHDX, &samp,
				CHD_STAT | CHD_NAME))) {
				(void) sprintf(line,
					"Slot \"%d\" Already Allocated", slot);
				post_msg(440, line);
				}
			else	{
				z->chd_symbstat = status;
				(void) strcpy(z->chd_label, vol);
				chd_save(CHDX);
				if (status == CHD_SCRATCH) {
					(void) sprintf(line,
						"Allocate Vol %s Slot %d Stat Scratch", vol, slot);
					post_msg(240, line);
					}
				else	{
					(void) sprintf(line,
						"Allocate Vol %s Slot %d Stat Old", vol, slot);
					post_msg(240, line);
					}
				}
			}
		}





	}
