/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	"chd.h"

do_load(s, l, a)
char	*s, **a;
int	l;
	{
	char	*p, *vol = NULL, line[256];
	int	i, status = CHD_FULL, slot = 0, op_load(),
		drive = CHD_NODRIVE, mask = 0, abbrev();
	struct chd_struct	*src, *rbt, *unt, *tgt, *z, samp, *chd_srch();

	for (i= 0, p = a[i]; p != NULL; i++, p = a[i]) {
		if (abbrev("VOLUME", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				vol = a[i];
			}
		else if (abbrev("SLOT", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				(void) sscanf(a[i], "%d", &slot);
			}
		else if (abbrev("DRIVE", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				(void) sscanf(a[i], "%d", &drive);
			}
		else if (abbrev("SCRATCH", p, 2))
			status = CHD_SCRATCH;

		else if (vol == NULL)
			vol = a[i];
		}

	if (((slot != 0 && vol != NULL) ||
		(slot != 0 && status == CHD_SCRATCH) ||
		(vol != NULL && status == CHD_SCRATCH)) ||
		(slot == 0 && vol == NULL && status != CHD_SCRATCH))
		post_msg(460,
			"Usage: Load Volume VVVVVVVV | Slot NN | SCratch [Drive NN]");

	else	{
		if (drive != CHD_NODRIVE) {
			chd_fill(&samp, drive, 0, CHD_DRIVE, CHD_EMPTY, NULL);
			if (tgt = chd_srch(CHDX, &samp, CHD_NAME | CHD_STAT)) {

				mask = CHD_STAT | CHD_UNIT;
				if (slot != 0) {
					chd_fill(&samp,
						slot, 0, CHD_SLOT, CHD_NONEMPTY, "");
					mask |= CHD_NAME;
					}
				else if (vol != NULL) {
					chd_fill(&samp,
						0, 0, CHD_SLOT, CHD_NONEMPTY, vol);
					mask |= CHD_VOL;
					}
				else if (status == CHD_SCRATCH) {
					chd_fill(&samp,
						0, 0, CHD_SLOT, CHD_SCRATCH, "");
					}
				samp.chd_unitid = tgt->chd_unitid;
				if (src = chd_srch(CHDX, &samp, mask)) {
					chd_fill(&samp, tgt->chd_unitid, 0, CHD_UNITID, 0, NULL);
					unt = chd_srch(CHDX, &samp, CHD_NAME);
					chd_fill(&samp, 0, tgt->chd_unitid, CHD_CHM, 0, NULL);
					rbt = chd_srch(CHDX, &samp, CHD_UNIT);
	
					if (op_load(src, tgt, rbt, unt)) {
						src->chd_symbstat = tgt->chd_symbid;
						tgt->chd_symbstat = src->chd_symbid;
						chd_save(CHDX);

						(void) sprintf(line,
							"Load Vol %s Slot %d Drive %d Den %d Unit %d Device %s",
							src->chd_label,
							src->chd_symbid,
							tgt->chd_symbid,
							tgt->chd_densid,
							tgt->chd_unitid,
							tgt->chd_label);
						post_msg(260, line);
						}
					else	{
						post_msg(460, "Load Operation Failed");
						}
					}
				else
					post_msg(460, "Vol / Slot Not Available Or Slot / Drive Conflict");
				}
			else
				post_msg(460, "Drive Not Found Or Not Available");
			}

		else	{
			if (status == CHD_SCRATCH) {
				chd_fill(&samp, 0,0, CHD_DRIVE, CHD_EMPTY, NULL);

				for (tgt = chd_srch(CHDX, &samp, CHD_STAT); tgt != NULL;
				tgt = chd_srch(++tgt, &samp, CHD_STAT)) {
					chd_fill(&samp, 0, tgt->chd_unitid, CHD_SLOT, CHD_SCRATCH, NULL);
					if (src = chd_srch(CHDX, &samp, CHD_STAT | CHD_UNIT)) {
						chd_fill(&samp, tgt->chd_unitid, 0, CHD_UNITID, 0, NULL);
						unt = chd_srch(CHDX, &samp, CHD_NAME);
						chd_fill(&samp, 0, tgt->chd_unitid, CHD_CHM, 0, NULL);
						rbt = chd_srch(CHDX, &samp, CHD_UNIT);

						if (op_load(src, tgt, rbt, unt)) {
							src->chd_symbstat = tgt->chd_symbid;
							tgt->chd_symbstat = src->chd_symbid;
							chd_save(CHDX);

							(void) sprintf(line,
								"Load Vol %s Slot %d Drive %d Den %d Unit %d Device %s",
								src->chd_label,
								src->chd_symbid,
								tgt->chd_symbid,
								tgt->chd_densid,
								tgt->chd_unitid,
								tgt->chd_label);
							post_msg(260, line);
							return;
							}
						else	{
							post_msg(460, "Load Operation Failed");
							return;
							}
						}
					chd_fill(&samp, 0,0, CHD_DRIVE, CHD_EMPTY, NULL);
					}
				post_msg(469, "Scratch Mount Not Possible");
				}

			else	{
				if (slot != 0) {
					chd_fill(&samp, slot, 0, CHD_SLOT, CHD_NONEMPTY, NULL);
					mask = CHD_NAME;
					}
				else if (vol != NULL) {
					chd_fill(&samp, 0, 0, CHD_SLOT, CHD_NONEMPTY, vol);
					mask = CHD_VOL;
					}
				if (src = chd_srch(CHDX, &samp, mask | CHD_STAT)) {
					chd_fill(&samp, 0, src->chd_unitid, CHD_DRIVE, CHD_EMPTY, NULL);
					if (tgt = chd_srch(CHDX, &samp, CHD_UNIT | CHD_STAT)) {
						chd_fill(&samp, tgt->chd_unitid, 0, CHD_UNITID, 0, NULL);
						unt = chd_srch(CHDX, &samp, CHD_NAME);
						chd_fill(&samp, 0, tgt->chd_unitid, CHD_CHM, 0, NULL);
						rbt = chd_srch(CHDX, &samp, CHD_UNIT);

						if (op_load(src, tgt, rbt, unt)) {
							src->chd_symbstat = tgt->chd_symbid;
							tgt->chd_symbstat = src->chd_symbid;
							chd_save(CHDX);

							(void) sprintf(line,
								"Load Vol %s Slot %d Drive %d Den %d Unit %d Device %s",
								src->chd_label,
								src->chd_symbid,
								tgt->chd_symbid,
								tgt->chd_densid,
								tgt->chd_unitid,
								tgt->chd_label);
							post_msg(260, line);
							}
						else
							post_msg(460, "Load Operation Failed");
						}
					else
						post_msg(460, "Drive Not Available");
					}
				else
					post_msg(460, "Vol Not Found Or Already In Use");
				}
			}
		}

	}
