/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/termios.h>
#include	<sys/ioctl.h>
#include	<fcntl.h>

#define	BAD	1
#define	GOOD	0

#define	TRUE	1
#define	FALSE	0

#define		USAGE		"usage: ctd_8l -L|U|I|E|S|Z [-d file_id] [-h handler_file_id] -s nn -c nn -t nn\n"
#define		CHANGER		"/dev/serial_switch0"
#define		TAPEDRIVE	"/dev/rst0"

main(argc, argv)
int	argc;
char	**argv;
	{
	FILE		*fd;
	extern char	*optarg;
	extern int	optind;
	int		irc, c, operation = 'L', check_door(), open_door(),
			handler = 0, source = 0, target = 0, density = 0,
			physical = 0;
	int		retry, no_load = FALSE;
	struct	termios	control_mode;
	char		*file_id = CHANGER;
	char		*tapedrive = TAPEDRIVE;
	char		errbuf[1024];

	while ((c = getopt(argc, argv, "EILSUZc:d:h:m:np:s:t:?")) != -1)
		switch (c) {
		case 'd':
			tapedrive = optarg;
			break;
		case 'h':
			file_id = optarg;
			break;
		case 'c':
			sscanf(optarg, "%d", &handler);
			break;
		case 'm':
			sscanf(optarg, "%d", &density);
			break;
		case 'p':
			sscanf(optarg, "%d", &physical);
			break;
		case 's':
			sscanf(optarg, "%d", &source);
			break;
		case 't':
			sscanf(optarg, "%d", &target);
			break;
		case 'E':
		case 'I':
		case 'Z':
		case 'S':
		case 'L':
		case 'U':
			operation = c;
			break;
		case 'n':
			no_load = TRUE;
			break;
		case '?':
		default:
			fprintf(stderr, USAGE);
			exit(BAD);
		}

	if ((fd = fopen(file_id, "r+")) == NULL)
		exit(BAD);

	irc = ioctl(fileno(fd), TCGETS, &control_mode);
	control_mode.c_iflag = 0;
	control_mode.c_oflag &= ~OPOST;
	control_mode.c_cflag |= CS8;
	control_mode.c_cflag &= ~PARENB;
	control_mode.c_lflag = 0;
	irc = ioctl(fileno(fd), TCSETS, &control_mode);

	if (operation == 'L') {

		fprintf(fd, "D %d\r", target);
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		fprintf(fd, "S %d\r", source);
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		fprintf(fd, "C\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		for (retry = 3; retry > 0; retry--) {
			fprintf(fd, "F\r");
			fflush(fd);
			if (ctd_sync(fileno(fd), errbuf) < 0)
				post_msg(307, "Retry Finger");
			else
				break;
			}

		if (retry == 0) {
			post_msg(301, errbuf);
			fprintf(fd, "U\r");
			fflush(fd);
			if (ctd_sync(fileno(fd), errbuf) < 0)
				post_msg(302, errbuf);
			exit(BAD);
			}

		if ((!(no_load)) && (!(check_door(tapedrive)))) {
			post_msg(301, "Tape Load Failed (Latch Operation)");
			fprintf(fd, "U\r");
			fflush(fd);
			if (ctd_sync(fileno(fd), errbuf) < 0)
				post_msg(302, errbuf);
			exit(BAD);
			}
		}

	else if (operation == 'U') {

		if (no_load || open_door(tapedrive)) {

			fprintf(fd, "D %d\r", source);
			fflush(fd);
			if (ctd_sync(fileno(fd), errbuf) < 0) {
				post_msg(301, errbuf);
				exit(BAD);
				}

			fprintf(fd, "S %d\r", target);
			fflush(fd);
			if (ctd_sync(fileno(fd), errbuf) < 0) {
				post_msg(301, errbuf);
				exit(BAD);
				}

			fprintf(fd, "U\r");
			fflush(fd);
			if (ctd_sync(fileno(fd), errbuf) < 0) {
				post_msg(301, errbuf);
				exit(BAD);
				}
			}
		else	{
			exit(BAD);
			}
		}

	else if (operation == 'I') {

		fprintf(fd, "D 1\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		fprintf(fd, "H\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		fprintf(fd, "S %d\r", target);
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		fprintf(fd, "E\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		sleep(10);
		fprintf(fd, "I\r");
		fflush(fd);
		while (ctd_sync(fileno(fd), errbuf) < 1) {
			post_msg(301, "Waiting For Tape Load");
			sleep(10);
			fprintf(fd, "I\r");
			fflush(fd);
			}

		fprintf(fd, "N\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}
		}

	else if (operation == 'E') {

		fprintf(fd, "D 1\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		fprintf(fd, "H\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		fprintf(fd, "S %d\r", source);
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		fprintf(fd, "E\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}

		sleep(10);
		fprintf(fd, "I\r");
		fflush(fd);
		while (ctd_sync(fileno(fd), errbuf) < 1) {
			post_msg(301, "Waiting For Door Close");
			sleep(10);
			fprintf(fd, "I\r");
			fflush(fd);
			}

		fprintf(fd, "N\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}
		}

	else if (operation == 'S') {

		fprintf(fd, "N\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}
		}

	else if (operation == 'Z') {

		fprintf(fd, "H\r");
		fflush(fd);
		if (ctd_sync(fileno(fd), errbuf) < 0) {
			post_msg(301, errbuf);
			exit(BAD);
			}
		}

	else	{

		(void) fclose(fd);

		exit(BAD);
		}

	(void) fclose(fd);

	exit(GOOD);
	}
