/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<string.h>

#include	<X11/X.h>
#include	<X11/Intrinsic.h>
#include	<Xm/Xm.h>
#include	<Xm/Form.h>
#include	<Xm/PushB.h>
#include	<Xm/Text.h>
#include	<Xm/Label.h>
#include	<Xm/Separator.h>

#define	CMDSTR	"stty cs8 raw -parenb -echo <%s >%s"
#define	OUTSTR	"xterm -title 'EXB-10 CHS' -bg black -fg yellow -font 9x15 -fb 9x15bold -e /bin/csh -c 'cat %s' &"

static XtTranslations parsed_translations;

static char addtranslations[] = "<Key>Tab:        self-insert()";

FILE		*fid;
XtAppContext app_con;

main(argc, argv)
int	argc;
char	*argv[];
{
	Widget	server;
	Widget	panel,separator,quit;
	Widget	text1,text1_label;
	XmString label;
	XtTimerCallbackProc refresh();
	int	fd;
	void 	text_notify(),die();

	char		device_name[256], buffer[512];

	if (argc > 1)
		(void) strcpy(device_name, argv[1]);
	else
		(void) strcpy(device_name, "/dev/stacker0");

	fid = fopen(device_name, "r+");
	fd = fileno(fid);

/* - this is now done by the startup script to prevent keysym error in the
     xterm					- joe m. wade 7/22/97

	sprintf(buffer, OUTSTR, device_name);
	(void) system(buffer);
*/
	sprintf(buffer, CMDSTR, device_name, device_name);
	(void) system(buffer);

	label = XmStringCreate("EXB-10 CHS CONTROL",XmSTRING_DEFAULT_CHARSET);
	server = XtAppInitialize (&app_con, "EXB-10", NULL,
			0, &argc, argv,
			NULL, NULL, 0);
	XmStringFree(label);

	panel = XtVaCreateManagedWidget("panel",
		xmFormWidgetClass, server, NULL);
/*
  I create the widgets from the bottom of the panel up to prevent a
  circular dependency that occurred in tieing the bottom of the label
  widget to the associated text widget.
*/

	quit = XtVaCreateManagedWidget("Exit",
		xmPushButtonWidgetClass, panel, 
			XmNbottomOffset,		10,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,		40,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,		60,
			NULL);

	separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, panel, 
			XmNheight,		4,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	quit,
			XmNbottomOffset,	5,
			NULL);
	
	label = XmStringCreate("Command Input:",XmSTRING_DEFAULT_CHARSET);
	text1_label = XtVaCreateManagedWidget("label",
		xmLabelWidgetClass, panel,
			XmNtopOffset,		10,
			XmNleftOffset,		10,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	separator,
			XmNbottomOffset,		10,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	text1 = XtVaCreateManagedWidget("input",
		xmTextWidgetClass, panel, 
			XmNtopAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,		text1_label,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		text1_label,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,		10,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	separator,
			XmNbottomOffset,	10,
			XmNcolumns,		20,
			XmNrows,		1,
			NULL);

	parsed_translations = XtParseTranslationTable(addtranslations);
	XtOverrideTranslations(text1, parsed_translations);

	XtAddCallback(text1, XmNactivateCallback, text_notify, (XtPointer)fd);
	XtAddCallback(quit, XmNactivateCallback, die, NULL);
	XtManageChild(text1);

	XmProcessTraversal((Widget)text1,XmTRAVERSE_CURRENT);
	XtRealizeWidget(server);
/*
  Give them time to put the xterm up, then request a refresh automatically
*/
	XtAppAddTimeOut(app_con,4000,refresh,(XtPointer)fd);
	XtAppMainLoop(app_con);
}

XtTimerCallbackProc refresh(client_data,id)
XtPointer 	client_data;
XtIntervalId	id;
{
	(void) write((int)client_data, "r", 1);

/* - this would update every 10 seconds

	XtAppAddTimeOut(app_con,10000,refresh,client_data);
*/
	return(FALSE);
}
void text_notify(item, client_data, event)
Widget	item;
XtPointer 	event,client_data;
{
	char	*s;
	
	s = XmTextGetString(item);

	switch ((char)*s) {
		case '\0':
			(void) write((int)client_data, "r", 1);
			return;
		default:
			(void) write((int)client_data, s, strlen(s));
			XmTextSetString(item,"");
			return;
		}
}

void die(widget, client_data, call_data)
Widget widget;
XtPointer call_data,client_data;
{
/*
  kill all group process to terminate the xterm window
*/
	kill(0,9);
	exit(0);
}
