/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/List.h>

#include <global.h>

void build_list(list,type,match)
Widget list;
char *type;
SearchList match[];
{
	int unit;
	int chd_status;
	char identifier[32],stat[32],vol[32];
	int slot,arg,den,phys;
	char list_item[80];
	char *chd_line;
	XmString item;
	int list_pos = 1;
	int field_no = 0;

	chd_cmd("query all");

#ifdef DEBUG
	fprintf(stderr,"entering build_list\n");
	while ( match[field_no].search_key != NULL) {
	      fprintf( stderr,"   key = %d, value = %s\n",
		match[field_no].search_key,match[field_no].value);
		field_no++;
	   }
	fprintf( stderr,"   key = NULL\n");
#endif

	do {
	   field_no = 0;
	   if ((chd_status = chd_stat(FALSE,FALSE)) < 400) {
	    chd_line = get_chd_line(FALSE);
	    sscanf(chd_line,"%s",identifier);
#ifdef DEBUG
	fprintf(stderr,"identifier = >%s<, looking for >%s<\n",
		identifier,type);
#endif
	     if (strcmp(identifier,type) == 0) {
#ifdef DEBUG
	fprintf(stderr,"found identifier ; scan line into chd_line buffer\n");
#endif
	      sscanf(chd_line+strlen(identifier),
		"%d Unit %d Arg %d Den %d Phys %d Stat %s Vol %s",
		&slot,&unit,&arg,&den,&phys,stat,vol);
	      while ( match[field_no].search_key != NULL) {
#ifdef DEBUG
	fprintf(stderr,"perform action for search key %d with value %s; chd_line =  %s\n",
		match[field_no].search_key,match[field_no].value,chd_line);
#endif
	      switch ( match[field_no].search_key ) {
		case ENTRY_STAT:
	          if (strcmp(stat,match[field_no].value) == 0) {
#ifdef DEBUG
	            fprintf(stderr,"build_list: widget=%s\n",XtName(list));
	            fprintf(stderr,
			" %2d      %2d      %2d      %d      %d    %8s  %-16s",
			slot,unit,arg,den,phys,stat,vol);
#endif
	            sprintf(list_item,
			" %2d      %2d      %2d      %d      %d    %8s  %-16s",
			slot,unit,arg,den,phys,stat,vol);
	            item = XmStringCreateLtoR(&list_item[0],
			XmSTRING_DEFAULT_CHARSET);
    	            XmListAddItem(list,item,list_pos);
	            XmStringFree(item);
		    }
		  break;
		default:
		  break;
		}
		field_no++;
		}
	      }
	    XtFree(chd_line);
	    }
	   else
	     chd_response(TRUE,TRUE);

	   list_pos++;
	   } while (chd_status != 285);
}
