/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <Xm/Xm.h>
#include <sys/ioctl.h>

#define MAXBUFLEN 256

int buffered_bytes = NULL;
char buffer[MAXBUFLEN];

int chd_getpiece(string,delimiter)
char *string;
char delimiter;
{
	int i,j,nbytes,bytes_read;
	char *indx;
	
#ifdef DEBUG
	fprintf(stderr,"chd_getpiece: delimiter = '%02x'\n",delimiter);
#endif

	do {
	if ((indx=strchr(buffer,(int) delimiter)) != NULL) {
	  strncpy(string,buffer,indx-buffer);
	  string[indx-buffer] = '\0';
	  for (i=0,indx++; indx<buffer+buffered_bytes; i++, indx++) {
	     buffer[i] = *indx;
	     }
	  buffered_bytes -= strlen(string) + 1;
	  buffer[buffered_bytes] = '\0';
	  return((int) strlen(string));
	  }
	else {
	  if (data_to_be_read(fileno(stdin))) {
	    ioctl(fileno(stdin),FIONREAD,&nbytes);
#ifdef DEBUG
	    fprintf(stderr,"buffered bytes = %d, reading %d\n",
		buffered_bytes,MAXBUFLEN-buffered_bytes);
#endif
	    bytes_read = read(fileno(stdin),&buffer[buffered_bytes],MAXBUFLEN-buffered_bytes);
#ifdef DEBUG
	    fprintf(stderr,"%d bytes actually read (",bytes_read);
	    for (i=0; i<bytes_read; i++) {
	      fprintf(stderr,"%c",(char)(buffer[buffered_bytes+i]));
	      }
	    fprintf(stderr,")\n");
#endif
	    if (bytes_read < 0) return((int) NULL);
	    buffered_bytes += bytes_read;
	    }
	  else
	    return((int) NULL);
	  }
	  } while (indx == NULL);
}
int chd_getcode(code)
int *code;
{
	char codestr[4];	
	*code = 0;
	if (chd_getpiece(codestr,' ') != NULL) {
	  *code = atoi(codestr);
#ifdef DEBUG
	  {int i; 
	  fprintf(stderr,"chd_getcode: codestr = ");
	  for (i=0; i<4; i++) fprintf(stderr,"%c",codestr[i]);
	  fprintf(stderr,"\n");}
	  fprintf(stderr,"chd_getcode returning %d\n",*code);
#endif
	  return(*code);
	  }
	else
	  return((int) NULL);
}
int chd_getstring(string)
char *string;
{
	int status;
	string[0] = '\0';
	status = chd_getpiece(string,'\n');
#ifdef DEBUG
	fprintf(stderr,"chd_getstring:\n>%s<\n",string);
#endif
	return(status);
}
