/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <global.h>
#include <stropts.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>

int chd_status = 0;

int chd_stat(echo,flush)
Boolean echo,flush;
{
        Boolean data_to_be_read();
	int i = 0;
	char chd_char;
	char action[12];
	char status_string[2048];
	
#ifdef DEBUG
	fprintf(stderr,"chd_stat...\n");
#endif
/*
  This maps a busy cursor to all of the dialog windows and the main panel
*/
	if (dpy != NULL) {
	  for (i=0; i<NUMBER_OF_BUSY_WINS; i++)
	    if (*(busy_win+i) != NULL) XMapRaised(dpy,*(busy_win+i));
	  XmUpdateDisplay(chd_stat_text);
	  }

	do {
	 chd_getcode(&chd_status);
	 sprintf(&status_string[0],"%d ",chd_status);

	 if (chd_status != NULL) {
	   if (echo) {
	     XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),
		status_string);
	     XmTextShowPosition(chd_stat_text,
		XmTextGetLastPosition(chd_stat_text)-1);
	     XmUpdateDisplay(chd_stat_text);
	     }

	    XmTextInsert(history_text,XmTextGetLastPosition(history_text),
		status_string);
  	    XmTextShowPosition(history_text,
		XmTextGetLastPosition(history_text)-1);
	    XmUpdateDisplay(history_text);
	    }

/*
  310 is the "Waiting for Lock" condition; if received, eat the message and
  keep trying to get a valid code. A code of 410 says that service is 
  unavailable, so we abandon hope at that point.
*/

	 if (chd_status == 310) chd_response(TRUE,FALSE);

	 if (chd_status == 410) {
	   chd_response(TRUE,FALSE);
	   if (dpy != NULL) {
	     for (i=0; i<NUMBER_OF_BUSY_WINS; i++)
		if (*(busy_win+i) != NULL) XUnmapWindow(dpy,*(busy_win+i));
	     }
	   return(chd_status);
	   }
	} while ((chd_status == NULL) || (chd_status == 310));

/*
  flush says that we don't care about the responses, so we can just 
  read them out and place them in history text.
*/
	if (flush) chd_response(echo,flush);

	if (dpy != NULL) {
	  for (i=0; i<NUMBER_OF_BUSY_WINS; i++)
	    if (*(busy_win+i) != NULL) XUnmapWindow(dpy,*(busy_win+i));
	  }

	return(chd_status);
}
void chd_response(echo,flush)
Boolean echo;
Boolean flush;
{
	char chd_char;
	char status_string[120];
#ifdef DEBUG
fprintf(stderr,"chd_response (echo = %s, flush=%s)\n",
  ( echo ) ? "TRUE" : "FALSE",
  ( flush ) ? "TRUE" : "FALSE");
#endif


	do {
	  if ( chd_getstring(status_string) != NULL) {

	    if (echo) {
	      XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),
		status_string);
	      XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),
		"\n");
	      XmTextShowPosition(chd_stat_text,
		XmTextGetLastPosition(chd_stat_text)-1);
	      XmUpdateDisplay(chd_stat_text);
	      }

	    XmTextInsert(history_text,XmTextGetLastPosition(history_text),
		status_string);
	    XmTextInsert(history_text,XmTextGetLastPosition(history_text),
		"\n");
	    XmTextShowPosition(history_text,
		XmTextGetLastPosition(history_text)-1);
	    XmUpdateDisplay(history_text);
	    }
	  else
	    return;
	  } while (flush);

}
/*
 *   data_to_be_read() - Check to see if a read of the specified file 
 *	would block.
 *
 *   Returns:
 *        FALSE, if read would block
 *        TRUE, if read would not block
 */

Boolean
data_to_be_read(fd)
   int fd;                       /* File descriptor */
{
	int nfound;              /* Number of ready descriptors */
	fd_set readfds;               /* Read file descriptors bit mask */
	struct timeval timeout;
	int sync=1;		/* set asynchronous I/O */
	int bytes=0;		/* return number of available bytes */

	FD_ZERO(&readfds);
	FD_SET(fd, &readfds);

	timeout.tv_sec = 0;      /* Cause select to return immediately */
	timeout.tv_usec = 0;

#ifdef DEBUG
	fprintf(stderr,"file descriptors in set: ");
	for (nfound=0; nfound < FD_SETSIZE; nfound++) {
	  if (FD_ISSET(nfound,&readfds) != 0 ) fprintf(stderr," %d",nfound);
	  }
#endif
/*
	ioctl(fd,FIOASYNC,&sync);
	fsync(fd);
*/
	ioctl(fd,I_FLUSH,FLUSHRW);
#ifdef DEBUG
	ioctl(fd,FIONREAD,&bytes);
	fprintf(stderr," ; bytes = %d",bytes);
	{
	struct stat fd_stat_buf;
	fstat(fd,&fd_stat_buf);
	fprintf(stderr,"preferred block size for fd %d = %d\n",fd,fd_stat_buf.st_blksize);
	}
#endif
	while
         ((nfound = select(FD_SETSIZE, &readfds, NULL, NULL, &timeout)) == -1)
	  {
		if (errno == EINTR)
			continue; /* Ignore interrupts */

		fprintf(stderr, "select() failed, errno = %d\n", errno);
		exit(1);
	  }
	return((Boolean) (nfound > 0));
}
char *get_chd_line(echo)
Boolean echo;
{
	char chd_char;
	char *status_string;

	status_string = (char *) XtMalloc(256);

	chd_getstring(status_string);

	if (echo) {
	  XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),
		status_string);
	  XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),
		"\n");
	  XmTextShowPosition(chd_stat_text,
		XmTextGetLastPosition(chd_stat_text)-1);
	  XmUpdateDisplay(chd_stat_text);
	  }

	XmTextInsert(history_text,XmTextGetLastPosition(history_text),
		status_string);
	XmTextInsert(history_text,XmTextGetLastPosition(history_text),
		"\n");
	XmTextShowPosition(history_text,
		XmTextGetLastPosition(history_text)-1);
	XmUpdateDisplay(history_text);
	status_string = (char *) realloc(status_string,strlen(status_string)+1);
	return(status_string);
}
void chd_cmd(cmd)
char *cmd;
{
/* added this to flush out chd responses which may have been delayed */

	while (data_to_be_read(fileno(stdin))) {
	    chd_response(FALSE,FALSE);
	    }

#ifdef DEBUG
	fprintf(stderr,"to chd: %s\n",cmd);
#endif
	fprintf(stdout,"%s\n",cmd);
	fflush(stdout);

	XmTextInsert(history_text,XmTextGetLastPosition(history_text),
		">>");
	XmTextInsert(history_text,XmTextGetLastPosition(history_text),
		cmd);
	XmTextInsert(history_text,XmTextGetLastPosition(history_text),
		"\n");

	XtVaSetValues (history_text, XmNcursorPosition, 
		XmTextGetLastPosition(history_text), NULL);
	XtManageChild(history_text);
	XmTextShowPosition(history_text, XmTextGetLastPosition(history_text)-1);
	XmUpdateDisplay(history_text);
}

