/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<errno.h>
#include	<string.h>
#include	<strings.h>
#include	<fcntl.h>
#include	<sys/termios.h>
#include	<sys/types.h>
#include	<sys/mtio.h>
#include	<sys/uio.h>
#include	<sys/time.h>

#define		FALSE	0
#define		TRUE	1

#define		MAX_TAPE_RETRIES	10
#define		CYCLE_TIMEOUT		10

int
check_door(device)
char	*device;
	{
	char		array[256];
	int		irc = 10, times = 0, id, sleep();
	struct mtop	mt_command;

	mt_command.mt_op = MTOFFL;
	mt_command.mt_count = 1;

	for (times = MAX_TAPE_RETRIES; times > 0; times--)
		if ((id = open(device, O_RDONLY)) < 0) {
#ifdef	TRIAL_RUN
			(void) sprintf(array,
				"Chk %d Err %d",
				times, errno);
			post_msg(396, array);
#endif
			sleep(CYCLE_TIMEOUT);
			}
		else	{
			(void) close(id);
			irc = 0;
			break;
			}

	return (irc == 0 ? TRUE : FALSE);
	}

