/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef	LIST_H
#define	LIST_H
/*
**	application support for list handling
*/
#include <usystype.h>

typedef	VPTR	LIST;
LIST	ls_new();
void	ls_dispose();
long	ls_addl();
long	ls_addp();
long	ls_getl();
long	ls_getlx();
VPTR	ls_getp();
VPTR	ls_getpx();
void	ls_delid();
long	ls_len();
long	ls_type();
int	ls_isl();
int	ls_isp();
long	ls_idof();
LIST	ls_parentof();
VPTR	ls_unique();
long	ls_myid();
int	ls_hasid();

#define	ITEM_LONG	((long)(1))
#define	ITEM_POINTER	((long)(2))

#define	LSNEW(parent,itype,ltype,unique) \
					(ls_new( (VPTR)(parent), \
					(long)(itype), (long)(ltype), \
					(VPTR)(unique)) )
#define	LSDISPOSE(list)			(ls_dispose((VPTR)(list)))
#define	LSADDL(list,itemid,lval)	(ls_addl( (VPTR)(list), \
					(long)(itemid), (long)(lval)) )
#define	LSADDP(list,itemid,pval)	(ls_addp( (VPTR)(list), \
					(long)(itemid), (VPTR)(pval)) )
#define	LSGETL(list,itemid)		(ls_getl( (VPTR)(list), (long)(itemid)))
#define	LSGETLX(list,index)		(ls_getlx( (VPTR)(list), (long)(index)))
#define	LSGETP(list,itemid)		(ls_getp( (VPTR)(list), (long)(itemid)))
#define	LSGETPX(list,index)		(ls_getpx( (VPTR)(list), (long)(index)))
#define	LSDELID(list,itemid)		(ls_delid((VPTR)(list),(long)(itemid)))
#define	LSLEN(list)			(ls_len( (VPTR)(list) ))
#define	LSTYPE(list)			(ls_type( (VPTR)(list) ))
#define	LSISL(list)			(ls_isl( (VPTR)(list) ))
#define	LSISP(list)			(ls_isp( (VPTR)(list) ))
#define	LSIDOF(list,index)		(ls_idof( (VPTR)(list), (long)(index)))
#define	LSPARENTOF(list)		(ls_parentof((VPTR)(list)))
#define	LSUNIQUE(list)			(ls_unique((VPTR)(list)))
#define	LSMYID(list)			(ls_myid((VPTR)(list)))
#define	LSHASID(list,itemid)		(ls_hasid( (VPTR)(list), (long)(itemid)))

#endif
