/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
 **	Ccincl main file.
 **
 **	3/17/89	    mls	renamed std.h -> cakestd.h
 **			added  -opath  which changes the filename.x:
 **		    	part of the -f output to path/filename.o:
 **			also causes -opath to turn off error returns.
 **
 **	3/30/89	    mls	added support so that -opath output would name
 **			the command line file that precipitated the
 **			search despite intermediate includes.
 **
 **	3/06/92	    jmw	changed typing of index variable in process 
 **			routine to int from bool. sign bit was getting
 **			set when index hit 128. this didn't jive with
 **			the fact that MAXFILES is 1024.
 */

static	char
    rcs_id[] = "$Header$";

#include	<ctype.h>
#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	"cakestd.h"

typedef	struct	stat	Stat;

#define	MAXDIRS		64
#define	MAXSTOPS	64
#define	MAXIGNORES	64
#define	MAXFILES	1024
#define	MAXBUF		2048

char	*dir_list[MAXDIRS];
char	*stop_list[MAXSTOPS];
char	*ign_list[MAXIGNORES];
char	*file_list[MAXFILES];
bool	search_list[MAXFILES];
ino_t	ino_list[MAXFILES];
int	dircount = 0;
int	stopcount = 0;
int	igncount = 0;
int	filecount = 0;
int	initialfiles	=   0;	    /* MLS TRC number of command line files */
char	*original_file[MAXFILES];   /* MLS TRC target for current dependency */
int	altersuffix = 0;
char	*alterprefix = NULL;

char	*currdir = ".";
char	*filename;
char	*targetfilename;	    /* MLS TRC name of target file for -o */
int	filenameindex;		    /* MLS TRC index of current filename */
Stat	statbuf;
int	rflag = FALSE;
int	fflag = FALSE;
int	vflag = FALSE;
int	errorcount = 0;

main(argc, argv)
int	argc;
char	**argv;
{
    extern FILE    *yyin;
    reg int         i;
    
    dir_list[dircount++] = ".";
    while (argc > 1 && argv[1][0] == '-') {
	for (i = 1; argv[1][i] != '\0'; i++) {
	    switch (argv[1][i]) {
	      case 'f':
		fflag = TRUE;
		break;
	      case 'o':
		altersuffix = TRUE;
		alterprefix = &argv[1][2];
		fflag = TRUE;
		goto nextword;
		break;
	      case 'r':
		rflag = TRUE;
		break;
	      case 'v':
		vflag = TRUE;
		break;
	      case 'i':
		if (i != 1)
		    usage();
		
		ign_list[igncount++] = &argv[1][2];
		file_list[filecount] = &argv[1][2];
		
		if (stat(&argv[1][2], &statbuf) != 0) {
		    fprintf(stderr,
			    "ccincl: cannot find %s\n",
			    &argv[1][2]);
		    exit(1);
		} /* if */
		
		search_list[filecount] = FALSE;
		ino_list[filecount] = statbuf.st_ino;
		filecount++;
		goto nextword;
		break;
	      case 's':
		if (i != 1)
		    usage();
		
		stop_list[stopcount++] = &argv[1][2];
		file_list[filecount] = &argv[1][2];
		
		if (stat(&argv[1][2], &statbuf) != 0) {
		    fprintf(stderr, "ccincl: cannot find %s\n", &argv[1][2]);
		    exit(1);
		} /* if */
		
		search_list[filecount] = FALSE;
		ino_list[filecount] = statbuf.st_ino;
		filecount++;
		goto nextword;
		break;
	      case 'C':
		if (i != 1)
		    usage();
		
		currdir = &argv[1][2];
		goto nextword;
		break;
	      case 'I':
		if (i != 1)
		    usage();
		
		dir_list[dircount++] = &argv[1][2];
		goto nextword;
		break;
	      default:
		usage();
	    } /* switch */
	} /* for */
	
      nextword:
	argc--;
	argv++;
    } /* while */
    
    dir_list[dircount++] = "/usr/include";
    if (dircount > MAXDIRS) {
	fprintf(stderr, "ccincl: too many dir_list.\n");
	exit(1);
    } /* if */
    
    if (argc < 2)
	usage();
    
    while (argc > 1) {
	file_list[filecount] = argv[1];
	if (stat(argv[1], &statbuf) != 0) {
	    fprintf(stderr, "ccincl: cannot find %s\n", argv[1]);
	    exit(1);
	} /* if */
	
	search_list[filecount] = TRUE;
	ino_list[filecount] = statbuf.st_ino;
	original_file[initialfiles++] = NULL;	/* MLS TRC */
	filecount++;
	argc--;
	argv++;
    } /* while */
    
    for (i = 0; i < filecount; i++) {
	if (!search_list[i])
	    continue;
	
	filename = file_list[i];
	/*
	 **  MLS TRC aaded support for remembering command line file that
	 **  triggered the current search.
	 */
	if(i < initialfiles)
	    targetfilename = filename;
	else
	    targetfilename = original_file[i];
	filenameindex = i;
	if(vflag)
	    fprintf(stderr, "verbose: scanning %s\n", filename);
	
	if ((yyin = fopen(filename, "r")) == NULL) {
	    fflush(stdout);
	    perror("ccincl");
	    fprintf(stderr, "ccincl: cannot open %s\n", filename);
	    exit(1);
	} /* if */
	
	yylex();
	fclose(yyin);
    } /* for */
    
    exit(altersuffix ? 0 : errorcount);
} /* main */

/*
 **  return a pointer to static space holding the filename with
 **  its suffix (if any) changed to 'o'.  names with no suffix or
 **  which are all suffix are an error.
 */
#define CHARLENGTH  1025
static char *alteredfilename(name)
char *name;
{
    static char     t[CHARLENGTH];
    long            i;
    
    if ((strlen(name) + strlen(alterprefix) + 1 + 1) > CHARLENGTH) {
	fprintf(stderr, "ccincl: name too long.\n");
	exit(1);
    } /* if */
    if (alterprefix != NULL) {
	strcpy(t, alterprefix);
	strcat(t, "/");
    } /* if */
    strcat(t, name);
    for (i = strlen(t) - 1; i > 0; i--)
	if (t[i] == '.') {
	    t[i + 1] = 'o';
	    t[i + 2] = '\0';
	    return t;
	} /* if */
    fprintf(stderr, "ccincl: \"%s\" not a good sufficed name.\n", name);
    exit(1);
    return t;
} /* alteredfilename */

process(line)
reg	char	*line;
{
    extern char	*malloc();
/*    extern int	yylineno; */
    char	buf[MAXBUF];
    reg char	*s, *start;
    reg int	i, startdir;
    reg int	index;		/* changed from bool - j.m.wade 92066 */
    reg char	endchar;
    reg bool	found;
    
    for (s = line + 1; *s != '\0' && isspace(*s); s++)
	;
    
    if (strndiff(s, "include", 7))
	return;
    
    for (s += 7; *s != '\0' && isspace(*s); s++)
	;
    
    if (*s == '<')
	endchar = '>', startdir = 1;
    else
	endchar = '"', startdir = 0;
    
    start = s + 1;
    for (s = start; *s != '\0' && *s != endchar; s++)
	;
    
    if (*s != endchar) {
	fprintf(stderr,
/*
		"ccincl: file %s(%d)\nbad include syntax\n\n     %s\n\n",
		filename, yylineno, (char *)line);
*/
		"ccincl: file %s\nbad include syntax\n\n     %s\n\n",
		filename, (char *)line);
	errorcount++;
	return;
    } /* if */
    
    /* terminate arg (now pointed to by start) */
    *s = '\0';
    
    /* handle absolute pathnames */
    if (*start == '/') {
	sprintf(buf, "%s", start);
	goto end;
    } /* if */
    
    /* handle relative pathnames */
    if (*start == '.') {
	sprintf(buf, "%s/%s", currdir, start);
	goto end;
    } /* if */
    
    /* handle implicit pathnames */
    found = FALSE;
    for (i = startdir; i < dircount; i++) {
	if (i == 0) {
	    if (streq(currdir, "."))
		strcpy(buf, "");
	    else {
		strcpy(buf, dir_list[i]);
		strcat(buf, "/");
	    } /* else */
	    
	    strcat(buf, start);
	} /* if */
	else {
	    strcpy(buf, dir_list[i]);
	    strcat(buf, "/");
	    strcat(buf, start);
	} /* else */
	
	if (strlen(buf) > MAXBUF) {
	    fprintf(stderr, "ccincl: buffer length exceeded\n");
	    exit(1);
	} /* if */
	
	if (stat(buf, &statbuf) == 0) {
	    found = TRUE;
	    break;
	} /* if */
    } /* for */
    
    if (!found) {
/*
   Because this program doesn't handle #ifdefs which may contain include
   statements for header files which aren't actually used, this message
   just confuses people ; go ahead and let the compiler complain

	fprintf(stderr, "ccincl: cannot find %s\n", start);
*/
	errorcount++;
	return;
    } /* if */
    
  end:
    if (stat(buf, &statbuf) != 0) {
	fprintf(stderr, "ccincl: cannot stat %s\n", buf);
	errorcount++;
	return;
    } /* if */
    
    found = FALSE;
    for (i = 0; i < filecount; i++)
	if (ino_list[i] == statbuf.st_ino) {
	    found = TRUE;
	    index = i;
	    break;
	} /* if */
    
    if (!found) {
	index = filecount;
	ino_list[filecount] = statbuf.st_ino;
	search_list[filecount] = FALSE;
	file_list[filecount] = malloc(strlen(buf) + 1);
	strcpy(file_list[filecount], buf);
	
	if(filenameindex < initialfiles)
	    original_file[filecount] = filename;
	else
	    original_file[filecount] = original_file[filenameindex];
	
	filecount++;
    } /* if */
    
    for (i = 0; i < igncount; i++)
	if (streq(file_list[index], ign_list[i]))
	    return;
    
    if (altersuffix)
	printf("%s: ", alteredfilename(targetfilename));
    else if (fflag)
	printf("%s: ", filename);
    
    printf("%s\n", file_list[index]);
    
    if (rflag && !found) {	/* MLS TRC added "&& !found" */
	for (i = 0; i < stopcount; i++)
	    if (streq(buf, stop_list[i]))
		return;
	search_list[filecount - 1] = TRUE;  /* TRC MLS added "-1" */
    } /* if */
} /* process */

/*
 **	Tell the unfortunate user how to use ccincl.
 */

usage()
{
    fprintf(stderr,
	    "Usage: ccincl [-rf] [-ifile] [-sfile] [-Cdir] [-Idir] ... file ...\n");
    exit(1);
} /* usage */
