/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include "symname.h"
#ifdef SOLARIS
#include <unistd.h>
#endif
#include <cu.h>
#include <pwd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
    /*
     ** takes as a command line argument the path of the
     ** file to be checked,
     ** returns the path name of the file under ~trcgp
     ** if appropriate.

     **
     ** added some code to open up a .symname file under the user's
     ** home directory and, if one exists, the files i-nodes are looked
     ** up to match against the specified directory. In this manner, the
     ** names of sym-linked files may be put into this file to enable the
     ** links to be followed. Note that the directory names in this file
     ** must start with the specified root path to match. - j.m.wade 7/27/93
     **
     */
int DEBUG = 0;
char *progname;

int main(argc, argv)
int argc;
char **argv;
{
    int  c, copy_num, done, i, errno, found_one, getopt(), offset, stat();
    char *final_path, *index_ptr, *malloc(), *new_path, *path,
    sym_true_name[256], true_name[256], *symfile_list, symfile[1024];
    void debug();
    struct stat buf, lbuf;
    struct passwd *pwdtable;
    FILE *symfiles;
    int symfile_count;
    struct afile *local_shortlist = NULL;
    extern char *optarg;
    extern int  optind;
    
    progname=argv[0];
    while((c=getopt(argc, argv,"dh"))!= -1)
	switch(c){
	  case 'd':
	    DEBUG = 1;
	    break;
	  case 'h':
	  case '?':
	    cuerror(-1,"usage: %s [-d] path\n", progname);
	} /* switch */
    if(optind == argc)
	cuerror(-1, "usage: %s [-d] path\n", progname);
    
    /* initialize known links */
    for(i=0; i < NumFiles; i++) {
	if(stat(shortlist[i].name, &buf) == -1) {
	    fprintf(stderr, "%s: stat returned -1 on name \"%s\"\n",
		    progname, shortlist[i].name);
	    perror(progname);
	/*  exit(-1); - changed to keep going - jmw 01/29/90 */
	} /* if */
	else {
	shortlist[i].inode = buf.st_ino;
	debug("init: %s has inode %d\n", shortlist[i].name,shortlist[i].inode);
	}
    } /* for */
    
    pwdtable = getpwuid(getuid());
    symfile_list = (char *) malloc(strlen(pwdtable->pw_dir) + 10);
    if (symfile_list == NULL) {
	fprintf(stderr, "%s: unable to malloc space looking for %s in %s\n",
	   ".symname", pwdtable->pw_dir);
	}
    else {
	strcpy(symfile_list,pwdtable->pw_dir);
	strcat(symfile_list,"/.symname");
	}
/*
    sprintf(symfile_list,"%s/.symname",pwdtable->pw_dir);
*/
    if ((stat(symfile_list,&buf) == 0) && (S_ISREG(buf.st_mode))) {
        symfiles = fopen(symfile_list,"r");
	while (fscanf(symfiles,"%s",symfile) != EOF) {
/*
 - allow for commented lines
*/
	  if (strncmp(symfile,"#",1) != 0) {
    	    if (stat(symfile,&buf) == -1) {
	      fprintf(stderr, "%s: stat returned -1 on name \"%s\"\n",
		    progname, symfile);
	      perror(progname);
	      }
	    else {
	      if (local_shortlist == NULL) {
		local_shortlist = (struct afile *) malloc(sizeof(struct afile));
		symfile_count = 1;
		}
	      else {
	        symfile_count++;
	        local_shortlist = (struct afile *)
		  realloc(local_shortlist, symfile_count*sizeof(struct afile));
		}
	      local_shortlist[symfile_count-1].inode = buf.st_ino;
	      local_shortlist[symfile_count-1].name  = (char *)
		malloc((strlen(symfile)+1) * sizeof(char));
	      strcpy(local_shortlist[symfile_count-1].name,symfile);
	      }
	    }
	  else
	    while(fgetc(symfiles) != '\n');
	  }
      }

    for(;optind< argc; optind++){
	found_one = 0;
	done = 0;
	path=argv[optind];
	debug("path      = %s\n", path);
	offset = strlen(path);
	new_path  = strdup(path);
	index_ptr = malloc(sizeof(path) +1);
	do{
	    if(access(new_path, F_OK) == -1){
		fprintf(stderr,"%s: can't access file %s\n",progname,new_path);
		perror(progname);
		exit(-1);
	    } /* if */
	    debug("call stat\n");
	    if(stat(new_path, &buf) == -1){
		fprintf(stderr,"%s: stat returned -1\n", progname);
		perror(progname);
		exit(-1);
	    } /* if */
	    debug("\tinode of %s is %d\n", new_path, buf.st_ino);
	    for(i=0; i<NumFiles && !found_one; i++) {
		debug("\tsearching: list inode = %d\n", shortlist[i].inode);
		if(buf.st_ino == shortlist[i].inode){
		    final_path=malloc(strlen(shortlist[i].name) + 
				      strlen(path+offset) + 1);
		    strcpy(final_path, shortlist[i].name);
		    debug("\tfinal_path root: >>%s<<\n", final_path);
		    debug("\tappending >>%s<<\n", path+offset);
		    strcat(final_path, path+offset);
		    debug("\tfinal_path is: %s\n", final_path);
		    if((realpath(final_path, sym_true_name) != (int)NULL) &&
		       (realpath(path, true_name) != (int)NULL) &&
		       (strcmp(sym_true_name, true_name) == 0)){
			debug("\t\ttrue_name = %s\n", true_name);
			found_one=1;
			printf("%s\n", final_path);
		    } /* if */
		    else
			debug("\t\tnot a valid path\n");
		} /* if */
	      } /* for */
	    for(i=0; i<symfile_count && !found_one; i++) {
		debug("\tsearching: list inode = %d\n", local_shortlist[i].inode);
		if(buf.st_ino == local_shortlist[i].inode){
		    final_path=malloc(strlen(local_shortlist[i].name) + 
				      strlen(path+offset) + 1);
		    strcpy(final_path, local_shortlist[i].name);
		    debug("\tfinal_path root: >>%s<<\n", final_path);
		    debug("\tappending >>%s<<\n", path+offset);
		    strcat(final_path, path+offset);
		    debug("\tfinal_path is: %s\n", final_path);
		    if((realpath(final_path, sym_true_name) != (int)NULL) &&
		       (realpath(path, true_name) != (int)NULL) &&
		       (strcmp(sym_true_name, true_name) == 0)){
			debug("\t\ttrue_name = %s\n", true_name);
			found_one=1;
			printf("%s\n", final_path);
		    } /* if */
		    else
			debug("\t\tnot a valid path\n");
		} /* if */
	      } /* for */
	    if(!found_one) {
		debug("changing new_path from: \n");
		debug("\tnew_path  = %s\n", new_path);
		debug("by dropping index_ptr = %s\n", index_ptr);
		copy_num= (int)(index_ptr-new_path);
		offset=copy_num;
		strncpy(new_path, path, copy_num);
		new_path[copy_num] = '\0';
		debug("to get: new_path = %s\n", new_path);
		if ((index_ptr = strrchr(new_path,'/')) == NULL) done = 1;
	    } /* if */
	    debug("\n\n");
	} while(!found_one && !done);
	if(!found_one)
	    printf("%s\n", path);
    } /* for */
} /* main */
