/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <strings.h>

/* ---------------------------------------------------------------- */

/*   I only put my name here because I didn't want to be
         accused of being a spineless slime by not giving
         people someone to bitch at when this stuff
         doesn't work.  Not all of the original argsys
         stuff is here but the important routines are
         and they include:
                 argi4()
                 argi8()
                 argr4()
                 argr8()
                 argstr()
                 argis()
         Also, you will notice if you have to maintain
         this code that all these functions look very
         similar.  This was the quickest and easiest
         way to do these functions.  A better and more
         compact version could be made by having one
         generic arg getting function that accepted one
         more parameter - that being the kind of arg
         to look for (int, float, char *, etc.).
         Someone could fix this but this stuff does
         work.
                Rick Cook       1-11-90
*/
/*
	Fixed minor error concerning allocation of new argv list
	and put in error checks for possible malloc failures
		joe m. wade	5-17-91
*/
/*
	Fixed major error concerning allocation of new argv list.
	ie. don't do it!!! The code where Rick freed the original
	argument strings was causing abortions. I now just play
	with the original list. At the same time, I have changed
	the code so that the original argv pointer is expected
	as input rather than &argv. This is compatible with all
	the standard routines utilizing the argv pointer.
		joe m. wade	6-14-91
*/
/*
	Change C_ARGSTR routine so that the character string passed
	in for receipt of the argument is null, strdup() will be
	called to get a new variable and that address will be passed
	back to the calling routine via the return() call.

	ie. newvalue = C_ARGSTR("-N",NULL," "," ",&argc,argv);

		joe m. wade	8-25-00
*/

#define TRUE 1
#define FALSE 0

/*
   argstr - returns the argument that immediately
            follows flag (close bindings).  If flag
            exists but no argument is specified, argstr
            returns default1 in answer.  If flag does not
            exist, then argstr returns default2
            in answer.
*/

char *argstr_c(flag, answer, default1, default2, argc, argv)
char *flag, *answer, *default1, *default2, **argv;
int *argc;
{
  int i, j = 0, flag_found =0;
  char *strdup();
  
				/* loop thru the arguments looking 
				   for the right flag */
  for (i=0; i<*argc; i++) {
    if( !strncmp(flag,argv[i],strlen(flag))) {
      flag_found=1;
	  
				/* we have found the flag but
				   do we have an argument */
      if ( strlen(argv[i]) == strlen(flag) ) {
	if (i+1 == *argc) {
	  if (answer == NULL)
		answer = strdup(default1);
	  else
		strcpy(answer,default1);
	}
	else {
	  if (argv[i+1][0]!='-') { /* Don't have a '-' must be an argument. */
	    if (answer == NULL)
	      answer = strdup(argv[i+1]);
	    else
	      strcpy( answer,argv[i+1]);
	    flag_found=2;
	  } else {
	    if (isdigit(argv[i+1][1])) { /* Check for "-1..." for argument. */
	      if (answer == NULL)
	        answer = strdup(argv[i+1]);
	      else
	        strcpy( answer,argv[i+1]);
	      flag_found=2;
	    } else {
	      if (answer == NULL)
	        answer = strdup(default1);
	      else
	        strcpy( answer,default1);
	    }
	  }
	}
      } else {
	if (answer == NULL)
	  answer = strdup(argv[i]+strlen(flag));
	else
	  strcpy(answer,argv[i]+strlen(flag));
      }
      break;
    }
  }
  
				/* if we found the flag then decrease the 
				   number of args and take one or two 
				   element out of the argv list. */
  if (flag_found!=0) {
    (*argc)-=flag_found;
    for ( j=i; j<*argc; j++)
      argv[j] = argv[j+flag_found];
    argv[*argc] = '\0';
  } else {
    if (answer == NULL)
      answer = strdup( default2 );
    else
      strcpy( answer, default2 );
  }
  
  return( answer );
}

/* ------------------------------------------------------------- */

/*
   
    argi4 - same as argstr except we do atoi to get the argument

*/

int argi4_c(flag, answer, default1, default2, argc, argv)
char *flag, **argv;
int *argc, *answer, default1, default2;
{
  int i, j = 0, flag_found = FALSE;
  
  /* loop thru the arguments looking for the right flag */
  
  for (i=0; i<*argc; i++) {
    if( !strncmp( flag, argv[i], strlen(flag)) ) {
      flag_found = 1;
	  
				/* we have found the flag but
				   do we have an argument */
      if ( strlen(argv[i]) == strlen(flag) ) {
	if (i+1 == *argc) {
	  *answer = default1;
	}
	else {
	  if (argv[i+1][0]!='-') { /* Don't have a '-' must be an argument. */
	    *answer = atoi( argv[i+1]);
	    flag_found=2;
	  } else {
	    if (isdigit(argv[i+1][1])) { /* Check for "-1..." for argument. */
	     *answer = atoi( argv[i+1]);
	     flag_found=2;
	    } else {
	      *answer = default1;
	    }
	  }
	}
      } else {
	*answer = atoi( argv[i]+strlen(flag) );
      }
      break;
    }
  }
  
  /* if we found the flag then decrease the number of args
     and take one element out of the argv list		*/
  
  if (flag_found!=0) {
    (*argc)-=flag_found;
    for ( j=i; j<*argc; j++)
      argv[j] = argv[j+flag_found];
    argv[*argc] = '\0';
  } else {
    *answer = default2;
  }
  
  return( *answer );
}

/* ------------------------------------------------------------- */

/*
   
    argi8 - same as argi4 except we do atol to get the argument and
    use long variables

*/

long argi8_c(flag, answer, default1, default2, argc, argv)
char *flag, **argv;
int *argc;
long *answer, default1, default2;
{
  int i, j = 0, flag_found = FALSE;
  
  /* loop thru the arguments looking for the right flag */
  
  for (i=0; i<*argc; i++) {
    if( !strncmp( flag, argv[i], strlen(flag)) ) {
      flag_found = 1;
	  
				/* we have found the flag but
				   do we have an argument */
      if ( strlen(argv[i]) == strlen(flag) ) {
	if (i+1 == *argc) {
	  *answer = default1;
	}
	else {
	  if (argv[i+1][0]!='-') { /* Don't have a '-' must be an argument. */
	    *answer = atol( argv[i+1]);
	    flag_found=2;
	  } else {
	    if (isdigit(argv[i+1][1])) { /* Check for "-1..." for argument. */
	     *answer = atol( argv[i+1]);
	     flag_found=2;
	    } else {
	      *answer = default1;
	    }
	  }
	}
      } else {
	*answer = atol( argv[i]+strlen(flag) );
      }
      break;
    }
  }
  
  /* if we found the flag then decrease the number of args
     and take one element out of the argv list		*/
  
  if (flag_found!=0) {
    (*argc)-=flag_found;
    for ( j=i; j<*argc; j++)
      argv[j] = argv[j+flag_found];
    argv[*argc] = '\0';
  } else {
    *answer = default2;
  }
  
  return( *answer );
}
/* ------------------------------------------------------------- */

/*
   
    argr4 - same as argstr except we do atof to get the argument

*/

float argr4_c(flag, answer, default1, default2, argc, argv)
char *flag, **argv;
int *argc;
float *answer, default1, default2;
{
  int i, j = 0, flag_found = FALSE;
  double atof();
  
  /* loop thru the arguments looking for the right flag */
  
  for (i=0; i<*argc; i++) {
    if( !strncmp( flag, argv[i], strlen(flag)) ) {
      flag_found = 1;
	  
				/* we have found the flag but
				   do we have an argument */
      if ( strlen(argv[i]) == strlen(flag) ) {
	if (i+1 == *argc) {
	  *answer = default1;
	}
	else {
	  if (argv[i+1][0]!='-') { /* Don't have a '-' must be an argument. */
	    *answer = atof( argv[i+1]);
	    flag_found=2;
	  } else {
	    if (isdigit(argv[i+1][1])) { /* Check for "-1..." for argument. */
	      *answer = atof( argv[i+1]);
	      flag_found=2;
	    } else {
	      *answer = default1;
	    }
	  }
	}
      } else {
	*answer = atof( argv[i]+strlen(flag) );
      }
      break;
    }
  }
  
  /* if we found the flag then decrease the number of args
     and take one element out of the argv list		*/
  
  if (flag_found!=0) {
    (*argc)-=flag_found;
    for ( j=i; j<*argc; j++)
      argv[j] = argv[j+flag_found];
    argv[*argc] = '\0';
  } else {
    *answer = default2;
  }
  
  return( *answer );
}

/* --------------------------------------------------------------- */

/*
   
    argr8 - same as argr4 except we do (double)atof to get the argument

*/

double argr8_c(flag, answer, default1, default2, argc, argv)
char *flag, **argv;
int *argc;
double *answer, default1, default2;
{
  int i, j = 0, flag_found = FALSE;
  double atof();
  
  /* loop thru the arguments looking for the right flag */
  
  for (i=0; i<*argc; i++) {
    if( !strncmp( flag, argv[i], strlen(flag)) ) {
      flag_found = 1;
	  
				/* we have found the flag but
				   do we have an argument */
      if ( strlen(argv[i]) == strlen(flag) ) {
	if (i+1 == *argc) {
	  *answer = default1;
	}
	else {
	  if (argv[i+1][0]!='-') { /* Don't have a '-' must be an argument. */
	    *answer = (double)atof( argv[i+1]);
	    flag_found=2;
	  } else {
	    if (isdigit(argv[i+1][1])) { /* Check for "-1..." for argument. */
	      *answer = (double)atof( argv[i+1]);
	      flag_found=2;
	    } else {
	      *answer = default1;
	    }
	  }
	}
      } else {
	*answer = (double)atof( argv[i]+strlen(flag) );
      }
      break;
    }
  }
  
  /* if we found the flag then decrease the number of args
     and take one element out of the argv list		*/
  
  if (flag_found!=0) {
    (*argc)-=flag_found;
    for ( j=i; j<*argc; j++)
      argv[j] = argv[j+flag_found];
    argv[*argc] = '\0';
  } else {
    *answer = default2;
  }
  
  return( *answer );
}

/* -------------------------------------------------------------- */

/*
   
    argis - just looks to see if the flag is an argument

*/

int argis_c(flag, argc, argv)
char *flag, **argv;
int *argc;
{
  int i, j = 0, answer=0;
  
  /* loop thru the arguments looking for the right flag */
  
  for (i=0; i<*argc; i++) {
    if (( strncmp( flag, argv[i], strlen(flag)) == 0 ) &&
	 ( strlen(argv[i]) == strlen(flag) )) {
	answer = 1;
	break;
    }
  }
  
  /* if we found the flag then decrease the number of args
     and take one element out of the argv list		*/
  
  if (answer == 1) {
    (*argc)--;
    for ( j=i; j<*argc; j++)
      argv[j] = argv[j+1];
    argv[*argc] = '\0';
  }
  
  return( answer );
}
