/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <dlist.h>
#include <usystype.h>
#include <sys/types.h>
#include <sys/stat.h>

#if defined (CRAYSYSTEM) || defined (SOLARIS) || defined( _POSIX_SOURCE )
#include <dirent.h>
#define	DSTRUCT	dirent
#else
#include <sys/dir.h>
#define DSTRUCT direct
#endif

#include <cu.h>

static long dlist_magic = 0xa0b1c2d3;

typedef struct {
    char *filename;
    struct stat *filestat;
} dlist_t;

static void checklist(d)
LIST d;
{
    if(LSTYPE(d) != dlist_magic)
	cuerror(1, "dlist: passed a bad list (type %ld)\n", LSTYPE(d));
}

static void freeditem(t)
dlist_t *t;
{
    cufree(t->filename);
    cufree(t->filestat);
    cufree(t);
}

static int itemstat(l, n)
LIST l;
long n;
{
    char           *tpath, *dpath;
    dlist_t        *t;
    int             ret;

    if((n < 0) || (n >= LSLEN(l)))
	return 0;
    t = (dlist_t *)LSGETPX(l, n);
    if (t->filestat != NULL)
	return 1;

    dpath = (char *) LSUNIQUE(l);
    t = (dlist_t *) LSGETPX(l, n);
    tpath = (char *) cumalloc(strlen(dpath) + strlen(t->filename) + 2);
    strcpy(tpath, dpath);
    strcat(tpath, "/");
    strcat(tpath, t->filename);
    t->filestat = (struct stat *) cumalloc(sizeof(struct stat));
    ret = (stat(tpath, t->filestat) == 0);
    cufree((void *) tpath);
    return ret;
}

DLIST inspectdir(path)
char *path;
{
    char           *realpath;
    DIR            *dp;
    LIST            r;
    long            l;
    dlist_t        *t;
    struct DSTRUCT  *e;

    if (path != NULL)
	realpath = path;
    else
	realpath = ".";
    if ((dp = opendir(realpath)) == NULL)
	return NULL;
    r = LSNEW(NULL, ITEM_POINTER, dlist_magic, allocstr(realpath));
    for (l = 0; (e = readdir(dp)) != NULL;)
    {
	if (strcmp(".", e->d_name) == 0)
	    continue;
	if (strcmp("..", e->d_name) == 0)
	    continue;
	t = (dlist_t *) cumalloc(sizeof(dlist_t));
	t->filename = allocstr(e->d_name);
	t->filestat = NULL;
	++l;
	LSADDP(r, l, t);
    }
    closedir(dp);
    return r;

}

long entrycount(d)
DLIST d;
{
    checklist(d);
    return LSLEN(d);
}

char *entryname(d, n)
DLIST d;
long n;
{
    checklist(d);
    if (n < 0)
	return NULL;
    if (n >= LSLEN(d))
	return NULL;
    return ((dlist_t *) LSGETPX(d, n))->filename;
}

int isadir(d, n)
DLIST d;
long n;
{
    dlist_t        *t;

    checklist(d);
    if ((n < 0) || (n >= LSLEN(d)))
	return 0;
    t = (dlist_t *) LSGETPX(d, n);
    if (itemstat(d, n) == 0)
	return 0;
    return (t->filestat->st_mode & S_IFDIR) != 0;
}

void deleteentry(d, n)
DLIST d;
long n;
{
    dlist_t        *t;

    checklist(d);
    if ((n < 0) || (n >= LSLEN(d)))
	return;
    t = (dlist_t *) LSGETPX(d, n);
    LSDELID(d, LSIDOF(d, n));
    freeditem(t);
    return;
}

void freedlist(d)
DLIST d;
{
    long            l;
    dlist_t        *t;

    checklist(d);
    cufree(LSUNIQUE(d));
    for (l = 0; l < LSLEN(d); l++)
	freeditem((dlist_t *) LSGETPX(d, l));
    LSDISPOSE(d);
    return;
}

char *dlistpath(d)
DLIST d;
{
    checklist(d);
    return (char *) LSUNIQUE(d);
}
