/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/errno.h>

extern int errno;

/*	This is a quick little utility that I wrote to 
	check a FILE pointer to see if it is pointing
	at a pipe. A non-zero value is returned if a 
	pipe is found or errors are encountered in 
	doing the stat. ( A negative value is returned
	for errors. )			- j.m.wade 9/18/91

	Modified to get around machines where the macros
	don't work properly. Do a 0 length seek and check 
	the errno to see if we're dealing with a pipe.
					- j.m.wade 12/15/95
*/

int is_a_pipe(file)
FILE *file;
{
	int status;
	struct stat buf;
	if ( fstat(fileno(file),&buf) == 0) {
	  if ((buf.st_mode & S_IFMT ) == S_IFIFO ) {
	    return(1);
	    }
	  else if (fseek(file,0L,SEEK_CUR) != 0) {
/* HP changed the error code to EINVAL  - 7/2/96 - zjmw36
	    if (errno == ESPIPE)
*/
	    if ((errno == ESPIPE) | (errno == EINVAL))
	      return(1);
	    else
	      return(0);
	    }
	  return(0);
	  }
	else {
	  return(-1);
	  }
}
