c***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c
#include <f77/localsys.h>
c	locate a possibly non-existent flag which may or may not
c	have a following double argument
c
c	only searches arguments 1...
c
c	a blank key results in the use of the first free argument
c
c	value 	=	defval	if the argument has no attached value
c		=	noval	if the argument doesn't exist
c		=	the command-line value otherwise
c
	subroutine argr8 ( key, value, defval, noval )
	character*(*) key
	double precision value, defval, noval
#include <f77/fstd.h>
#include <f77/fargs.h>
	integer isdouble, u0arlc
	double precision dval
	integer first, carg
	character*(maxargln) res

	data res / ' ' /

	carg = u0arlc( key, res )
	if( carg .le. 0 ) then
		value = noval
	else
		first = 1
		if( isdouble( res, first, first, dval ) .eq. 0 ) then
			value = defval
		else
			value = dval
		end if
	end if
	return
	end
