C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c********************************************************************
c
c Construct a name for output files, error messages, etc.
c
c Methodology:
c 1.) Strip off any leading path
c 2.) Convert the remainder to upper case
c
c Usage:
c
c     character name * 100
c     character getname * 100
c
c ....
c
c     name = getname()
c
c                                               Author: Joe Dellinger
c                                                       Sept 20, 1994
c
c********************************************************************

      function getname()

      character getname*100
      character name*100
      character cname*100
      character arg0*100

      integer ii, lenname,nblen

      name = arg0()
      lenname = nblen(name)

c
c Look backwards from the end of the string for the last slash
c
      do 10 ii = lenname, 1, -1

      if (name(ii:ii) .eq. '/') goto 20

 10   continue

      ii = 0

 20   ii = ii + 1

c
c If the name somehow ENDED in a slash there was no file name
c at all! So use UNKNOWN (this really shouldn't be able to happen).
c The f77 standard says you aren't allowed to copy a substring
c to a possibly overlapping substring, so we use "cname" for
c "copy of name" on the left hand side.
c
      if (ii .le. lenname) then
          cname = name(ii:lenname)
      else
          cname = 'UNKNOWN'
      endif

c
c Convert to upper case
c
      do 30 ii = 1, nblen(cname)

      if (cname(ii:ii) .ge. 'a' .and. cname(ii:ii) .le. 'z') then
          cname(ii:ii) = char (
     1    ichar(cname(ii:ii)) + (ichar('A') - ichar('a'))
     1    )
      endif

30    continue

      getname = cname

      return
      end
