c***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c
#include <f77/localsys.h>
c
c	decode a double beginning at character first
c
c	on return
c	1 ==>	successful decode.  dval has the interpreted value
c		and next points to the first unused character
c		or one past the end of the string.
c	0 ==>	not a double value.  next and dval are unaltered.
c
	integer function isdouble( s, first, next, dval )
	character*(*) s
	integer first, next
	double precision dval

	integer u0stodpr
	integer used
	double precision dtemp

	if( first .le. len( s ) ) then
		used = u0stodpr( s(first:), dtemp )
		if( used .gt. 0 ) then
			next = first + used
			dval = dtemp
			isdouble = 1
		else
			isdouble = 0
		end if
	else
		isdouble = 0
	end if
	return
	end

