/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <localsys.h>
/*
        changed long declarations to int; these are NOT the same!
                                                - joe m. wade 5/26/95
*/
#ifndef CRAYSYSTEM
/*
**	convert a fortran string, of length fl and pointed to by fstring,
**	to a null-terminated C string (less any trailing blanks in
**	the original) and return a pointer to malloc'd space
**	holding the new (possibly shorter) string.
**
**	ALWAYS returns a pointer to some string, even if it only
**	holds a terminating '\0'.
**
**	only callable from C
*/
char *u0f2cstr( fstring, fl )
char *fstring;
int fl;
{
	char *cstring, *malloc();
	int i;
/*
**	find real length of fstring.
*/
	for( fl = fl - 1; fl >= 0; --fl )
		if( fstring[ fl ] != ' ' )
			break;
/*
**	fl is now the (C) index of the last non-blank or
**	-1 if there are no non-blank characters in fstring.
*/
	cstring = malloc( fl + 2 );

/* - replace this with strncpy - j.m.wade 8/19/92
	for( i = 0; i <= fl; i++ )
		cstring[ i ] = fstring[ i ];
*/
	strncpy(cstring, fstring, fl+1);
	cstring[ fl+1 ] = '\0';
	return cstring;
}
#else
#ifndef NULL
#define NULL	((char *)0)
#endif
/*
**	convert a fortran _fcd to a null-terminated, malloc'd
**	C string.
**
**	Always return a pointer to something even if it only holds
**	a terminating '\0'.
*/
#include <fortran.h>
char *u0f2cstr(fstring)
_fcd fstring;
{
	char *cstring, *malloc(), *fp;
	int i, fl;
/*
**	find real length of fstring.
*/
	fl = _fcdlen(fstring);
	fp = _fcdtocp(fstring);
	for( fl = fl - 1; fl >= 0; --fl )
		if( fp[ fl ] != ' ' )
			break;
/*
**	fl is now the (C) index of the last non-blank or
**	-1 if there are no non-blank characters in fstring.
*/
	cstring = malloc( fl + 2 );
/* - replace this with strncpy - j.m.wade 8/19/92
	for( i = 0; i <= fl; i++ )
		cstring[ i ] = fp[ i ];
	cstring[ i ] = '\0';
*/
	strncpy(cstring, fp, fl+1);
	cstring[ fl+1 ] = '\0';
	return cstring;
}
/*
**	pack a C string into a fortran _fcd (as far as possible)
*/
void u0c2fstr(cp, fstring)
char *cp;
_fcd fstring;
{
	int flen, clen, i;
	char *fp;

	if(cp == NULL)
		cp = "";
	clen = strlen(cp);
	flen = _fcdlen(fstring);
	fp = _fcdtocp(fstring);

/* - replace this with strncpy - j.m.wade 8/19/92
	for( i = 0; (i < clen) && (i < flen); i++)
		fp[i] = cp[i];

	while( i < flen )
		fp[i++] = ' ';
*/
	if ( flen < clen )
	  strncpy(fp, cp, flen);
	else {
	  strncpy(fp, cp, clen);
	  for( i = clen; i < flen; i++)
		fp[i] = ' ';
	  }
}
#endif
