*#**********************************************************************

      SUBROUTINE CCHDC(A,LDA,P,WORK,JPVT,JOB,INFO)                      00000010

      INTEGER LDA,P,JPVT(1),JOB,INFO                                    00000020
      COMPLEX A(LDA,1),WORK(1)                                          00000030
C                                                                       00000040
C     CCHDC COMPUTES THE CHOLESKY DECOMPOSITION OF A POSITIVE DEFINITE  00000050
C     MATRIX.  A PIVOTING OPTION ALLOWS THE USER TO ESTIMATE THE        00000060
C     CONDITION OF A POSITIVE DEFINITE MATRIX OR DETERMINE THE RANK     00000070
C     OF A POSITIVE SEMIDEFINITE MATRIX.                                00000080
C                                                                       00000090
C     ON ENTRY                                                          00000100
C                                                                       00000110
C         A      COMPLEX(LDA,P).                                        00000120
C                A CONTAINS THE MATRIX WHOSE DECOMPOSITION IS TO        00000130
C                BE COMPUTED.  ONLT THE UPPER HALF OF A NEED BE STORED. 00000140
C                THE LOWER PART OF THE ARRAY A IS NOT REFERENCED.       00000150
C                                                                       00000160
C         LDA    INTEGER.                                               00000170
C                LDA IS THE LEADING DIMENSION OF THE ARRAY A.           00000180
C                                                                       00000190
C         P      INTEGER.                                               00000200
C                P IS THE ORDER OF THE MATRIX.                          00000210
C                                                                       00000220
C         WORK   COMPLEX.                                               00000230
C                WORK IS A WORK ARRAY.                                  00000240
C                                                                       00000250
C         JPVT   INTEGER(P).                                            00000260
C                JPVT CONTAINS INTEGERS THAT CONTROL THE SELECTION      00000270
C                OF THE PIVOT ELEMENTS, IF PIVOTING HAS BEEN REQUESTED. 00000280
C                EACH DIAGONAL ELEMENT A(K,K)                           00000290
C                IS PLACED IN ONE OF THREE CLASSES ACCORDING TO THE     00000300
C                VALUE OF JPVT(K).                                      00000310
C                                                                       00000320
C                   IF JPVT(K) .GT. 0, THEN X(K) IS AN INITIAL          00000330
C                                      ELEMENT.                         00000340
C                                                                       00000350
C                   IF JPVT(K) .EQ. 0, THEN X(K) IS A FREE ELEMENT.     00000360
C                                                                       00000370
C                   IF JPVT(K) .LT. 0, THEN X(K) IS A FINAL ELEMENT.    00000380
C                                                                       00000390
C                BEFORE THE DECOMPOSITION IS COMPUTED, INITIAL ELEMENTS 00000400
C                ARE MOVED BY SYMMETRIC ROW AND COLUMN INTERCHANGES TO  00000410
C                THE BEGINNING OF THE ARRAY A AND FINAL                 00000420
C                ELEMENTS TO THE END.  BOTH INITIAL AND FINAL ELEMENTS  00000430
C                ARE FROZEN IN PLACE DURING THE COMPUTATION AND ONLY    00000440
C                FREE ELEMENTS ARE MOVED.  AT THE K-TH STAGE OF THE     00000450
C                REDUCTION, IF A(K,K) IS OCCUPIED BY A FREE ELEMENT     00000460
C                IT IS INTERCHANGED WITH THE LARGEST FREE ELEMENT       00000470
C                A(L,L) WITH L .GE. K.  JPVT IS NOT REFERENCED IF       00000480
C                JOB .EQ. 0.                                            00000490
C                                                                       00000500
C        JOB     INTEGER.                                               00000510
C                JOB IS AN INTEGER THAT INITIATES COLUMN PIVOTING.      00000520
C                IF JOB .EQ. 0, NO PIVOTING IS DONE.                    00000530
C                IF JOB .NE. 0, PIVOTING IS DONE.                       00000540
C                                                                       00000550
C     ON RETURN                                                         00000560
C                                                                       00000570
C         A      A CONTAINS IN ITS UPPER HALF THE CHOLESKY FACTOR       00000580
C                OF THE MATRIX A AS IT HAS BEEN PERMUTED BY PIVOTING.   00000590
C                                                                       00000600
C         JPVT   JPVT(J) CONTAINS THE INDEX OF THE DIAGONAL ELEMENT     00000610
C                OF A THAT WAS MOVED INTO THE J-TH POSITION,            00000620
C                PROVIDED PIVOTING WAS REQUESTED.                       00000630
C                                                                       00000640
C         INFO   CONTAINS THE INDEX OF THE LAST POSITIVE DIAGONAL       00000650
C                ELEMENT OF THE CHOLESKY FACTOR.                        00000660
C                                                                       00000670
C     FOR POSITIVE DEFINITE MATRICES INFO = P IS THE NORMAL RETURN.     00000680
C     FOR PIVOTING WITH POSITIVE SEMIDEFINITE MATRICES INFO WILL        00000690
C     IN GENERAL BE LESS THAN P.  HOWEVER, INFO MAY BE GREATER THAN     00000700
C     THE RANK OF A, SINCE ROUNDING ERROR CAN CAUSE AN OTHERWISE ZERO   00000710
C     ELEMENT TO BE POSITIVE. INDEFINITE SYSTEMS WILL ALWAYS CAUSE      00000720
C     INFO TO BE LESS THAN P.                                           00000730
C                                                                       00000740
C     LINPACK. THIS VERSION DATED 03/19/79 .                            00000750
C     J.J. DONGARRA AND G.W. STEWART, ARGONNE NATIONAL LABORATORY AND   00000760
C     UNIVERSITY OF MARYLAND.                                           00000770
C                                                                       00000780
C                                                                       00000790
C     BLAS CAXPY,CSWAP                                                  00000800
C     FORTRAN SQRT,REAL,CONJG                                           00000810
C                                                                       00000820
C     INTERNAL VARIABLES                                                00000830
C                                                                       00000840
      INTEGER PU,PL,PLP1,I,J,JP,JT,K,KB,KM1,KP1,L,MAXL                  00000850
      COMPLEX TEMP                                                      00000860
      REAL MAXDIA                                                       00000870
      LOGICAL SWAPK,NEGK                                                00000880
C                                                                       00000890
      PL = 1                                                            00000900
      PU = 0                                                            00000910
      INFO = P                                                          00000920
      IF (JOB .EQ. 0) GO TO 160                                         00000930
C                                                                       00000940
C        PIVOTING HAS BEEN REQUESTED. REARRANGE THE                     00000950
C        THE ELEMENTS ACCORDING TO JPVT.                                00000960
C                                                                       00000970
         DO 70 K = 1, P                                                 00000980
            SWAPK = JPVT(K) .GT. 0                                      00000990
            NEGK = JPVT(K) .LT. 0                                       00001000
            JPVT(K) = K                                                 00001010
            IF (NEGK) JPVT(K) = -JPVT(K)                                00001020
            IF (.NOT.SWAPK) GO TO 60                                    00001030
               IF (K .EQ. PL) GO TO 50                                  00001040
                  CALL CSWAP(PL-1,A(1,K),1,A(1,PL),1)                   00001050
                  TEMP = A(K,K)                                         00001060
                  A(K,K) = A(PL,PL)                                     00001070
                  A(PL,PL) = TEMP                                       00001080
                  A(PL,K) = CONJG(A(PL,K))                              00001090
                  PLP1 = PL + 1                                         00001100
                  IF (P .LT. PLP1) GO TO 40                             00001110
                  DO 30 J = PLP1, P                                     00001120
                     IF (J .GE. K) GO TO 10                             00001130
                        TEMP = CONJG(A(PL,J))                           00001140
                        A(PL,J) = CONJG(A(J,K))                         00001150
                        A(J,K) = TEMP                                   00001160
                     GO TO 20                                           00001170
   10                CONTINUE                                           00001180
                     IF (J .EQ. K) GO TO 20                             00001190
                        TEMP = A(K,J)                                   00001200
                        A(K,J) = A(PL,J)                                00001210
                        A(PL,J) = TEMP                                  00001220
   20                CONTINUE                                           00001230
   30             CONTINUE                                              00001240
   40             CONTINUE                                              00001250
                  JPVT(K) = JPVT(PL)                                    00001260
                  JPVT(PL) = K                                          00001270
   50          CONTINUE                                                 00001280
               PL = PL + 1                                              00001290
   60       CONTINUE                                                    00001300
   70    CONTINUE                                                       00001310
         PU = P                                                         00001320
         IF (P .LT. PL) GO TO 150                                       00001330
         DO 140 KB = PL, P                                              00001340
            K = P - KB + PL                                             00001350
            IF (JPVT(K) .GE. 0) GO TO 130                               00001360
               JPVT(K) = -JPVT(K)                                       00001370
               IF (PU .EQ. K) GO TO 120                                 00001380
                  CALL CSWAP(K-1,A(1,K),1,A(1,PU),1)                    00001390
                  TEMP = A(K,K)                                         00001400
                  A(K,K) = A(PU,PU)                                     00001410
                  A(PU,PU) = TEMP                                       00001420
                  A(K,PU) = CONJG(A(K,PU))                              00001430
                  KP1 = K + 1                                           00001440
                  IF (P .LT. KP1) GO TO 110                             00001450
                  DO 100 J = KP1, P                                     00001460
                     IF (J .GE. PU) GO TO 80                            00001470
                        TEMP = CONJG(A(K,J))                            00001480
                        A(K,J) = CONJG(A(J,PU))                         00001490
                        A(J,PU) = TEMP                                  00001500
                     GO TO 90                                           00001510
   80                CONTINUE                                           00001520
                     IF (J .EQ. PU) GO TO 90                            00001530
                        TEMP = A(K,J)                                   00001540
                        A(K,J) = A(PU,J)                                00001550
                        A(PU,J) = TEMP                                  00001560
   90                CONTINUE                                           00001570
  100             CONTINUE                                              00001580
  110             CONTINUE                                              00001590
                  JT = JPVT(K)                                          00001600
                  JPVT(K) = JPVT(PU)                                    00001610
                  JPVT(PU) = JT                                         00001620
  120          CONTINUE                                                 00001630
               PU = PU - 1                                              00001640
  130       CONTINUE                                                    00001650
  140    CONTINUE                                                       00001660
  150    CONTINUE                                                       00001670
  160 CONTINUE                                                          00001680
      DO 270 K = 1, P                                                   00001690
C                                                                       00001700
C        REDUCTION LOOP.                                                00001710
C                                                                       00001720
         MAXDIA = REAL(A(K,K))                                          00001730
         KP1 = K + 1                                                    00001740
         MAXL = K                                                       00001750
C                                                                       00001760
C        DETERMINE THE PIVOT ELEMENT.                                   00001770
C                                                                       00001780
         IF (K .LT. PL .OR. K .GE. PU) GO TO 190                        00001790
            DO 180 L = KP1, PU                                          00001800
               IF (REAL(A(L,L)) .LE. MAXDIA) GO TO 170                  00001810
                  MAXDIA = REAL(A(L,L))                                 00001820
                  MAXL = L                                              00001830
  170          CONTINUE                                                 00001840
  180       CONTINUE                                                    00001850
  190    CONTINUE                                                       00001860
C                                                                       00001870
C        QUIT IF THE PIVOT ELEMENT IS NOT POSITIVE.                     00001880
C                                                                       00001890
         IF (MAXDIA .GT. 0.0E0) GO TO 200                               00001900
            INFO = K - 1                                                00001910
C     ......EXIT                                                        00001920
            GO TO 280                                                   00001930
  200    CONTINUE                                                       00001940
         IF (K .EQ. MAXL) GO TO 210                                     00001950
C                                                                       00001960
C           START THE PIVOTING AND UPDATE JPVT.                         00001970
C                                                                       00001980
            KM1 = K - 1                                                 00001990
            CALL CSWAP(KM1,A(1,K),1,A(1,MAXL),1)                        00002000
            A(MAXL,MAXL) = A(K,K)                                       00002010
            A(K,K) = CMPLX(MAXDIA,0.0E0)                                00002020
            JP = JPVT(MAXL)                                             00002030
            JPVT(MAXL) = JPVT(K)                                        00002040
            JPVT(K) = JP                                                00002050
            A(K,MAXL) = CONJG(A(K,MAXL))                                00002060
  210    CONTINUE                                                       00002070
C                                                                       00002080
C        REDUCTION STEP. PIVOTING IS CONTAINED ACROSS THE ROWS.         00002090
C                                                                       00002100
         WORK(K) = CMPLX(SQRT(REAL(A(K,K))),0.0E0)                      00002110
         A(K,K) = WORK(K)                                               00002120
         IF (P .LT. KP1) GO TO 260                                      00002130
         DO 250 J = KP1, P                                              00002140
            IF (K .EQ. MAXL) GO TO 240                                  00002150
               IF (J .GE. MAXL) GO TO 220                               00002160
                  TEMP = CONJG(A(K,J))                                  00002170
                  A(K,J) = CONJG(A(J,MAXL))                             00002180
                  A(J,MAXL) = TEMP                                      00002190
               GO TO 230                                                00002200
  220          CONTINUE                                                 00002210
               IF (J .EQ. MAXL) GO TO 230                               00002220
                  TEMP = A(K,J)                                         00002230
                  A(K,J) = A(MAXL,J)                                    00002240
                  A(MAXL,J) = TEMP                                      00002250
  230          CONTINUE                                                 00002260
  240       CONTINUE                                                    00002270
            A(K,J) = A(K,J)/WORK(K)                                     00002280
            WORK(J) = CONJG(A(K,J))                                     00002290
            TEMP = -A(K,J)                                              00002300
            CALL CAXPY(J-K,TEMP,WORK(KP1),1,A(KP1,J),1)                 00002310
  250    CONTINUE                                                       00002320
  260    CONTINUE                                                       00002330
  270 CONTINUE                                                          00002340
  280 CONTINUE                                                          00002350
      RETURN                                                            00002360
      END                                                               00002370
