*#**********************************************************************

      SUBROUTINE CGBCO(ABD,LDA,N,ML,MU,IPVT,RCOND,Z)                    00000010

      INTEGER LDA,N,ML,MU,IPVT(1)                                       00000020
      COMPLEX ABD(LDA,1),Z(1)                                           00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     CGBCO FACTORS A COMPLEX BAND MATRIX BY GAUSSIAN                   00000060
C     ELIMINATION AND ESTIMATES THE CONDITION OF THE MATRIX.            00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, CGBFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW CGBCO BY CGBSL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CGBCO BY CGBSL.                 00000110
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CGBCO BY CGBDI.               00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        ABD     COMPLEX(LDA, N)                                        00000160
C                CONTAINS THE MATRIX IN BAND STORAGE.  THE COLUMNS      00000170
C                OF THE MATRIX ARE STORED IN THE COLUMNS OF  ABD  AND   00000180
C                THE DIAGONALS OF THE MATRIX ARE STORED IN ROWS         00000190
C                ML+1 THROUGH 2*ML+MU+1 OF  ABD .                       00000200
C                SEE THE COMMENTS BELOW FOR DETAILS.                    00000210
C                                                                       00000220
C        LDA     INTEGER                                                00000230
C                THE LEADING DIMENSION OF THE ARRAY  ABD .              00000240
C                LDA MUST BE .GE. 2*ML + MU + 1 .                       00000250
C                                                                       00000260
C        N       INTEGER                                                00000270
C                THE ORDER OF THE ORIGINAL MATRIX.                      00000280
C                                                                       00000290
C        ML      INTEGER                                                00000300
C                NUMBER OF DIAGONALS BELOW THE MAIN DIAGONAL.           00000310
C                0 .LE. ML .LT. N .                                     00000320
C                                                                       00000330
C        MU      INTEGER                                                00000340
C                NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.           00000350
C                0 .LE. MU .LT. N .                                     00000360
C                MORE EFFICIENT IF  ML .LE. MU .                        00000370
C                                                                       00000380
C     ON RETURN                                                         00000390
C                                                                       00000400
C        ABD     AN UPPER TRIANGULAR MATRIX IN BAND STORAGE AND         00000410
C                THE MULTIPLIERS WHICH WERE USED TO OBTAIN IT.          00000420
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U  WHERE       00000430
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER          00000440
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.       00000450
C                                                                       00000460
C        IPVT    INTEGER(N)                                             00000470
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000480
C                                                                       00000490
C        RCOND   REAL                                                   00000500
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000510
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000520
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000530
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000540
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000550
C                           1.0 + RCOND .EQ. 1.0                        00000560
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000570
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000580
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000590
C                UNDERFLOWS.                                            00000600
C                                                                       00000610
C        Z       COMPLEX(N)                                             00000620
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000630
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000640
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000650
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000660
C                                                                       00000670
C     BAND STORAGE                                                      00000680
C                                                                       00000690
C           IF  A  IS A BAND MATRIX, THE FOLLOWING PROGRAM SEGMENT      00000700
C           WILL SET UP THE INPUT.                                      00000710
C                                                                       00000720
C                   ML = (BAND WIDTH BELOW THE DIAGONAL)                00000730
C                   MU = (BAND WIDTH ABOVE THE DIAGONAL)                00000740
C                   M = ML + MU + 1                                     00000750
C                   DO 20 J = 1, N                                      00000760
C                      I1 = MAX0(1, J-MU)                               00000770
C                      I2 = MIN0(N, J+ML)                               00000780
C                      DO 10 I = I1, I2                                 00000790
C                         K = I - J + M                                 00000800
C                         ABD(K,J) = A(I,J)                             00000810
C                10    CONTINUE                                         00000820
C                20 CONTINUE                                            00000830
C                                                                       00000840
C           THIS USES ROWS  ML+1  THROUGH  2*ML+MU+1  OF  ABD .         00000850
C           IN ADDITION, THE FIRST  ML  ROWS IN  ABD  ARE USED FOR      00000860
C           ELEMENTS GENERATED DURING THE TRIANGULARIZATION.            00000870
C           THE TOTAL NUMBER OF ROWS NEEDED IN  ABD  IS  2*ML+MU+1 .    00000880
C           THE  ML+MU BY ML+MU  UPPER LEFT TRIANGLE AND THE            00000890
C           ML BY ML  LOWER RIGHT TRIANGLE ARE NOT REFERENCED.          00000900
C                                                                       00000910
C     EXAMPLE..  IF THE ORIGINAL MATRIX IS                              00000920
C                                                                       00000930
C           11 12 13  0  0  0                                           00000940
C           21 22 23 24  0  0                                           00000950
C            0 32 33 34 35  0                                           00000960
C            0  0 43 44 45 46                                           00000970
C            0  0  0 54 55 56                                           00000980
C            0  0  0  0 65 66                                           00000990
C                                                                       00001000
C      THEN  N = 6, ML = 1, MU = 2, LDA .GE. 5  AND ABD SHOULD CONTAIN  00001010
C                                                                       00001020
C            *  *  *  +  +  +  , * = NOT USED                           00001030
C            *  * 13 24 35 46  , + = USED FOR PIVOTING                  00001040
C            * 12 23 34 45 56                                           00001050
C           11 22 33 44 55 66                                           00001060
C           21 32 43 54 65  *                                           00001070
C                                                                       00001080
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00001090
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00001100
C                                                                       00001110
C     SUBROUTINES AND FUNCTIONS                                         00001120
C                                                                       00001130
C     LINPACK CGBFA                                                     00001140
C     BLAS CAXPY,CDOTC,CSSCAL,SCASUM                                    00001150
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,MAX0,MIN0,REAL                00001160
C                                                                       00001170
C     INTERNAL VARIABLES                                                00001180
C                                                                       00001190
      COMPLEX CDOTC,EK,T,WK,WKM                                         00001200
      REAL ANORM,S,SCASUM,SM,YNORM                                      00001210
      INTEGER IS,INFO,J,JU,K,KB,KP1,L,LA,LM,LZ,M,MM                     00001220
C                                                                       00001230
      COMPLEX ZDUM,ZDUM1,ZDUM2,CSIGN1                                   00001240
      REAL CABS1                                                        00001250
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00001260
      CSIGN1(ZDUM1,ZDUM2) = CABS1(ZDUM1)*(ZDUM2/CABS1(ZDUM2))           00001270
C                                                                       00001280
C     COMPUTE 1-NORM OF A                                               00001290
C                                                                       00001300
      ANORM = 0.0E0                                                     00001310
      L = ML + 1                                                        00001320
      IS = L + MU                                                       00001330
      DO 10 J = 1, N                                                    00001340
         ANORM = AMAX1(ANORM,SCASUM(L,ABD(IS,J),1))                     00001350
         IF (IS .GT. ML + 1) IS = IS - 1                                00001360
         IF (J .LE. MU) L = L + 1                                       00001370
         IF (J .GE. N - ML) L = L - 1                                   00001380
   10 CONTINUE                                                          00001390
C                                                                       00001400
C     FACTOR                                                            00001410
C                                                                       00001420
      CALL CGBFA(ABD,LDA,N,ML,MU,IPVT,INFO)                             00001430
C                                                                       00001440
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00001450
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  CTRANS(A)*Y = E . 00001460
C     CTRANS(A)  IS THE CONJUGATE TRANSPOSE OF A .                      00001470
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001480
C     GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(U)*W = E .             00001490
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001500
C                                                                       00001510
C     SOLVE CTRANS(U)*W = E                                             00001520
C                                                                       00001530
      EK = (1.0E0,0.0E0)                                                00001540
      DO 20 J = 1, N                                                    00001550
         Z(J) = (0.0E0,0.0E0)                                           00001560
   20 CONTINUE                                                          00001570
      M = ML + MU + 1                                                   00001580
      JU = 0                                                            00001590
      DO 100 K = 1, N                                                   00001600
         IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,-Z(K))              00001610
         IF (CABS1(EK-Z(K)) .LE. CABS1(ABD(M,K))) GO TO 30              00001620
            S = CABS1(ABD(M,K))/CABS1(EK-Z(K))                          00001630
            CALL CSSCAL(N,S,Z,1)                                        00001640
            EK = CMPLX(S,0.0E0)*EK                                      00001650
   30    CONTINUE                                                       00001660
         WK = EK - Z(K)                                                 00001670
         WKM = -EK - Z(K)                                               00001680
         S = CABS1(WK)                                                  00001690
         SM = CABS1(WKM)                                                00001700
         IF (CABS1(ABD(M,K)) .EQ. 0.0E0) GO TO 40                       00001710
            WK = WK/CONJG(ABD(M,K))                                     00001720
            WKM = WKM/CONJG(ABD(M,K))                                   00001730
         GO TO 50                                                       00001740
   40    CONTINUE                                                       00001750
            WK = (1.0E0,0.0E0)                                          00001760
            WKM = (1.0E0,0.0E0)                                         00001770
   50    CONTINUE                                                       00001780
         KP1 = K + 1                                                    00001790
         JU = MIN0(MAX0(JU,MU+IPVT(K)),N)                               00001800
         MM = M                                                         00001810
         IF (KP1 .GT. JU) GO TO 90                                      00001820
            DO 60 J = KP1, JU                                           00001830
               MM = MM - 1                                              00001840
               SM = SM + CABS1(Z(J)+WKM*CONJG(ABD(MM,J)))               00001850
               Z(J) = Z(J) + WK*CONJG(ABD(MM,J))                        00001860
               S = S + CABS1(Z(J))                                      00001870
   60       CONTINUE                                                    00001880
            IF (S .GE. SM) GO TO 80                                     00001890
               T = WKM - WK                                             00001900
               WK = WKM                                                 00001910
               MM = M                                                   00001920
               DO 70 J = KP1, JU                                        00001930
                  MM = MM - 1                                           00001940
                  Z(J) = Z(J) + T*CONJG(ABD(MM,J))                      00001950
   70          CONTINUE                                                 00001960
   80       CONTINUE                                                    00001970
   90    CONTINUE                                                       00001980
         Z(K) = WK                                                      00001990
  100 CONTINUE                                                          00002000
      S = 1.0E0/SCASUM(N,Z,1)                                           00002010
      CALL CSSCAL(N,S,Z,1)                                              00002020
C                                                                       00002030
C     SOLVE CTRANS(L)*Y = W                                             00002040
C                                                                       00002050
      DO 120 KB = 1, N                                                  00002060
         K = N + 1 - KB                                                 00002070
         LM = MIN0(ML,N-K)                                              00002080
         IF (K .LT. N) Z(K) = Z(K) + CDOTC(LM,ABD(M+1,K),1,Z(K+1),1)    00002090
         IF (CABS1(Z(K)) .LE. 1.0E0) GO TO 110                          00002100
            S = 1.0E0/CABS1(Z(K))                                       00002110
            CALL CSSCAL(N,S,Z,1)                                        00002120
  110    CONTINUE                                                       00002130
         L = IPVT(K)                                                    00002140
         T = Z(L)                                                       00002150
         Z(L) = Z(K)                                                    00002160
         Z(K) = T                                                       00002170
  120 CONTINUE                                                          00002180
      S = 1.0E0/SCASUM(N,Z,1)                                           00002190
      CALL CSSCAL(N,S,Z,1)                                              00002200
C                                                                       00002210
      YNORM = 1.0E0                                                     00002220
C                                                                       00002230
C     SOLVE L*V = Y                                                     00002240
C                                                                       00002250
      DO 140 K = 1, N                                                   00002260
         L = IPVT(K)                                                    00002270
         T = Z(L)                                                       00002280
         Z(L) = Z(K)                                                    00002290
         Z(K) = T                                                       00002300
         LM = MIN0(ML,N-K)                                              00002310
         IF (K .LT. N) CALL CAXPY(LM,T,ABD(M+1,K),1,Z(K+1),1)           00002320
         IF (CABS1(Z(K)) .LE. 1.0E0) GO TO 130                          00002330
            S = 1.0E0/CABS1(Z(K))                                       00002340
            CALL CSSCAL(N,S,Z,1)                                        00002350
            YNORM = S*YNORM                                             00002360
  130    CONTINUE                                                       00002370
  140 CONTINUE                                                          00002380
      S = 1.0E0/SCASUM(N,Z,1)                                           00002390
      CALL CSSCAL(N,S,Z,1)                                              00002400
      YNORM = S*YNORM                                                   00002410
C                                                                       00002420
C     SOLVE  U*Z = W                                                    00002430
C                                                                       00002440
      DO 160 KB = 1, N                                                  00002450
         K = N + 1 - KB                                                 00002460
         IF (CABS1(Z(K)) .LE. CABS1(ABD(M,K))) GO TO 150                00002470
            S = CABS1(ABD(M,K))/CABS1(Z(K))                             00002480
            CALL CSSCAL(N,S,Z,1)                                        00002490
            YNORM = S*YNORM                                             00002500
  150    CONTINUE                                                       00002510
         IF (CABS1(ABD(M,K)) .NE. 0.0E0) Z(K) = Z(K)/ABD(M,K)           00002520
         IF (CABS1(ABD(M,K)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)           00002530
         LM = MIN0(K,M) - 1                                             00002540
         LA = M - LM                                                    00002550
         LZ = K - LM                                                    00002560
         T = -Z(K)                                                      00002570
         CALL CAXPY(LM,T,ABD(LA,K),1,Z(LZ),1)                           00002580
  160 CONTINUE                                                          00002590
C     MAKE ZNORM = 1.0                                                  00002600
      S = 1.0E0/SCASUM(N,Z,1)                                           00002610
      CALL CSSCAL(N,S,Z,1)                                              00002620
      YNORM = S*YNORM                                                   00002630
C                                                                       00002640
      IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                         00002650
      IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                               00002660
      RETURN                                                            00002670
      END                                                               00002680
