*#**********************************************************************

      SUBROUTINE CGBDI(ABD,LDA,N,ML,MU,IPVT,DET)                        00000010

      INTEGER LDA,N,ML,MU,IPVT(1)                                       00000020
      COMPLEX ABD(LDA,1),DET(2)                                         00000030
C                                                                       00000040
C     CGBDI COMPUTES THE DETERMINANT OF A BAND MATRIX                   00000050
C     USING THE FACTORS COMPUTED BY CGBCO OR CGBFA.                     00000060
C     IF THE INVERSE IS NEEDED, USE CGBSL  N  TIMES.                    00000070
C                                                                       00000080
C     ON ENTRY                                                          00000090
C                                                                       00000100
C        ABD     COMPLEX(LDA, N)                                        00000110
C                THE OUTPUT FROM CGBCO OR CGBFA.                        00000120
C                                                                       00000130
C        LDA     INTEGER                                                00000140
C                THE LEADING DIMENSION OF THE ARRAY  ABD .              00000150
C                                                                       00000160
C        N       INTEGER                                                00000170
C                THE ORDER OF THE ORIGINAL MATRIX.                      00000180
C                                                                       00000190
C        ML      INTEGER                                                00000200
C                NUMBER OF DIAGONALS BELOW THE MAIN DIAGONAL.           00000210
C                                                                       00000220
C        MU      INTEGER                                                00000230
C                NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.           00000240
C                                                                       00000250
C        IPVT    INTEGER(N)                                             00000260
C                THE PIVOT VECTOR FROM CGBCO OR CGBFA.                  00000270
C                                                                       00000280
C     ON RETURN                                                         00000290
C                                                                       00000300
C        DET     COMPLEX(2)                                             00000310
C                DETERMINANT OF ORIGINAL MATRIX.                        00000320
C                DETERMINANT = DET(1) * 10.0**DET(2)                    00000330
C                WITH  1.0 .LE. CABS1(DET(1)) .LT. 10.0                 00000340
C                OR  DET(1) = 0.0 .                                     00000350
C                                                                       00000360
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000370
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000380
C                                                                       00000390
C     SUBROUTINES AND FUNCTIONS                                         00000400
C                                                                       00000410
C     FORTRAN ABS,AIMAG,CMPLX,REAL                                      00000420
C                                                                       00000430
C     INTERNAL VARIABLES                                                00000440
C                                                                       00000450
      REAL TEN                                                          00000460
      INTEGER I,M                                                       00000470
C                                                                       00000480
      COMPLEX ZDUM                                                      00000490
      REAL CABS1                                                        00000500
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000510
C                                                                       00000520
      M = ML + MU + 1                                                   00000530
      DET(1) = (1.0E0,0.0E0)                                            00000540
      DET(2) = (0.0E0,0.0E0)                                            00000550
      TEN = 10.0E0                                                      00000560
      DO 50 I = 1, N                                                    00000570
         IF (IPVT(I) .NE. I) DET(1) = -DET(1)                           00000580
         DET(1) = ABD(M,I)*DET(1)                                       00000590
C     ...EXIT                                                           00000600
         IF (CABS1(DET(1)) .EQ. 0.0E0) GO TO 60                         00000610
   10    IF (CABS1(DET(1)) .GE. 1.0E0) GO TO 20                         00000620
            DET(1) = CMPLX(TEN,0.0E0)*DET(1)                            00000630
            DET(2) = DET(2) - (1.0E0,0.0E0)                             00000640
         GO TO 10                                                       00000650
   20    CONTINUE                                                       00000660
   30    IF (CABS1(DET(1)) .LT. TEN) GO TO 40                           00000670
            DET(1) = DET(1)/CMPLX(TEN,0.0E0)                            00000680
            DET(2) = DET(2) + (1.0E0,0.0E0)                             00000690
         GO TO 30                                                       00000700
   40    CONTINUE                                                       00000710
   50 CONTINUE                                                          00000720
   60 CONTINUE                                                          00000730
      RETURN                                                            00000740
      END                                                               00000750
