*#**********************************************************************

      SUBROUTINE CHICO(A,LDA,N,KPVT,RCOND,Z)                            00000010

      INTEGER LDA,N,KPVT(1)                                             00000020
      COMPLEX A(LDA,1),Z(1)                                             00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     CHICO FACTORS A COMPLEX HERMITIAN MATRIX BY ELIMINATION WITH      00000060
C     SYMMETRIC PIVOTING AND ESTIMATES THE CONDITION OF THE MATRIX.     00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, CHIFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW CHICO BY CHISL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CHICO BY CHISL.                 00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW CHICO BY CHIDI.                   00000120
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CHICO BY CHIDI.               00000130
C     TO COMPUTE  INERTIA(A), FOLLOW CHICO BY CHIDI.                    00000140
C                                                                       00000150
C     ON ENTRY                                                          00000160
C                                                                       00000170
C        A       COMPLEX(LDA, N)                                        00000180
C                THE HERMITIAN MATRIX TO BE FACTORED.                   00000190
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000200
C                                                                       00000210
C        LDA     INTEGER                                                00000220
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000230
C                                                                       00000240
C        N       INTEGER                                                00000250
C                THE ORDER OF THE MATRIX  A .                           00000260
C                                                                       00000270
C     OUTPUT                                                            00000280
C                                                                       00000290
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000300
C                WERE USED TO OBTAIN IT.                                00000310
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*CTRANS(U)    00000320
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000330
C                UPPER TRIANGULAR MATRICES , CTRANS(U) IS THE           00000340
C                CONJUGATE TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL  00000350
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000360
C                                                                       00000370
C        KPVT    INTEGER(N)                                             00000380
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000390
C                                                                       00000400
C        RCOND   REAL                                                   00000410
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000420
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000430
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000440
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000450
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000460
C                           1.0 + RCOND .EQ. 1.0                        00000470
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000480
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000490
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000500
C                UNDERFLOWS.                                            00000510
C                                                                       00000520
C        Z       COMPLEX(N)                                             00000530
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000540
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000550
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000560
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000570
C                                                                       00000580
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000590
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000600
C                                                                       00000610
C     SUBROUTINES AND FUNCTIONS                                         00000620
C                                                                       00000630
C     LINPACK CHIFA                                                     00000640
C     BLAS CAXPY,CDOTC,CSSCAL,SCASUM                                    00000650
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,IABS,REAL                     00000660
C                                                                       00000670
C     INTERNAL VARIABLES                                                00000680
C                                                                       00000690
      COMPLEX AK,AKM1,BK,BKM1,CDOTC,DENOM,EK,T                          00000700
      REAL ANORM,S,SCASUM,YNORM                                         00000710
      INTEGER I,INFO,J,JM1,K,KP,KPS,KS                                  00000720
C                                                                       00000730
      COMPLEX ZDUM,ZDUM2,CSIGN1                                         00000740
      REAL CABS1                                                        00000750
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000760
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000770
C                                                                       00000780
C     FIND NORM OF A USING ONLY UPPER HALF                              00000790
C                                                                       00000800
      DO 30 J = 1, N                                                    00000810
         Z(J) = CMPLX(SCASUM(J,A(1,J),1),0.0E0)                         00000820
         JM1 = J - 1                                                    00000830
         IF (JM1 .LT. 1) GO TO 20                                       00000840
         DO 10 I = 1, JM1                                               00000850
            Z(I) = CMPLX(REAL(Z(I))+CABS1(A(I,J)),0.0E0)                00000860
   10    CONTINUE                                                       00000870
   20    CONTINUE                                                       00000880
   30 CONTINUE                                                          00000890
      ANORM = 0.0E0                                                     00000900
      DO 40 J = 1, N                                                    00000910
         ANORM = AMAX1(ANORM,REAL(Z(J)))                                00000920
   40 CONTINUE                                                          00000930
C                                                                       00000940
C     FACTOR                                                            00000950
C                                                                       00000960
      CALL CHIFA(A,LDA,N,KPVT,INFO)                                     00000970
C                                                                       00000980
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00000990
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00001000
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001010
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00001020
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001030
C                                                                       00001040
C     SOLVE U*D*W = E                                                   00001050
C                                                                       00001060
      EK = (1.0E0,0.0E0)                                                00001070
      DO 50 J = 1, N                                                    00001080
         Z(J) = (0.0E0,0.0E0)                                           00001090
   50 CONTINUE                                                          00001100
      K = N                                                             00001110
   60 IF (K .EQ. 0) GO TO 120                                           00001120
         KS = 1                                                         00001130
         IF (KPVT(K) .LT. 0) KS = 2                                     00001140
         KP = IABS(KPVT(K))                                             00001150
         KPS = K + 1 - KS                                               00001160
         IF (KP .EQ. KPS) GO TO 70                                      00001170
            T = Z(KPS)                                                  00001180
            Z(KPS) = Z(KP)                                              00001190
            Z(KP) = T                                                   00001200
   70    CONTINUE                                                       00001210
         IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,Z(K))               00001220
         Z(K) = Z(K) + EK                                               00001230
         CALL CAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                          00001240
         IF (KS .EQ. 1) GO TO 80                                        00001250
            IF (CABS1(Z(K-1)) .NE. 0.0E0) EK = CSIGN1(EK,Z(K-1))        00001260
            Z(K-1) = Z(K-1) + EK                                        00001270
            CALL CAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)                   00001280
   80    CONTINUE                                                       00001290
         IF (KS .EQ. 2) GO TO 100                                       00001300
            IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 90                00001310
               S = CABS1(A(K,K))/CABS1(Z(K))                            00001320
               CALL CSSCAL(N,S,Z,1)                                     00001330
               EK = CMPLX(S,0.0E0)*EK                                   00001340
   90       CONTINUE                                                    00001350
            IF (CABS1(A(K,K)) .NE. 0.0E0) Z(K) = Z(K)/A(K,K)            00001360
            IF (CABS1(A(K,K)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)          00001370
         GO TO 110                                                      00001380
  100    CONTINUE                                                       00001390
            AK = A(K,K)/CONJG(A(K-1,K))                                 00001400
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00001410
            BK = Z(K)/CONJG(A(K-1,K))                                   00001420
            BKM1 = Z(K-1)/A(K-1,K)                                      00001430
            DENOM = AK*AKM1 - 1.0E0                                     00001440
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001450
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001460
  110    CONTINUE                                                       00001470
         K = K - KS                                                     00001480
      GO TO 60                                                          00001490
  120 CONTINUE                                                          00001500
      S = 1.0E0/SCASUM(N,Z,1)                                           00001510
      CALL CSSCAL(N,S,Z,1)                                              00001520
C                                                                       00001530
C     SOLVE CTRANS(U)*Y = W                                             00001540
C                                                                       00001550
      K = 1                                                             00001560
  130 IF (K .GT. N) GO TO 160                                           00001570
         KS = 1                                                         00001580
         IF (KPVT(K) .LT. 0) KS = 2                                     00001590
         IF (K .EQ. 1) GO TO 150                                        00001600
            Z(K) = Z(K) + CDOTC(K-1,A(1,K),1,Z(1),1)                    00001610
            IF (KS .EQ. 2)                                              00001620
     *         Z(K+1) = Z(K+1) + CDOTC(K-1,A(1,K+1),1,Z(1),1)           00001630
            KP = IABS(KPVT(K))                                          00001640
            IF (KP .EQ. K) GO TO 140                                    00001650
               T = Z(K)                                                 00001660
               Z(K) = Z(KP)                                             00001670
               Z(KP) = T                                                00001680
  140       CONTINUE                                                    00001690
  150    CONTINUE                                                       00001700
         K = K + KS                                                     00001710
      GO TO 130                                                         00001720
  160 CONTINUE                                                          00001730
      S = 1.0E0/SCASUM(N,Z,1)                                           00001740
      CALL CSSCAL(N,S,Z,1)                                              00001750
C                                                                       00001760
      YNORM = 1.0E0                                                     00001770
C                                                                       00001780
C     SOLVE U*D*V = Y                                                   00001790
C                                                                       00001800
      K = N                                                             00001810
  170 IF (K .EQ. 0) GO TO 230                                           00001820
         KS = 1                                                         00001830
         IF (KPVT(K) .LT. 0) KS = 2                                     00001840
         IF (K .EQ. KS) GO TO 190                                       00001850
            KP = IABS(KPVT(K))                                          00001860
            KPS = K + 1 - KS                                            00001870
            IF (KP .EQ. KPS) GO TO 180                                  00001880
               T = Z(KPS)                                               00001890
               Z(KPS) = Z(KP)                                           00001900
               Z(KP) = T                                                00001910
  180       CONTINUE                                                    00001920
            CALL CAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                       00001930
            IF (KS .EQ. 2) CALL CAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)    00001940
  190    CONTINUE                                                       00001950
         IF (KS .EQ. 2) GO TO 210                                       00001960
            IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 200               00001970
               S = CABS1(A(K,K))/CABS1(Z(K))                            00001980
               CALL CSSCAL(N,S,Z,1)                                     00001990
               YNORM = S*YNORM                                          00002000
  200       CONTINUE                                                    00002010
            IF (CABS1(A(K,K)) .NE. 0.0E0) Z(K) = Z(K)/A(K,K)            00002020
            IF (CABS1(A(K,K)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)          00002030
         GO TO 220                                                      00002040
  210    CONTINUE                                                       00002050
            AK = A(K,K)/CONJG(A(K-1,K))                                 00002060
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00002070
            BK = Z(K)/CONJG(A(K-1,K))                                   00002080
            BKM1 = Z(K-1)/A(K-1,K)                                      00002090
            DENOM = AK*AKM1 - 1.0E0                                     00002100
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002110
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002120
  220    CONTINUE                                                       00002130
         K = K - KS                                                     00002140
      GO TO 170                                                         00002150
  230 CONTINUE                                                          00002160
      S = 1.0E0/SCASUM(N,Z,1)                                           00002170
      CALL CSSCAL(N,S,Z,1)                                              00002180
      YNORM = S*YNORM                                                   00002190
C                                                                       00002200
C     SOLVE CTRANS(U)*Z = V                                             00002210
C                                                                       00002220
      K = 1                                                             00002230
  240 IF (K .GT. N) GO TO 270                                           00002240
         KS = 1                                                         00002250
         IF (KPVT(K) .LT. 0) KS = 2                                     00002260
         IF (K .EQ. 1) GO TO 260                                        00002270
            Z(K) = Z(K) + CDOTC(K-1,A(1,K),1,Z(1),1)                    00002280
            IF (KS .EQ. 2)                                              00002290
     *         Z(K+1) = Z(K+1) + CDOTC(K-1,A(1,K+1),1,Z(1),1)           00002300
            KP = IABS(KPVT(K))                                          00002310
            IF (KP .EQ. K) GO TO 250                                    00002320
               T = Z(K)                                                 00002330
               Z(K) = Z(KP)                                             00002340
               Z(KP) = T                                                00002350
  250       CONTINUE                                                    00002360
  260    CONTINUE                                                       00002370
         K = K + KS                                                     00002380
      GO TO 240                                                         00002390
  270 CONTINUE                                                          00002400
C     MAKE ZNORM = 1.0                                                  00002410
      S = 1.0E0/SCASUM(N,Z,1)                                           00002420
      CALL CSSCAL(N,S,Z,1)                                              00002430
      YNORM = S*YNORM                                                   00002440
C                                                                       00002450
      IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                         00002460
      IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                               00002470
      RETURN                                                            00002480
      END                                                               00002490
