*#**********************************************************************

      SUBROUTINE CHPCO(AP,N,KPVT,RCOND,Z)                               00000010

      INTEGER N,KPVT(1)                                                 00000020
      COMPLEX AP(1),Z(1)                                                00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     CHPCO FACTORS A COMPLEX HERMITIAN MATRIX STORED IN PACKED         00000060
C     FORM BY ELIMINATION WITH SYMMETRIC PIVOTING AND ESTIMATES         00000070
C     THE CONDITION OF THE MATRIX.                                      00000080
C                                                                       00000090
C     IF  RCOND  IS NOT NEEDED, CHPFA IS SLIGHTLY FASTER.               00000100
C     TO SOLVE  A*X = B , FOLLOW CHPCO BY CHPSL.                        00000110
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CHPCO BY CHPSL.                 00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW CHPCO BY CHPDI.                   00000130
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CHPCO BY CHPDI.               00000140
C     TO COMPUTE  INERTIA(A), FOLLOW CHPCO BY CHPDI.                    00000150
C                                                                       00000160
C     ON ENTRY                                                          00000170
C                                                                       00000180
C        AP      COMPLEX (N*(N+1)/2)                                    00000190
C                THE PACKED FORM OF A HERMITIAN MATRIX  A .  THE        00000200
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000210
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000220
C                SEE COMMENTS BELOW FOR DETAILS.                        00000230
C                                                                       00000240
C        N       INTEGER                                                00000250
C                THE ORDER OF THE MATRIX  A .                           00000260
C                                                                       00000270
C     OUTPUT                                                            00000280
C                                                                       00000290
C        AP      A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000300
C                WERE USED TO OBTAIN IT STORED IN PACKED FORM.          00000310
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*CTRANS(U)    00000320
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000330
C                UPPER TRIANGULAR MATRICES , CTRANS(U) IS THE           00000340
C                CONJUGATE TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL  00000350
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000360
C                                                                       00000370
C        KPVT    INTEGER(N)                                             00000380
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000390
C                                                                       00000400
C        RCOND   REAL                                                   00000410
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000420
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000430
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000440
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000450
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000460
C                           1.0 + RCOND .EQ. 1.0                        00000470
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000480
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000490
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000500
C                UNDERFLOWS.                                            00000510
C                                                                       00000520
C        Z       COMPLEX(N)                                             00000530
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000540
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000550
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000560
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000570
C                                                                       00000580
C     PACKED STORAGE                                                    00000590
C                                                                       00000600
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000610
C          TRIANGLE OF A HERMITIAN MATRIX.                              00000620
C                                                                       00000630
C                K = 0                                                  00000640
C                DO 20 J = 1, N                                         00000650
C                   DO 10 I = 1, J                                      00000660
C                      K = K + 1                                        00000670
C                      AP(K) = A(I,J)                                   00000680
C             10    CONTINUE                                            00000690
C             20 CONTINUE                                               00000700
C                                                                       00000710
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000720
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000730
C                                                                       00000740
C     SUBROUTINES AND FUNCTIONS                                         00000750
C                                                                       00000760
C     LINPACK CHPFA                                                     00000770
C     BLAS CAXPY,CDOTC,CSSCAL,SCASUM                                    00000780
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,IABS,REAL                     00000790
C                                                                       00000800
C     INTERNAL VARIABLES                                                00000810
C                                                                       00000820
      COMPLEX AK,AKM1,BK,BKM1,CDOTC,DENOM,EK,T                          00000830
      REAL ANORM,S,SCASUM,YNORM                                         00000840
      INTEGER I,IJ,IK,IKM1,IKP1,INFO,J,JM1,J1                           00000850
      INTEGER K,KK,KM1K,KM1KM1,KP,KPS,KS                                00000860
C                                                                       00000870
      COMPLEX ZDUM,ZDUM2,CSIGN1                                         00000880
      REAL CABS1                                                        00000890
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000900
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000910
C                                                                       00000920
C     FIND NORM OF A USING ONLY UPPER HALF                              00000930
C                                                                       00000940
      J1 = 1                                                            00000950
      DO 30 J = 1, N                                                    00000960
         Z(J) = CMPLX(SCASUM(J,AP(J1),1),0.0E0)                         00000970
         IJ = J1                                                        00000980
         J1 = J1 + J                                                    00000990
         JM1 = J - 1                                                    00001000
         IF (JM1 .LT. 1) GO TO 20                                       00001010
         DO 10 I = 1, JM1                                               00001020
            Z(I) = CMPLX(REAL(Z(I))+CABS1(AP(IJ)),0.0E0)                00001030
            IJ = IJ + 1                                                 00001040
   10    CONTINUE                                                       00001050
   20    CONTINUE                                                       00001060
   30 CONTINUE                                                          00001070
      ANORM = 0.0E0                                                     00001080
      DO 40 J = 1, N                                                    00001090
         ANORM = AMAX1(ANORM,REAL(Z(J)))                                00001100
   40 CONTINUE                                                          00001110
C                                                                       00001120
C     FACTOR                                                            00001130
C                                                                       00001140
      CALL CHPFA(AP,N,KPVT,INFO)                                        00001150
C                                                                       00001160
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00001170
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00001180
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001190
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00001200
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001210
C                                                                       00001220
C     SOLVE U*D*W = E                                                   00001230
C                                                                       00001240
      EK = (1.0E0,0.0E0)                                                00001250
      DO 50 J = 1, N                                                    00001260
         Z(J) = (0.0E0,0.0E0)                                           00001270
   50 CONTINUE                                                          00001280
      K = N                                                             00001290
      IK = (N*(N - 1))/2                                                00001300
   60 IF (K .EQ. 0) GO TO 120                                           00001310
         KK = IK + K                                                    00001320
         IKM1 = IK - (K - 1)                                            00001330
         KS = 1                                                         00001340
         IF (KPVT(K) .LT. 0) KS = 2                                     00001350
         KP = IABS(KPVT(K))                                             00001360
         KPS = K + 1 - KS                                               00001370
         IF (KP .EQ. KPS) GO TO 70                                      00001380
            T = Z(KPS)                                                  00001390
            Z(KPS) = Z(KP)                                              00001400
            Z(KP) = T                                                   00001410
   70    CONTINUE                                                       00001420
         IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,Z(K))               00001430
         Z(K) = Z(K) + EK                                               00001440
         CALL CAXPY(K-KS,Z(K),AP(IK+1),1,Z(1),1)                        00001450
         IF (KS .EQ. 1) GO TO 80                                        00001460
            IF (CABS1(Z(K-1)) .NE. 0.0E0) EK = CSIGN1(EK,Z(K-1))        00001470
            Z(K-1) = Z(K-1) + EK                                        00001480
            CALL CAXPY(K-KS,Z(K-1),AP(IKM1+1),1,Z(1),1)                 00001490
   80    CONTINUE                                                       00001500
         IF (KS .EQ. 2) GO TO 100                                       00001510
            IF (CABS1(Z(K)) .LE. CABS1(AP(KK))) GO TO 90                00001520
               S = CABS1(AP(KK))/CABS1(Z(K))                            00001530
               CALL CSSCAL(N,S,Z,1)                                     00001540
               EK = CMPLX(S,0.0E0)*EK                                   00001550
   90       CONTINUE                                                    00001560
            IF (CABS1(AP(KK)) .NE. 0.0E0) Z(K) = Z(K)/AP(KK)            00001570
            IF (CABS1(AP(KK)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)          00001580
         GO TO 110                                                      00001590
  100    CONTINUE                                                       00001600
            KM1K = IK + K - 1                                           00001610
            KM1KM1 = IKM1 + K - 1                                       00001620
            AK = AP(KK)/CONJG(AP(KM1K))                                 00001630
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00001640
            BK = Z(K)/CONJG(AP(KM1K))                                   00001650
            BKM1 = Z(K-1)/AP(KM1K)                                      00001660
            DENOM = AK*AKM1 - 1.0E0                                     00001670
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001680
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001690
  110    CONTINUE                                                       00001700
         K = K - KS                                                     00001710
         IK = IK - K                                                    00001720
         IF (KS .EQ. 2) IK = IK - (K + 1)                               00001730
      GO TO 60                                                          00001740
  120 CONTINUE                                                          00001750
      S = 1.0E0/SCASUM(N,Z,1)                                           00001760
      CALL CSSCAL(N,S,Z,1)                                              00001770
C                                                                       00001780
C     SOLVE CTRANS(U)*Y = W                                             00001790
C                                                                       00001800
      K = 1                                                             00001810
      IK = 0                                                            00001820
  130 IF (K .GT. N) GO TO 160                                           00001830
         KS = 1                                                         00001840
         IF (KPVT(K) .LT. 0) KS = 2                                     00001850
         IF (K .EQ. 1) GO TO 150                                        00001860
            Z(K) = Z(K) + CDOTC(K-1,AP(IK+1),1,Z(1),1)                  00001870
            IKP1 = IK + K                                               00001880
            IF (KS .EQ. 2)                                              00001890
     *         Z(K+1) = Z(K+1) + CDOTC(K-1,AP(IKP1+1),1,Z(1),1)         00001900
            KP = IABS(KPVT(K))                                          00001910
            IF (KP .EQ. K) GO TO 140                                    00001920
               T = Z(K)                                                 00001930
               Z(K) = Z(KP)                                             00001940
               Z(KP) = T                                                00001950
  140       CONTINUE                                                    00001960
  150    CONTINUE                                                       00001970
         IK = IK + K                                                    00001980
         IF (KS .EQ. 2) IK = IK + (K + 1)                               00001990
         K = K + KS                                                     00002000
      GO TO 130                                                         00002010
  160 CONTINUE                                                          00002020
      S = 1.0E0/SCASUM(N,Z,1)                                           00002030
      CALL CSSCAL(N,S,Z,1)                                              00002040
C                                                                       00002050
      YNORM = 1.0E0                                                     00002060
C                                                                       00002070
C     SOLVE U*D*V = Y                                                   00002080
C                                                                       00002090
      K = N                                                             00002100
      IK = N*(N - 1)/2                                                  00002110
  170 IF (K .EQ. 0) GO TO 230                                           00002120
         KK = IK + K                                                    00002130
         IKM1 = IK - (K - 1)                                            00002140
         KS = 1                                                         00002150
         IF (KPVT(K) .LT. 0) KS = 2                                     00002160
         IF (K .EQ. KS) GO TO 190                                       00002170
            KP = IABS(KPVT(K))                                          00002180
            KPS = K + 1 - KS                                            00002190
            IF (KP .EQ. KPS) GO TO 180                                  00002200
               T = Z(KPS)                                               00002210
               Z(KPS) = Z(KP)                                           00002220
               Z(KP) = T                                                00002230
  180       CONTINUE                                                    00002240
            CALL CAXPY(K-KS,Z(K),AP(IK+1),1,Z(1),1)                     00002250
            IF (KS .EQ. 2) CALL CAXPY(K-KS,Z(K-1),AP(IKM1+1),1,Z(1),1)  00002260
  190    CONTINUE                                                       00002270
         IF (KS .EQ. 2) GO TO 210                                       00002280
            IF (CABS1(Z(K)) .LE. CABS1(AP(KK))) GO TO 200               00002290
               S = CABS1(AP(KK))/CABS1(Z(K))                            00002300
               CALL CSSCAL(N,S,Z,1)                                     00002310
               YNORM = S*YNORM                                          00002320
  200       CONTINUE                                                    00002330
            IF (CABS1(AP(KK)) .NE. 0.0E0) Z(K) = Z(K)/AP(KK)            00002340
            IF (CABS1(AP(KK)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)          00002350
         GO TO 220                                                      00002360
  210    CONTINUE                                                       00002370
            KM1K = IK + K - 1                                           00002380
            KM1KM1 = IKM1 + K - 1                                       00002390
            AK = AP(KK)/CONJG(AP(KM1K))                                 00002400
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00002410
            BK = Z(K)/CONJG(AP(KM1K))                                   00002420
            BKM1 = Z(K-1)/AP(KM1K)                                      00002430
            DENOM = AK*AKM1 - 1.0E0                                     00002440
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002450
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002460
  220    CONTINUE                                                       00002470
         K = K - KS                                                     00002480
         IK = IK - K                                                    00002490
         IF (KS .EQ. 2) IK = IK - (K + 1)                               00002500
      GO TO 170                                                         00002510
  230 CONTINUE                                                          00002520
      S = 1.0E0/SCASUM(N,Z,1)                                           00002530
      CALL CSSCAL(N,S,Z,1)                                              00002540
      YNORM = S*YNORM                                                   00002550
C                                                                       00002560
C     SOLVE CTRANS(U)*Z = V                                             00002570
C                                                                       00002580
      K = 1                                                             00002590
      IK = 0                                                            00002600
  240 IF (K .GT. N) GO TO 270                                           00002610
         KS = 1                                                         00002620
         IF (KPVT(K) .LT. 0) KS = 2                                     00002630
         IF (K .EQ. 1) GO TO 260                                        00002640
            Z(K) = Z(K) + CDOTC(K-1,AP(IK+1),1,Z(1),1)                  00002650
            IKP1 = IK + K                                               00002660
            IF (KS .EQ. 2)                                              00002670
     *         Z(K+1) = Z(K+1) + CDOTC(K-1,AP(IKP1+1),1,Z(1),1)         00002680
            KP = IABS(KPVT(K))                                          00002690
            IF (KP .EQ. K) GO TO 250                                    00002700
               T = Z(K)                                                 00002710
               Z(K) = Z(KP)                                             00002720
               Z(KP) = T                                                00002730
  250       CONTINUE                                                    00002740
  260    CONTINUE                                                       00002750
         IK = IK + K                                                    00002760
         IF (KS .EQ. 2) IK = IK + (K + 1)                               00002770
         K = K + KS                                                     00002780
      GO TO 240                                                         00002790
  270 CONTINUE                                                          00002800
C     MAKE ZNORM = 1.0                                                  00002810
      S = 1.0E0/SCASUM(N,Z,1)                                           00002820
      CALL CSSCAL(N,S,Z,1)                                              00002830
      YNORM = S*YNORM                                                   00002840
C                                                                       00002850
      IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                         00002860
      IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                               00002870
      RETURN                                                            00002880
      END                                                               00002890
