*#**********************************************************************

      SUBROUTINE CHPSL(AP,N,KPVT,B)                                     00000010

      INTEGER N,KPVT(1)                                                 00000020
      COMPLEX AP(1),B(1)                                                00000030
C                                                                       00000040
C     CHISL SOLVES THE COMPLEX HERMITIAN SYSTEM                         00000050
C     A * X = B                                                         00000060
C     USING THE FACTORS COMPUTED BY CHPFA.                              00000070
C                                                                       00000080
C     ON ENTRY                                                          00000090
C                                                                       00000100
C        AP      COMPLEX(N*(N+1)/2)                                     00000110
C                THE OUTPUT FROM CHPFA.                                 00000120
C                                                                       00000130
C        N       INTEGER                                                00000140
C                THE ORDER OF THE MATRIX  A .                           00000150
C                                                                       00000160
C        KPVT    INTEGER(N)                                             00000170
C                THE PIVOT VECTOR FROM CHPFA.                           00000180
C                                                                       00000190
C        B       COMPLEX(N)                                             00000200
C                THE RIGHT HAND SIDE VECTOR.                            00000210
C                                                                       00000220
C     ON RETURN                                                         00000230
C                                                                       00000240
C        B       THE SOLUTION VECTOR  X .                               00000250
C                                                                       00000260
C     ERROR CONDITION                                                   00000270
C                                                                       00000280
C        A DIVISION BY ZERO MAY OCCUR IF  CHPCO  HAS SET RCOND .EQ. 0.0 00000290
C        OR  CHPFA  HAS SET INFO .NE. 0  .                              00000300
C                                                                       00000310
C     TO COMPUTE  INVERSE(A) * C  WHERE  C  IS A MATRIX                 00000320
C     WITH  P  COLUMNS                                                  00000330
C           CALL CHPFA(AP,N,KPVT,INFO)                                  00000340
C           IF (INFO .NE. 0) GO TO ...                                  00000350
C           DO 10 J = 1, P                                              00000360
C              CALL CHPSL(AP,N,KPVT,C(1,J))                             00000370
C        10 CONTINUE                                                    00000380
C                                                                       00000390
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000400
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000410
C                                                                       00000420
C     SUBROUTINES AND FUNCTIONS                                         00000430
C                                                                       00000440
C     BLAS CAXPY,CDOTC                                                  00000450
C     FORTRAN CONJG,IABS                                                00000460
C                                                                       00000470
C     INTERNAL VARIABLES.                                               00000480
C                                                                       00000490
      COMPLEX AK,AKM1,BK,BKM1,CDOTC,DENOM,TEMP                          00000500
      INTEGER IK,IKM1,IKP1,K,KK,KM1K,KM1KM1,KP                          00000510
C                                                                       00000520
C     LOOP BACKWARD APPLYING THE TRANSFORMATIONS AND                    00000530
C     D INVERSE TO B.                                                   00000540
C                                                                       00000550
      K = N                                                             00000560
      IK = (N*(N - 1))/2                                                00000570
   10 IF (K .EQ. 0) GO TO 80                                            00000580
         KK = IK + K                                                    00000590
         IF (KPVT(K) .LT. 0) GO TO 40                                   00000600
C                                                                       00000610
C           1 X 1 PIVOT BLOCK.                                          00000620
C                                                                       00000630
            IF (K .EQ. 1) GO TO 30                                      00000640
               KP = KPVT(K)                                             00000650
               IF (KP .EQ. K) GO TO 20                                  00000660
C                                                                       00000670
C                 INTERCHANGE.                                          00000680
C                                                                       00000690
                  TEMP = B(K)                                           00000700
                  B(K) = B(KP)                                          00000710
                  B(KP) = TEMP                                          00000720
   20          CONTINUE                                                 00000730
C                                                                       00000740
C              APPLY THE TRANSFORMATION.                                00000750
C                                                                       00000760
               CALL CAXPY(K-1,B(K),AP(IK+1),1,B(1),1)                   00000770
   30       CONTINUE                                                    00000780
C                                                                       00000790
C           APPLY D INVERSE.                                            00000800
C                                                                       00000810
            B(K) = B(K)/AP(KK)                                          00000820
            K = K - 1                                                   00000830
            IK = IK - K                                                 00000840
         GO TO 70                                                       00000850
   40    CONTINUE                                                       00000860
C                                                                       00000870
C           2 X 2 PIVOT BLOCK.                                          00000880
C                                                                       00000890
            IKM1 = IK - (K - 1)                                         00000900
            IF (K .EQ. 2) GO TO 60                                      00000910
               KP = IABS(KPVT(K))                                       00000920
               IF (KP .EQ. K - 1) GO TO 50                              00000930
C                                                                       00000940
C                 INTERCHANGE.                                          00000950
C                                                                       00000960
                  TEMP = B(K-1)                                         00000970
                  B(K-1) = B(KP)                                        00000980
                  B(KP) = TEMP                                          00000990
   50          CONTINUE                                                 00001000
C                                                                       00001010
C              APPLY THE TRANSFORMATION.                                00001020
C                                                                       00001030
               CALL CAXPY(K-2,B(K),AP(IK+1),1,B(1),1)                   00001040
               CALL CAXPY(K-2,B(K-1),AP(IKM1+1),1,B(1),1)               00001050
   60       CONTINUE                                                    00001060
C                                                                       00001070
C           APPLY D INVERSE.                                            00001080
C                                                                       00001090
            KM1K = IK + K - 1                                           00001100
            KK = IK + K                                                 00001110
            AK = AP(KK)/CONJG(AP(KM1K))                                 00001120
            KM1KM1 = IKM1 + K - 1                                       00001130
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00001140
            BK = B(K)/CONJG(AP(KM1K))                                   00001150
            BKM1 = B(K-1)/AP(KM1K)                                      00001160
            DENOM = AK*AKM1 - 1.0E0                                     00001170
            B(K) = (AKM1*BK - BKM1)/DENOM                               00001180
            B(K-1) = (AK*BKM1 - BK)/DENOM                               00001190
            K = K - 2                                                   00001200
            IK = IK - (K + 1) - K                                       00001210
   70    CONTINUE                                                       00001220
      GO TO 10                                                          00001230
   80 CONTINUE                                                          00001240
C                                                                       00001250
C     LOOP FORWARD APPLYING THE TRANSFORMATIONS.                        00001260
C                                                                       00001270
      K = 1                                                             00001280
      IK = 0                                                            00001290
   90 IF (K .GT. N) GO TO 160                                           00001300
         IF (KPVT(K) .LT. 0) GO TO 120                                  00001310
C                                                                       00001320
C           1 X 1 PIVOT BLOCK.                                          00001330
C                                                                       00001340
            IF (K .EQ. 1) GO TO 110                                     00001350
C                                                                       00001360
C              APPLY THE TRANSFORMATION.                                00001370
C                                                                       00001380
               B(K) = B(K) + CDOTC(K-1,AP(IK+1),1,B(1),1)               00001390
               KP = KPVT(K)                                             00001400
               IF (KP .EQ. K) GO TO 100                                 00001410
C                                                                       00001420
C                 INTERCHANGE.                                          00001430
C                                                                       00001440
                  TEMP = B(K)                                           00001450
                  B(K) = B(KP)                                          00001460
                  B(KP) = TEMP                                          00001470
  100          CONTINUE                                                 00001480
  110       CONTINUE                                                    00001490
            IK = IK + K                                                 00001500
            K = K + 1                                                   00001510
         GO TO 150                                                      00001520
  120    CONTINUE                                                       00001530
C                                                                       00001540
C           2 X 2 PIVOT BLOCK.                                          00001550
C                                                                       00001560
            IF (K .EQ. 1) GO TO 140                                     00001570
C                                                                       00001580
C              APPLY THE TRANSFORMATION.                                00001590
C                                                                       00001600
               B(K) = B(K) + CDOTC(K-1,AP(IK+1),1,B(1),1)               00001610
               IKP1 = IK + K                                            00001620
               B(K+1) = B(K+1) + CDOTC(K-1,AP(IKP1+1),1,B(1),1)         00001630
               KP = IABS(KPVT(K))                                       00001640
               IF (KP .EQ. K) GO TO 130                                 00001650
C                                                                       00001660
C                 INTERCHANGE.                                          00001670
C                                                                       00001680
                  TEMP = B(K)                                           00001690
                  B(K) = B(KP)                                          00001700
                  B(KP) = TEMP                                          00001710
  130          CONTINUE                                                 00001720
  140       CONTINUE                                                    00001730
            IK = IK + K + K + 1                                         00001740
            K = K + 2                                                   00001750
  150    CONTINUE                                                       00001760
      GO TO 90                                                          00001770
  160 CONTINUE                                                          00001780
      RETURN                                                            00001790
      END                                                               00001800
